% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yml_distill.R
\name{yml_distill_opts}
\alias{yml_distill_opts}
\alias{yml_distill_author}
\alias{distill_listing}
\alias{distill_collection}
\alias{distill_resources}
\title{Set Top-level YAML options for distill}
\usage{
yml_distill_opts(
  .yml,
  draft = yml_blank(),
  slug = yml_blank(),
  categories = yml_blank(),
  listing = yml_blank(),
  collection = yml_blank(),
  citation_url = yml_blank(),
  preview = yml_blank(),
  repository_url = yml_blank(),
  base_url = yml_blank(),
  compare_updates_url = yml_blank(),
  creative_commons = yml_blank(),
  twitter_site = yml_blank(),
  twitter_creator = yml_blank(),
  journal_title = yml_blank(),
  journal_issn = yml_blank(),
  journal_publisher = yml_blank(),
  volume = yml_blank(),
  issue = yml_blank(),
  doi = yml_blank(),
  resources = yml_blank(),
  ...
)

yml_distill_author(
  .yml,
  name = yml_blank(),
  url = yml_blank(),
  affiliation = yml_blank(),
  affiliation_url = yml_blank()
)

distill_listing(listing_name = "posts", slugs = NULL)

distill_collection(
  collection_name = "post",
  feed_items_max = yml_blank(),
  disqus_name = yml_blank(),
  disqus_hidden = yml_blank(),
  share = yml_blank(),
  citations = yml_blank(),
  subscribe = yml_blank()
)

distill_resources(include = yml_blank(), exclude = yml_blank())
}
\arguments{
\item{.yml}{a \code{yml} object created by \code{yml()}, \code{as_yml()}, or returned by
a \verb{yml_*()} function}

\item{draft}{Logical. Set the post to be a draft? Draft posts won't be
published.}

\item{slug}{The abbreviated version of the citation included in the BibTeX
entry. If you don’t provide a slug then one will be automatically
generated.}

\item{categories}{A character vector, the post categories}

\item{listing}{The listing a post is under; either a character vector, the
output of \code{distill_listing()}, or a named list.}

\item{collection}{Specify the RSS, sharing, and other settings of a listing;
use \code{distill_collection()} or a named list.}

\item{citation_url}{A URL to the article; automatically generated for blog
articles}

\item{preview}{a path or link to the preview image for your article. You can
also set this by including \code{preview = TRUE} in an R Markdown code chunk in
your document.}

\item{repository_url}{A URL where the source code for your article can be
found}

\item{base_url}{Base (root) URL for the location where the website will be
deployed (used for providing preview images for Open Graph and Twitter
Card)}

\item{compare_updates_url}{a URL that will show the differences between the
article’s current version and the version that was initially published}

\item{creative_commons}{Designate articles that you create as Creative
Commons licensed by specifying one of the standard Creative Commons
licenses. Common options include "CC BY", "CC BY-SA", "CC BY-ND", and "CC
BY-NC". See the \href{https://rstudio.github.io/distill/metadata.html}{distill vignette} for more
details.}

\item{twitter_site}{The Twitter handle for the site}

\item{twitter_creator}{The Twitter handle for the creator}

\item{journal_title}{The title of the journal}

\item{journal_issn}{The issn of the journal}

\item{journal_publisher}{The publisher of the journal}

\item{volume}{The volume the article is on}

\item{issue}{The issue the article is on}

\item{doi}{The article Digital Object Identifier (DOI)}

\item{resources}{Files to include or exclude while publishing. Use
\code{distill_resources()} or a named list to specify.}

\item{...}{additional named R objects, such as characters or lists, to
transform into YAML}

\item{name}{A character vector, name of the author(s)}

\item{url}{the author URL}

\item{affiliation}{The author's affiliation; must match length of \code{name},
e.g. if \code{name} has length of two, \code{affiliation} must as well; use \code{NA} if
you don't want to include an affiliation for a given author.Note that not
all formats support the \code{affiliation} field.}

\item{affiliation_url}{the affiliation URL}

\item{listing_name}{A character vector, the name of the listing}

\item{slugs}{A character vector of the posts to include in the listing}

\item{collection_name}{A character vector, the name of the collection}

\item{feed_items_max}{Number of articles to include in the RSS feed (default:
20). Specify \code{FALSE} to have no limit on the number of items included in
the feed.}

\item{disqus_name}{A shortname for the disqus comments section (\code{base_url}
field is required in order to use Disqus)}

\item{disqus_hidden}{Logical. Show full text of disqus comments? By default,
this is \code{FALSE} so as not to obscure the bibliography and other appendices.}

\item{share}{Share buttons to include. Choices: "twitter", "linkedin",
"facebook", "google-plus", and "pinterest". (\code{base_url} field is required
in order to use sharing links)}

\item{citations}{Logical. If your \verb{_site.yml} file provides a \code{base_url}
field, an article citation appendix and related metadata will be included
automatically within all published posts. Set to \code{FALSE} to disable this
behavior.}

\item{subscribe}{a path to a HTML file enabling readers to subscribe. See the
\href{https://rstudio.github.io/distill/blog.html#creating-a-blog}{distill vignette on blog posts} for
more details.}

\item{include, exclude}{a character vector of files to explicitly include or
exclude when publishing a post. Can use wild cards, such as "*.csv".}
}
\value{
a \code{yml} object
}
\description{
distill uses many custom YAML fields to create some of its unique features,
such as article metadata and citations. In addition to the arguments in
\code{yml_distill_opts()}, ymlthis supports distill in a number of other ways.
\code{yml_distill_author()} wraps \code{\link[=yml_author]{yml_author()}} to include these extra used in
distill. For a distill blog, you can specify the listings page a post belongs
to, including an optional vector of other posts to list with it;
\code{distill_listing()} is a helper function to pass to the \code{listing} argument to
specify such pages. distill uses the same approach to navbars as R Markdown.
\code{\link[=yml_navbar]{yml_navbar()}} and friends will help you write the YAML for that. YAML
specifying the site build, like the output field and navbars, can also be
placed in \verb{_site.yml}; see \code{\link[=yml_site_opts]{yml_site_opts()}} for further R Markdown website
build options and \code{\link[=use_site_yml]{use_site_yml()}} for creating that file based on a \code{yml}
object. distill's YAML options are discussed in greater detail in the
\href{https://rstudio.github.io/distill}{articles on the distill website}.
}
\examples{
post_listing <- distill_listing(
  slugs = c(
    "2016-11-08-sharpe-ratio",
    "2017-11-09-visualizing-asset-returns",
    "2017-09-13-asset-volatility"
  )
)

yml() \%>\%
  yml_title("Gallery of featured posts") \%>\%
  yml_distill_opts(listing = post_listing)

yml_empty() \%>\%
  yml_title("Reproducible Finance with R") \%>\%
  yml_description("Exploring reproducible finance with the R statistical,
  computing environment.") \%>\%
  yml_site_opts(name = "reproducible-finance-with-r") \%>\%
  yml_distill_opts(
    base_url = "https://beta.rstudioconnect.com/content/3776/",
    collection = distill_collection(
      feed_items_max = 30,
      disqus_name = "reproducible-finance-with-r",
      disqus_hidden = FALSE,
      share = c("twitter", "linkedin")
    )
  )

}
\seealso{
\code{\link[=use_site_yml]{use_site_yml()}} \code{\link[=use_rmarkdown]{use_rmarkdown()}}

Other yml: 
\code{\link{asis_yaml_output}()},
\code{\link{bib2yml}()},
\code{\link{draw_yml_tree}()},
\code{\link{has_field}()},
\code{\link{read_json}()},
\code{\link{use_yml_defaults}()},
\code{\link{use_yml_file}()},
\code{\link{use_yml}()},
\code{\link{yml_author}()},
\code{\link{yml_blogdown_opts}()},
\code{\link{yml_bookdown_opts}()},
\code{\link{yml_citations}()},
\code{\link{yml_clean}()},
\code{\link{yml_latex_opts}()},
\code{\link{yml_output}()},
\code{\link{yml_pagedown_opts}()},
\code{\link{yml_params}()},
\code{\link{yml_pkgdown}()},
\code{\link{yml_reference}()},
\code{\link{yml_replace}()},
\code{\link{yml_resource_files}()},
\code{\link{yml_rsconnect_email}()},
\code{\link{yml_rticles_opts}()},
\code{\link{yml_runtime}()},
\code{\link{yml_site_opts}()},
\code{\link{yml_toc}()},
\code{\link{yml_vignette}()}

Other websites: 
\code{\link{yml_pkgdown}()},
\code{\link{yml_site_opts}()}
}
\concept{distill}
\concept{websites}
\concept{yml}
