% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv-brier_survival_integrated.R
\name{brier_survival_integrated}
\alias{brier_survival_integrated}
\alias{brier_survival_integrated.data.frame}
\alias{brier_survival_integrated_vec}
\title{Integrated Brier score for right censored data}
\usage{
brier_survival_integrated(data, ...)

\method{brier_survival_integrated}{data.frame}(data, truth, ..., na_rm = TRUE, case_weights = NULL)

brier_survival_integrated_vec(
  truth,
  estimate,
  na_rm = TRUE,
  case_weights = NULL,
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} containing the columns specified by \code{truth} and
\code{...}.}

\item{...}{The column identifier for the survival probabilities this
should be a list column of data.frames corresponding to the output given when
predicting with \href{https://censored.tidymodels.org/}{censored} model. This
should be an unquoted column name although this argument is passed by
expression and supports \link[rlang:topic-inject]{quasiquotation} (you can
unquote column names). For \verb{_vec()} functions, the dots are not used.}

\item{truth}{The column identifier for the true survival result (that
is created using \code{\link[survival:Surv]{survival::Surv()}}.). This should be an unquoted column name
although this argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column names). For
\verb{_vec()} functions, an \code{\link[survival:Surv]{survival::Surv()}} object.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}

\item{case_weights}{The optional column identifier for case weights.
This should be an unquoted column name that evaluates to a numeric column
in \code{data}. For \verb{_vec()} functions, a numeric vector,
\code{\link[hardhat:importance_weights]{hardhat::importance_weights()}}, or \code{\link[hardhat:frequency_weights]{hardhat::frequency_weights()}}.}

\item{estimate}{A list column of data.frames corresponding to the output
given when predicting with \href{https://censored.tidymodels.org/}{censored}
model. See the details for more information regarding format.}
}
\value{
A \code{tibble} with columns \code{.metric}, \code{.estimator}, and \code{.estimate}.

For an ungrouped data frame, the result has one row of values. For a grouped data frame,
the number of rows returned is the same as the number of groups.

For \code{brier_survival_integrated_vec()}, a \code{numeric} vector same length as the input argument
\code{eval_time}. (or \code{NA}).
}
\description{
Compute the integrated Brier score for right censored data, which is an
overall calculation of model performance for all values of \code{.eval_time}.
}
\details{
The integrated time-dependent brier score is calculated in an "area under the
curve" fashion. The brier score is calculated for each value of \code{.eval_time}.
The area is calculated via the trapezoidal rule. The area is divided by the
largest value of \code{.eval_time} to bring it into the same scale as the
traditional brier score.

Smaller values of the score are associated with better model performance.

This formulation takes survival probability predictions at one or more
specific \emph{evaluation times} and, for each time, computes the Brier score.
To account for censoring, inverse probability of censoring weights
(IPCW) are used in the calculations.

The column passed to \code{...} should be a list column with one element per
independent experiential unit (e.g. patient). The list column should contain
data frames with several columns:
\itemize{
\item \code{.eval_time}: The time that the prediction is made.
\item \code{.pred_survival}: The predicted probability of survival up to \code{.eval_time}
\item \code{.weight_censored}: The case weight for the inverse probability of censoring.
}

The last column can be produced using \code{\link[parsnip:censoring_weights]{parsnip::.censoring_weights_graf()}}.
This corresponds to the weighting scheme of  Graf \emph{et al} (1999). The
internal data set \code{lung_surv} shows an example of the format.

This method automatically groups by the \code{.eval_time} argument.
}
\examples{
library(dplyr)

lung_surv \%>\%
  brier_survival_integrated(
    truth = surv_obj,
    .pred
  )
}
\references{
E. Graf, C. Schmoor, W. Sauerbrei, and M. Schumacher, “Assessment
and comparison of prognostic classification schemes for survival data,”
Statistics in Medicine, vol. 18, no. 17-18, pp. 2529–2545, 1999.
}
\seealso{
Other dynamic survival metrics: 
\code{\link{brier_survival}()},
\code{\link{roc_auc_survival}()}
}
\author{
Emil Hvitfeldt
}
\concept{dynamic survival metrics}
