% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explicit_guide.R
\name{implicit_guide.dvec}
\alias{implicit_guide.dvec}
\title{Coerce Decorated Vector Guide to Something More Implicit}
\usage{
\method{implicit_guide}{dvec}(x, ...)
}
\arguments{
\item{x}{dvec}

\item{...}{ignored}
}
\value{
dvec
}
\description{
Coerces dvec guide-like attributes to 'guide'.
The attribute 'guide' generally suggests a guide
to interpretation of a data item, such as units, formats, codelists,
and encodings.  The idea here is to replace these with 'guide':
i.e., to undo the effects of \code{\link{explicit_guide.dvec}}.
If guide attribute is still present, the explicit attribute is removed.
Otherwise the explicit element is renamed.
}
\examples{
library(magrittr)
x <- data.frame(
 ID = as_dvec(1),
 CONC = as_dvec(1),
 RACE = as_dvec(1),
 SEX = as_dvec(1),
 DATE = as_dvec(1)
)
x \%<>\% modify(ID, label = 'subject identifier')
x \%<>\% modify(CONC, label = 'concentration', guide = 'ng/mL')
x \%<>\% modify(RACE, label = 'race', guide = list(white = 0, black = 1, asian = 2))
x \%<>\% modify(SEX, label = 'sex', guide = list(female = 0, male = 1))
x \%<>\% modify(DATE, label  = 'date', guide = '\%Y-\%m-\%d')
x \%>\% decorations
x \%>\% explicit_guide \%>\% decorations
x \%>\% explicit_guide \%>\% implicit_guide \%>\% decorations
x \%>\% explicit_guide \%>\% implicit_guide(DATE) \%>\% decorations # limit scope
x \%>\% explicit_guide(simplify = FALSE) \%>\% decorations
x \%>\% explicit_guide(simplify = FALSE) \%>\% implicit_guide \%>\% decorations
x \%<>\% explicit_guide
a <- x$DATE
str(a)
str(a \%>\% implicit_guide)
}
\seealso{
Other explicit_guide: 
\code{\link{explicit_guide.data.frame}()},
\code{\link{explicit_guide.dvec}()},
\code{\link{explicit_guide.yamlet}()},
\code{\link{explicit_guide}()},
\code{\link{implicit_guide.data.frame}()},
\code{\link{implicit_guide}()},
\code{\link{infer_guide}()}

Other dvec: 
\code{\link{[.dvec}()},
\code{\link{[<-.dvec}()},
\code{\link{[[.dvec}()},
\code{\link{[[<-.dvec}()},
\code{\link{as.data.frame.dvec}()},
\code{\link{as_dvec.character}()},
\code{\link{as_dvec.complex}()},
\code{\link{as_dvec.dvec}()},
\code{\link{as_dvec.integer}()},
\code{\link{as_dvec.logical}()},
\code{\link{as_dvec.numeric}()},
\code{\link{as_dvec}()},
\code{\link{c.dvec}()},
\code{\link{classified.dvec}()},
\code{\link{desolve.dvec}()},
\code{\link{explicit_guide.data.frame}()},
\code{\link{format.dvec}()},
\code{\link{length.dvec}()},
\code{\link{print.dvec}()},
\code{\link{resolve.dvec}()},
\code{\link{unclassified.dvec}()}
}
\concept{dvec}
\concept{explicit_guide}
\keyword{internal}
