% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desolve.R
\name{desolve.classified}
\alias{desolve.classified}
\title{Desolve Guide for Classified}
\usage{
\method{desolve}{classified}(x, ...)
}
\arguments{
\item{x}{classified}

\item{...}{passed to \code{\link{implicit_guide}} and \code{\link{unclassified}}}
}
\value{
dvec
}
\description{
Un-resolves explicit usage of default key 'guide' to
implicit usage for class classified
Simply calls \code{\link{unclassified}}
followed by \code{\link{implicit_guide}}.
}
\examples{
library(magrittr)
x <- as_dvec(4:6)
attr(x, 'guide') <- list(a = 4L, b = 5L, c = 6L)
x \%>\% str
x \%>\% classified \%>\% str
x \%>\% explicit_guide \%>\% classified \%>\% str
x \%>\% resolve \%>\% str
x \%>\% str
x \%>\% resolve \%>\% desolve \%>\% str
}
\seealso{
Other resolve: 
\code{\link{desolve.decorated}()},
\code{\link{desolve.dvec}()},
\code{\link{desolve}()},
\code{\link{resolve.decorated}()},
\code{\link{resolve.dvec}()},
\code{\link{resolve}()}

Other classified: 
\code{\link{[.classified}()},
\code{\link{[<-.classified}()},
\code{\link{[[.classified}()},
\code{\link{[[<-.classified}()},
\code{\link{as.integer.classified}()},
\code{\link{c.classified}()},
\code{\link{classified.classified}()},
\code{\link{classified.data.frame}()},
\code{\link{classified.default}()},
\code{\link{classified.dvec}()},
\code{\link{classified}()},
\code{\link{unclassified.classified}()},
\code{\link{unclassified.data.frame}()},
\code{\link{unclassified}()}
}
\concept{classified}
\concept{resolve}
