% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classified.R
\name{c.classified}
\alias{c.classified}
\title{Combine Classified}
\usage{
\method{c}{classified}(..., recursive = TRUE)
}
\arguments{
\item{...}{passed to next method}

\item{x}{classified factor}
}
\value{
class 'classified' 'factor'
}
\description{
Combines classified factor, retaining attributes.
Attributes other than levels and codelist are taken
from the first argument.  Attribute 'levels' is
supplied by next method.  Attribute 'codelist'
is the combined codelists in sequence of
all (dots) arguments, after silently removing
exact duplicates, and then removing
duplicated names with warning.
}
\examples{
a <- classified(letters[1:3])
b <- classified(letters[3:5])
c <- c(a,b)
c
class(c)

}
\seealso{
Other classified: 
\code{\link{[.classified}()},
\code{\link{[<-.classified}()},
\code{\link{[[.classified}()},
\code{\link{[[<-.classified}()},
\code{\link{as.integer.classified}()},
\code{\link{classified.classified}()},
\code{\link{classified.data.frame}()},
\code{\link{classified.default}()},
\code{\link{classified.dvec}()},
\code{\link{classified}()},
\code{\link{desolve.classified}()},
\code{\link{unclassified.classified}()},
\code{\link{unclassified.data.frame}()},
\code{\link{unclassified}()}
}
\concept{classified}
\keyword{internal}
