% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explicit_guide.R
\name{explicit_guide.yamlet}
\alias{explicit_guide.yamlet}
\title{Coerce Yamlet Guide to Something More Explicit}
\usage{
\method{explicit_guide}{yamlet}(x, ..., default = "guide", data = NULL)
}
\arguments{
\item{x}{yamlet}

\item{...}{passed to \code{\link[dplyr]{select}} to limit scope}

\item{default}{length-one character: the default key}

\item{data}{optional data.frame for testing guides with length > 1}
}
\value{
yamlet
}
\description{
Coerces yamlet 'guide' keys to something more explicit.
The key 'guide' generally suggests a guide
to interpretation of a data item, such as units, formats, codelists,
and encodings.  The idea here is to replace 'guide' with something
explicit in case required downstream.
}
\details{
The key 'guide' is replaced as follows for the first test
that succeeds, or replaced with the default if none do.

* If the value of 'guide' is of length greater than
one (and data is not supplied), key becomes 'codelist'.
* If the value of 'guide' \code{\link{is_parseable}},
key becomes 'units'.
* If the value of 'guide' contains two or more percent signs,
key becomes 'format' (i.e. a 'format' string for a date or time class).
* If the value of 'guide' is (\code{\link[encode]{encoded}}),
key becomes 'encoding'.

If \code{data} is supplied, guides with length greater than one
are checked to see if they evaluate to conditions in data context
(see \code{\link{isConditional.list}}).
If so, inferences are based on the first guide element rather
than the guide as a whole.
}
\examples{
library(magrittr)
'CONC: [ concentration, µg/mL ]' \%>\% as_yamlet \%>\% explicit_guide
'RACE: [ subject race, [ Caucasian: 0, Latin: 1, Black: 2 ]]' \%>\% as_yamlet \%>\% explicit_guide
'RACE: [ subject race, [ Caucasian, Latin, Black ]]' \%>\% as_yamlet \%>\% explicit_guide
'RACE: [ subject race, //0/Caucasian//1/Latin//2/Black// ]' \%>\% as_yamlet \%>\% explicit_guide
'DATE: [ date, "\%Y-\%m-\%d" ]' \%>\% as_yamlet \%>\% explicit_guide
'PRSE: [ standard error, "\%" ]' \%>\% as_yamlet \%>\% explicit_guide

}
\seealso{
Other explicit_guide: 
\code{\link{explicit_guide.data.frame}()},
\code{\link{explicit_guide}()},
\code{\link{implicit_guide.data.frame}()},
\code{\link{implicit_guide}()}
}
\concept{explicit_guide}
\keyword{internal}
