% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agplot.R
\name{as_lab.list}
\alias{as_lab.list}
\title{Coerce List to Axis Label}
\usage{
\method{as_lab}{list}(
  x,
  default,
  collapse = "\\n",
  enclose = getOption("yamlet_enclose", default = c("(", ")")),
  data,
  ...
)
}
\arguments{
\item{x}{list, such as returned by \code{\link{attributes}}.}

\item{default}{a value to return by default}

\item{collapse}{character: separator for collapsing multi-line units}

\item{enclose}{length-two character for enclosing unit}

\item{data}{data.frame for resolving competing named values}

\item{...}{ignored}
}
\value{
length-one character
}
\description{
Coerces list to axis label. Accepts a default label
and returns that if nothing better can be done.
If the attribute list has one named 'label', it
is chosen as a substitute.  But if that attribute
is itself a list of values, an attempt is made
to identify a single relevant value by treating
the value names as conditions to evaluate on
the supplied data. If a suitable value is
found, it is chosen as a substitute.  See
\code{\link{singularity}} for search logic.
}
\examples{
meta <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
x <- decorate(meta)
as_lab(attributes(x$time), 'time', enclose = c('[',']'))
as_lab(attributes(x$time), 'time', enclose = c('[ ',' ]'))
}
\seealso{
Other lab: 
\code{\link{as_lab}()},
\code{\link{ggplot.decorated}()},
\code{\link{print.ag}()},
\code{\link{singularity}()}
}
\concept{lab}
