% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spork.R
\name{as_spork.unit_string}
\alias{as_spork.unit_string}
\title{Coerce Unit String to Spork}
\usage{
\method{as_spork}{unit_string}(x, ...)
}
\arguments{
\item{x}{unit_string}

\item{...}{ignored arguments}
}
\value{
units
}
\description{
Coerces unit string to spork.  A literal dot
means different things in spork vs. units,
and there may be some other subtleties as well.
Unit string is character that \code{\link{is_parseable}}.
}
\examples{
library(magrittr)
library(spork)
'kg.m^2/s^2' \%>\% as_unit_string \%>\% as_spork
'kg.m2 s-2' \%>\% as_unit_string \%>\% as_spork
}
\seealso{
Other spork: 
\code{\link{as_spork.symbolic_units}()},
\code{\link{as_spork.units}()}
}
\concept{spork}
\keyword{internal}
