% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grnn.optmiz_auc.R
\name{grnn.optmiz_auc}
\alias{grnn.optmiz_auc}
\title{Optimize the optimal value of GRNN smoothing parameter based on AUC}
\usage{
grnn.optmiz_auc(net, lower = 0, upper, nfolds = 4, seed = 1, method = 1)
}
\arguments{
\item{net}{A GRNN object generated by grnn.fit()}

\item{lower}{A scalar for the lower bound of the smoothing parameter}

\item{upper}{A scalar for the upper bound of the smoothing parameter}

\item{nfolds}{A scalar for the number of n-fold, 4 by default}

\item{seed}{The seed value for the n-fold cross-validation, 1 by default}

\item{method}{A scalar referring to the optimization method, 1 for Golden section searc and 2 for Brent’s method}
}
\value{
The best outcome
}
\description{
The function \code{grnn.optmiz_auc} optimize the optimal value of GRNN smoothing parameter by cross-validation.
It is applicable to the classification.
}
\examples{
data(iris, package = "datasets")
Y <- ifelse(iris[, 5] == "setosa", 1, 0)
X <- scale(iris[, 1:4])
gnet <- grnn.fit(x = X, y = Y)
\dontrun{
grnn.optmiz_auc(net = gnet, lower = 3, upper = 7, nfolds = 2)
}
}
\seealso{
\code{\link{grnn.search_auc}}
}
