% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commons.R
\name{gen.irt}
\alias{gen.irt}
\title{Generate IRT Object}
\usage{
gen.irt(n.peo, n.item, thetas = NULL, a = NULL, b = NULL, c = NULL,
  theta.mu = 0, theta.sig = 1, a.mu = 0, a.sig = 0.15, b.mu = 0,
  b.sig = 1, c.alpha = 5, c.beta = 43)
}
\arguments{
\item{n.peo}{the number of people to be generated}

\item{n.item}{the number of items to be generated}

\item{thetas}{a vector of ability parameters to be imported}

\item{a}{a vector/number of a parameters to be imported}

\item{b}{a vector of b parameters to be imported}

\item{c}{a vector/number of item c parameters to be imported}

\item{theta.mu}{the mean of the normal distribution from which thetas are generated}

\item{theta.sig}{the sd of the normal distribution from which thetas are generated}

\item{a.mu}{the log mean of the lognormal distribution from which a parameters are generated}

\item{a.sig}{the log sd of the lognormal distribution from which a parameters are generated}

\item{b.mu}{the mean of the normal distribution from which b parameters are generated}

\item{b.sig}{the sd of the normal distribution from which b parameters are generated}

\item{c.alpha}{the alpha parameter of the beta distribution from which c parameters are generated}

\item{c.beta}{the beta parameter of the beta distribution from which c parameters are generated}
}
\value{
an \code{irt} object
}
\description{
Create an IRT object with generated values
}
\details{
In generation, thetas are drawn from the normal distribution, a parameters from the lognormal distribution,
b parameters from the normal distribution, and c parameters from the beta distribution.
When parameters are imported, they are not drawn from the distribution.
}
\examples{
# generate 10 people, 5 items
gen.irt(10, 5)
# generate data with given thetas
gen.irt(10, 5, thetas=seq(.1, 1, length.out=10)) 
# generate data with given iteme parameters (Rasch items)
gen.irt(10, 5, a=.588, c=0)
}
\seealso{
Other commons: \code{\link{irt}}, \code{\link{prob}}
}

