#
#   xts: eXtensible time-series 
#
#   Copyright (C) 2008  Jeffrey A. Ryan jeff.a.ryan @ gmail.com
#
#   Contributions from Joshua M. Ulrich
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.


`as.xts.fts` <-
function(x, ..., .RECLASS=FALSE)
{
  dates <- as.numeric(dates(x)) # fts uses POSIXct
  attr(x,'dates') <- NULL
  if(.RECLASS) {
  .xts(unclass(x), dates, .CLASS="fts", ...)
  } else {
  .xts(unclass(x), dates, ...)
  }
}

`as.fts.xts` <-
function(x)
{
  fts(coredata(x), structure(.index(x), class=c("POSIXt","POSIXct")))
}

re.fts <- function(x, ...) 
{
  fts(coredata(x), structure(.index(x), class=c("POSIXt","POSIXct")))
}
