% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{split.xts}
\alias{split.xts}
\title{Divide into Groups by Time}
\usage{
\method{split}{xts}(x, f = "months", drop = FALSE, k = 1, ...)
}
\arguments{
\item{x}{An xts object.}

\item{f}{A character vector describing the period to split by.}

\item{drop}{Ignored by \code{split.xts()}.}

\item{k}{Number of periods to aggregate into each split. See details.}

\item{\dots}{Further arguments passed to other methods.}
}
\value{
A list of xts objects.
}
\description{
Creates a list of xts objects split along time periods.
}
\details{
A quick way to break up a large xts object by standard time periods; e.g.
'months', 'quarters', etc.

\code{\link[=endpoints]{endpoints()}} is used to find the start and end of each period (or
k-periods). See that function for valid arguments.

The inputs are passed to \code{\link[=split.zoo]{split.zoo()}} when \code{f} is not a character vector.
}
\note{
\code{\link[=aggregate.zoo]{aggregate.zoo()}} is more flexible, though not as fast for xts
objects.
}
\examples{

data(sample_matrix)
x <- as.xts(sample_matrix)


split(x)
split(x, f="weeks")
split(x, f="weeks", k=4)

}
\seealso{
\code{\link[=endpoints]{endpoints()}}, \code{\link[zoo:zoo]{split.zoo()}}, \code{\link[zoo:zoo]{aggregate.zoo()}}
}
\author{
Jeffrey A. Ryan
}
\keyword{utilities}
