% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xseq_expr_dis.R
\name{GetExpressionDistribution}
\alias{GetExpressionDistribution}
\title{Get the conditional distributions for a set of genes}
\usage{
GetExpressionDistribution(expr, mut = NULL, cna.call = NULL, gene = NULL,
  type = "student", show.plot = FALSE)
}
\arguments{
\item{expr}{A matrix of gene expression values where
each row corresponds to a patient and each column is a gene.}

\item{mut}{A data.frame of mutations. The data.frame should have
three columns of characters: sample, hgnc_symbol, and variant_type.
The variant_type column cat be either "HOMD", "HLAMP",
  "MISSENSE", "NONSENSE", "FRAMESHIFT", "INFRAME", "SPLICE", "NONSTOP",
  "STARTGAINED", "SYNONYMOUS", "OTHER", "FUSION", "COMPLEX".}

\item{cna.call}{A matrix containing the copy number calls, where each element is coded:
\itemize{
  \item -2, homozygous deletions
  \item -1, hemizygous deletions
  \item 0, neutral
  \item 1, gain
  \item 2, amplifications
  }}

\item{gene}{A character vector of official HGNC gene names}

\item{type}{Character, either Gaussian  ("gauss") or
Student ("student")}

\item{show.plot}{Logical, specifying whether to plot the fitted model}
}
\value{
A list containg the fitted expression distributions
}
\description{
Get the conditional distributions for a set of genes
}

