% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpose.multiple.plot.default.R
\name{xpose.multiple.plot.default}
\alias{xpose.multiple.plot.default}
\title{Xpose 4 generic function for plotting multiple lattice objects on one page}
\usage{
xpose.multiple.plot.default(
  plotList,
  plotTitle = NULL,
  prompt = FALSE,
  new.first.window = FALSE,
  max.plots.per.page = 4,
  title = list(title.x = unit(0.5, "npc"), title.y = unit(0.5, "npc"), title.gp =
    gpar(cex = 1.2, fontface = "bold"), title.just = c("center", "center")),
  mirror = FALSE,
  bql.layout = FALSE,
  page.numbers = TRUE,
  ...
)
}
\arguments{
\item{plotList}{A list of lattice plot objects such that plot object i can
be called with \code{plotList[[i]]}}

\item{plotTitle}{The title used for the multiple plot layout}

\item{prompt}{If more than one page is needed do you want a prompt at the
command line before the next page is printed}

\item{new.first.window}{Should the first page of this plot be in the already
opened window or should a new window be created}

\item{max.plots.per.page}{Maximum number of plots per page in the multiple
layout}

\item{title}{Look of title using \pkg{grid}.}

\item{mirror}{if the list contains mirror plots}

\item{bql.layout}{should we use layout optimized for BQL measurements?}

\item{page.numbers}{Should we add page numbers to multiple page plots?}

\item{\dots}{Other arguments passed to the code in this function}
}
\value{
returns nothing
}
\description{
Function takes a list of \pkg{lattice} plot objects and prints them in a
multiple plot layout with a title.
}
\details{
\strong{Additional arguments:} \describe{ \item{title.x}{Where the title
should be placed in the title \pkg{grid} region} \item{title.y}{Where the
title should be placed in the title \pkg{grid} region} \item{title.just}{how
the title should be justified} \item{title.gp}{The par parameters for the
title (see \pkg{grid})} }
}
\seealso{
\pkg{grid}, \code{\link{basic.gof}}, \code{\link{parm.vs.parm}},
\code{\link{parm.vs.cov}},
}
\author{
Andrew Hooker
}
