% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change.xvardef.R
\name{change.xvardef}
\alias{change.xvardef}
\alias{change.xvardef<-}
\title{Change Xpose variable definitions.}
\usage{
change.xvardef(
  object,
  var = ".ask",
  def = ".ask",
  listall = TRUE,
  classic = FALSE,
  check.var = FALSE,
  ...
)

change.xvardef(
  object,
  var,
  listall = FALSE,
  classic = FALSE,
  check.var = FALSE,
  ...
) <- value
}
\arguments{
\item{object}{An \code{xpose.data} object.}

\item{var}{The Xpose variable you would like to change or add to the current
object. A one-element character vector (e.g. \code{"idv"}).  If
\code{".ask"} the user will be prompted to input a value.}

\item{def}{A vector of column names from NONMEM table files
(\code{names(object@Data)}) that should be associated with this variable
(e.g. \code{c("TIME")}).  Multiple values are allowed. If \code{".ask"} the
user will be prompted to input values.}

\item{listall}{Should the function list the database values?}

\item{classic}{Is the function being used from the classic interface.  This
is an internal option.}

\item{check.var}{Should the variables be checked against the current
variables in the object?}

\item{\dots}{Items passed to functions within this function.}

\item{value}{a vector of values}
}
\value{
If called from the the command line then this function returns an
xpose database.  If called from the classic interface this function updates
the current xpose database (.cur.db).
}
\description{
These functions allow for the changing of Xpose variable definitions like
"idv" and "dv". These variable definitions are used to refer to columns of
the observed data in a generic way, so that generic plotting functions can
be created.
}
\section{Functions}{
\itemize{
\item \code{change.xvardef<-}: Change the covariate scope of
the xpose database object
}}

\section{Additional arguments}{
 \strong{The default xpose variables are:\cr}
\describe{ \item{id}{Individual identifier column in dataset}
\item{idlab}{values used for plotting ID values on data points in plots}
\item{occ}{The occasion variable} \item{dv}{The dv variable} \item{pred}{The
pred variable} \item{ipred}{The ipred variable} \item{wres}{The wres
variable} \item{cwres}{The cwres variable} \item{res}{The res variable}
\item{parms}{The parameters in the database} \item{covariates}{The
covariates in the database} \item{ranpar}{The random parameters in the
database} }
}

\examples{

## Here we load the example xpose database 
xpdb <- simpraz.xpdb

# Change the "id" variable to point to "PRED" in the xpose object
xpdb <- change.xvardef(xpdb,var="id",def="PRED")

# Check the value of the "id" variable
xvardef("id",xpdb)

# Change the "idv" variable
change.xvardef(xpdb,var="idv") <- "TIME"

# Change the covariate scope
change.xvardef(xpdb,var="covariates") <- c("SEX","AGE","WT")

\dontrun{
# Use the interactive capabilities of the function
xpdb <- change.xvardef(xpdb)
}

}
\seealso{
\code{\link{xvardef}}, \code{\link{xpose.data}}
}
\author{
Andrew Hooker
}
\keyword{methods}
