% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/element_descriptors.R
\name{num_total_elements}
\alias{num_total_elements}
\title{Total number of elements}
\usage{
num_total_elements(x, deduplicated = FALSE)
}
\arguments{
\item{x}{List with elements.}

\item{deduplicated}{Whether to only count the unique elements. (Logical)}
}
\value{
The total number of elements in \code{x}.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Unlists \code{x} recursively and finds the total number of elements.
}
\details{
Simple wrapper for
\code{length(unlist(x, recursive = TRUE, use.names = FALSE))}.
}
\examples{
# Attach packages
library(xpectr)

l <- list(list(list(1, 2, 3), list(2, list(3, 2))),
          list(1, list(list(2, 4), list(7, 1, list(3, 8)))),
          list(list(2, 7, 8), list(10, 2, list(18, 1, 4))))

num_total_elements(l)
num_total_elements(l, deduplicated = TRUE)
}
\seealso{
Other element descriptors: 
\code{\link{element_classes}()},
\code{\link{element_lengths}()},
\code{\link{element_types}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{element descriptors}
