% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simStahl.R
\name{simStahl}
\alias{simStahl}
\title{Simulate crossover locations under the Stahl model}
\usage{
simStahl(
  n.sim,
  nu = 1,
  p = 0,
  L = 100,
  obligate_chiasma = FALSE,
  n.bins4start = 10000
)
}
\arguments{
\item{n.sim}{Number of meiotic products to simulate.}

\item{nu}{The interference parameter in the gamma model.}

\item{p}{The proportion of chiasmata coming from the no-interference
mechanism.}

\item{L}{Chromosome length (in cM).}

\item{obligate_chiasma}{Require an obligate chiasma (requires \code{nu} to
be an integer; if nu is not an integer, it is rounded.}

\item{n.bins4start}{We approximate the distribution of the location of the
first crossover from the mechanism exhibiting interference using a even grid
with this many bins. (Only if \code{nu} is not an integer.)}
}
\value{
A vector of length \code{n.sim}, each element being empty (for
products with no crossovers) or a vector of crossover locations, in cM.  An
attribute, \code{L}, contains the chromosome length in cM.
}
\description{
Simulate crossover locations under the Stahl model.
}
\details{
The Stahl model is an extension to the gamma model, in which chiasmata occur
according to two independent mechanisms.  A proportion \eqn{p} come from a
mechanism exhibiting no interference, and a proportion 1-\eqn{p} come from a
mechanism in which chiasma locations follow a gamma model with interference
parameter \eqn{\nu}{nu}.
}
\examples{

# simulations with no interference, chromosome of length 80 cM
xoNI <- simStahl(100, nu=1, p=0, L=80)

# simulations under gamma model with nu=7.6
xogamma <- simStahl(100, nu=7.6, p=0, L=80)

# simulations under Stahl model with nu=7.6, p=0.1
xostahl <- simStahl(100, nu=7.6, p=0.1, L=80)

# simulations under chi-square model with nu=11 (m=10) and obligate chiasma
xo_oblchi <- simStahl(100, nu=11, p=0, L=80, obligate_chiasma=TRUE)

# simulations under Stahl model with nu=11, p=0.1, and obligate chiasma
xo_oblchi_stahl <- simStahl(100, nu=11, p=0.1, L=80, obligate_chiasma=TRUE)
}
\references{
Copenhaver, G. P., Housworth, E. A. and Stahl, F. W. (2002)
Crossover interference in Arabidopsis. \emph{Genetics} \strong{160},
1631--1639.

Housworth, E. A. and Stahl, F. W. (2003) Crossover interference in humans.
\emph{Am J Hum Genet} \strong{73}, 188--197.
}
\seealso{
\code{\link[=fitGamma]{fitGamma()}}, \code{\link[qtl:sim.cross]{qtl::sim.cross()}}
}
\author{
Karl W Broman, \email{broman@wisc.edu}
}
\keyword{datagen}
