% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{convertxoloc}
\alias{convertxoloc}
\title{Convert format of crossover locations data}
\usage{
convertxoloc(breaks)
}
\arguments{
\item{breaks}{A list of crossover locations, as output by
\code{\link[=find.breaks]{find.breaks()}} or \code{\link[=simStahl]{simStahl()}}.}
}
\value{
A data frame with two columns: the inter-crossover and crossover-to
chromosome end differences (\code{"distance"}) and indicators of censoring
type (\code{"censor"}), with 0 = distance between crossovers, 1=start of
chromosome to first crossover, 2 = crossover to end of chromosome, and 3 =
whole chromosome.
}
\description{
Convert the format of data on crossover locations to that needed for the
function \code{\link{fitGamma}.}
}
\examples{

data(bssbsb)

# crossover locations on chromosome 1
xoloc1 <- convertxoloc(find.breaks(bssbsb, chr=1))

# crossover locations on all chromosomes
xoloc <- convertxoloc(find.breaks(bssbsb))

}
\seealso{
\code{\link[=find.breaks]{find.breaks()}}, \code{\link[=fitGamma]{fitGamma()}},
\code{\link[=simStahl]{simStahl()}}
}
\author{
Karl W Broman, \email{broman@wisc.edu}
}
\keyword{utilities}
