% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_chart.R
\name{add_chart}
\alias{add_chart}
\title{Add a chart to the sheet}
\usage{
add_chart(py_obj, chart, anchor = NULL, ...)
}
\arguments{
\item{py_obj}{py_obj}

\item{chart}{chart}

\item{anchor}{anchor}

\item{...}{Additional arguments, i.e. kwargs.}
}
\value{
An openpyxl Python object.
}
\description{
Optionally provide a cell for the top-left anchor
}
\details{
\url{https://openpyxl.readthedocs.io/en/stable/api/openpyxl.worksheet.worksheet.html#openpyxl.worksheet.worksheet.Worksheet.add_chart}
}
\examples{
\dontrun{
wb <- Workbook()
ws <- wb$active
chart <- BarChart(type = "col")
data <- Reference(ws, min_col=2, min_row=1, max_row=7, max_col=3)
cats <- Reference(ws, min_col=1, min_row=2, max_row=7)
chart |>
  add_data(data = data, titles_from_data = TRUE) |>
  set_categories(cats)
ws |> add_chart(chart, "A10")
}

}
