% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgx_auto_explore.R
\name{get_rmd_str}
\alias{get_rmd_str}
\title{\code{get_rmd_str} returns a Rmd template string, based on the desired PKPD parameters}
\usage{
get_rmd_str(
  rmd_template_name = NULL,
  multiple_dosing = FALSE,
  pk_cmt = NULL,
  pd_cmt = NULL,
  pd_data_type = NULL
)
}
\arguments{
\item{rmd_template_name}{A custom output name for the generated Rmd file}

\item{multiple_dosing}{if FALSE use single ascending dose template, if TRUE use multiple}

\item{pk_cmt}{An integer denoting the "compartment" containing the PK data. The "CMT" column will typically
have these integers, where each row may contain either PK or PD data, potentially of different types (continuous, ordinal, etc.)}

\item{pd_cmt}{An integer denoting the "compartment" containing the PD data, of the desired type  (continuous, ordinal, etc.). The "CMT" column will typically
have these integers, where each row may contain either PK or PD data}

\item{pd_data_type}{The type of PD data - acceptable values exist in the following list: ["binary","continuous","count","ordinal","real_example","receptor_occupancy","time_to_event"]}
}
\value{
a string for the Rmd template name
}
\description{
\code{get_rmd_str} returns a Rmd template string, based on the desired PKPD parameters
}
