% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgx_summarize_covariates.R
\name{xgx_summarize_covariates}
\alias{xgx_summarize_covariates}
\title{Summarize Covariate information in a dataset}
\usage{
xgx_summarize_covariates(data, covariates = NULL, n_cts = 8)
}
\arguments{
\item{data, }{the dataset to check. must contain a USUBJID or ID column 
for subject id}

\item{covariates, }{the column names of covariates, to explore}

\item{n_cts, }{the number of unique values for a covariate to be treated as 
continuous, default is 8}
}
\value{
list
}
\description{
\code{xgx_summarize_covariates}
}
\examples{
data <- data.frame(ID = 1:10, WT0 = rnorm(10, 70, 10),
                   SEX = round(runif(10)))
x <- xgx_summarize_covariates(data, c("WT0", "SEX"))

}
