% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{xQTLquery_sqtlSig}
\alias{xQTLquery_sqtlSig}
\title{Query significant sQTL associations for a tissue or multple tissues}
\usage{
xQTLquery_sqtlSig(
  variantName = "",
  genes = "",
  variantType = "auto",
  geneType = "auto",
  tissueSiteDetail = ""
)
}
\arguments{
\item{variantName}{(character) name of variant, dbsnp ID and variant id is supported, eg. "rs138420351" and "chr17_7796745_C_T_b38".}

\item{genes}{(character string or a character vector) gene symbol or gencode id (versioned or unversioned are both supported).}

\item{variantType}{(character) options: "auto", "snpId" or "variantId". Default: "auto".}

\item{geneType}{(character) options: "auto","geneSymbol" or "gencodeId". Default: "auto".}

\item{tissueSiteDetail}{(character) details of tissues in GTEx can be listed using \code{tissueSiteDetailGTExv8} or \code{tissueSiteDetailGTExv7}}
}
\value{
A data.table object.
}
\description{
Only GTEx v8 is supported.
}
\examples{
\donttest{
# Query sQTL associations with rsid:
xQTLquery_sqtlSig(variantName="rs201327123")
xQTLquery_sqtlSig(variantName="chr1_14677_G_A_b38", tissueSiteDetail="Whole Blood")

# Query sQTL associations with gene symbol and gencode ID:
xQTLquery_sqtlSig(genes="ENSG00000141510.16", tissueSiteDetail="Lung" )
xQTLquery_sqtlSig(genes=c("ATAD3B", "MLH1"))

# Query sQTL associations with the variant-genes pair:
xQTLquery_sqtlSig(variantName="rs201327123", genes=c("WASH7P","RP11-206L10.2"))
xQTLquery_sqtlSig(variantName="chr17_7465085_A_G_b38", genes="TP53", tissueSiteDetail="Lung")
}
}
