% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anno.R
\name{xQTLanno_chippeak}
\alias{xQTLanno_chippeak}
\title{enrichment analysis for GWAS / QTL signals in functional elements, including enhancer, promoter, CPG, and TFs}
\usage{
xQTLanno_chippeak(
  snpInfo = "",
  genomeVersion = "hg38",
  enrichElement = NULL,
  distLimit = 1
)
}
\arguments{
\item{snpInfo}{A data.table/data.frame with three columns: chromosome, position and p-value.}

\item{genomeVersion}{"hg38" (default) or "hg19". Note: hg19 will be converted to hg38 automatically.}

\item{enrichElement}{A data.table of data.frame object including 4 columns (consistent with bed4 format): chrom, start, end, name.}

\item{distLimit}{Defaults: 0 (variants overlap with elements).}
}
\value{
A data.table object
}
\description{
enrichment analysis for GWAS / QTL signals in functional elements, including enhancer, promoter, CPG, and TFs
}
\examples{
\donttest{
url1 <- "http://bioinfo.szbl.ac.cn/xQTL_biolinks/xqtl_data/gwas/gwasSub.txt.gz"
url2 <- "http://bioinfo.szbl.ac.cn/xQTL_biolinks/xqtl_data/enhancer.txt"
snpInfo <- data.table::fread(url1, sep="\t")
enhancerDT <- data.table::fread(url2, sep="\t")
variants_hit_enhancer <- xQTLanno_chippeak(snpInfo, enrichElement=enhancerDT)
}
}
