% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate_x3p.R
\name{x3p_rotate}
\alias{x3p_rotate}
\alias{rotate_x3p}
\title{Rotate an x3p object}
\usage{
x3p_rotate(x3p, angle = 90)

rotate_x3p(x3p, angle = 90)
}
\arguments{
\item{x3p}{x3p object}

\item{angle}{rotate counter-clockwise by angle degrees given as 90, 180, 270 degree (or -90, -180, -270).}
}
\description{
Rotate the surface matrix of an x3p object. Also adjust meta information.
}
\examples{
logo <- x3p_read(system.file("csafe-logo.x3p", package="x3ptools"))
dim(logo$surface.matrix)
\dontrun{
x3p_image(logo)
}
# rotate the image by 90 degrees counter-clockwise:
logo90 <- x3p_rotate(logo, 90)
dim(logo90$surface.matrix)
\dontrun{
x3p_image(logo90)
}
}
