% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_x3p.R
\name{write_x3p}
\alias{write_x3p}
\title{Write an x3p object to a file}
\usage{
write_x3p(x3p, file, size = 8, quiet = F)
}
\arguments{
\item{x3p}{x3p object}

\item{file}{path to where the file should be written}

\item{size}{integer. The number of bytes per element in the  surface matrix used for creating the binary file. Use size = 4 for 32 bit IEEE 754 floating point numbers and size = 8 for 64 bit IEEE 754 floating point number (default).}

\item{quiet}{suppress messages}
}
\description{
Write an x3p object to a file
}
\examples{
logo <- read_x3p(system.file("csafe-logo.x3p", package="x3ptools"))
# write a copy of the file into a temporary file
write_x3p(logo, file = tempfile(fileext="x3p")) 
}
