% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesis_quantiles.R
\name{Q_WS_hyp_test}
\alias{Q_WS_hyp_test}
\title{Compute size alpha single-lag hypothesis test under weak or strong white noise assumption}
\usage{
Q_WS_hyp_test(
  f_data,
  lag,
  alpha = 0.05,
  iid = FALSE,
  M = NULL,
  bootstrap = FALSE,
  block_size = "adaptive",
  straps = 300,
  moving = FALSE
)
}
\arguments{
\item{f_data}{the functional data matrix with observed functions in the columns}

\item{lag}{the lag to use to compute the single lag test statistic}

\item{alpha}{the significance level to be used in the hypothesis test}

\item{iid}{boolean value, if given TRUE, the hypothesis test will use a strong-white noise assumption.
By default is FALSE, in which the hypothesis test will use a weak-white noise assumption.}

\item{M}{Number of samples to take when applying a Monte-Carlo approximation}

\item{bootstrap}{boolean value, if given TRUE, the hypothesis test is done by approximating the
limiting distribution of the test statistic via a block bootstrap algorithm. FALSE by default}

\item{block_size}{the block size to be used in the block bootstrap method (in each bootstrap sample).
10 by default.}

\item{straps}{the number of bootstrap samples to take; 300 by default}

\item{moving}{boolean value; determines whether or not the block bootstrap should be moving}
}
\value{
A list containing the p-value, the quantile, and a boolean value indicating whether or not the
hypothesis is rejected.
}
\description{
`Q_WS_hyp_test` Computes the size alpha test of a single lag hypothesis under a weak white noise
or strong white noise assumption using a Welch-Satterthwaite Approximation.
}
