
# ----------------------------------------------------------------
# $Author: thm $
# $Date: 2015-06-02 10:29:56 +0200 (Tue, 02 Jun 2015) $
# $Rev: 343 $
# ----------------------------------------------------------------

InitModelDictionary <- function() {
  ## This is the collection of all needed climate model metainformation.
  ## It is needed for the models2wux function. Currently all ENSEMBLES and
  ## CMIP3 models are described.
  ##
  ## Returns:
  ##   A named list of climate model information.
  ##
  ## History:
  ##   2011-02-11 | original code (thm)
  ##   2011-05-12 | changed CMIP3 data. now all runs have been placed here
  ##                according to
  ##              http://www-]pcmdi.llnl.gov/ipcc/info_for_analysts.php#time_info
  ##                (thm)
  ##       ...    | a lot has happened in the past...
  ##   2012-08-29 | added parameter ts for some ENSEMBLES models, resolved
  ##                some typos and such things (msu)
  ##   2012-12-06 | finally merged wux trunk and timeseries branch (geh & thm)
  ##   2013-03-12 | added RemoUBA-Datasaet (seb)
  ##   2013-10-08 | start adding available EURO CORDEX data (thm)
  ##   2014-02-26 | updated WEGC-CCLM_reclipcentury to new dataset (seb)
  ##   2014-05-22 | started adding quantile-mapped EURO-CORDEX-11 simulations (seb)

  model.input = list(
###++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
###++++++++++++++++++++++++    DATASET: E-OBS            ++++++++++++++++++++
###++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

################################################################################
    'E-OBS_v9' = list(
      rcm = "",
      gcm = "E-OBS",
      institute = "",
      emission.scenario = "",
      file.path.alt = list(
        air_temperature =  "/data/reloclim/rcd/e-obs/data/v9",
        precipitation_amount  =  "/data/reloclim/rcd/e-obs/data/v9"),
      ## file.path.default =  "/data/reloclim/rcd/e-obs/data/v9",
      file.name = list(
        air_temperature = '^tg_0.25deg_reg_v9.0.nc',
        precipitation_amount = '^rr_0.25deg_reg_v9.0.nc'),
      parameters = c(
        air_temperature = "tg",
        precipitation_amount = "rr"
        ),
      ## lonlat.var.name = c(longitude="longitude", latitude="latitude"),
      gridfile.path = "/data/reloclim/rcd/e-obs/data/",
      gridfile.filename = "eobs_0.25deg_reg_v5.0_landseamask.nc",
      land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc"
      ),


################################################################################
###++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
###++++++++++++++++++++++++    DATASET: ERA40            ++++++++++++++++++++
###++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

################################################################################
    'ERA40' = list(
      rcm = "",
      gcm = "ERA40",
      institute = "ECMWF",
      emission.scenario = "",
      file.path.default = "/data/reloclim/rcu/geh/data/ensembles/gcm/ERA40",
      file.name = list(
        air_temperature = c(
          'era40_air_temperature_2m_1957-1960_dm.nc',
          'era40_air_temperature_2m_1961-1970_dm.nc',
          'era40_air_temperature_2m_1971-1980_dm.nc',
          'era40_air_temperature_2m_1981-1990_dm.nc',
          'era40_air_temperature_2m_1991-2000_dm.nc',
          'era40_air_temperature_2m_2001-2002_dm.nc'
          ),
        precipitation_amount = c(
          'era40_precipitation_amount_sfc_1957-1960_ds.nc',
          'era40_precipitation_amount_sfc_1961-1970_ds.nc',
          'era40_precipitation_amount_sfc_1971-1980_ds.nc',
          'era40_precipitation_amount_sfc_1981-1990_ds.nc',
          'era40_precipitation_amount_sfc_1991-2000_ds.nc',
          'era40_precipitation_amount_sfc_2001-2002_ds.nc'
          )),
      parameters = c(air_temperature = "t2m",
        precipitation_amount = "tp"),
      lonlat.var.name = c(longitude="longitude", latitude="latitude"),
      gridfile.path = "/data/koeppen/rcd/ecmwf/data/cordex_eu",
      gridfile.filename = "era40_surface_geopotential_sfc_fix.nc"
      ),
################################################################################


###++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
###++++++++++++++++++++++++    DATASET: CMIP5            ++++++++++++++++++++
###++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

### ----------------------------------------------------------------------
### ************************** SCENARIO: RCP45 ***************************
### ----------------------------------------------------------------------


################################################################################
    'ACCESS1-0-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "ACCESS1-0",
      gcm.run = 1,
      institute = "CSIRO-BOM",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/ACCESS1.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/ACCESS1.0/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/ACCESS1.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/ACCESS1.0/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_ACCESS1-0_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_ACCESS1-0_rcp45_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_ACCESS1-0_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_ACCESS1-0_rcp45_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/ACCESS1.0/historical",
      gridfile.filename = "tas_Amon_ACCESS1-0_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'ACCESS1-3-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "ACCESS1-3",
      gcm.run = 1,
      institute = "CSIRO-BOM",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/ACCESS1.3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/ACCESS1.3/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/ACCESS1.3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/ACCESS1.3/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_ACCESS1-3_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_ACCESS1-3_rcp45_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_ACCESS1-3_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_ACCESS1-3_rcp45_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/ACCESS1.3/historical",
      gridfile.filename = "tas_Amon_ACCESS1-3_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'BCC-CSM1-1-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "BCC-CSM1-1",
      gcm.run = 1,
      institute = "BCC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_bcc-csm1-1_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_bcc-csm1-1_rcp45_r1i1p1_200601-209912.nc", 
            "tas_Amon_bcc-csm1-1_rcp45_r1i1p1_210001-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_bcc-csm1-1_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_bcc-csm1-1_rcp45_r1i1p1_200601-209912.nc", 
            "pr_Amon_bcc-csm1-1_rcp45_r1i1p1_210001-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1/historical",
      gridfile.filename = "tas_Amon_bcc-csm1-1_historical_r1i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'BCC-CSM1-1-m-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "BCC-CSM1-1-m",
      gcm.run = 1,
      institute = "BCC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1(m)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1(m)/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1(m)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1(m)/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_bcc-csm1-1-m_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_bcc-csm1-1-m_rcp45_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_bcc-csm1-1-m_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_bcc-csm1-1-m_rcp45_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1(m)/historical",
      gridfile.filename = "tas_Amon_bcc-csm1-1-m_historical_r1i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'BNU-ESM-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "BNU-ESM",
      gcm.run = 1,
      institute = "GCESS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BNU-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BNU-ESM/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BNU-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BNU-ESM/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_BNU-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_BNU-ESM_rcp45_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_BNU-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_BNU-ESM_rcp45_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BNU-ESM/historical",
      gridfile.filename = "tas_Amon_BNU-ESM_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanCM4-r10i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CanCM4",
      gcm.run = 10,
      institute = "CCCma",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanCM4_historical_r10i1p1_196101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanCM4_rcp45_r10i1p1_200601-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanCM4_historical_r10i1p1_196101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanCM4_rcp45_r10i1p1_200601-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
      gridfile.filename = "tas_Amon_CanCM4_historical_r10i1p1_196101-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanCM4-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CanCM4",
      gcm.run = 1,
      institute = "CCCma",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanCM4_historical_r1i1p1_196101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanCM4_rcp45_r1i1p1_200601-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanCM4_historical_r1i1p1_196101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanCM4_rcp45_r1i1p1_200601-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
      gridfile.filename = "tas_Amon_CanCM4_historical_r1i1p1_196101-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanCM4-r2i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CanCM4",
      gcm.run = 2,
      institute = "CCCma",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanCM4_historical_r2i1p1_196101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanCM4_rcp45_r2i1p1_200601-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanCM4_historical_r2i1p1_196101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanCM4_rcp45_r2i1p1_200601-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
      gridfile.filename = "tas_Amon_CanCM4_historical_r2i1p1_196101-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanCM4-r3i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CanCM4",
      gcm.run = 3,
      institute = "CCCma",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanCM4_historical_r3i1p1_196101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanCM4_rcp45_r3i1p1_200601-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanCM4_historical_r3i1p1_196101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanCM4_rcp45_r3i1p1_200601-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
      gridfile.filename = "tas_Amon_CanCM4_historical_r3i1p1_196101-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanCM4-r4i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CanCM4",
      gcm.run = 4,
      institute = "CCCma",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanCM4_historical_r4i1p1_196101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanCM4_rcp45_r4i1p1_200601-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanCM4_historical_r4i1p1_196101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanCM4_rcp45_r4i1p1_200601-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
      gridfile.filename = "tas_Amon_CanCM4_historical_r4i1p1_196101-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanCM4-r5i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CanCM4",
      gcm.run = 5,
      institute = "CCCma",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanCM4_historical_r5i1p1_196101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanCM4_rcp45_r5i1p1_200601-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanCM4_historical_r5i1p1_196101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanCM4_rcp45_r5i1p1_200601-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
      gridfile.filename = "tas_Amon_CanCM4_historical_r5i1p1_196101-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanCM4-r6i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CanCM4",
      gcm.run = 6,
      institute = "CCCma",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanCM4_historical_r6i1p1_196101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanCM4_rcp45_r6i1p1_200601-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanCM4_historical_r6i1p1_196101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanCM4_rcp45_r6i1p1_200601-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
      gridfile.filename = "tas_Amon_CanCM4_historical_r6i1p1_196101-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanCM4-r7i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CanCM4",
      gcm.run = 7,
      institute = "CCCma",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanCM4_historical_r7i1p1_196101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanCM4_rcp45_r7i1p1_200601-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanCM4_historical_r7i1p1_196101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanCM4_rcp45_r7i1p1_200601-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
      gridfile.filename = "tas_Amon_CanCM4_historical_r7i1p1_196101-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanCM4-r8i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CanCM4",
      gcm.run = 8,
      institute = "CCCma",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanCM4_historical_r8i1p1_196101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanCM4_rcp45_r8i1p1_200601-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanCM4_historical_r8i1p1_196101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanCM4_rcp45_r8i1p1_200601-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
      gridfile.filename = "tas_Amon_CanCM4_historical_r8i1p1_196101-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanCM4-r9i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CanCM4",
      gcm.run = 9,
      institute = "CCCma",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanCM4_historical_r9i1p1_196101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanCM4_rcp45_r9i1p1_200601-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanCM4_historical_r9i1p1_196101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanCM4_rcp45_r9i1p1_200601-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanCM4/historical",
      gridfile.filename = "tas_Amon_CanCM4_historical_r9i1p1_196101-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanESM2-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CanESM2",
      gcm.run = 1,
      institute = "CCCma",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanESM2_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanESM2_rcp45_r1i1p1_200601-210012.nc", 
            "tas_Amon_CanESM2_rcp45_r1i1p1_210101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanESM2_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanESM2_rcp45_r1i1p1_200601-210012.nc", 
            "pr_Amon_CanESM2_rcp45_r1i1p1_210101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
      gridfile.filename = "tas_Amon_CanESM2_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanESM2-r2i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CanESM2",
      gcm.run = 2,
      institute = "CCCma",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanESM2_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanESM2_rcp45_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanESM2_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanESM2_rcp45_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
      gridfile.filename = "tas_Amon_CanESM2_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanESM2-r3i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CanESM2",
      gcm.run = 3,
      institute = "CCCma",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanESM2_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanESM2_rcp45_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanESM2_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanESM2_rcp45_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
      gridfile.filename = "tas_Amon_CanESM2_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanESM2-r4i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CanESM2",
      gcm.run = 4,
      institute = "CCCma",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanESM2_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanESM2_rcp45_r4i1p1_200601-210012.nc", 
            "tas_Amon_CanESM2_rcp45_r4i1p1_210101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanESM2_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanESM2_rcp45_r4i1p1_200601-210012.nc", 
            "pr_Amon_CanESM2_rcp45_r4i1p1_210101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
      gridfile.filename = "tas_Amon_CanESM2_historical_r4i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanESM2-r5i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CanESM2",
      gcm.run = 5,
      institute = "CCCma",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanESM2_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanESM2_rcp45_r5i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanESM2_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanESM2_rcp45_r5i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
      gridfile.filename = "tas_Amon_CanESM2_historical_r5i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 1,
      institute = "NCAR",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_CCSM4_rcp45_r1i1p1_200501-210012.nc", 
            "tas_Amon_CCSM4_rcp45_r1i1p1_200601-210012.nc", 
            "tas_Amon_CCSM4_rcp45_r1i1p1_210101-229912.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp45_r1i1p1_200601-210012.nc", 
            "pr_Amon_CCSM4_rcp45_r1i1p1_210101-229912.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r2i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 2,
      institute = "NCAR",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_CCSM4_rcp45_r2i1p1_200501-210012.nc", 
            "tas_Amon_CCSM4_rcp45_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp45_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r3i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 3,
      institute = "NCAR",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_CCSM4_rcp45_r3i1p1_200501-210012.nc", 
            "tas_Amon_CCSM4_rcp45_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp45_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r4i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 4,
      institute = "NCAR",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_CCSM4_rcp45_r4i1p1_200501-210012.nc", 
            "tas_Amon_CCSM4_rcp45_r4i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp45_r4i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r4i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r5i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 5,
      institute = "NCAR",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_CCSM4_rcp45_r5i1p1_200501-210012.nc", 
            "tas_Amon_CCSM4_rcp45_r5i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp45_r5i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r5i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r6i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 6,
      institute = "NCAR",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r6i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CCSM4_rcp45_r6i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r6i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp45_r6i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r6i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CESM1-BGC-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CESM1-BGC",
      gcm.run = 1,
      institute = "NSF-DOE-NCAR",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(BGC)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(BGC)/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(BGC)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(BGC)/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CESM1-BGC_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CESM1-BGC_rcp45_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CESM1-BGC_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CESM1-BGC_rcp45_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(BGC)/historical",
      gridfile.filename = "tas_Amon_CESM1-BGC_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CESM1-CAM5-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CESM1-CAM5",
      gcm.run = 1,
      institute = "NSF-DOE-NCAR",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CESM1-CAM5_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CESM1-CAM5_rcp45_r1i1p1_200601-210012.nc", 
            "tas_Amon_CESM1-CAM5_rcp45_r1i1p1_210101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CESM1-CAM5_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CESM1-CAM5_rcp45_r1i1p1_200601-210012.nc", 
            "pr_Amon_CESM1-CAM5_rcp45_r1i1p1_210101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
      gridfile.filename = "tas_Amon_CESM1-CAM5_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CESM1-CAM5-r2i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CESM1-CAM5",
      gcm.run = 2,
      institute = "NSF-DOE-NCAR",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CESM1-CAM5_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CESM1-CAM5_rcp45_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CESM1-CAM5_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CESM1-CAM5_rcp45_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
      gridfile.filename = "tas_Amon_CESM1-CAM5_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CESM1-CAM5-r3i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CESM1-CAM5",
      gcm.run = 3,
      institute = "NSF-DOE-NCAR",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CESM1-CAM5_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CESM1-CAM5_rcp45_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CESM1-CAM5_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CESM1-CAM5_rcp45_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
      gridfile.filename = "tas_Amon_CESM1-CAM5_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CESM1-WACCM-r2i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CESM1-WACCM",
      gcm.run = 2,
      institute = "NSF-DOE-NCAR",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CESM1-WACCM_historical_r2i1p1_195501-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CESM1-WACCM_rcp45_r2i1p1_200601-209912.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CESM1-WACCM_historical_r2i1p1_195501-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CESM1-WACCM_rcp45_r2i1p1_200601-209912.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/historical",
      gridfile.filename = "tas_Amon_CESM1-WACCM_historical_r2i1p1_195501-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CESM1-WACCM-r3i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CESM1-WACCM",
      gcm.run = 3,
      institute = "NSF-DOE-NCAR",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CESM1-WACCM_historical_r3i1p1_195501-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CESM1-WACCM_rcp45_r3i1p1_200601-206512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CESM1-WACCM_historical_r3i1p1_195501-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CESM1-WACCM_rcp45_r3i1p1_200601-206512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/historical",
      gridfile.filename = "tas_Amon_CESM1-WACCM_historical_r3i1p1_195501-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CESM1-WACCM-r4i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CESM1-WACCM",
      gcm.run = 4,
      institute = "NSF-DOE-NCAR",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CESM1-WACCM_historical_r4i1p1_195501-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CESM1-WACCM_rcp45_r4i1p1_200601-206512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CESM1-WACCM_historical_r4i1p1_195501-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CESM1-WACCM_rcp45_r4i1p1_200601-206512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/historical",
      gridfile.filename = "tas_Amon_CESM1-WACCM_historical_r4i1p1_195501-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CMCC-CM-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CMCC-CM",
      gcm.run = 1,
      institute = "CMCC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CM/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CM/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CMCC-CM_historical_r1i1p1_185001-185912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_186001-186912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_187001-187912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_188001-188912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_189001-189912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_190001-190912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_191001-191912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_192001-192912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_193001-193912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_194001-194912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_195001-195912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_196001-196912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_197001-197912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_198001-198912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_199001-199912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_200001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CMCC-CM_rcp45_r1i1p1_200601-201012.nc", 
            "tas_Amon_CMCC-CM_rcp45_r1i1p1_201101-202012.nc", 
            "tas_Amon_CMCC-CM_rcp45_r1i1p1_202101-203012.nc", 
            "tas_Amon_CMCC-CM_rcp45_r1i1p1_203101-204012.nc", 
            "tas_Amon_CMCC-CM_rcp45_r1i1p1_204101-205012.nc", 
            "tas_Amon_CMCC-CM_rcp45_r1i1p1_205101-206012.nc", 
            "tas_Amon_CMCC-CM_rcp45_r1i1p1_206101-207012.nc", 
            "tas_Amon_CMCC-CM_rcp45_r1i1p1_207101-208012.nc", 
            "tas_Amon_CMCC-CM_rcp45_r1i1p1_208101-209012.nc", 
            "tas_Amon_CMCC-CM_rcp45_r1i1p1_209101-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CMCC-CM_historical_r1i1p1_185001-185912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_186001-186912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_187001-187912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_188001-188912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_189001-189912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_190001-190912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_191001-191912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_192001-192912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_193001-193912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_194001-194912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_195001-195912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_196001-196912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_197001-197912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_198001-198912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_199001-199912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_200001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CMCC-CM_rcp45_r1i1p1_200601-201012.nc", 
            "pr_Amon_CMCC-CM_rcp45_r1i1p1_201101-202012.nc", 
            "pr_Amon_CMCC-CM_rcp45_r1i1p1_202101-203012.nc", 
            "pr_Amon_CMCC-CM_rcp45_r1i1p1_203101-204012.nc", 
            "pr_Amon_CMCC-CM_rcp45_r1i1p1_204101-205012.nc", 
            "pr_Amon_CMCC-CM_rcp45_r1i1p1_205101-206012.nc", 
            "pr_Amon_CMCC-CM_rcp45_r1i1p1_206101-207012.nc", 
            "pr_Amon_CMCC-CM_rcp45_r1i1p1_207101-208012.nc", 
            "pr_Amon_CMCC-CM_rcp45_r1i1p1_208101-209012.nc", 
            "pr_Amon_CMCC-CM_rcp45_r1i1p1_209101-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CM/historical",
      gridfile.filename = "tas_Amon_CMCC-CM_historical_r1i1p1_185001-185912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CMCC-CMS-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CMCC-CMS",
      gcm.run = 1,
      institute = "CMCC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CMS/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CMS/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CMS/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CMS/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CMCC-CMS_historical_r1i1p1_185001-185912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_186001-186912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_187001-187912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_188001-188912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_189001-189912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_190001-190912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_191001-191912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_192001-192912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_193001-193912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_194001-194912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_195001-195912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_196001-196912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_197001-197912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_198001-198912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_199001-199912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_200001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CMCC-CMS_rcp45_r1i1p1_200601-200912.nc", 
            "tas_Amon_CMCC-CMS_rcp45_r1i1p1_201001-201912.nc", 
            "tas_Amon_CMCC-CMS_rcp45_r1i1p1_202001-202912.nc", 
            "tas_Amon_CMCC-CMS_rcp45_r1i1p1_203001-203912.nc", 
            "tas_Amon_CMCC-CMS_rcp45_r1i1p1_204001-204912.nc", 
            "tas_Amon_CMCC-CMS_rcp45_r1i1p1_205001-205912.nc", 
            "tas_Amon_CMCC-CMS_rcp45_r1i1p1_206001-206912.nc", 
            "tas_Amon_CMCC-CMS_rcp45_r1i1p1_207001-207912.nc", 
            "tas_Amon_CMCC-CMS_rcp45_r1i1p1_208001-208912.nc", 
            "tas_Amon_CMCC-CMS_rcp45_r1i1p1_209001-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CMCC-CMS_historical_r1i1p1_185001-185912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_186001-186912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_187001-187912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_188001-188912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_189001-189912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_190001-190912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_191001-191912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_192001-192912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_193001-193912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_194001-194912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_195001-195912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_196001-196912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_197001-197912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_198001-198912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_199001-199912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_200001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CMCC-CMS_rcp45_r1i1p1_200601-200912.nc", 
            "pr_Amon_CMCC-CMS_rcp45_r1i1p1_201001-201912.nc", 
            "pr_Amon_CMCC-CMS_rcp45_r1i1p1_202001-202912.nc", 
            "pr_Amon_CMCC-CMS_rcp45_r1i1p1_203001-203912.nc", 
            "pr_Amon_CMCC-CMS_rcp45_r1i1p1_204001-204912.nc", 
            "pr_Amon_CMCC-CMS_rcp45_r1i1p1_205001-205912.nc", 
            "pr_Amon_CMCC-CMS_rcp45_r1i1p1_206001-206912.nc", 
            "pr_Amon_CMCC-CMS_rcp45_r1i1p1_207001-207912.nc", 
            "pr_Amon_CMCC-CMS_rcp45_r1i1p1_208001-208912.nc", 
            "pr_Amon_CMCC-CMS_rcp45_r1i1p1_209001-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CMS/historical",
      gridfile.filename = "tas_Amon_CMCC-CMS_historical_r1i1p1_185001-185912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CNRM-CM5-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CNRM-CM5",
      gcm.run = 1,
      institute = "CNRM-CERFACS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CNRM-CM5_historical_r1i1p1_185001-189912.nc", 
            "tas_Amon_CNRM-CM5_historical_r1i1p1_190001-194912.nc", 
            "tas_Amon_CNRM-CM5_historical_r1i1p1_195001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CNRM-CM5_rcp45_r1i1p1_200601-205512.nc", 
            "tas_Amon_CNRM-CM5_rcp45_r1i1p1_205601-210012.nc", 
            "tas_Amon_CNRM-CM5_rcp45_r1i1p1_210101-215012.nc", 
            "tas_Amon_CNRM-CM5_rcp45_r1i1p1_215101-220012.nc", 
            "tas_Amon_CNRM-CM5_rcp45_r1i1p1_220101-225012.nc", 
            "tas_Amon_CNRM-CM5_rcp45_r1i1p1_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CNRM-CM5_historical_r1i1p1_185001-189912.nc", 
            "pr_Amon_CNRM-CM5_historical_r1i1p1_190001-194912.nc", 
            "pr_Amon_CNRM-CM5_historical_r1i1p1_195001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CNRM-CM5_rcp45_r1i1p1_200601-205512.nc", 
            "pr_Amon_CNRM-CM5_rcp45_r1i1p1_205601-210012.nc", 
            "pr_Amon_CNRM-CM5_rcp45_r1i1p1_210101-215012.nc", 
            "pr_Amon_CNRM-CM5_rcp45_r1i1p1_215101-220012.nc", 
            "pr_Amon_CNRM-CM5_rcp45_r1i1p1_220101-225012.nc", 
            "pr_Amon_CNRM-CM5_rcp45_r1i1p1_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/historical",
      gridfile.filename = "tas_Amon_CNRM-CM5_historical_r1i1p1_185001-189912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r10i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 10,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r10i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp45_r10i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r10i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp45_r10i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r10i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 1,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp45_r1i1p1_200601-210012.nc", 
            "tas_Amon_CSIRO-Mk3-6-0_rcp45_r1i1p1_210101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp45_r1i1p1_200601-210012.nc", 
            "pr_Amon_CSIRO-Mk3-6-0_rcp45_r1i1p1_210101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r2i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 2,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp45_r2i1p1_200601-210012.nc", 
            "tas_Amon_CSIRO-Mk3-6-0_rcp45_r2i1p1_210101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp45_r2i1p1_200601-210012.nc", 
            "pr_Amon_CSIRO-Mk3-6-0_rcp45_r2i1p1_210101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r3i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 3,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp45_r3i1p1_200601-210012.nc", 
            "tas_Amon_CSIRO-Mk3-6-0_rcp45_r3i1p1_210101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp45_r3i1p1_200601-210012.nc", 
            "pr_Amon_CSIRO-Mk3-6-0_rcp45_r3i1p1_210101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r4i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 4,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp45_r4i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp45_r4i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r4i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r5i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 5,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp45_r5i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp45_r5i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r5i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r6i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 6,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r6i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp45_r6i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r6i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp45_r6i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r6i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r7i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 7,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r7i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp45_r7i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r7i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp45_r7i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r7i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r8i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 8,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r8i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp45_r8i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r8i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp45_r8i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r8i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r9i1p1_rcp45' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 9,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r9i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp45_r9i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r9i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp45_r9i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r9i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'EC-EARTH-r12i1p1_rcp45' = list( 
      rcm = "",
      gcm = "EC-EARTH",
      gcm.run = 12,
      institute = "EC-EARTH",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_EC-EARTH_historical_r12i1p1_185001-189912.nc", 
            "tas_Amon_EC-EARTH_historical_r12i1p1_190001-194912.nc", 
            "tas_Amon_EC-EARTH_historical_r12i1p1_195001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_EC-EARTH_rcp45_r12i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_EC-EARTH_historical_r12i1p1_185001-189912.nc", 
            "pr_Amon_EC-EARTH_historical_r12i1p1_190001-194912.nc", 
            "pr_Amon_EC-EARTH_historical_r12i1p1_195001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_EC-EARTH_rcp45_r12i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
      gridfile.filename = "tas_Amon_EC-EARTH_historical_r12i1p1_185001-189912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'EC-EARTH-r13i1p1_rcp45' = list( 
      rcm = "",
      gcm = "EC-EARTH",
      gcm.run = 13,
      institute = "EC-EARTH",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_EC-EARTH_historical_r13i1p1_195001-195912.nc", 
            "tas_Amon_EC-EARTH_historical_r13i1p1_196001-196912.nc", 
            "tas_Amon_EC-EARTH_historical_r13i1p1_197001-197912.nc", 
            "tas_Amon_EC-EARTH_historical_r13i1p1_198001-198912.nc", 
            "tas_Amon_EC-EARTH_historical_r13i1p1_199001-199912.nc", 
            "tas_Amon_EC-EARTH_historical_r13i1p1_200001-200911.nc"
            ),
          scenario = c(
            "tas_Amon_EC-EARTH_rcp45_r13i1p1_200601-200912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r13i1p1_201001-201912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r13i1p1_202001-202912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r13i1p1_203001-203912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r13i1p1_204001-204912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r13i1p1_205001-205912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r13i1p1_206001-206912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r13i1p1_207001-207912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r13i1p1_208001-208912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r13i1p1_209001-209912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r13i1p1_210001-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_EC-EARTH_historical_r13i1p1_195001-195912.nc", 
            "pr_Amon_EC-EARTH_historical_r13i1p1_196001-196912.nc", 
            "pr_Amon_EC-EARTH_historical_r13i1p1_197001-197912.nc", 
            "pr_Amon_EC-EARTH_historical_r13i1p1_198001-198912.nc", 
            "pr_Amon_EC-EARTH_historical_r13i1p1_199001-199912.nc", 
            "pr_Amon_EC-EARTH_historical_r13i1p1_200001-200911.nc"
            ),
          scenario = c(
            "pr_Amon_EC-EARTH_rcp45_r13i1p1_200601-200912.nc", 
            "pr_Amon_EC-EARTH_rcp45_r13i1p1_201001-201912.nc", 
            "pr_Amon_EC-EARTH_rcp45_r13i1p1_202001-202912.nc", 
            "pr_Amon_EC-EARTH_rcp45_r13i1p1_203001-203912.nc", 
            "pr_Amon_EC-EARTH_rcp45_r13i1p1_204001-204912.nc", 
            "pr_Amon_EC-EARTH_rcp45_r13i1p1_205001-205912.nc", 
            "pr_Amon_EC-EARTH_rcp45_r13i1p1_206001-206912.nc", 
            "pr_Amon_EC-EARTH_rcp45_r13i1p1_207001-207912.nc", 
            "pr_Amon_EC-EARTH_rcp45_r13i1p1_208001-208912.nc", 
            "pr_Amon_EC-EARTH_rcp45_r13i1p1_209001-209912.nc", 
            "pr_Amon_EC-EARTH_rcp45_r13i1p1_210001-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
      gridfile.filename = "tas_Amon_EC-EARTH_historical_r13i1p1_195001-195912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'EC-EARTH-r14i1p1_rcp45' = list( 
      rcm = "",
      gcm = "EC-EARTH",
      gcm.run = 14,
      institute = "EC-EARTH",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_EC-EARTH_historical_r14i1p1_195001-195912.nc", 
            "tas_Amon_EC-EARTH_historical_r14i1p1_196001-196912.nc", 
            "tas_Amon_EC-EARTH_historical_r14i1p1_197001-197912.nc", 
            "tas_Amon_EC-EARTH_historical_r14i1p1_198001-198912.nc", 
            "tas_Amon_EC-EARTH_historical_r14i1p1_199001-199912.nc", 
            "tas_Amon_EC-EARTH_historical_r14i1p1_200001-200911.nc"
            ),
          scenario = c(
            "tas_Amon_EC-EARTH_rcp45_r14i1p1_200601-200912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r14i1p1_201001-201912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r14i1p1_202001-202912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r14i1p1_203001-203912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r14i1p1_204001-204912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r14i1p1_205001-205912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r14i1p1_206001-206912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r14i1p1_207001-207912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r14i1p1_208001-208912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r14i1p1_209001-209912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r14i1p1_210001-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_EC-EARTH_historical_r14i1p1_195001-195912.nc", 
            "pr_Amon_EC-EARTH_historical_r14i1p1_196001-196912.nc", 
            "pr_Amon_EC-EARTH_historical_r14i1p1_197001-197912.nc", 
            "pr_Amon_EC-EARTH_historical_r14i1p1_198001-198912.nc", 
            "pr_Amon_EC-EARTH_historical_r14i1p1_199001-199912.nc", 
            "pr_Amon_EC-EARTH_historical_r14i1p1_200001-200911.nc"
            ),
          scenario = c(
            "pr_Amon_EC-EARTH_rcp45_r14i1p1_200601-200912.nc", 
            "pr_Amon_EC-EARTH_rcp45_r14i1p1_201001-201912.nc", 
            "pr_Amon_EC-EARTH_rcp45_r14i1p1_202001-202912.nc", 
            "pr_Amon_EC-EARTH_rcp45_r14i1p1_203001-203912.nc", 
            "pr_Amon_EC-EARTH_rcp45_r14i1p1_204001-204912.nc", 
            "pr_Amon_EC-EARTH_rcp45_r14i1p1_205001-205912.nc", 
            "pr_Amon_EC-EARTH_rcp45_r14i1p1_206001-206912.nc", 
            "pr_Amon_EC-EARTH_rcp45_r14i1p1_207001-207912.nc", 
            "pr_Amon_EC-EARTH_rcp45_r14i1p1_208001-208912.nc", 
            "pr_Amon_EC-EARTH_rcp45_r14i1p1_209001-209912.nc", 
            "pr_Amon_EC-EARTH_rcp45_r14i1p1_210001-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
      gridfile.filename = "tas_Amon_EC-EARTH_historical_r14i1p1_195001-195912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    ## WARNING, SCENAIO DATA FOR PRECIP NOT AVAILABLE!
    'EC-EARTH-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "EC-EARTH",
      gcm.run = 1,
      institute = "EC-EARTH",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_EC-EARTH_historical_r1i1p1_185001-185912.nc", 
            "tas_Amon_EC-EARTH_historical_r1i1p1_186001-186912.nc", 
            "tas_Amon_EC-EARTH_historical_r1i1p1_187001-187912.nc", 
            "tas_Amon_EC-EARTH_historical_r1i1p1_188001-188912.nc", 
            "tas_Amon_EC-EARTH_historical_r1i1p1_189001-189912.nc", 
            "tas_Amon_EC-EARTH_historical_r1i1p1_190001-190912.nc", 
            "tas_Amon_EC-EARTH_historical_r1i1p1_191001-191912.nc", 
            "tas_Amon_EC-EARTH_historical_r1i1p1_192001-192912.nc", 
            "tas_Amon_EC-EARTH_historical_r1i1p1_193001-193912.nc", 
            "tas_Amon_EC-EARTH_historical_r1i1p1_194001-194912.nc", 
            "tas_Amon_EC-EARTH_historical_r1i1p1_195001-195912.nc", 
            "tas_Amon_EC-EARTH_historical_r1i1p1_196001-196912.nc", 
            "tas_Amon_EC-EARTH_historical_r1i1p1_197001-197912.nc", 
            "tas_Amon_EC-EARTH_historical_r1i1p1_198001-198912.nc", 
            "tas_Amon_EC-EARTH_historical_r1i1p1_199001-199912.nc", 
            "tas_Amon_EC-EARTH_historical_r1i1p1_200001-200911.nc"
            ),
          scenario = c(
            "tas_Amon_EC-EARTH_rcp45_r1i1p1_200601-200912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r1i1p1_201001-201912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r1i1p1_202001-202912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r1i1p1_203001-203912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r1i1p1_204001-204912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r1i1p1_205001-205912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r1i1p1_206001-206912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r1i1p1_207001-207912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r1i1p1_208001-208912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r1i1p1_209001-209912.nc", 
            "tas_Amon_EC-EARTH_rcp45_r1i1p1_210001-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            ## "pr_Amon_EC-EARTH_historical_r1i1p1_185001-185912.nc", 
            ## "pr_Amon_EC-EARTH_historical_r1i1p1_186001-186912.nc", 
            ## "pr_Amon_EC-EARTH_historical_r1i1p1_187001-187912.nc", 
            ## "pr_Amon_EC-EARTH_historical_r1i1p1_188001-188912.nc", 
            ## "pr_Amon_EC-EARTH_historical_r1i1p1_189001-189912.nc", 
            ## "pr_Amon_EC-EARTH_historical_r1i1p1_190001-190912.nc", 
            ## "pr_Amon_EC-EARTH_historical_r1i1p1_191001-191912.nc", 
            ## "pr_Amon_EC-EARTH_historical_r1i1p1_192001-192912.nc", 
            ## "pr_Amon_EC-EARTH_historical_r1i1p1_193001-193912.nc", 
            ## "pr_Amon_EC-EARTH_historical_r1i1p1_194001-194912.nc", 
            ## "pr_Amon_EC-EARTH_historical_r1i1p1_195001-195912.nc", 
            ## "pr_Amon_EC-EARTH_historical_r1i1p1_196001-196912.nc", 
            ## "pr_Amon_EC-EARTH_historical_r1i1p1_197001-197912.nc", 
            ## "pr_Amon_EC-EARTH_historical_r1i1p1_198001-198912.nc", 
            ## "pr_Amon_EC-EARTH_historical_r1i1p1_199001-199912.nc", 
            ## "pr_Amon_EC-EARTH_historical_r1i1p1_200001-200912.nc"
            NA
            ),
          scenario = c(
            NA
            ## "pr_Amon_EC-EARTH_rcp45_r1i1p1_200601-200912.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
      gridfile.filename = "tas_Amon_EC-EARTH_historical_r1i1p1_185001-185912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'EC-EARTH-r2i1p1_rcp45' = list( 
      rcm = "",
      gcm = "EC-EARTH",
      gcm.run = 2,
      institute = "EC-EARTH",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_EC-EARTH_historical_r2i1p1_185001-189912.nc", 
            "tas_Amon_EC-EARTH_historical_r2i1p1_190001-194912.nc", 
            "tas_Amon_EC-EARTH_historical_r2i1p1_195001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_EC-EARTH_rcp45_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_EC-EARTH_historical_r2i1p1_185001-189912.nc", 
            "pr_Amon_EC-EARTH_historical_r2i1p1_190001-194912.nc", 
            "pr_Amon_EC-EARTH_historical_r2i1p1_195001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_EC-EARTH_rcp45_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
      gridfile.filename = "tas_Amon_EC-EARTH_historical_r2i1p1_185001-189912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'EC-EARTH-r6i1p1_rcp45' = list( 
      rcm = "",
      gcm = "EC-EARTH",
      gcm.run = 6,
      institute = "EC-EARTH",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_EC-EARTH_historical_r6i1p1_185001-189912.nc", 
            "tas_Amon_EC-EARTH_historical_r6i1p1_190001-194912.nc", 
            "tas_Amon_EC-EARTH_historical_r6i1p1_195001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_EC-EARTH_rcp45_r6i1p1_200601-205012.nc", 
            "tas_Amon_EC-EARTH_rcp45_r6i1p1_205101-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_EC-EARTH_historical_r6i1p1_185001-189912.nc", 
            "pr_Amon_EC-EARTH_historical_r6i1p1_190001-194912.nc", 
            "pr_Amon_EC-EARTH_historical_r6i1p1_195001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_EC-EARTH_rcp45_r6i1p1_200601-205012.nc", 
            "pr_Amon_EC-EARTH_rcp45_r6i1p1_205101-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
      gridfile.filename = "tas_Amon_EC-EARTH_historical_r6i1p1_185001-189912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    ## 'EC-EARTH-r7i1p1_rcp45' = list( 
    ##   rcm = "",
    ##   gcm = "EC-EARTH",
    ##   gcm.run = 7,
    ##   institute = "EC-EARTH",
    ##   emission.scenario = "rcp45",
    ##   file.path.alt = list(
    ##     air_temperature =
    ##     list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
    ##          scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp45"),
    ##     precipitation_amount =
    ##     list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
    ##          scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp45")),
    ##   file.name = list(
    ##     air_temperature = list(
    ##       historical = c(
    ##         "tas_Amon_EC-EARTH_historical_r7i1p1_200601-204512.nc", 
    ##         "tas_Amon_EC-EARTH_historical_r7i1p1_204601-208012.nc", 
    ##         "tas_Amon_EC-EARTH_historical_r7i1p1_208101-210012.nc"
    ##         ),
    ##       scenario = c(
    ##         "tas_Amon_EC-EARTH_rcp45_r7i1p1_200601-205012.nc", 
    ##         "tas_Amon_EC-EARTH_rcp45_r7i1p1_205101-210012.nc"
    ##         )),
    ##     precipitation_amount = list(
    ##       historical = c(
    ##         "pr_Amon_EC-EARTH_historical_r7i1p1_200601-204512.nc", 
    ##         "pr_Amon_EC-EARTH_historical_r7i1p1_204601-208012.nc", 
    ##         "pr_Amon_EC-EARTH_historical_r7i1p1_208101-210012.nc"
    ##         ),
    ##       scenario = c(
    ##         "pr_Amon_EC-EARTH_rcp45_r7i1p1_200601-205012.nc", 
    ##         "pr_Amon_EC-EARTH_rcp45_r7i1p1_205101-210012.nc"
    ##        ))),
    ##   gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
    ##   gridfile.filename = "tas_Amon_EC-EARTH_historical_r7i1p1_200601-204512.nc",
    ##   resolution = "",
    ##   what.timesteps = "monthly"
    ##   ),

################################################################################
    'EC-EARTH-r8i1p1_rcp45' = list( 
      rcm = "",
      gcm = "EC-EARTH",
      gcm.run = 8,
      institute = "EC-EARTH",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_EC-EARTH_historical_r8i1p1_185001-189912.nc", 
            "tas_Amon_EC-EARTH_historical_r8i1p1_190001-194912.nc", 
            "tas_Amon_EC-EARTH_historical_r8i1p1_195001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_EC-EARTH_rcp45_r8i1p1_200601-205012.nc", 
            "tas_Amon_EC-EARTH_rcp45_r8i1p1_205101-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_EC-EARTH_historical_r8i1p1_185001-189912.nc", 
            "pr_Amon_EC-EARTH_historical_r8i1p1_190001-194912.nc", 
            "pr_Amon_EC-EARTH_historical_r8i1p1_195001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_EC-EARTH_rcp45_r8i1p1_200601-205012.nc", 
            "pr_Amon_EC-EARTH_rcp45_r8i1p1_205101-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
      gridfile.filename = "tas_Amon_EC-EARTH_historical_r8i1p1_185001-189912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'EC-EARTH-r9i1p1_rcp45' = list( 
      rcm = "",
      gcm = "EC-EARTH",
      gcm.run = 9,
      institute = "EC-EARTH",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_EC-EARTH_historical_r9i1p1_185001-189912.nc", 
            "tas_Amon_EC-EARTH_historical_r9i1p1_190001-194912.nc", 
            "tas_Amon_EC-EARTH_historical_r9i1p1_195001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_EC-EARTH_rcp45_r9i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_EC-EARTH_historical_r9i1p1_185001-189912.nc", 
            "pr_Amon_EC-EARTH_historical_r9i1p1_190001-194912.nc", 
            "pr_Amon_EC-EARTH_historical_r9i1p1_195001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_EC-EARTH_rcp45_r9i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
      gridfile.filename = "tas_Amon_EC-EARTH_historical_r9i1p1_185001-189912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'FGOALS-g2-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "FGOALS-g2",
      gcm.run = 1,
      institute = "LASG-CESS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-g2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-g2/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-g2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-g2/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_FGOALS-g2_historical_r1i1p1_185001-185912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_186001-186912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_187001-187912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_188001-188912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_189001-189912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_190001-190912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_191001-191912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_192001-192912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_193001-193912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_194001-194912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_195001-195912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_196001-196912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_197001-197912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_198001-198912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_199001-199912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_200001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_200601-201512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_201601-202512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_202601-203512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_203601-204512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_204601-205512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_205601-206512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_206601-207512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_207601-208512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_208601-209512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_209601-210512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_210601-211512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_211601-212512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_212601-213512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_213601-214512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_214601-215512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_215601-216512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_216601-217512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_217601-218512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_218601-219512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_219601-220512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_220601-221512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_221601-222512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_222601-223512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_223601-224512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_224601-225512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_225601-226512.nc", 
            "tas_Amon_FGOALS-g2_rcp45_r1i1p1_226601-227512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_FGOALS-g2_historical_r1i1p1_185001-185912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_186001-186912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_187001-187912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_188001-188912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_189001-189912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_190001-190912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_191001-191912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_192001-192912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_193001-193912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_194001-194912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_195001-195912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_196001-196912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_197001-197912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_198001-198912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_199001-199912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_200001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_200601-201512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_201601-202512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_202601-203512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_203601-204512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_204601-205512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_205601-206512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_206601-207512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_207601-208512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_208601-209512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_209601-210512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_210601-211512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_211601-212512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_212601-213512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_213601-214512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_214601-215512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_215601-216512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_216601-217512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_217601-218512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_218601-219512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_219601-220512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_220601-221512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_221601-222512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_222601-223512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_223601-224512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_224601-225512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_225601-226512.nc", 
            "pr_Amon_FGOALS-g2_rcp45_r1i1p1_226601-227512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-g2/historical",
      gridfile.filename = "tas_Amon_FGOALS-g2_historical_r1i1p1_185001-185912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'FIO-ESM-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "FIO-ESM",
      gcm.run = 1,
      institute = "FIO",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_FIO-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_FIO-ESM_rcp45_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_FIO-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_FIO-ESM_rcp45_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
      gridfile.filename = "tas_Amon_FIO-ESM_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'FIO-ESM-r2i1p1_rcp45' = list( 
      rcm = "",
      gcm = "FIO-ESM",
      gcm.run = 2,
      institute = "FIO",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_FIO-ESM_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_FIO-ESM_rcp45_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_FIO-ESM_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_FIO-ESM_rcp45_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
      gridfile.filename = "tas_Amon_FIO-ESM_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'FIO-ESM-r3i1p1_rcp45' = list( 
      rcm = "",
      gcm = "FIO-ESM",
      gcm.run = 3,
      institute = "FIO",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_FIO-ESM_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_FIO-ESM_rcp45_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_FIO-ESM_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_FIO-ESM_rcp45_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
      gridfile.filename = "tas_Amon_FIO-ESM_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-CM2-1-r10i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GFDL-CM2-1",
      gcm.run = 10,
      institute = "NOAA GFDL",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_186101-186512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_186601-187012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_187101-187512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_187601-188012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_188101-188512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_188601-189012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_189101-189512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_189601-190012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_190101-190512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_190601-191012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_191101-191512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_191601-192012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_192101-192512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_192601-193012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_193101-193512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_193601-194012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_194101-194512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_194601-195012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_195101-195512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_195601-196012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_196101-196512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_196601-197012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_197101-197512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_197601-198012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_198101-198512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_198601-199012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_199101-199512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_199601-200012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r10i1p1_200101-200512.nc"
            ## "tas_Amon_GFDL-CM2p1_historical_r10i1p1_200601-201012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r10i1p1_201101-201512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r10i1p1_201601-202012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r10i1p1_202101-202512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r10i1p1_202601-203012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r10i1p1_203101-203512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r10i1p1_203601-204012.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-CM2p1_rcp45_r10i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r10i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r10i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r10i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r10i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r10i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r10i1p1_203601-204012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_186101-186512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_186601-187012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_187101-187512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_187601-188012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_188101-188512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_188601-189012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_189101-189512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_189601-190012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_190101-190512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_190601-191012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_191101-191512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_191601-192012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_192101-192512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_192601-193012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_193101-193512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_193601-194012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_194101-194512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_194601-195012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_195101-195512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_195601-196012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_196101-196512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_196601-197012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_197101-197512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_197601-198012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_198101-198512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_198601-199012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_199101-199512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_199601-200012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r10i1p1_200101-200512.nc"
            ## "pr_Amon_GFDL-CM2p1_historical_r10i1p1_200601-201012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r10i1p1_201101-201512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r10i1p1_201601-202012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r10i1p1_202101-202512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r10i1p1_202601-203012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r10i1p1_203101-203512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r10i1p1_203601-204012.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-CM2p1_rcp45_r10i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r10i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r10i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r10i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r10i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r10i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r10i1p1_203601-204012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
      gridfile.filename = "tas_Amon_GFDL-CM2p1_historical_r10i1p1_186101-186512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-CM2-1-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GFDL-CM2-1",
      gcm.run = 1,
      institute = "NOAA GFDL",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_186101-186512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_186601-187012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_187101-187512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_187601-188012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_188101-188512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_188601-189012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_189101-189512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_189601-190012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_190101-190512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_190601-191012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_191101-191512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_191601-192012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_192101-192512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_192601-193012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_193101-193512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_193601-194012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_194101-194512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_194601-195012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_195101-195512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_195601-196012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_196101-196512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_196601-197012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_197101-197512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_197601-198012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_198101-198512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_198601-199012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_199101-199512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_199601-200012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r1i1p1_200101-200512.nc"
            ## "tas_Amon_GFDL-CM2p1_historical_r1i1p1_200601-201012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r1i1p1_201101-201512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r1i1p1_201601-202012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r1i1p1_202101-202512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r1i1p1_202601-203012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r1i1p1_203101-203512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r1i1p1_203601-204012.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-CM2p1_rcp45_r1i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r1i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r1i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r1i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r1i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r1i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r1i1p1_203601-204012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_186101-186512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_186601-187012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_187101-187512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_187601-188012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_188101-188512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_188601-189012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_189101-189512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_189601-190012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_190101-190512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_190601-191012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_191101-191512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_191601-192012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_192101-192512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_192601-193012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_193101-193512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_193601-194012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_194101-194512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_194601-195012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_195101-195512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_195601-196012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_196101-196512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_196601-197012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_197101-197512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_197601-198012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_198101-198512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_198601-199012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_199101-199512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_199601-200012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r1i1p1_200101-200512.nc"
            ## "pr_Amon_GFDL-CM2p1_historical_r1i1p1_200601-201012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r1i1p1_201101-201512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r1i1p1_201601-202012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r1i1p1_202101-202512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r1i1p1_202601-203012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r1i1p1_203101-203512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r1i1p1_203601-204012.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-CM2p1_rcp45_r1i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r1i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r1i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r1i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r1i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r1i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r1i1p1_203601-204012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
      gridfile.filename = "tas_Amon_GFDL-CM2p1_historical_r1i1p1_186101-186512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-CM2-1-r2i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GFDL-CM2-1",
      gcm.run = 2,
      institute = "NOAA GFDL",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_186101-186512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_186601-187012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_187101-187512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_187601-188012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_188101-188512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_188601-189012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_189101-189512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_189601-190012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_190101-190512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_190601-191012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_191101-191512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_191601-192012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_192101-192512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_192601-193012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_193101-193512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_193601-194012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_194101-194512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_194601-195012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_195101-195512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_195601-196012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_196101-196512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_196601-197012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_197101-197512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_197601-198012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_198101-198512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_198601-199012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_199101-199512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_199601-200012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r2i1p1_200101-200512.nc"
            ## "tas_Amon_GFDL-CM2p1_historical_r2i1p1_200601-201012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r2i1p1_201101-201512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r2i1p1_201601-202012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r2i1p1_202101-202512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r2i1p1_202601-203012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r2i1p1_203101-203512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r2i1p1_203601-204012.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-CM2p1_rcp45_r2i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r2i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r2i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r2i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r2i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r2i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r2i1p1_203601-204012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_186101-186512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_186601-187012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_187101-187512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_187601-188012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_188101-188512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_188601-189012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_189101-189512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_189601-190012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_190101-190512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_190601-191012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_191101-191512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_191601-192012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_192101-192512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_192601-193012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_193101-193512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_193601-194012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_194101-194512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_194601-195012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_195101-195512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_195601-196012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_196101-196512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_196601-197012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_197101-197512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_197601-198012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_198101-198512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_198601-199012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_199101-199512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_199601-200012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r2i1p1_200101-200512.nc" 
            ## "pr_Amon_GFDL-CM2p1_historical_r2i1p1_200601-201012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r2i1p1_201101-201512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r2i1p1_201601-202012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r2i1p1_202101-202512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r2i1p1_202601-203012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r2i1p1_203101-203512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r2i1p1_203601-204012.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-CM2p1_rcp45_r2i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r2i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r2i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r2i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r2i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r2i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r2i1p1_203601-204012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
      gridfile.filename = "tas_Amon_GFDL-CM2p1_historical_r2i1p1_186101-186512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-CM2-1-r3i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GFDL-CM2-1",
      gcm.run = 3,
      institute = "NOAA GFDL",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_186101-186512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_186601-187012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_187101-187512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_187601-188012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_188101-188512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_188601-189012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_189101-189512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_189601-190012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_190101-190512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_190601-191012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_191101-191512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_191601-192012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_192101-192512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_192601-193012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_193101-193512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_193601-194012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_194101-194512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_194601-195012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_195101-195512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_195601-196012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_196101-196512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_196601-197012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_197101-197512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_197601-198012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_198101-198512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_198601-199012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_199101-199512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_199601-200012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r3i1p1_200101-200512.nc" 
            ## "tas_Amon_GFDL-CM2p1_historical_r3i1p1_200601-201012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r3i1p1_201101-201512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r3i1p1_201601-202012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r3i1p1_202101-202512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r3i1p1_202601-203012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r3i1p1_203101-203512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r3i1p1_203601-204012.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-CM2p1_rcp45_r3i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r3i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r3i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r3i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r3i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r3i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r3i1p1_203601-204012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_186101-186512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_186601-187012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_187101-187512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_187601-188012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_188101-188512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_188601-189012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_189101-189512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_189601-190012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_190101-190512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_190601-191012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_191101-191512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_191601-192012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_192101-192512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_192601-193012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_193101-193512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_193601-194012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_194101-194512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_194601-195012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_195101-195512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_195601-196012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_196101-196512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_196601-197012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_197101-197512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_197601-198012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_198101-198512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_198601-199012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_199101-199512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_199601-200012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r3i1p1_200101-200512.nc"
            ## "pr_Amon_GFDL-CM2p1_historical_r3i1p1_200601-201012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r3i1p1_201101-201512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r3i1p1_201601-202012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r3i1p1_202101-202512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r3i1p1_202601-203012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r3i1p1_203101-203512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r3i1p1_203601-204012.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-CM2p1_rcp45_r3i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r3i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r3i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r3i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r3i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r3i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r3i1p1_203601-204012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
      gridfile.filename = "tas_Amon_GFDL-CM2p1_historical_r3i1p1_186101-186512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-CM2-1-r4i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GFDL-CM2-1",
      gcm.run = 4,
      institute = "NOAA GFDL",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_186101-186512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_186601-187012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_187101-187512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_187601-188012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_188101-188512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_188601-189012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_189101-189512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_189601-190012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_190101-190512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_190601-191012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_191101-191512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_191601-192012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_192101-192512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_192601-193012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_193101-193512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_193601-194012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_194101-194512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_194601-195012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_195101-195512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_195601-196012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_196101-196512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_196601-197012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_197101-197512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_197601-198012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_198101-198512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_198601-199012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_199101-199512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_199601-200012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r4i1p1_200101-200512.nc"
            ## "tas_Amon_GFDL-CM2p1_historical_r4i1p1_200601-201012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r4i1p1_201101-201512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r4i1p1_201601-202012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r4i1p1_202101-202512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r4i1p1_202601-203012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r4i1p1_203101-203512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r4i1p1_203601-204012.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-CM2p1_rcp45_r4i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r4i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r4i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r4i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r4i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r4i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r4i1p1_203601-204012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_186101-186512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_186601-187012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_187101-187512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_187601-188012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_188101-188512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_188601-189012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_189101-189512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_189601-190012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_190101-190512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_190601-191012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_191101-191512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_191601-192012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_192101-192512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_192601-193012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_193101-193512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_193601-194012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_194101-194512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_194601-195012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_195101-195512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_195601-196012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_196101-196512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_196601-197012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_197101-197512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_197601-198012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_198101-198512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_198601-199012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_199101-199512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_199601-200012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r4i1p1_200101-200512.nc"
            ## "pr_Amon_GFDL-CM2p1_historical_r4i1p1_200601-201012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r4i1p1_201101-201512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r4i1p1_201601-202012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r4i1p1_202101-202512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r4i1p1_202601-203012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r4i1p1_203101-203512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r4i1p1_203601-204012.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-CM2p1_rcp45_r4i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r4i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r4i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r4i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r4i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r4i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r4i1p1_203601-204012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
      gridfile.filename = "tas_Amon_GFDL-CM2p1_historical_r4i1p1_186101-186512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-CM2-1-r5i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GFDL-CM2-1",
      gcm.run = 5,
      institute = "NOAA GFDL",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_186101-186512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_186601-187012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_187101-187512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_187601-188012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_188101-188512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_188601-189012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_189101-189512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_189601-190012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_190101-190512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_190601-191012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_191101-191512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_191601-192012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_192101-192512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_192601-193012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_193101-193512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_193601-194012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_194101-194512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_194601-195012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_195101-195512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_195601-196012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_196101-196512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_196601-197012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_197101-197512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_197601-198012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_198101-198512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_198601-199012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_199101-199512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_199601-200012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r5i1p1_200101-200512.nc" 
            ## "tas_Amon_GFDL-CM2p1_historical_r5i1p1_200601-201012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r5i1p1_201101-201512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r5i1p1_201601-202012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r5i1p1_202101-202512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r5i1p1_202601-203012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r5i1p1_203101-203512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r5i1p1_203601-204012.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-CM2p1_rcp45_r5i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r5i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r5i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r5i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r5i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r5i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r5i1p1_203601-204012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_186101-186512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_186601-187012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_187101-187512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_187601-188012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_188101-188512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_188601-189012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_189101-189512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_189601-190012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_190101-190512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_190601-191012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_191101-191512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_191601-192012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_192101-192512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_192601-193012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_193101-193512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_193601-194012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_194101-194512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_194601-195012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_195101-195512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_195601-196012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_196101-196512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_196601-197012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_197101-197512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_197601-198012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_198101-198512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_198601-199012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_199101-199512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_199601-200012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r5i1p1_200101-200512.nc"
            ## "pr_Amon_GFDL-CM2p1_historical_r5i1p1_200601-201012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r5i1p1_201101-201512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r5i1p1_201601-202012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r5i1p1_202101-202512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r5i1p1_202601-203012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r5i1p1_203101-203512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r5i1p1_203601-204012.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-CM2p1_rcp45_r5i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r5i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r5i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r5i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r5i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r5i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r5i1p1_203601-204012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
      gridfile.filename = "tas_Amon_GFDL-CM2p1_historical_r5i1p1_186101-186512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-CM2-1-r6i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GFDL-CM2-1",
      gcm.run = 6,
      institute = "NOAA GFDL",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_186101-186512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_186601-187012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_187101-187512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_187601-188012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_188101-188512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_188601-189012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_189101-189512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_189601-190012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_190101-190512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_190601-191012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_191101-191512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_191601-192012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_192101-192512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_192601-193012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_193101-193512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_193601-194012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_194101-194512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_194601-195012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_195101-195512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_195601-196012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_196101-196512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_196601-197012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_197101-197512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_197601-198012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_198101-198512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_198601-199012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_199101-199512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_199601-200012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r6i1p1_200101-200512.nc"
            ## "tas_Amon_GFDL-CM2p1_historical_r6i1p1_200601-201012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r6i1p1_201101-201512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r6i1p1_201601-202012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r6i1p1_202101-202512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r6i1p1_202601-203012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r6i1p1_203101-203512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r6i1p1_203601-204012.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-CM2p1_rcp45_r6i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r6i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r6i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r6i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r6i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r6i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r6i1p1_203601-204012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_186101-186512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_186601-187012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_187101-187512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_187601-188012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_188101-188512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_188601-189012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_189101-189512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_189601-190012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_190101-190512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_190601-191012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_191101-191512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_191601-192012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_192101-192512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_192601-193012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_193101-193512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_193601-194012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_194101-194512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_194601-195012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_195101-195512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_195601-196012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_196101-196512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_196601-197012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_197101-197512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_197601-198012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_198101-198512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_198601-199012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_199101-199512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_199601-200012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r6i1p1_200101-200512.nc"
            ## "pr_Amon_GFDL-CM2p1_historical_r6i1p1_200601-201012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r6i1p1_201101-201512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r6i1p1_201601-202012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r6i1p1_202101-202512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r6i1p1_202601-203012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r6i1p1_203101-203512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r6i1p1_203601-204012.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-CM2p1_rcp45_r6i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r6i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r6i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r6i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r6i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r6i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r6i1p1_203601-204012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
      gridfile.filename = "tas_Amon_GFDL-CM2p1_historical_r6i1p1_186101-186512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-CM2-1-r7i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GFDL-CM2-1",
      gcm.run = 7,
      institute = "NOAA GFDL",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_186101-186512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_186601-187012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_187101-187512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_187601-188012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_188101-188512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_188601-189012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_189101-189512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_189601-190012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_190101-190512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_190601-191012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_191101-191512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_191601-192012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_192101-192512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_192601-193012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_193101-193512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_193601-194012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_194101-194512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_194601-195012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_195101-195512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_195601-196012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_196101-196512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_196601-197012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_197101-197512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_197601-198012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_198101-198512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_198601-199012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_199101-199512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_199601-200012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r7i1p1_200101-200512.nc"
            ## "tas_Amon_GFDL-CM2p1_historical_r7i1p1_200601-201012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r7i1p1_201101-201512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r7i1p1_201601-202012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r7i1p1_202101-202512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r7i1p1_202601-203012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r7i1p1_203101-203512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r7i1p1_203601-204012.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-CM2p1_rcp45_r7i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r7i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r7i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r7i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r7i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r7i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r7i1p1_203601-204012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_186101-186512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_186601-187012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_187101-187512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_187601-188012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_188101-188512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_188601-189012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_189101-189512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_189601-190012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_190101-190512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_190601-191012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_191101-191512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_191601-192012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_192101-192512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_192601-193012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_193101-193512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_193601-194012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_194101-194512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_194601-195012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_195101-195512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_195601-196012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_196101-196512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_196601-197012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_197101-197512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_197601-198012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_198101-198512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_198601-199012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_199101-199512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_199601-200012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r7i1p1_200101-200512.nc"
            ## "pr_Amon_GFDL-CM2p1_historical_r7i1p1_200601-201012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r7i1p1_201101-201512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r7i1p1_201601-202012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r7i1p1_202101-202512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r7i1p1_202601-203012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r7i1p1_203101-203512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r7i1p1_203601-204012.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-CM2p1_rcp45_r7i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r7i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r7i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r7i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r7i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r7i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r7i1p1_203601-204012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
      gridfile.filename = "tas_Amon_GFDL-CM2p1_historical_r7i1p1_186101-186512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-CM2-1-r8i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GFDL-CM2-1",
      gcm.run = 8,
      institute = "NOAA GFDL",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_186101-186512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_186601-187012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_187101-187512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_187601-188012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_188101-188512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_188601-189012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_189101-189512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_189601-190012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_190101-190512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_190601-191012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_191101-191512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_191601-192012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_192101-192512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_192601-193012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_193101-193512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_193601-194012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_194101-194512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_194601-195012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_195101-195512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_195601-196012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_196101-196512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_196601-197012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_197101-197512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_197601-198012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_198101-198512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_198601-199012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_199101-199512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_199601-200012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r8i1p1_200101-200512.nc"
            ## "tas_Amon_GFDL-CM2p1_historical_r8i1p1_200601-201012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r8i1p1_201101-201512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r8i1p1_201601-202012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r8i1p1_202101-202512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r8i1p1_202601-203012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r8i1p1_203101-203512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r8i1p1_203601-204012.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-CM2p1_rcp45_r8i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r8i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r8i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r8i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r8i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r8i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r8i1p1_203601-204012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_186101-186512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_186601-187012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_187101-187512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_187601-188012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_188101-188512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_188601-189012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_189101-189512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_189601-190012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_190101-190512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_190601-191012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_191101-191512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_191601-192012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_192101-192512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_192601-193012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_193101-193512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_193601-194012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_194101-194512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_194601-195012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_195101-195512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_195601-196012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_196101-196512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_196601-197012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_197101-197512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_197601-198012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_198101-198512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_198601-199012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_199101-199512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_199601-200012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r8i1p1_200101-200512.nc"
            ## "pr_Amon_GFDL-CM2p1_historical_r8i1p1_200601-201012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r8i1p1_201101-201512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r8i1p1_201601-202012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r8i1p1_202101-202512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r8i1p1_202601-203012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r8i1p1_203101-203512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r8i1p1_203601-204012.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-CM2p1_rcp45_r8i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r8i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r8i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r8i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r8i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r8i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r8i1p1_203601-204012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
      gridfile.filename = "tas_Amon_GFDL-CM2p1_historical_r8i1p1_186101-186512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-CM2-1-r9i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GFDL-CM2-1",
      gcm.run = 9,
      institute = "NOAA GFDL",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_186101-186512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_186601-187012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_187101-187512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_187601-188012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_188101-188512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_188601-189012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_189101-189512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_189601-190012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_190101-190512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_190601-191012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_191101-191512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_191601-192012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_192101-192512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_192601-193012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_193101-193512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_193601-194012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_194101-194512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_194601-195012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_195101-195512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_195601-196012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_196101-196512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_196601-197012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_197101-197512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_197601-198012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_198101-198512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_198601-199012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_199101-199512.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_199601-200012.nc", 
            "tas_Amon_GFDL-CM2p1_historical_r9i1p1_200101-200512.nc"
            ## "tas_Amon_GFDL-CM2p1_historical_r9i1p1_200601-201012.nc",
            ## "tas_Amon_GFDL-CM2p1_historical_r9i1p1_201101-201512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r9i1p1_201601-202012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r9i1p1_202101-202512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r9i1p1_202601-203012.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r9i1p1_203101-203512.nc", 
            ## "tas_Amon_GFDL-CM2p1_historical_r9i1p1_203601-204012.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-CM2p1_rcp45_r9i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r9i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r9i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r9i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r9i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r9i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-CM2p1_rcp45_r9i1p1_203601-204012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_186101-186512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_186601-187012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_187101-187512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_187601-188012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_188101-188512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_188601-189012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_189101-189512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_189601-190012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_190101-190512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_190601-191012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_191101-191512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_191601-192012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_192101-192512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_192601-193012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_193101-193512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_193601-194012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_194101-194512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_194601-195012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_195101-195512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_195601-196012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_196101-196512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_196601-197012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_197101-197512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_197601-198012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_198101-198512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_198601-199012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_199101-199512.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_199601-200012.nc", 
            "pr_Amon_GFDL-CM2p1_historical_r9i1p1_200101-200512.nc"
            ## "pr_Amon_GFDL-CM2p1_historical_r9i1p1_200601-201012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r9i1p1_201101-201512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r9i1p1_201601-202012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r9i1p1_202101-202512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r9i1p1_202601-203012.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r9i1p1_203101-203512.nc", 
            ## "pr_Amon_GFDL-CM2p1_historical_r9i1p1_203601-204012.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-CM2p1_rcp45_r9i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r9i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r9i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r9i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r9i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r9i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-CM2p1_rcp45_r9i1p1_203601-204012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM2.1/historical",
      gridfile.filename = "tas_Amon_GFDL-CM2p1_historical_r9i1p1_186101-186512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-CM3-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GFDL-CM3",
      gcm.run = 1,
      institute = "NOAA GFDL",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM3/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM3/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-CM3_historical_r1i1p1_186001-186412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_186501-186912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_187001-187412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_187501-187912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_188001-188412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_188501-188912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_189001-189412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_189501-189912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_190001-190412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_190501-190912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_191001-191412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_191501-191912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_192001-192412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_192501-192912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_193001-193412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_193501-193912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_194001-194412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_194501-194912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_195001-195412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_195501-195912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_196001-196412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_196501-196912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_197001-197412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_197501-197912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_198001-198412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_198501-198912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_199001-199412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_199501-199912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_200001-200412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_200501-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_203601-204012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_204101-204512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_204601-205012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_205101-205512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_205601-206012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_206101-206512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_206601-207012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_207101-207512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_207601-208012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_208101-208512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_208601-209012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_209101-209512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_209601-210012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_210101-210512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_210601-211012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_211101-211512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_211601-212012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_212101-212512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_212601-213012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_213101-213512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_213601-214012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_214101-214512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_214601-215012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_215101-215512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_215601-216012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_216101-216512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_216601-217012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_217101-217512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_217601-218012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_218101-218512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_218601-219012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_219101-219512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_219601-220012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_220101-220512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_220601-221012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_221101-221512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_221601-222012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_222101-222512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_222601-223012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_223101-223512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_223601-224012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_224101-224512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_224601-225012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_225101-225512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_225601-226012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_226101-226512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_226601-227012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_227101-227512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_227601-228012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_228101-228512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_228601-229012.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_229101-229512.nc", 
            "tas_Amon_GFDL-CM3_rcp45_r1i1p1_229601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-CM3_historical_r1i1p1_186001-186412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_186501-186912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_187001-187412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_187501-187912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_188001-188412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_188501-188912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_189001-189412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_189501-189912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_190001-190412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_190501-190912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_191001-191412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_191501-191912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_192001-192412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_192501-192912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_193001-193412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_193501-193912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_194001-194412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_194501-194912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_195001-195412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_195501-195912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_196001-196412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_196501-196912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_197001-197412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_197501-197912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_198001-198412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_198501-198912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_199001-199412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_199501-199912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_200001-200412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_200501-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_203601-204012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_204101-204512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_204601-205012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_205101-205512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_205601-206012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_206101-206512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_206601-207012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_207101-207512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_207601-208012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_208101-208512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_208601-209012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_209101-209512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_209601-210012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_210101-210512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_210601-211012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_211101-211512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_211601-212012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_212101-212512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_212601-213012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_213101-213512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_213601-214012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_214101-214512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_214601-215012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_215101-215512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_215601-216012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_216101-216512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_216601-217012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_217101-217512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_217601-218012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_218101-218512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_218601-219012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_219101-219512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_219601-220012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_220101-220512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_220601-221012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_221101-221512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_221601-222012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_222101-222512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_222601-223012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_223101-223512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_223601-224012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_224101-224512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_224601-225012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_225101-225512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_225601-226012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_226101-226512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_226601-227012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_227101-227512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_227601-228012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_228101-228512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_228601-229012.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_229101-229512.nc", 
            "pr_Amon_GFDL-CM3_rcp45_r1i1p1_229601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM3/historical",
      gridfile.filename = "tas_Amon_GFDL-CM3_historical_r1i1p1_186001-186412.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-ESM2G-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GFDL-ESM2G",
      gcm.run = 1,
      institute = "NOAA GFDL",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2G/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2G/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2G/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2G/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_186101-186512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_186601-187012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_187101-187512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_187601-188012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_188101-188512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_188601-189012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_189101-189512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_189601-190012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_190101-190512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_190601-191012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_191101-191512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_191601-192012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_192101-192512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_192601-193012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_193101-193512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_193601-194012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_194101-194512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_194601-195012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_195101-195512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_195601-196012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_196101-196512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_196601-197012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_197101-197512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_197601-198012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_198101-198512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_198601-199012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_199101-199512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_199601-200012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-ESM2G_rcp45_r1i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp45_r1i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp45_r1i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp45_r1i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp45_r1i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp45_r1i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp45_r1i1p1_203601-204012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp45_r1i1p1_204101-204512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp45_r1i1p1_204601-205012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp45_r1i1p1_205101-205512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp45_r1i1p1_205601-206012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp45_r1i1p1_206101-206512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp45_r1i1p1_206601-207012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp45_r1i1p1_207101-207512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp45_r1i1p1_207601-208012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp45_r1i1p1_208101-208512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp45_r1i1p1_208601-209012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp45_r1i1p1_209101-209512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp45_r1i1p1_209601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_186101-186512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_186601-187012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_187101-187512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_187601-188012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_188101-188512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_188601-189012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_189101-189512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_189601-190012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_190101-190512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_190601-191012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_191101-191512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_191601-192012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_192101-192512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_192601-193012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_193101-193512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_193601-194012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_194101-194512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_194601-195012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_195101-195512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_195601-196012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_196101-196512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_196601-197012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_197101-197512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_197601-198012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_198101-198512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_198601-199012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_199101-199512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_199601-200012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-ESM2G_rcp45_r1i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp45_r1i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp45_r1i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp45_r1i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp45_r1i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp45_r1i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp45_r1i1p1_203601-204012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp45_r1i1p1_204101-204512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp45_r1i1p1_204601-205012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp45_r1i1p1_205101-205512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp45_r1i1p1_205601-206012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp45_r1i1p1_206101-206512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp45_r1i1p1_206601-207012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp45_r1i1p1_207101-207512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp45_r1i1p1_207601-208012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp45_r1i1p1_208101-208512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp45_r1i1p1_208601-209012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp45_r1i1p1_209101-209512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp45_r1i1p1_209601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2G/historical",
      gridfile.filename = "tas_Amon_GFDL-ESM2G_historical_r1i1p1_186101-186512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-ESM2M-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GFDL-ESM2M",
      gcm.run = 1,
      institute = "NOAA GFDL",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2M/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2M/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2M/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2M/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_186101-186512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_186601-187012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_187101-187512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_187601-188012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_188101-188512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_188601-189012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_189101-189512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_189601-190012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_190101-190512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_190601-191012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_191101-191512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_191601-192012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_192101-192512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_192601-193012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_193101-193512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_193601-194012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_194101-194512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_194601-195012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_195101-195512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_195601-196012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_196101-196512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_196601-197012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_197101-197512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_197601-198012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_198101-198512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_198601-199012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_199101-199512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_199601-200012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_203601-204012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_204101-204512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_204601-205012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_205101-205512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_205601-206012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_206101-206512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_206601-207012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_207101-207512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_207601-208012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_208101-208512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_208601-209012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_209101-209512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_209601-210012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_210101-210512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_210601-211012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_211101-211512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_211601-212012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_212101-212512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_212601-213012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_213101-213512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_213601-214012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_214101-214512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_214601-215012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_215101-215512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_215601-216012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_216101-216512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_216601-217012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_217101-217512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_217601-218012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_218101-218512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_218601-219012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_219101-219512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp45_r1i1p1_219601-220012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_186101-186512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_186601-187012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_187101-187512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_187601-188012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_188101-188512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_188601-189012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_189101-189512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_189601-190012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_190101-190512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_190601-191012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_191101-191512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_191601-192012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_192101-192512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_192601-193012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_193101-193512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_193601-194012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_194101-194512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_194601-195012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_195101-195512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_195601-196012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_196101-196512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_196601-197012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_197101-197512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_197601-198012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_198101-198512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_198601-199012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_199101-199512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_199601-200012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-ESM2M_rcp45_r1i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp45_r1i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp45_r1i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp45_r1i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp45_r1i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp45_r1i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp45_r1i1p1_203601-204012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp45_r1i1p1_204101-204512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp45_r1i1p1_204601-205012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp45_r1i1p1_205101-205512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp45_r1i1p1_205601-206012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp45_r1i1p1_206101-206512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp45_r1i1p1_206601-207012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp45_r1i1p1_207101-207512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp45_r1i1p1_207601-208012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp45_r1i1p1_208101-208512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp45_r1i1p1_208601-209012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp45_r1i1p1_209101-209512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp45_r1i1p1_209601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2M/historical",
      gridfile.filename = "tas_Amon_GFDL-ESM2M_historical_r1i1p1_186101-186512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r1i1p1_185001-190012.nc", 
            "tas_Amon_GISS-E2-H_historical_r1i1p1_190101-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r1i1p1_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp45_r1i1p1_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r1i1p1_205101-210012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r1i1p1_210101-215012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r1i1p1_215101-220012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r1i1p1_220101-225012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r1i1p1_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r1i1p1_185001-190012.nc", 
            "pr_Amon_GISS-E2-H_historical_r1i1p1_190101-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r1i1p1_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp45_r1i1p1_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r1i1p1_205101-210012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r1i1p1_210101-215012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r1i1p1_215101-220012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r1i1p1_220101-225012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r1i1p1_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r1i1p1_185001-190012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r1i1p2_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r1i1p2_185001-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r1i1p2_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp45_r1i1p2_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r1i1p2_205101-210012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r1i1p2_210101-215012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r1i1p2_215101-220012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r1i1p2_220101-225012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r1i1p2_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r1i1p2_185001-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r1i1p2_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp45_r1i1p2_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r1i1p2_205101-210012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r1i1p2_210101-215012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r1i1p2_215101-220012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r1i1p2_220101-225012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r1i1p2_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r1i1p2_185001-195012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r1i1p3_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r1i1p3_185001-190012.nc", 
            "tas_Amon_GISS-E2-H_historical_r1i1p3_190101-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r1i1p3_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp45_r1i1p3_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r1i1p3_205101-210012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r1i1p3_210101-215012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r1i1p3_215101-220012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r1i1p3_220101-225012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r1i1p3_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r1i1p3_185001-190012.nc", 
            "pr_Amon_GISS-E2-H_historical_r1i1p3_190101-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r1i1p3_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp45_r1i1p3_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r1i1p3_205101-210012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r1i1p3_210101-215012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r1i1p3_215101-220012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r1i1p3_220101-225012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r1i1p3_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r1i1p3_185001-190012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r2i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 2,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r2i1p1_185001-190012.nc", 
            "tas_Amon_GISS-E2-H_historical_r2i1p1_190101-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r2i1p1_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp45_r2i1p1_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r2i1p1_205101-210012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r2i1p1_210101-215012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r2i1p1_215101-220012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r2i1p1_220101-225012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r2i1p1_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r2i1p1_185001-190012.nc", 
            "pr_Amon_GISS-E2-H_historical_r2i1p1_190101-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r2i1p1_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp45_r2i1p1_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r2i1p1_205101-210012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r2i1p1_210101-215012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r2i1p1_215101-220012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r2i1p1_220101-225012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r2i1p1_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r2i1p1_185001-190012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r2i1p2_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 2,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r2i1p2_185001-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r2i1p2_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp45_r2i1p2_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r2i1p2_205101-210012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r2i1p2_210101-215012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r2i1p2_215101-220012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r2i1p2_220101-225012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r2i1p2_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r2i1p2_185001-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r2i1p2_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp45_r2i1p2_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r2i1p2_205101-210012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r2i1p2_210101-215012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r2i1p2_215101-220012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r2i1p2_220101-225012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r2i1p2_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r2i1p2_185001-195012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r2i1p3_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 2,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r2i1p3_185001-190012.nc", 
            "tas_Amon_GISS-E2-H_historical_r2i1p3_190101-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r2i1p3_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp45_r2i1p3_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r2i1p3_205101-210012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r2i1p3_210101-215012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r2i1p3_215101-220012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r2i1p3_220101-225012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r2i1p3_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r2i1p3_185001-190012.nc", 
            "pr_Amon_GISS-E2-H_historical_r2i1p3_190101-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r2i1p3_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp45_r2i1p3_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r2i1p3_205101-210012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r2i1p3_210101-215012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r2i1p3_215101-220012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r2i1p3_220101-225012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r2i1p3_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r2i1p3_185001-190012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r3i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 3,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r3i1p1_185001-190012.nc", 
            "tas_Amon_GISS-E2-H_historical_r3i1p1_190101-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r3i1p1_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp45_r3i1p1_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r3i1p1_205101-210012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r3i1p1_210101-215012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r3i1p1_215101-220012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r3i1p1_220101-225012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r3i1p1_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r3i1p1_185001-190012.nc", 
            "pr_Amon_GISS-E2-H_historical_r3i1p1_190101-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r3i1p1_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp45_r3i1p1_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r3i1p1_205101-210012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r3i1p1_210101-215012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r3i1p1_215101-220012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r3i1p1_220101-225012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r3i1p1_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r3i1p1_185001-190012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r3i1p2_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 3,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r3i1p2_185001-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r3i1p2_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp45_r3i1p2_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r3i1p2_205101-210012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r3i1p2_210101-215012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r3i1p2_215101-220012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r3i1p2_220101-225012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r3i1p2_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r3i1p2_185001-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r3i1p2_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp45_r3i1p2_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r3i1p2_205101-210012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r3i1p2_210101-215012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r3i1p2_215101-220012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r3i1p2_220101-225012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r3i1p2_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r3i1p2_185001-195012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r3i1p3_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 3,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r3i1p3_185001-190012.nc", 
            "tas_Amon_GISS-E2-H_historical_r3i1p3_190101-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r3i1p3_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp45_r3i1p3_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r3i1p3_205101-210012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r3i1p3_210101-215012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r3i1p3_215101-220012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r3i1p3_220101-225012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r3i1p3_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r3i1p3_185001-190012.nc", 
            "pr_Amon_GISS-E2-H_historical_r3i1p3_190101-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r3i1p3_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp45_r3i1p3_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r3i1p3_205101-210012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r3i1p3_210101-215012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r3i1p3_215101-220012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r3i1p3_220101-225012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r3i1p3_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r3i1p3_185001-190012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r4i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 4,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r4i1p1_185001-190012.nc", 
            "tas_Amon_GISS-E2-H_historical_r4i1p1_190101-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r4i1p1_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp45_r4i1p1_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r4i1p1_205101-210012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r4i1p1_210101-215012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r4i1p1_215101-220012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r4i1p1_220101-225012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r4i1p1_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r4i1p1_185001-190012.nc", 
            "pr_Amon_GISS-E2-H_historical_r4i1p1_190101-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r4i1p1_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp45_r4i1p1_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r4i1p1_205101-210012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r4i1p1_210101-215012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r4i1p1_215101-220012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r4i1p1_220101-225012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r4i1p1_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r4i1p1_185001-190012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r4i1p2_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 4,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r4i1p2_185001-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r4i1p2_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp45_r4i1p2_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r4i1p2_205101-210012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r4i1p2_210101-215012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r4i1p2_215101-220012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r4i1p2_220101-225012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r4i1p2_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r4i1p2_185001-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r4i1p2_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp45_r4i1p2_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r4i1p2_205101-210012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r4i1p2_210101-215012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r4i1p2_215101-220012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r4i1p2_220101-225012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r4i1p2_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r4i1p2_185001-195012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r4i1p3_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 4,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r4i1p3_185001-190012.nc", 
            "tas_Amon_GISS-E2-H_historical_r4i1p3_190101-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r4i1p3_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp45_r4i1p3_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r4i1p3_205101-210012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r4i1p3_210101-215012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r4i1p3_215101-220012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r4i1p3_220101-225012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r4i1p3_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r4i1p3_185001-190012.nc", 
            "pr_Amon_GISS-E2-H_historical_r4i1p3_190101-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r4i1p3_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp45_r4i1p3_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r4i1p3_205101-210012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r4i1p3_210101-215012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r4i1p3_215101-220012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r4i1p3_220101-225012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r4i1p3_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r4i1p3_185001-190012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r5i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 5,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r5i1p1_185001-190012.nc", 
            "tas_Amon_GISS-E2-H_historical_r5i1p1_190101-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r5i1p1_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp45_r5i1p1_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r5i1p1_205101-210012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r5i1p1_210101-215012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r5i1p1_215101-220012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r5i1p1_220101-225012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r5i1p1_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r5i1p1_185001-190012.nc", 
            "pr_Amon_GISS-E2-H_historical_r5i1p1_190101-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r5i1p1_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp45_r5i1p1_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r5i1p1_205101-210012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r5i1p1_210101-215012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r5i1p1_215101-220012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r5i1p1_220101-225012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r5i1p1_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r5i1p1_185001-190012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r5i1p2_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 5,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r5i1p2_185001-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r5i1p2_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp45_r5i1p2_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r5i1p2_205101-210012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r5i1p2_210101-215012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r5i1p2_215101-220012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r5i1p2_220101-225012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r5i1p2_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r5i1p2_185001-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r5i1p2_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp45_r5i1p2_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r5i1p2_205101-210012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r5i1p2_210101-215012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r5i1p2_215101-220012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r5i1p2_220101-225012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r5i1p2_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r5i1p2_185001-195012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r5i1p3_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 5,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r5i1p3_185001-190012.nc", 
            "tas_Amon_GISS-E2-H_historical_r5i1p3_190101-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r5i1p3_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp45_r5i1p3_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r5i1p3_205101-210012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r5i1p3_210101-215012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r5i1p3_215101-220012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r5i1p3_220101-225012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r5i1p3_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r5i1p3_185001-190012.nc", 
            "pr_Amon_GISS-E2-H_historical_r5i1p3_190101-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r5i1p3_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp45_r5i1p3_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r5i1p3_205101-210012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r5i1p3_210101-215012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r5i1p3_215101-220012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r5i1p3_220101-225012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r5i1p3_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r5i1p3_185001-190012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r6i1p3_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 6,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r6i1p3_185001-190012.nc", 
            "tas_Amon_GISS-E2-H_historical_r6i1p3_190101-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r6i1p3_195101-200012.nc", 
            "tas_Amon_GISS-E2-H_historical_r6i1p3_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp45_r6i1p3_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp45_r6i1p3_205101-209912.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r6i1p3_185001-190012.nc", 
            "pr_Amon_GISS-E2-H_historical_r6i1p3_190101-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r6i1p3_195101-200012.nc", 
            "pr_Amon_GISS-E2-H_historical_r6i1p3_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp45_r6i1p3_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp45_r6i1p3_205101-209912.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r6i1p3_185001-190012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-CC-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-H-CC",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H-CC/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H-CC/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H-CC/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H-CC/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H-CC_historical_r1i1p1_185001-190012.nc", 
            "tas_Amon_GISS-E2-H-CC_historical_r1i1p1_190101-195012.nc", 
            "tas_Amon_GISS-E2-H-CC_historical_r1i1p1_195101-201012.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H-CC_rcp45_r1i1p1_200601-205012.nc", 
            "tas_Amon_GISS-E2-H-CC_rcp45_r1i1p1_205101-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H-CC_historical_r1i1p1_185001-190012.nc", 
            "pr_Amon_GISS-E2-H-CC_historical_r1i1p1_190101-195012.nc", 
            "pr_Amon_GISS-E2-H-CC_historical_r1i1p1_195101-201012.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H-CC_rcp45_r1i1p1_200601-205012.nc", 
            "pr_Amon_GISS-E2-H-CC_rcp45_r1i1p1_205101-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H-CC/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H-CC_historical_r1i1p1_185001-190012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r1i1p1_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp45_r1i1p1_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p1_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p1_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p1_207601-210012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p1_210101-212512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p1_212601-215012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p1_215101-217512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p1_217601-220012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p1_220101-222512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p1_222601-225012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p1_225101-227512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p1_227601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r1i1p1_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp45_r1i1p1_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p1_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p1_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p1_207601-210012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p1_210101-212512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p1_212601-215012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p1_215101-217512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p1_217601-220012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p1_220101-222512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p1_222601-225012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p1_225101-227512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p1_227601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r1i1p1_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r1i1p2_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r1i1p2_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp45_r1i1p2_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p2_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p2_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p2_207601-210012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p2_210101-212512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p2_212601-215012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p2_215101-217512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p2_217601-220012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p2_220101-222512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p2_222601-225012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p2_225101-227512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p2_227601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r1i1p2_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp45_r1i1p2_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p2_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p2_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p2_207601-210012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p2_210101-212512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p2_212601-215012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p2_215101-217512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p2_217601-220012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p2_220101-222512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p2_222601-225012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p2_225101-227512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p2_227601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r1i1p2_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r1i1p3_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r1i1p3_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp45_r1i1p3_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p3_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p3_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p3_207601-210012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p3_210101-212512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p3_212601-215012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p3_215101-217512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p3_217601-220012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p3_220101-222512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p3_222601-225012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p3_225101-227512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r1i1p3_227601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r1i1p3_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp45_r1i1p3_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p3_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p3_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p3_207601-210012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p3_210101-212512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p3_212601-215012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p3_215101-217512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p3_217601-220012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p3_220101-222512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p3_222601-225012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p3_225101-227512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r1i1p3_227601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r1i1p3_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r2i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 2,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r2i1p1_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p1_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p1_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p1_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p1_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p1_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p1_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp45_r2i1p1_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p1_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p1_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p1_207601-210012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p1_210101-212512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p1_212601-215012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p1_215101-217512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p1_217601-220012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p1_220101-222512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p1_222601-225012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p1_225101-227512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p1_227601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r2i1p1_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p1_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p1_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p1_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p1_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p1_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p1_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp45_r2i1p1_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p1_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p1_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p1_207601-210012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p1_210101-212512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p1_212601-215012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p1_215101-217512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p1_217601-220012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p1_220101-222512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p1_222601-225012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p1_225101-227512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p1_227601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r2i1p1_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r2i1p2_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 2,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r2i1p2_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p2_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p2_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p2_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p2_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p2_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p2_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp45_r2i1p2_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p2_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p2_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p2_207601-210012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p2_210101-212512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p2_212601-215012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p2_215101-217512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p2_217601-220012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p2_220101-222512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p2_222601-225012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p2_225101-227512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p2_227601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r2i1p2_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p2_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p2_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p2_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p2_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p2_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p2_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp45_r2i1p2_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p2_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p2_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p2_207601-210012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p2_210101-212512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p2_212601-215012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p2_215101-217512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p2_217601-220012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p2_220101-222512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p2_222601-225012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p2_225101-227512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p2_227601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r2i1p2_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r2i1p3_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 2,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r2i1p3_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p3_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p3_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p3_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p3_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p3_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p3_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp45_r2i1p3_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p3_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p3_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p3_207601-210012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p3_210101-212512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p3_212601-215012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p3_215101-217512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p3_217601-220012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p3_220101-222512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p3_222601-225012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p3_225101-227512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r2i1p3_227601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r2i1p3_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p3_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p3_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p3_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p3_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p3_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p3_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp45_r2i1p3_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p3_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p3_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p3_207601-210012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p3_210101-212512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p3_212601-215012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p3_215101-217512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p3_217601-220012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p3_220101-222512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p3_222601-225012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p3_225101-227512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r2i1p3_227601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r2i1p3_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r3i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 3,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r3i1p1_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r3i1p1_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r3i1p1_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r3i1p1_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r3i1p1_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r3i1p1_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r3i1p1_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp45_r3i1p1_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p1_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p1_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p1_207601-210012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p1_210101-212512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p1_212601-215012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p1_215101-217512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p1_217601-220012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p1_220101-222512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p1_222601-225012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p1_225101-227512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p1_227601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r3i1p1_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r3i1p1_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r3i1p1_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r3i1p1_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r3i1p1_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r3i1p1_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r3i1p1_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp45_r3i1p1_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p1_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p1_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p1_207601-210012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p1_210101-212512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p1_212601-215012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p1_215101-217512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p1_217601-220012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p1_220101-222512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p1_222601-225012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p1_225101-227512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p1_227601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r3i1p1_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r3i1p2_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 3,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r3i1p2_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r3i1p2_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r3i1p2_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r3i1p2_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r3i1p2_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r3i1p2_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r3i1p2_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp45_r3i1p2_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p2_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p2_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p2_207601-210012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p2_210101-212512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p2_212601-215012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p2_215101-217512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p2_217601-220012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p2_220101-222512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p2_222601-225012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p2_225101-227512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p2_227601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r3i1p2_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r3i1p2_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r3i1p2_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r3i1p2_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r3i1p2_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r3i1p2_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r3i1p2_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp45_r3i1p2_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p2_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p2_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p2_207601-210012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p2_210101-212512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p2_212601-215012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p2_215101-217512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p2_217601-220012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p2_220101-222512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p2_222601-225012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p2_225101-227512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p2_227601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r3i1p2_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r3i1p3_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 3,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r3i1p3_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r3i1p3_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r3i1p3_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r3i1p3_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r3i1p3_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r3i1p3_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r3i1p3_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp45_r3i1p3_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p3_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p3_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p3_207601-210012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p3_210101-212512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p3_212601-215012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p3_215101-217512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p3_217601-220012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p3_220101-222512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p3_222601-225012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p3_225101-227512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r3i1p3_227601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r3i1p3_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r3i1p3_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r3i1p3_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r3i1p3_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r3i1p3_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r3i1p3_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r3i1p3_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp45_r3i1p3_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p3_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p3_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p3_207601-210012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p3_210101-212512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p3_212601-215012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p3_215101-217512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p3_217601-220012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p3_220101-222512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p3_222601-225012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p3_225101-227512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r3i1p3_227601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r3i1p3_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r4i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 4,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r4i1p1_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r4i1p1_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r4i1p1_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r4i1p1_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r4i1p1_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r4i1p1_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r4i1p1_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp45_r4i1p1_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p1_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p1_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p1_207601-210012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p1_210101-212512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p1_212601-215012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p1_215101-217512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p1_217601-220012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p1_220101-222512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p1_222601-225012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p1_225101-227512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p1_227601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r4i1p1_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r4i1p1_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r4i1p1_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r4i1p1_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r4i1p1_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r4i1p1_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r4i1p1_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp45_r4i1p1_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p1_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p1_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p1_207601-210012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p1_210101-212512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p1_212601-215012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p1_215101-217512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p1_217601-220012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p1_220101-222512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p1_222601-225012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p1_225101-227512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p1_227601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r4i1p1_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r4i1p2_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 4,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r4i1p2_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r4i1p2_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r4i1p2_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r4i1p2_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r4i1p2_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r4i1p2_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r4i1p2_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp45_r4i1p2_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p2_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p2_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p2_207601-210012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p2_210101-212512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p2_212601-215012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p2_215101-217512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p2_217601-220012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p2_220101-222512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p2_222601-225012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p2_225101-227512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p2_227601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r4i1p2_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r4i1p2_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r4i1p2_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r4i1p2_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r4i1p2_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r4i1p2_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r4i1p2_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp45_r4i1p2_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p2_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p2_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p2_207601-210012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p2_210101-212512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p2_212601-215012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p2_215101-217512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p2_217601-220012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p2_220101-222512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p2_222601-225012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p2_225101-227512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p2_227601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r4i1p2_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r4i1p3_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 4,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r4i1p3_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r4i1p3_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r4i1p3_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r4i1p3_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r4i1p3_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r4i1p3_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r4i1p3_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp45_r4i1p3_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p3_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p3_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p3_207601-210012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p3_210101-212512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p3_212601-215012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p3_215101-217512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p3_217601-220012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p3_220101-222512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p3_222601-225012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p3_225101-227512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r4i1p3_227601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r4i1p3_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r4i1p3_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r4i1p3_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r4i1p3_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r4i1p3_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r4i1p3_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r4i1p3_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp45_r4i1p3_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p3_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p3_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p3_207601-210012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p3_210101-212512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p3_212601-215012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p3_215101-217512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p3_217601-220012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p3_220101-222512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p3_222601-225012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p3_225101-227512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r4i1p3_227601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r4i1p3_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r5i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 5,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r5i1p1_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r5i1p1_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r5i1p1_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r5i1p1_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r5i1p1_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r5i1p1_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r5i1p1_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp45_r5i1p1_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p1_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p1_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p1_207601-210012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p1_210101-212512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p1_212601-215012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p1_215101-217512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p1_217601-220012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p1_220101-222512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p1_222601-225012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p1_225101-227512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p1_227601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r5i1p1_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r5i1p1_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r5i1p1_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r5i1p1_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r5i1p1_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r5i1p1_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r5i1p1_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp45_r5i1p1_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p1_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p1_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p1_207601-210012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p1_210101-212512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p1_212601-215012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p1_215101-217512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p1_217601-220012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p1_220101-222512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p1_222601-225012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p1_225101-227512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p1_227601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r5i1p1_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r5i1p2_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 5,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r5i1p2_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r5i1p2_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r5i1p2_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r5i1p2_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r5i1p2_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r5i1p2_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r5i1p2_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp45_r5i1p2_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p2_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p2_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p2_207601-210012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p2_210101-212512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p2_212601-215012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p2_215101-217512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p2_217601-220012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p2_220101-222512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p2_222601-225012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p2_225101-227512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p2_227601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r5i1p2_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r5i1p2_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r5i1p2_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r5i1p2_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r5i1p2_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r5i1p2_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r5i1p2_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp45_r5i1p2_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p2_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p2_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p2_207601-210012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p2_210101-212512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p2_212601-215012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p2_215101-217512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p2_217601-220012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p2_220101-222512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p2_222601-225012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p2_225101-227512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p2_227601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r5i1p2_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r5i1p3_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 5,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r5i1p3_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r5i1p3_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r5i1p3_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r5i1p3_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r5i1p3_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r5i1p3_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r5i1p3_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp45_r5i1p3_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p3_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p3_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p3_207601-210012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p3_210101-212512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p3_212601-215012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p3_215101-217512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p3_217601-220012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p3_220101-222512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p3_222601-225012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p3_225101-227512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r5i1p3_227601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r5i1p3_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r5i1p3_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r5i1p3_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r5i1p3_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r5i1p3_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r5i1p3_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r5i1p3_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp45_r5i1p3_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p3_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p3_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p3_207601-210012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p3_210101-212512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p3_212601-215012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p3_215101-217512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p3_217601-220012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p3_220101-222512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p3_222601-225012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p3_225101-227512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r5i1p3_227601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r5i1p3_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r6i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 6,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r6i1p1_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r6i1p1_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r6i1p1_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r6i1p1_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r6i1p1_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r6i1p1_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r6i1p1_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp45_r6i1p1_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r6i1p1_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r6i1p1_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r6i1p1_207601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r6i1p1_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r6i1p1_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r6i1p1_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r6i1p1_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r6i1p1_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r6i1p1_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r6i1p1_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp45_r6i1p1_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r6i1p1_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r6i1p1_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r6i1p1_207601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r6i1p1_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r6i1p3_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 6,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r6i1p3_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r6i1p3_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r6i1p3_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r6i1p3_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r6i1p3_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r6i1p3_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r6i1p3_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp45_r6i1p3_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r6i1p3_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r6i1p3_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp45_r6i1p3_207601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r6i1p3_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r6i1p3_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r6i1p3_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r6i1p3_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r6i1p3_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r6i1p3_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r6i1p3_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp45_r6i1p3_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r6i1p3_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r6i1p3_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp45_r6i1p3_207601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r6i1p3_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-CC-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "GISS-E2-R-CC",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R-CC/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R-CC/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R-CC/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R-CC/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R-CC_historical_r1i1p1_185001-187512.nc", 
            "tas_Amon_GISS-E2-R-CC_historical_r1i1p1_187601-190012.nc", 
            "tas_Amon_GISS-E2-R-CC_historical_r1i1p1_190101-192512.nc", 
            "tas_Amon_GISS-E2-R-CC_historical_r1i1p1_192601-195012.nc", 
            "tas_Amon_GISS-E2-R-CC_historical_r1i1p1_195101-197512.nc", 
            "tas_Amon_GISS-E2-R-CC_historical_r1i1p1_197601-200012.nc", 
            "tas_Amon_GISS-E2-R-CC_historical_r1i1p1_200101-201012.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R-CC_rcp45_r1i1p1_200601-202512.nc", 
            "tas_Amon_GISS-E2-R-CC_rcp45_r1i1p1_202601-205012.nc", 
            "tas_Amon_GISS-E2-R-CC_rcp45_r1i1p1_205101-207512.nc", 
            "tas_Amon_GISS-E2-R-CC_rcp45_r1i1p1_207601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R-CC_historical_r1i1p1_185001-187512.nc", 
            "pr_Amon_GISS-E2-R-CC_historical_r1i1p1_187601-190012.nc", 
            "pr_Amon_GISS-E2-R-CC_historical_r1i1p1_190101-192512.nc", 
            "pr_Amon_GISS-E2-R-CC_historical_r1i1p1_192601-195012.nc", 
            "pr_Amon_GISS-E2-R-CC_historical_r1i1p1_195101-197512.nc", 
            "pr_Amon_GISS-E2-R-CC_historical_r1i1p1_197601-200012.nc", 
            "pr_Amon_GISS-E2-R-CC_historical_r1i1p1_200101-201012.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R-CC_rcp45_r1i1p1_200601-202512.nc", 
            "pr_Amon_GISS-E2-R-CC_rcp45_r1i1p1_202601-205012.nc", 
            "pr_Amon_GISS-E2-R-CC_rcp45_r1i1p1_205101-207512.nc", 
            "pr_Amon_GISS-E2-R-CC_rcp45_r1i1p1_207601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R-CC/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R-CC_historical_r1i1p1_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadCM3-r10i1p1_rcp45' = list( 
      rcm = "",
      gcm = "HadCM3",
      gcm.run = 10,
      institute = "MOHC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadCM3_historical_r10i1p1_185912-188411.nc", 
            "tas_Amon_HadCM3_historical_r10i1p1_188412-190911.nc", 
            "tas_Amon_HadCM3_historical_r10i1p1_190912-193411.nc", 
            "tas_Amon_HadCM3_historical_r10i1p1_193412-195911.nc", 
            "tas_Amon_HadCM3_historical_r10i1p1_195912-198411.nc", 
            "tas_Amon_HadCM3_historical_r10i1p1_198412-200512.nc"
            ),
          scenario = c(
            "tas_Amon_HadCM3_rcp45_r10i1p1_200601-203012.nc", 
            "tas_Amon_HadCM3_rcp45_r10i1p1_203101-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadCM3_historical_r10i1p1_185912-188411.nc", 
            "pr_Amon_HadCM3_historical_r10i1p1_188412-190911.nc", 
            "pr_Amon_HadCM3_historical_r10i1p1_190912-193411.nc", 
            "pr_Amon_HadCM3_historical_r10i1p1_193412-195911.nc", 
            "pr_Amon_HadCM3_historical_r10i1p1_195912-198411.nc", 
            "pr_Amon_HadCM3_historical_r10i1p1_198412-200512.nc"
            ),
          scenario = c(
            "pr_Amon_HadCM3_rcp45_r10i1p1_200601-203012.nc", 
            "pr_Amon_HadCM3_rcp45_r10i1p1_203101-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
      gridfile.filename = "tas_Amon_HadCM3_historical_r10i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadCM3-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "HadCM3",
      gcm.run = 1,
      institute = "MOHC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadCM3_historical_r1i1p1_185912-188411.nc", 
            "tas_Amon_HadCM3_historical_r1i1p1_188412-190911.nc", 
            "tas_Amon_HadCM3_historical_r1i1p1_190912-193411.nc", 
            "tas_Amon_HadCM3_historical_r1i1p1_193412-195911.nc", 
            "tas_Amon_HadCM3_historical_r1i1p1_195912-198411.nc", 
            "tas_Amon_HadCM3_historical_r1i1p1_198412-200512.nc"
            ),
          scenario = c(
            "tas_Amon_HadCM3_rcp45_r1i1p1_200601-203012.nc", 
            "tas_Amon_HadCM3_rcp45_r1i1p1_203101-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadCM3_historical_r1i1p1_185912-188411.nc", 
            "pr_Amon_HadCM3_historical_r1i1p1_188412-190911.nc", 
            "pr_Amon_HadCM3_historical_r1i1p1_190912-193411.nc", 
            "pr_Amon_HadCM3_historical_r1i1p1_193412-195911.nc", 
            "pr_Amon_HadCM3_historical_r1i1p1_195912-198411.nc", 
            "pr_Amon_HadCM3_historical_r1i1p1_198412-200512.nc"
            ),
          scenario = c(
            "pr_Amon_HadCM3_rcp45_r1i1p1_200601-203012.nc", 
            "pr_Amon_HadCM3_rcp45_r1i1p1_203101-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
      gridfile.filename = "tas_Amon_HadCM3_historical_r1i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadCM3-r2i1p1_rcp45' = list( 
      rcm = "",
      gcm = "HadCM3",
      gcm.run = 2,
      institute = "MOHC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadCM3_historical_r2i1p1_185912-188411.nc", 
            "tas_Amon_HadCM3_historical_r2i1p1_188412-190911.nc", 
            "tas_Amon_HadCM3_historical_r2i1p1_190912-193411.nc", 
            "tas_Amon_HadCM3_historical_r2i1p1_193412-195911.nc", 
            "tas_Amon_HadCM3_historical_r2i1p1_195912-198411.nc", 
            "tas_Amon_HadCM3_historical_r2i1p1_198412-200512.nc"
            ),
          scenario = c(
            "tas_Amon_HadCM3_rcp45_r2i1p1_200601-203012.nc", 
            "tas_Amon_HadCM3_rcp45_r2i1p1_203101-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadCM3_historical_r2i1p1_185912-188411.nc", 
            "pr_Amon_HadCM3_historical_r2i1p1_188412-190911.nc", 
            "pr_Amon_HadCM3_historical_r2i1p1_190912-193411.nc", 
            "pr_Amon_HadCM3_historical_r2i1p1_193412-195911.nc", 
            "pr_Amon_HadCM3_historical_r2i1p1_195912-198411.nc", 
            "pr_Amon_HadCM3_historical_r2i1p1_198412-200512.nc"
            ),
          scenario = c(
            "pr_Amon_HadCM3_rcp45_r2i1p1_200601-203012.nc", 
            "pr_Amon_HadCM3_rcp45_r2i1p1_203101-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
      gridfile.filename = "tas_Amon_HadCM3_historical_r2i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadCM3-r3i1p1_rcp45' = list( 
      rcm = "",
      gcm = "HadCM3",
      gcm.run = 3,
      institute = "MOHC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadCM3_historical_r3i1p1_185912-188411.nc", 
            "tas_Amon_HadCM3_historical_r3i1p1_188412-190911.nc", 
            "tas_Amon_HadCM3_historical_r3i1p1_190912-193411.nc", 
            "tas_Amon_HadCM3_historical_r3i1p1_193412-195911.nc", 
            "tas_Amon_HadCM3_historical_r3i1p1_195912-198411.nc", 
            "tas_Amon_HadCM3_historical_r3i1p1_198412-200512.nc"
            ),
          scenario = c(
            "tas_Amon_HadCM3_rcp45_r3i1p1_200601-203012.nc", 
            "tas_Amon_HadCM3_rcp45_r3i1p1_203101-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadCM3_historical_r3i1p1_185912-188411.nc", 
            "pr_Amon_HadCM3_historical_r3i1p1_188412-190911.nc", 
            "pr_Amon_HadCM3_historical_r3i1p1_190912-193411.nc", 
            "pr_Amon_HadCM3_historical_r3i1p1_193412-195911.nc", 
            "pr_Amon_HadCM3_historical_r3i1p1_195912-198411.nc", 
            "pr_Amon_HadCM3_historical_r3i1p1_198412-200512.nc"
            ),
          scenario = c(
            "pr_Amon_HadCM3_rcp45_r3i1p1_200601-203012.nc", 
            "pr_Amon_HadCM3_rcp45_r3i1p1_203101-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
      gridfile.filename = "tas_Amon_HadCM3_historical_r3i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadCM3-r4i1p1_rcp45' = list( 
      rcm = "",
      gcm = "HadCM3",
      gcm.run = 4,
      institute = "MOHC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadCM3_historical_r4i1p1_185912-188411.nc", 
            "tas_Amon_HadCM3_historical_r4i1p1_188412-190911.nc", 
            "tas_Amon_HadCM3_historical_r4i1p1_190912-193411.nc", 
            "tas_Amon_HadCM3_historical_r4i1p1_193412-195911.nc", 
            "tas_Amon_HadCM3_historical_r4i1p1_195912-198411.nc", 
            "tas_Amon_HadCM3_historical_r4i1p1_198412-200512.nc"
            ),
          scenario = c(
            "tas_Amon_HadCM3_rcp45_r4i1p1_200601-203012.nc", 
            "tas_Amon_HadCM3_rcp45_r4i1p1_203101-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadCM3_historical_r4i1p1_185912-188411.nc", 
            "pr_Amon_HadCM3_historical_r4i1p1_188412-190911.nc", 
            "pr_Amon_HadCM3_historical_r4i1p1_190912-193411.nc", 
            "pr_Amon_HadCM3_historical_r4i1p1_193412-195911.nc", 
            "pr_Amon_HadCM3_historical_r4i1p1_195912-198411.nc", 
            "pr_Amon_HadCM3_historical_r4i1p1_198412-200512.nc"
            ),
          scenario = c(
            "pr_Amon_HadCM3_rcp45_r4i1p1_200601-203012.nc", 
            "pr_Amon_HadCM3_rcp45_r4i1p1_203101-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
      gridfile.filename = "tas_Amon_HadCM3_historical_r4i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadCM3-r5i1p1_rcp45' = list( 
      rcm = "",
      gcm = "HadCM3",
      gcm.run = 5,
      institute = "MOHC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadCM3_historical_r5i1p1_185912-188411.nc", 
            "tas_Amon_HadCM3_historical_r5i1p1_188412-190911.nc", 
            "tas_Amon_HadCM3_historical_r5i1p1_190912-193411.nc", 
            "tas_Amon_HadCM3_historical_r5i1p1_193412-195911.nc", 
            "tas_Amon_HadCM3_historical_r5i1p1_195912-198411.nc", 
            "tas_Amon_HadCM3_historical_r5i1p1_198412-200512.nc"
            ),
          scenario = c(
            "tas_Amon_HadCM3_rcp45_r5i1p1_200601-203012.nc", 
            "tas_Amon_HadCM3_rcp45_r5i1p1_203101-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadCM3_historical_r5i1p1_185912-188411.nc", 
            "pr_Amon_HadCM3_historical_r5i1p1_188412-190911.nc", 
            "pr_Amon_HadCM3_historical_r5i1p1_190912-193411.nc", 
            "pr_Amon_HadCM3_historical_r5i1p1_193412-195911.nc", 
            "pr_Amon_HadCM3_historical_r5i1p1_195912-198411.nc", 
            "pr_Amon_HadCM3_historical_r5i1p1_198412-200512.nc"
            ),
          scenario = c(
            "pr_Amon_HadCM3_rcp45_r5i1p1_200601-203012.nc", 
            "pr_Amon_HadCM3_rcp45_r5i1p1_203101-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
      gridfile.filename = "tas_Amon_HadCM3_historical_r5i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadCM3-r6i1p1_rcp45' = list( 
      rcm = "",
      gcm = "HadCM3",
      gcm.run = 6,
      institute = "MOHC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadCM3_historical_r6i1p1_185912-188411.nc", 
            "tas_Amon_HadCM3_historical_r6i1p1_188412-190911.nc", 
            "tas_Amon_HadCM3_historical_r6i1p1_190912-193411.nc", 
            "tas_Amon_HadCM3_historical_r6i1p1_193412-195911.nc", 
            "tas_Amon_HadCM3_historical_r6i1p1_195912-198411.nc", 
            "tas_Amon_HadCM3_historical_r6i1p1_198412-200512.nc"
            ),
          scenario = c(
            "tas_Amon_HadCM3_rcp45_r6i1p1_200601-203012.nc", 
            "tas_Amon_HadCM3_rcp45_r6i1p1_203101-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadCM3_historical_r6i1p1_185912-188411.nc", 
            "pr_Amon_HadCM3_historical_r6i1p1_188412-190911.nc", 
            "pr_Amon_HadCM3_historical_r6i1p1_190912-193411.nc", 
            "pr_Amon_HadCM3_historical_r6i1p1_193412-195911.nc", 
            "pr_Amon_HadCM3_historical_r6i1p1_195912-198411.nc", 
            "pr_Amon_HadCM3_historical_r6i1p1_198412-200512.nc"
            ),
          scenario = c(
            "pr_Amon_HadCM3_rcp45_r6i1p1_200601-203012.nc", 
            "pr_Amon_HadCM3_rcp45_r6i1p1_203101-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
      gridfile.filename = "tas_Amon_HadCM3_historical_r6i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadCM3-r7i1p1_rcp45' = list( 
      rcm = "",
      gcm = "HadCM3",
      gcm.run = 7,
      institute = "MOHC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadCM3_historical_r7i1p1_185912-188411.nc", 
            "tas_Amon_HadCM3_historical_r7i1p1_188412-190911.nc", 
            "tas_Amon_HadCM3_historical_r7i1p1_190912-193411.nc", 
            "tas_Amon_HadCM3_historical_r7i1p1_193412-195911.nc", 
            "tas_Amon_HadCM3_historical_r7i1p1_195912-198411.nc", 
            "tas_Amon_HadCM3_historical_r7i1p1_198412-200512.nc"
            ),
          scenario = c(
            "tas_Amon_HadCM3_rcp45_r7i1p1_200601-203012.nc", 
            "tas_Amon_HadCM3_rcp45_r7i1p1_203101-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadCM3_historical_r7i1p1_185912-188411.nc", 
            "pr_Amon_HadCM3_historical_r7i1p1_188412-190911.nc", 
            "pr_Amon_HadCM3_historical_r7i1p1_190912-193411.nc", 
            "pr_Amon_HadCM3_historical_r7i1p1_193412-195911.nc", 
            "pr_Amon_HadCM3_historical_r7i1p1_195912-198411.nc", 
            "pr_Amon_HadCM3_historical_r7i1p1_198412-200512.nc"
            ),
          scenario = c(
            "pr_Amon_HadCM3_rcp45_r7i1p1_200601-203012.nc", 
            "pr_Amon_HadCM3_rcp45_r7i1p1_203101-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
      gridfile.filename = "tas_Amon_HadCM3_historical_r7i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadCM3-r8i1p1_rcp45' = list( 
      rcm = "",
      gcm = "HadCM3",
      gcm.run = 8,
      institute = "MOHC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadCM3_historical_r8i1p1_185912-188411.nc", 
            "tas_Amon_HadCM3_historical_r8i1p1_188412-190911.nc", 
            "tas_Amon_HadCM3_historical_r8i1p1_190912-193411.nc", 
            "tas_Amon_HadCM3_historical_r8i1p1_193412-195911.nc", 
            "tas_Amon_HadCM3_historical_r8i1p1_195912-198411.nc", 
            "tas_Amon_HadCM3_historical_r8i1p1_198412-200512.nc"
            ),
          scenario = c(
            "tas_Amon_HadCM3_rcp45_r8i1p1_200601-203012.nc", 
            "tas_Amon_HadCM3_rcp45_r8i1p1_203101-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadCM3_historical_r8i1p1_185912-188411.nc", 
            "pr_Amon_HadCM3_historical_r8i1p1_188412-190911.nc", 
            "pr_Amon_HadCM3_historical_r8i1p1_190912-193411.nc", 
            "pr_Amon_HadCM3_historical_r8i1p1_193412-195911.nc", 
            "pr_Amon_HadCM3_historical_r8i1p1_195912-198411.nc", 
            "pr_Amon_HadCM3_historical_r8i1p1_198412-200512.nc"
            ),
          scenario = c(
            "pr_Amon_HadCM3_rcp45_r8i1p1_200601-203012.nc", 
            "pr_Amon_HadCM3_rcp45_r8i1p1_203101-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
      gridfile.filename = "tas_Amon_HadCM3_historical_r8i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadCM3-r9i1p1_rcp45' = list( 
      rcm = "",
      gcm = "HadCM3",
      gcm.run = 9,
      institute = "MOHC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadCM3_historical_r9i1p1_185912-188411.nc", 
            "tas_Amon_HadCM3_historical_r9i1p1_188412-190911.nc", 
            "tas_Amon_HadCM3_historical_r9i1p1_190912-193411.nc", 
            "tas_Amon_HadCM3_historical_r9i1p1_193412-195911.nc", 
            "tas_Amon_HadCM3_historical_r9i1p1_195912-198411.nc", 
            "tas_Amon_HadCM3_historical_r9i1p1_198412-200512.nc"
            ),
          scenario = c(
            "tas_Amon_HadCM3_rcp45_r9i1p1_200601-203012.nc", 
            "tas_Amon_HadCM3_rcp45_r9i1p1_203101-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadCM3_historical_r9i1p1_185912-188411.nc", 
            "pr_Amon_HadCM3_historical_r9i1p1_188412-190911.nc", 
            "pr_Amon_HadCM3_historical_r9i1p1_190912-193411.nc", 
            "pr_Amon_HadCM3_historical_r9i1p1_193412-195911.nc", 
            "pr_Amon_HadCM3_historical_r9i1p1_195912-198411.nc", 
            "pr_Amon_HadCM3_historical_r9i1p1_198412-200512.nc"
            ),
          scenario = c(
            "pr_Amon_HadCM3_rcp45_r9i1p1_200601-203012.nc", 
            "pr_Amon_HadCM3_rcp45_r9i1p1_203101-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadCM3/historical",
      gridfile.filename = "tas_Amon_HadCM3_historical_r9i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-AO-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "HadGEM2-AO",
      gcm.run = 1,
      institute = "NIMR/KMA",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-AO/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-AO/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-AO/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-AO/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-AO_historical_r1i1p1_186001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_HadGEM2-AO_rcp45_r1i1p1_200601-209912.nc", 
            "tas_Amon_HadGEM2-AO_rcp45_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-AO_historical_r1i1p1_186001-200512.nc"
            ),
          scenario = c(
##            "pr_Amon_HadGEM2-AO_rcp45_r1i1p1_200601-209912.nc", 
            "pr_Amon_HadGEM2-AO_rcp45_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-AO/historical",
      gridfile.filename = "tas_Amon_HadGEM2-AO_historical_r1i1p1_186001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-CC-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "HadGEM2-CC",
      gcm.run = 1,
      institute = "MOHC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-CC/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-CC/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-CC/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-CC/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-CC_historical_r1i1p1_185912-188411.nc", 
            "tas_Amon_HadGEM2-CC_historical_r1i1p1_188412-190911.nc", 
            "tas_Amon_HadGEM2-CC_historical_r1i1p1_190912-193411.nc", 
            "tas_Amon_HadGEM2-CC_historical_r1i1p1_193412-195911.nc", 
            "tas_Amon_HadGEM2-CC_historical_r1i1p1_195912-198411.nc", 
            "tas_Amon_HadGEM2-CC_historical_r1i1p1_198412-200511.nc"
            ),
          scenario = c(
            "tas_Amon_HadGEM2-CC_rcp45_r1i1p1_200512-203011.nc", 
            "tas_Amon_HadGEM2-CC_rcp45_r1i1p1_203012-205511.nc", 
            "tas_Amon_HadGEM2-CC_rcp45_r1i1p1_205512-208011.nc", 
            "tas_Amon_HadGEM2-CC_rcp45_r1i1p1_208012-209912.nc", 
            "tas_Amon_HadGEM2-CC_rcp45_r1i1p1_210001-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-CC_historical_r1i1p1_185912-188411.nc", 
            "pr_Amon_HadGEM2-CC_historical_r1i1p1_188412-190911.nc", 
            "pr_Amon_HadGEM2-CC_historical_r1i1p1_190912-193411.nc", 
            "pr_Amon_HadGEM2-CC_historical_r1i1p1_193412-195911.nc", 
            "pr_Amon_HadGEM2-CC_historical_r1i1p1_195912-198411.nc", 
            "pr_Amon_HadGEM2-CC_historical_r1i1p1_198412-200511.nc"
            ),
          scenario = c(
            "pr_Amon_HadGEM2-CC_rcp45_r1i1p1_200512-203011.nc", 
            "pr_Amon_HadGEM2-CC_rcp45_r1i1p1_203012-205511.nc", 
            "pr_Amon_HadGEM2-CC_rcp45_r1i1p1_205512-208011.nc", 
            "pr_Amon_HadGEM2-CC_rcp45_r1i1p1_208012-209912.nc", 
            "pr_Amon_HadGEM2-CC_rcp45_r1i1p1_210001-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-CC/historical",
      gridfile.filename = "tas_Amon_HadGEM2-CC_historical_r1i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-ES-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "HadGEM2-ES",
      gcm.run = 1,
      institute = "MOHC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_185912-188411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_188412-190911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_190912-193411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_193412-195911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_195912-198411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_198412-200511.nc"
            ),
          scenario = c(
            "tas_Amon_HadGEM2-ES_rcp45_r1i1p1_200512-203011.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r1i1p1_203012-205511.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r1i1p1_205512-208011.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r1i1p1_208012-209911.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r1i1p1_209912-212411.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r1i1p1_212412-214911.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r1i1p1_214912-217411.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r1i1p1_217412-219911.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r1i1p1_219912-222411.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r1i1p1_222412-224911.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r1i1p1_224912-227411.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r1i1p1_227412-229911.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r1i1p1_229912-229912.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_185912-188411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_188412-190911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_190912-193411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_193412-195911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_195912-198411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_198412-200511.nc"
            ),
          scenario = c(
            "pr_Amon_HadGEM2-ES_rcp45_r1i1p1_200512-203011.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r1i1p1_203012-205511.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r1i1p1_205512-208011.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r1i1p1_208012-209911.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r1i1p1_209912-212411.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r1i1p1_212412-214911.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r1i1p1_214912-217411.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r1i1p1_217412-219911.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r1i1p1_219912-222411.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r1i1p1_222412-224911.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r1i1p1_224912-227411.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r1i1p1_227412-229911.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r1i1p1_229912-229912.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
      gridfile.filename = "tas_Amon_HadGEM2-ES_historical_r1i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-ES-r2i1p1_rcp45' = list( 
      rcm = "",
      gcm = "HadGEM2-ES",
      gcm.run = 2,
      institute = "MOHC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_185912-188411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_188412-190911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_190912-193411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_193412-195911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_195912-198411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_198412-200512.nc"
            ),
          scenario = c(
            "tas_Amon_HadGEM2-ES_rcp45_r2i1p1_200512-203011.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r2i1p1_203012-205511.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r2i1p1_205512-208011.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r2i1p1_208012-210011.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r2i1p1_210012-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_185912-188411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_188412-190911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_190912-193411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_193412-195911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_195912-198411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_198412-200512.nc"
            ),
          scenario = c(
            "pr_Amon_HadGEM2-ES_rcp45_r2i1p1_200512-203011.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r2i1p1_203012-205511.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r2i1p1_205512-208011.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r2i1p1_208012-210011.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r2i1p1_210012-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
      gridfile.filename = "tas_Amon_HadGEM2-ES_historical_r2i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-ES-r3i1p1_rcp45' = list( 
      rcm = "",
      gcm = "HadGEM2-ES",
      gcm.run = 3,
      institute = "MOHC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_185912-188411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_188412-190911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_190912-193411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_193412-195911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_195912-198411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_198412-200512.nc"
            ),
          scenario = c(
            "tas_Amon_HadGEM2-ES_rcp45_r3i1p1_200512-203011.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r3i1p1_203012-205511.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r3i1p1_205512-208011.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r3i1p1_208012-210011.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r3i1p1_210012-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_185912-188411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_188412-190911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_190912-193411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_193412-195911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_195912-198411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_198412-200512.nc"
            ),
          scenario = c(
            "pr_Amon_HadGEM2-ES_rcp45_r3i1p1_200512-203011.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r3i1p1_203012-205511.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r3i1p1_205512-208011.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r3i1p1_208012-210011.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r3i1p1_210012-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
      gridfile.filename = "tas_Amon_HadGEM2-ES_historical_r3i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-ES-r4i1p1_rcp45' = list( 
      rcm = "",
      gcm = "HadGEM2-ES",
      gcm.run = 4,
      institute = "MOHC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_185912-188411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_188412-190911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_190912-193411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_193412-195911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_195912-198411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_198412-200511.nc"
            ),
          scenario = c(
            "tas_Amon_HadGEM2-ES_rcp45_r4i1p1_200512-203011.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r4i1p1_203012-205511.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r4i1p1_205512-208011.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r4i1p1_208012-210011.nc", 
            "tas_Amon_HadGEM2-ES_rcp45_r4i1p1_210012-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_185912-188411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_188412-190911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_190912-193411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_193412-195911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_195912-198411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_198412-200511.nc"
            ),
          scenario = c(
            "pr_Amon_HadGEM2-ES_rcp45_r4i1p1_200512-203011.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r4i1p1_203012-205511.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r4i1p1_205512-208011.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r4i1p1_208012-210011.nc", 
            "pr_Amon_HadGEM2-ES_rcp45_r4i1p1_210012-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
      gridfile.filename = "tas_Amon_HadGEM2-ES_historical_r4i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'INM-CM4-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "INM-CM4",
      gcm.run = 1,
      institute = "INM",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/INM-CM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/INM-CM4/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/INM-CM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/INM-CM4/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_inmcm4_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_inmcm4_rcp45_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_inmcm4_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_inmcm4_rcp45_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/INM-CM4/historical",
      gridfile.filename = "tas_Amon_inmcm4_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'IPSL-CM5A-LR-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "IPSL-CM5A-LR",
      gcm.run = 1,
      institute = "IPSL",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_IPSL-CM5A-LR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_IPSL-CM5A-LR_rcp45_r1i1p1_200601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_IPSL-CM5A-LR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_IPSL-CM5A-LR_rcp45_r1i1p1_200601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
      gridfile.filename = "tas_Amon_IPSL-CM5A-LR_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'IPSL-CM5A-LR-r2i1p1_rcp45' = list( 
      rcm = "",
      gcm = "IPSL-CM5A-LR",
      gcm.run = 2,
      institute = "IPSL",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_IPSL-CM5A-LR_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_IPSL-CM5A-LR_rcp45_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_IPSL-CM5A-LR_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_IPSL-CM5A-LR_rcp45_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
      gridfile.filename = "tas_Amon_IPSL-CM5A-LR_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'IPSL-CM5A-LR-r3i1p1_rcp45' = list( 
      rcm = "",
      gcm = "IPSL-CM5A-LR",
      gcm.run = 3,
      institute = "IPSL",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_IPSL-CM5A-LR_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_IPSL-CM5A-LR_rcp45_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_IPSL-CM5A-LR_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_IPSL-CM5A-LR_rcp45_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
      gridfile.filename = "tas_Amon_IPSL-CM5A-LR_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'IPSL-CM5A-LR-r4i1p1_rcp45' = list( 
      rcm = "",
      gcm = "IPSL-CM5A-LR",
      gcm.run = 4,
      institute = "IPSL",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_IPSL-CM5A-LR_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_IPSL-CM5A-LR_rcp45_r4i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_IPSL-CM5A-LR_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_IPSL-CM5A-LR_rcp45_r4i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
      gridfile.filename = "tas_Amon_IPSL-CM5A-LR_historical_r4i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'IPSL-CM5A-MR-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "IPSL-CM5A-MR",
      gcm.run = 1,
      institute = "IPSL",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-MR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-MR/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-MR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-MR/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_IPSL-CM5A-MR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_IPSL-CM5A-MR_rcp45_r1i1p1_200601-210012.nc", 
            "tas_Amon_IPSL-CM5A-MR_rcp45_r1i1p1_210101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_IPSL-CM5A-MR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_IPSL-CM5A-MR_rcp45_r1i1p1_200601-210012.nc", 
            "pr_Amon_IPSL-CM5A-MR_rcp45_r1i1p1_210101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-MR/historical",
      gridfile.filename = "tas_Amon_IPSL-CM5A-MR_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'IPSL-CM5B-LR-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "IPSL-CM5B-LR",
      gcm.run = 1,
      institute = "IPSL",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5B-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5B-LR/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5B-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5B-LR/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_IPSL-CM5B-LR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_IPSL-CM5B-LR_rcp45_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_IPSL-CM5B-LR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_IPSL-CM5B-LR_rcp45_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5B-LR/historical",
      gridfile.filename = "tas_Amon_IPSL-CM5B-LR_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC4h-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "MIROC4h",
      gcm.run = 1,
      institute = "MIROC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC4h/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC4h/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC4h/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC4h/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC4h_historical_r1i1p1_195001-195012.nc", 
            "tas_Amon_MIROC4h_historical_r1i1p1_195101-196012.nc", 
            "tas_Amon_MIROC4h_historical_r1i1p1_196101-197012.nc", 
            "tas_Amon_MIROC4h_historical_r1i1p1_197101-198012.nc", 
            "tas_Amon_MIROC4h_historical_r1i1p1_198101-199012.nc", 
            "tas_Amon_MIROC4h_historical_r1i1p1_199101-200012.nc", 
            "tas_Amon_MIROC4h_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC4h_rcp45_r1i1p1_200601-201512.nc", 
            "tas_Amon_MIROC4h_rcp45_r1i1p1_201601-202512.nc", 
            "tas_Amon_MIROC4h_rcp45_r1i1p1_202601-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC4h_historical_r1i1p1_195001-195012.nc", 
            "pr_Amon_MIROC4h_historical_r1i1p1_195101-196012.nc", 
            "pr_Amon_MIROC4h_historical_r1i1p1_196101-197012.nc", 
            "pr_Amon_MIROC4h_historical_r1i1p1_197101-198012.nc", 
            "pr_Amon_MIROC4h_historical_r1i1p1_198101-199012.nc", 
            "pr_Amon_MIROC4h_historical_r1i1p1_199101-200012.nc", 
            "pr_Amon_MIROC4h_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC4h_rcp45_r1i1p1_200601-201512.nc", 
            "pr_Amon_MIROC4h_rcp45_r1i1p1_201601-202512.nc", 
            "pr_Amon_MIROC4h_rcp45_r1i1p1_202601-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC4h/historical",
      gridfile.filename = "tas_Amon_MIROC4h_historical_r1i1p1_195001-195012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC4h-r2i1p1_rcp45' = list( 
      rcm = "",
      gcm = "MIROC4h",
      gcm.run = 2,
      institute = "MIROC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC4h/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC4h/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC4h/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC4h/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC4h_historical_r2i1p1_195001-195012.nc", 
            "tas_Amon_MIROC4h_historical_r2i1p1_195101-196012.nc", 
            "tas_Amon_MIROC4h_historical_r2i1p1_196101-197012.nc", 
            "tas_Amon_MIROC4h_historical_r2i1p1_197101-198012.nc", 
            "tas_Amon_MIROC4h_historical_r2i1p1_198101-199012.nc", 
            "tas_Amon_MIROC4h_historical_r2i1p1_199101-200012.nc", 
            "tas_Amon_MIROC4h_historical_r2i1p1_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC4h_rcp45_r2i1p1_200601-201512.nc", 
            "tas_Amon_MIROC4h_rcp45_r2i1p1_201601-202512.nc", 
            "tas_Amon_MIROC4h_rcp45_r2i1p1_202601-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC4h_historical_r2i1p1_195001-195012.nc", 
            "pr_Amon_MIROC4h_historical_r2i1p1_195101-196012.nc", 
            "pr_Amon_MIROC4h_historical_r2i1p1_196101-197012.nc", 
            "pr_Amon_MIROC4h_historical_r2i1p1_197101-198012.nc", 
            "pr_Amon_MIROC4h_historical_r2i1p1_198101-199012.nc", 
            "pr_Amon_MIROC4h_historical_r2i1p1_199101-200012.nc", 
            "pr_Amon_MIROC4h_historical_r2i1p1_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC4h_rcp45_r2i1p1_200601-201512.nc", 
            "pr_Amon_MIROC4h_rcp45_r2i1p1_201601-202512.nc", 
            "pr_Amon_MIROC4h_rcp45_r2i1p1_202601-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC4h/historical",
      gridfile.filename = "tas_Amon_MIROC4h_historical_r2i1p1_195001-195012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC4h-r3i1p1_rcp45' = list( 
      rcm = "",
      gcm = "MIROC4h",
      gcm.run = 3,
      institute = "MIROC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC4h/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC4h/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC4h/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC4h/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC4h_historical_r3i1p1_195001-195012.nc", 
            "tas_Amon_MIROC4h_historical_r3i1p1_195101-196012.nc", 
            "tas_Amon_MIROC4h_historical_r3i1p1_196101-197012.nc", 
            "tas_Amon_MIROC4h_historical_r3i1p1_197101-198012.nc", 
            "tas_Amon_MIROC4h_historical_r3i1p1_198101-199012.nc", 
            "tas_Amon_MIROC4h_historical_r3i1p1_199101-200012.nc", 
            "tas_Amon_MIROC4h_historical_r3i1p1_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC4h_rcp45_r3i1p1_200601-201512.nc", 
            "tas_Amon_MIROC4h_rcp45_r3i1p1_201601-202512.nc", 
            "tas_Amon_MIROC4h_rcp45_r3i1p1_202601-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC4h_historical_r3i1p1_195001-195012.nc", 
            "pr_Amon_MIROC4h_historical_r3i1p1_195101-196012.nc", 
            "pr_Amon_MIROC4h_historical_r3i1p1_196101-197012.nc", 
            "pr_Amon_MIROC4h_historical_r3i1p1_197101-198012.nc", 
            "pr_Amon_MIROC4h_historical_r3i1p1_198101-199012.nc", 
            "pr_Amon_MIROC4h_historical_r3i1p1_199101-200012.nc", 
            "pr_Amon_MIROC4h_historical_r3i1p1_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC4h_rcp45_r3i1p1_200601-201512.nc", 
            "pr_Amon_MIROC4h_rcp45_r3i1p1_201601-202512.nc", 
            "pr_Amon_MIROC4h_rcp45_r3i1p1_202601-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC4h/historical",
      gridfile.filename = "tas_Amon_MIROC4h_historical_r3i1p1_195001-195012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC5-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "MIROC5",
      gcm.run = 1,
      institute = "MIROC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC5_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC5_rcp45_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC5_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC5_rcp45_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
      gridfile.filename = "tas_Amon_MIROC5_historical_r1i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC5-r2i1p1_rcp45' = list( 
      rcm = "",
      gcm = "MIROC5",
      gcm.run = 2,
      institute = "MIROC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC5_historical_r2i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC5_rcp45_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC5_historical_r2i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC5_rcp45_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
      gridfile.filename = "tas_Amon_MIROC5_historical_r2i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC5-r3i1p1_rcp45' = list( 
      rcm = "",
      gcm = "MIROC5",
      gcm.run = 3,
      institute = "MIROC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC5_historical_r3i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC5_rcp45_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC5_historical_r3i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC5_rcp45_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
      gridfile.filename = "tas_Amon_MIROC5_historical_r3i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC5-r4i1p1_rcp45' = list( 
      rcm = "",
      gcm = "MIROC5",
      gcm.run = 4,
      institute = "MIROC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC5_historical_r4i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC5_rcp45_r4i1p1_200601-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC5_historical_r4i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC5_rcp45_r4i1p1_200601-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
      gridfile.filename = "tas_Amon_MIROC5_historical_r4i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC5-r5i1p1_rcp45' = list( 
      rcm = "",
      gcm = "MIROC5",
      gcm.run = 5,
      institute = "MIROC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC5_historical_r5i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC5_rcp45_r5i1p1_200601-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC5_historical_r5i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC5_rcp45_r5i1p1_200601-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
      gridfile.filename = "tas_Amon_MIROC5_historical_r5i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC-ESM-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "MIROC-ESM",
      gcm.run = 1,
      institute = "MIROC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC-ESM_rcp45_r1i1p1_200601-210012.nc", 
            "tas_Amon_MIROC-ESM_rcp45_r1i1p1_210101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC-ESM_rcp45_r1i1p1_200601-210012.nc", 
            "pr_Amon_MIROC-ESM_rcp45_r1i1p1_210101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM/historical",
      gridfile.filename = "tas_Amon_MIROC-ESM_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC-ESM-CHEM-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "MIROC-ESM-CHEM",
      gcm.run = 1,
      institute = "MIROC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM-CHEM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM-CHEM/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM-CHEM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM-CHEM/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC-ESM-CHEM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC-ESM-CHEM_rcp45_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC-ESM-CHEM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC-ESM-CHEM_rcp45_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM-CHEM/historical",
      gridfile.filename = "tas_Amon_MIROC-ESM-CHEM_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MPI-ESM-LR-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "MPI-ESM-LR",
      gcm.run = 1,
      institute = "MPI-M",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MPI-ESM-LR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MPI-ESM-LR_rcp45_r1i1p1_200601-210012.nc", 
            "tas_Amon_MPI-ESM-LR_rcp45_r1i1p1_210101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MPI-ESM-LR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MPI-ESM-LR_rcp45_r1i1p1_200601-210012.nc", 
            "pr_Amon_MPI-ESM-LR_rcp45_r1i1p1_210101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
      gridfile.filename = "tas_Amon_MPI-ESM-LR_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MPI-ESM-LR-r2i1p1_rcp45' = list( 
      rcm = "",
      gcm = "MPI-ESM-LR",
      gcm.run = 2,
      institute = "MPI-M",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MPI-ESM-LR_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MPI-ESM-LR_rcp45_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MPI-ESM-LR_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MPI-ESM-LR_rcp45_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
      gridfile.filename = "tas_Amon_MPI-ESM-LR_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MPI-ESM-LR-r3i1p1_rcp45' = list( 
      rcm = "",
      gcm = "MPI-ESM-LR",
      gcm.run = 3,
      institute = "MPI-M",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MPI-ESM-LR_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MPI-ESM-LR_rcp45_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MPI-ESM-LR_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MPI-ESM-LR_rcp45_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
      gridfile.filename = "tas_Amon_MPI-ESM-LR_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MPI-ESM-MR-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "MPI-ESM-MR",
      gcm.run = 1,
      institute = "MPI-M",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MPI-ESM-MR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MPI-ESM-MR_rcp45_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MPI-ESM-MR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MPI-ESM-MR_rcp45_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/historical",
      gridfile.filename = "tas_Amon_MPI-ESM-MR_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MPI-ESM-MR-r2i1p1_rcp45' = list( 
      rcm = "",
      gcm = "MPI-ESM-MR",
      gcm.run = 2,
      institute = "MPI-M",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MPI-ESM-MR_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MPI-ESM-MR_rcp45_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MPI-ESM-MR_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MPI-ESM-MR_rcp45_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/historical",
      gridfile.filename = "tas_Amon_MPI-ESM-MR_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MPI-ESM-MR-r3i1p1_rcp45' = list( 
      rcm = "",
      gcm = "MPI-ESM-MR",
      gcm.run = 3,
      institute = "MPI-M",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MPI-ESM-MR_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MPI-ESM-MR_rcp45_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MPI-ESM-MR_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MPI-ESM-MR_rcp45_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/historical",
      gridfile.filename = "tas_Amon_MPI-ESM-MR_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MRI-CGCM3-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "MRI-CGCM3",
      gcm.run = 1,
      institute = "MRI",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-CGCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-CGCM3/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-CGCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-CGCM3/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MRI-CGCM3_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MRI-CGCM3_rcp45_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MRI-CGCM3_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MRI-CGCM3_rcp45_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-CGCM3/historical",
      gridfile.filename = "tas_Amon_MRI-CGCM3_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'NorESM1-M-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "NorESM1-M",
      gcm.run = 1,
      institute = "NCC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-M/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-M/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-M/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-M/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_NorESM1-M_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_NorESM1-M_rcp45_r1i1p1_200601-210012.nc", 
            "tas_Amon_NorESM1-M_rcp45_r1i1p1_210101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_NorESM1-M_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_NorESM1-M_rcp45_r1i1p1_200601-210012.nc", 
            "pr_Amon_NorESM1-M_rcp45_r1i1p1_210101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-M/historical",
      gridfile.filename = "tas_Amon_NorESM1-M_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'NorESM1-ME-r1i1p1_rcp45' = list( 
      rcm = "",
      gcm = "NorESM1-ME",
      gcm.run = 1,
      institute = "NCC",
      emission.scenario = "rcp45",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-ME/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-ME/rcp45"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-ME/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-ME/rcp45")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_NorESM1-ME_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_NorESM1-ME_rcp45_r1i1p1_200601-210212.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_NorESM1-ME_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_NorESM1-ME_rcp45_r1i1p1_200601-210212.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-ME/historical",
      gridfile.filename = "tas_Amon_NorESM1-ME_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
##     'CSIRO-Mk3L-1-2-r1i2p1_rcp45' = list( 
##       rcm = "",
##       gcm = "CSIRO-Mk3L-1-2",
##       gcm.run = 1,
##       institute = "CSIRO-QCCCE",
##       emission.scenario = "rcp45",
##       file.path.alt = list(
##         air_temperature =
##         list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3L-1-2/historical",
##              scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3L-1-2/rcp45"),
##         precipitation_amount =
##         list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3L-1-2/historical",
##              scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3L-1-2/rcp45")),
##       file.name = list(
##         air_temperature = list(
##           historical = c(
##             "tas_Amon_CSIRO-Mk3L-1-2_historical_r1i2p1_185101-200512.nc"
##             ),
##           scenario = c(
##             "tas_Amon_CSIRO-Mk3L-1-2_rcp45_r1i2p1_200601-230012.nc"
##             )),
##         precipitation_amount = list(
##           historical = c(
##             "pr_Amon_CSIRO-Mk3L-1-2_historical_r1i2p1_185101-200512.nc"
##             ),
##           scenario = c(
##             "pr_Amon_CSIRO-Mk3L-1-2_rcp45_r1i2p1_200601-230012.nc"
##            ))),
##       gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3L-1-2/historical",
##       gridfile.filename = "tas_Amon_CSIRO-Mk3L-1-2_historical_r1i2p1_185101-200512.nc",
##       resolution = "",
##       what.timesteps = "monthly"
##       ),

## ################################################################################
##     'CSIRO-Mk3L-1-2-r2i2p1_rcp45' = list( 
##       rcm = "",
##       gcm = "CSIRO-Mk3L-1-2",
##       gcm.run = 2,
##       institute = "CSIRO-QCCCE",
##       emission.scenario = "rcp45",
##       file.path.alt = list(
##         air_temperature =
##         list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3L-1-2/historical",
##              scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3L-1-2/rcp45"),
##         precipitation_amount =
##         list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3L-1-2/historical",
##              scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3L-1-2/rcp45")),
##       file.name = list(
##         air_temperature = list(
##           historical = c(
##             "tas_Amon_CSIRO-Mk3L-1-2_historical_r2i2p1_185101-200512.nc"
##             ),
##           scenario = c(
##             "tas_Amon_CSIRO-Mk3L-1-2_rcp45_r2i2p1_200601-230012.nc"
##             )),
##         precipitation_amount = list(
##           historical = c(
##             "pr_Amon_CSIRO-Mk3L-1-2_historical_r2i2p1_185101-200512.nc"
##             ),
##           scenario = c(
##             "pr_Amon_CSIRO-Mk3L-1-2_rcp45_r2i2p1_200601-230012.nc"
##            ))),
##       gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3L-1-2/historical",
##       gridfile.filename = "tas_Amon_CSIRO-Mk3L-1-2_historical_r2i2p1_185101-200512.nc",
##       resolution = "",
##       what.timesteps = "monthly"
##       ),

## ################################################################################
##     'CSIRO-Mk3L-1-2-r3i2p1_rcp45' = list( 
##       rcm = "",
##       gcm = "CSIRO-Mk3L-1-2",
##       gcm.run = 3,
##       institute = "CSIRO-QCCCE",
##       emission.scenario = "rcp45",
##       file.path.alt = list(
##         air_temperature =
##         list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3L-1-2/historical",
##              scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3L-1-2/rcp45"),
##         precipitation_amount =
##         list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3L-1-2/historical",
##              scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3L-1-2/rcp45")),
##       file.name = list(
##         air_temperature = list(
##           historical = c(
##             "tas_Amon_CSIRO-Mk3L-1-2_historical_r3i2p1_185101-200512.nc"
##             ),
##           scenario = c(
##             "tas_Amon_CSIRO-Mk3L-1-2_rcp45_r3i2p1_200601-230012.nc"
##             )),
##         precipitation_amount = list(
##           historical = c(
##             "pr_Amon_CSIRO-Mk3L-1-2_historical_r3i2p1_185101-200512.nc"
##             ),
##           scenario = c(
##             "pr_Amon_CSIRO-Mk3L-1-2_rcp45_r3i2p1_200601-230012.nc"
##            ))),
##       gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3L-1-2/historical",
##       gridfile.filename = "tas_Amon_CSIRO-Mk3L-1-2_historical_r3i2p1_185101-200512.nc",
##       resolution = "",
##       what.timesteps = "monthly"
##       ),
## acrnonyms: , 
##  ACCESS1-0-r1i1p1_rcp45, 
##  ACCESS1-3-r1i1p1_rcp45, 
##  BCC-CSM1-1-r1i1p1_rcp45, 
##  BCC-CSM1-1-m-r1i1p1_rcp45, 
##  BNU-ESM-r1i1p1_rcp45, 
##  CanCM4-r10i1p1_rcp45, 
##  CanCM4-r1i1p1_rcp45, 
##  CanCM4-r2i1p1_rcp45, 
##  CanCM4-r3i1p1_rcp45, 
##  CanCM4-r4i1p1_rcp45, 
##  CanCM4-r5i1p1_rcp45, 
##  CanCM4-r6i1p1_rcp45, 
##  CanCM4-r7i1p1_rcp45, 
##  CanCM4-r8i1p1_rcp45, 
##  CanCM4-r9i1p1_rcp45, 
##  CanESM2-r1i1p1_rcp45, 
##  CanESM2-r2i1p1_rcp45, 
##  CanESM2-r3i1p1_rcp45, 
##  CanESM2-r4i1p1_rcp45, 
##  CanESM2-r5i1p1_rcp45, 
##  CCSM4-r1i1p1_rcp45, 
##  CCSM4-r2i1p1_rcp45, 
##  CCSM4-r3i1p1_rcp45, 
##  CCSM4-r4i1p1_rcp45, 
##  CCSM4-r5i1p1_rcp45, 
##  CCSM4-r6i1p1_rcp45, 
##  CESM1-BGC-r1i1p1_rcp45, 
##  CESM1-CAM5-r1i1p1_rcp45, 
##  CESM1-CAM5-r2i1p1_rcp45, 
##  CESM1-CAM5-r3i1p1_rcp45, 
##  CESM1-WACCM-r2i1p1_rcp45, 
##  CESM1-WACCM-r3i1p1_rcp45, 
##  CESM1-WACCM-r4i1p1_rcp45, 
##  CMCC-CM-r1i1p1_rcp45, 
##  CMCC-CMS-r1i1p1_rcp45, 
##  CNRM-CM5-r1i1p1_rcp45, 
##  CSIRO-Mk3-6-0-r10i1p1_rcp45, 
##  CSIRO-Mk3-6-0-r1i1p1_rcp45, 
##  CSIRO-Mk3-6-0-r2i1p1_rcp45, 
##  CSIRO-Mk3-6-0-r3i1p1_rcp45, 
##  CSIRO-Mk3-6-0-r4i1p1_rcp45, 
##  CSIRO-Mk3-6-0-r5i1p1_rcp45, 
##  CSIRO-Mk3-6-0-r6i1p1_rcp45, 
##  CSIRO-Mk3-6-0-r7i1p1_rcp45, 
##  CSIRO-Mk3-6-0-r8i1p1_rcp45, 
##  CSIRO-Mk3-6-0-r9i1p1_rcp45, 
##  EC-EARTH-r12i1p1_rcp45, 
##  EC-EARTH-r13i1p1_rcp45, 
##  EC-EARTH-r14i1p1_rcp45, 
##  EC-EARTH-r1i1p1_rcp45, 
##  EC-EARTH-r2i1p1_rcp45, 
##  EC-EARTH-r6i1p1_rcp45, 
##  EC-EARTH-r7i1p1_rcp45, 
##  EC-EARTH-r8i1p1_rcp45, 
##  EC-EARTH-r9i1p1_rcp45, 
##  FGOALS-g2-r1i1p1_rcp45, 
##  FIO-ESM-r1i1p1_rcp45, 
##  FIO-ESM-r2i1p1_rcp45, 
##  FIO-ESM-r3i1p1_rcp45, 
##  GFDL-CM2-1-r10i1p1_rcp45, 
##  GFDL-CM2-1-r1i1p1_rcp45, 
##  GFDL-CM2-1-r2i1p1_rcp45, 
##  GFDL-CM2-1-r3i1p1_rcp45, 
##  GFDL-CM2-1-r4i1p1_rcp45, 
##  GFDL-CM2-1-r5i1p1_rcp45, 
##  GFDL-CM2-1-r6i1p1_rcp45, 
##  GFDL-CM2-1-r7i1p1_rcp45, 
##  GFDL-CM2-1-r8i1p1_rcp45, 
##  GFDL-CM2-1-r9i1p1_rcp45, 
##  GFDL-CM3-r1i1p1_rcp45, 
##  GFDL-ESM2G-r1i1p1_rcp45, 
##  GFDL-ESM2M-r1i1p1_rcp45, 
##  GISS-E2-H-r1i1p1_rcp45, 
##  GISS-E2-H-r1i1p2_rcp45, 
##  GISS-E2-H-r1i1p3_rcp45, 
##  GISS-E2-H-r2i1p1_rcp45, 
##  GISS-E2-H-r2i1p2_rcp45, 
##  GISS-E2-H-r2i1p3_rcp45, 
##  GISS-E2-H-r3i1p1_rcp45, 
##  GISS-E2-H-r3i1p2_rcp45, 
##  GISS-E2-H-r3i1p3_rcp45, 
##  GISS-E2-H-r4i1p1_rcp45, 
##  GISS-E2-H-r4i1p2_rcp45, 
##  GISS-E2-H-r4i1p3_rcp45, 
##  GISS-E2-H-r5i1p1_rcp45, 
##  GISS-E2-H-r5i1p2_rcp45, 
##  GISS-E2-H-r5i1p3_rcp45, 
##  GISS-E2-H-r6i1p3_rcp45, 
##  GISS-E2-H-CC-r1i1p1_rcp45, 
##  GISS-E2-R-r1i1p1_rcp45, 
##  GISS-E2-R-r1i1p2_rcp45, 
##  GISS-E2-R-r1i1p3_rcp45, 
##  GISS-E2-R-r2i1p1_rcp45, 
##  GISS-E2-R-r2i1p2_rcp45, 
##  GISS-E2-R-r2i1p3_rcp45, 
##  GISS-E2-R-r3i1p1_rcp45, 
##  GISS-E2-R-r3i1p2_rcp45, 
##  GISS-E2-R-r3i1p3_rcp45, 
##  GISS-E2-R-r4i1p1_rcp45, 
##  GISS-E2-R-r4i1p2_rcp45, 
##  GISS-E2-R-r4i1p3_rcp45, 
##  GISS-E2-R-r5i1p1_rcp45, 
##  GISS-E2-R-r5i1p2_rcp45, 
##  GISS-E2-R-r5i1p3_rcp45, 
##  GISS-E2-R-r6i1p1_rcp45, 
##  GISS-E2-R-r6i1p3_rcp45, 
##  GISS-E2-R-CC-r1i1p1_rcp45, 
##  HadCM3-r10i1p1_rcp45, 
##  HadCM3-r1i1p1_rcp45, 
##  HadCM3-r2i1p1_rcp45, 
##  HadCM3-r3i1p1_rcp45, 
##  HadCM3-r4i1p1_rcp45, 
##  HadCM3-r5i1p1_rcp45, 
##  HadCM3-r6i1p1_rcp45, 
##  HadCM3-r7i1p1_rcp45, 
##  HadCM3-r8i1p1_rcp45, 
##  HadCM3-r9i1p1_rcp45, 
##  HadGEM2-AO-r1i1p1_rcp45, 
##  HadGEM2-CC-r1i1p1_rcp45, 
##  HadGEM2-ES-r1i1p1_rcp45, 
##  HadGEM2-ES-r2i1p1_rcp45, 
##  HadGEM2-ES-r3i1p1_rcp45, 
##  HadGEM2-ES-r4i1p1_rcp45, 
##  INM-CM4-r1i1p1_rcp45, 
##  IPSL-CM5A-LR-r1i1p1_rcp45, 
##  IPSL-CM5A-LR-r2i1p1_rcp45, 
##  IPSL-CM5A-LR-r3i1p1_rcp45, 
##  IPSL-CM5A-LR-r4i1p1_rcp45, 
##  IPSL-CM5A-MR-r1i1p1_rcp45, 
##  IPSL-CM5B-LR-r1i1p1_rcp45, 
##  MIROC4h-r1i1p1_rcp45, 
##  MIROC4h-r2i1p1_rcp45, 
##  MIROC4h-r3i1p1_rcp45, 
##  MIROC5-r1i1p1_rcp45, 
##  MIROC5-r2i1p1_rcp45, 
##  MIROC5-r3i1p1_rcp45, 
##  MIROC5-r4i1p1_rcp45, 
##  MIROC5-r5i1p1_rcp45, 
##  MIROC-ESM-r1i1p1_rcp45, 
##  MIROC-ESM-CHEM-r1i1p1_rcp45, 
##  MPI-ESM-LR-r1i1p1_rcp45, 
##  MPI-ESM-LR-r2i1p1_rcp45, 
##  MPI-ESM-LR-r3i1p1_rcp45, 
##  MPI-ESM-MR-r1i1p1_rcp45, 
##  MPI-ESM-MR-r2i1p1_rcp45, 
##  MPI-ESM-MR-r3i1p1_rcp45, 
##  MRI-CGCM3-r1i1p1_rcp45, 
##  NorESM1-M-r1i1p1_rcp45, 
##  NorESM1-ME-r1i1p1_rcp45, 
##  CSIRO-Mk3L-1-2-r1i2p1_rcp45, 
##  CSIRO-Mk3L-1-2-r2i2p1_rcp45, 
##  CSIRO-Mk3L-1-2-r3i2p1_rcp45
### ----------------------------------------------------------------------
### ************************** SCENARIO: RCP85 ***************************
### ----------------------------------------------------------------------

################################################################################
    'ACCESS1-0-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "ACCESS1-0",
      gcm.run = 1,
      institute = "CSIRO-BOM",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/ACCESS1.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/ACCESS1.0/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/ACCESS1.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/ACCESS1.0/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_ACCESS1-0_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_ACCESS1-0_rcp85_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_ACCESS1-0_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_ACCESS1-0_rcp85_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/ACCESS1.0/historical",
      gridfile.filename = "tas_Amon_ACCESS1-0_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'ACCESS1-3-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "ACCESS1-3",
      gcm.run = 1,
      institute = "CSIRO-BOM",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/ACCESS1.3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/ACCESS1.3/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/ACCESS1.3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/ACCESS1.3/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_ACCESS1-3_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_ACCESS1-3_rcp85_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_ACCESS1-3_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_ACCESS1-3_rcp85_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/ACCESS1.3/historical",
      gridfile.filename = "tas_Amon_ACCESS1-3_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'BCC-CSM1-1-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "BCC-CSM1-1",
      gcm.run = 1,
      institute = "BCC",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_bcc-csm1-1_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_bcc-csm1-1_rcp85_r1i1p1_200601-209912.nc", 
            "tas_Amon_bcc-csm1-1_rcp85_r1i1p1_210001-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_bcc-csm1-1_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_bcc-csm1-1_rcp85_r1i1p1_200601-209912.nc", 
            "pr_Amon_bcc-csm1-1_rcp85_r1i1p1_210001-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1/historical",
      gridfile.filename = "tas_Amon_bcc-csm1-1_historical_r1i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'BCC-CSM1-1-m-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "BCC-CSM1-1-m",
      gcm.run = 1,
      institute = "BCC",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1(m)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1(m)/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1(m)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1(m)/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_bcc-csm1-1-m_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_bcc-csm1-1-m_rcp85_r1i1p1_200601-209912.nc", 
            "tas_Amon_bcc-csm1-1-m_rcp85_r1i1p1_210001-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_bcc-csm1-1-m_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_bcc-csm1-1-m_rcp85_r1i1p1_200601-209912.nc", 
            "pr_Amon_bcc-csm1-1-m_rcp85_r1i1p1_210001-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1(m)/historical",
      gridfile.filename = "tas_Amon_bcc-csm1-1-m_historical_r1i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'BNU-ESM-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "BNU-ESM",
      gcm.run = 1,
      institute = "GCESS",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BNU-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BNU-ESM/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BNU-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BNU-ESM/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_BNU-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_BNU-ESM_rcp85_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_BNU-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_BNU-ESM_rcp85_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BNU-ESM/historical",
      gridfile.filename = "tas_Amon_BNU-ESM_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanESM2-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CanESM2",
      gcm.run = 1,
      institute = "CCCma",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanESM2_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanESM2_rcp85_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanESM2_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanESM2_rcp85_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
      gridfile.filename = "tas_Amon_CanESM2_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanESM2-r2i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CanESM2",
      gcm.run = 2,
      institute = "CCCma",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanESM2_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanESM2_rcp85_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanESM2_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanESM2_rcp85_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
      gridfile.filename = "tas_Amon_CanESM2_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanESM2-r3i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CanESM2",
      gcm.run = 3,
      institute = "CCCma",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanESM2_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanESM2_rcp85_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanESM2_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanESM2_rcp85_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
      gridfile.filename = "tas_Amon_CanESM2_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanESM2-r4i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CanESM2",
      gcm.run = 4,
      institute = "CCCma",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanESM2_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanESM2_rcp85_r4i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanESM2_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanESM2_rcp85_r4i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
      gridfile.filename = "tas_Amon_CanESM2_historical_r4i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanESM2-r5i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CanESM2",
      gcm.run = 5,
      institute = "CCCma",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanESM2_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanESM2_rcp85_r5i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanESM2_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanESM2_rcp85_r5i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
      gridfile.filename = "tas_Amon_CanESM2_historical_r5i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 1,
      institute = "NCAR",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CCSM4_rcp85_r1i1p1_200601-210012.nc", 
            "tas_Amon_CCSM4_rcp85_r1i1p1_210101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp85_r1i1p1_200601-210012.nc", 
            "pr_Amon_CCSM4_rcp85_r1i1p1_210101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r2i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 2,
      institute = "NCAR",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_CCSM4_rcp85_r2i1p1_200501-210012.nc", 
            "tas_Amon_CCSM4_rcp85_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp85_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r3i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 3,
      institute = "NCAR",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_CCSM4_rcp85_r3i1p1_200501-210012.nc", 
            "tas_Amon_CCSM4_rcp85_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp85_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r4i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 4,
      institute = "NCAR",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_CCSM4_rcp85_r4i1p1_200501-210012.nc", 
            "tas_Amon_CCSM4_rcp85_r4i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp85_r4i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r4i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r5i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 5,
      institute = "NCAR",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_CCSM4_rcp85_r5i1p1_200501-210012.nc", 
            "tas_Amon_CCSM4_rcp85_r5i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp85_r5i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r5i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r6i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 6,
      institute = "NCAR",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r6i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CCSM4_rcp85_r6i1p1_200501-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r6i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp85_r6i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r6i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CESM1-BGC-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CESM1-BGC",
      gcm.run = 1,
      institute = "NSF-DOE-NCAR",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(BGC)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(BGC)/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(BGC)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(BGC)/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CESM1-BGC_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CESM1-BGC_rcp85_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CESM1-BGC_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CESM1-BGC_rcp85_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(BGC)/historical",
      gridfile.filename = "tas_Amon_CESM1-BGC_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CESM1-CAM5-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CESM1-CAM5",
      gcm.run = 1,
      institute = "NSF-DOE-NCAR",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CESM1-CAM5_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CESM1-CAM5_rcp85_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CESM1-CAM5_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CESM1-CAM5_rcp85_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
      gridfile.filename = "tas_Amon_CESM1-CAM5_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CESM1-CAM5-r2i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CESM1-CAM5",
      gcm.run = 2,
      institute = "NSF-DOE-NCAR",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CESM1-CAM5_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CESM1-CAM5_rcp85_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CESM1-CAM5_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CESM1-CAM5_rcp85_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
      gridfile.filename = "tas_Amon_CESM1-CAM5_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CESM1-CAM5-r3i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CESM1-CAM5",
      gcm.run = 3,
      institute = "NSF-DOE-NCAR",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CESM1-CAM5_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CESM1-CAM5_rcp85_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CESM1-CAM5_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CESM1-CAM5_rcp85_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
      gridfile.filename = "tas_Amon_CESM1-CAM5_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CESM1-WACCM-r2i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CESM1-WACCM",
      gcm.run = 2,
      institute = "NSF-DOE-NCAR",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CESM1-WACCM_historical_r2i1p1_195501-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CESM1-WACCM_rcp85_r2i1p1_200601-209912.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CESM1-WACCM_historical_r2i1p1_195501-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CESM1-WACCM_rcp85_r2i1p1_200601-209912.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/historical",
      gridfile.filename = "tas_Amon_CESM1-WACCM_historical_r2i1p1_195501-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CESM1-WACCM-r3i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CESM1-WACCM",
      gcm.run = 3,
      institute = "NSF-DOE-NCAR",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CESM1-WACCM_historical_r3i1p1_195501-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CESM1-WACCM_rcp85_r3i1p1_200601-205512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CESM1-WACCM_historical_r3i1p1_195501-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CESM1-WACCM_rcp85_r3i1p1_200601-205512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/historical",
      gridfile.filename = "tas_Amon_CESM1-WACCM_historical_r3i1p1_195501-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CESM1-WACCM-r4i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CESM1-WACCM",
      gcm.run = 4,
      institute = "NSF-DOE-NCAR",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CESM1-WACCM_historical_r4i1p1_195501-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CESM1-WACCM_rcp85_r4i1p1_200601-205012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CESM1-WACCM_historical_r4i1p1_195501-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CESM1-WACCM_rcp85_r4i1p1_200601-205012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(WACCM)/historical",
      gridfile.filename = "tas_Amon_CESM1-WACCM_historical_r4i1p1_195501-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CMCC-CESM-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CMCC-CESM",
      gcm.run = 1,
      institute = "CMCC",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CESM/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CESM/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CMCC-CESM_historical_r1i1p1_185001-185412.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_185501-185912.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_186001-186412.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_186501-186912.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_187001-187412.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_187501-187912.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_188001-188412.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_188501-188912.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_189001-189412.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_189501-189912.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_190001-190412.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_190501-190912.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_191001-191412.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_191501-191912.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_192001-192412.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_192501-192912.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_193001-193412.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_193501-193912.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_194001-194412.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_194501-194912.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_195001-195412.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_195501-195912.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_196001-196412.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_196501-196912.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_197001-197412.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_197501-197912.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_198001-198412.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_198501-198912.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_199001-199412.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_199501-199912.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_200001-200412.nc", 
            "tas_Amon_CMCC-CESM_historical_r1i1p1_200501-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_CMCC-CESM_rcp85_r1i1p1_200001-200412.nc", 
##            "tas_Amon_CMCC-CESM_rcp85_r1i1p1_200501-200512.nc", 
            "tas_Amon_CMCC-CESM_rcp85_r1i1p1_200601-201512.nc", 
            "tas_Amon_CMCC-CESM_rcp85_r1i1p1_201601-202512.nc", 
            "tas_Amon_CMCC-CESM_rcp85_r1i1p1_202601-203512.nc", 
            "tas_Amon_CMCC-CESM_rcp85_r1i1p1_203601-204512.nc", 
            "tas_Amon_CMCC-CESM_rcp85_r1i1p1_204601-205512.nc", 
            "tas_Amon_CMCC-CESM_rcp85_r1i1p1_205601-206512.nc", 
            "tas_Amon_CMCC-CESM_rcp85_r1i1p1_206601-207512.nc", 
            "tas_Amon_CMCC-CESM_rcp85_r1i1p1_207601-208512.nc", 
            "tas_Amon_CMCC-CESM_rcp85_r1i1p1_208601-209512.nc", 
            "tas_Amon_CMCC-CESM_rcp85_r1i1p1_209601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CMCC-CESM_historical_r1i1p1_185001-185412.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_185501-185912.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_186001-186412.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_186501-186912.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_187001-187412.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_187501-187912.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_188001-188412.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_188501-188912.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_189001-189412.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_189501-189912.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_190001-190412.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_190501-190912.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_191001-191412.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_191501-191912.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_192001-192412.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_192501-192912.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_193001-193412.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_193501-193912.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_194001-194412.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_194501-194912.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_195001-195412.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_195501-195912.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_196001-196412.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_196501-196912.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_197001-197412.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_197501-197912.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_198001-198412.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_198501-198912.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_199001-199412.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_199501-199912.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_200001-200412.nc", 
            "pr_Amon_CMCC-CESM_historical_r1i1p1_200501-200512.nc"
            ),
          scenario = c(
##            "pr_Amon_CMCC-CESM_rcp85_r1i1p1_200001-200412.nc", 
##            "pr_Amon_CMCC-CESM_rcp85_r1i1p1_200501-200512.nc", 
            "pr_Amon_CMCC-CESM_rcp85_r1i1p1_200601-201512.nc", 
            "pr_Amon_CMCC-CESM_rcp85_r1i1p1_201601-202512.nc", 
            "pr_Amon_CMCC-CESM_rcp85_r1i1p1_202601-203512.nc", 
            "pr_Amon_CMCC-CESM_rcp85_r1i1p1_203601-204512.nc", 
            "pr_Amon_CMCC-CESM_rcp85_r1i1p1_204601-205512.nc", 
            "pr_Amon_CMCC-CESM_rcp85_r1i1p1_205601-206512.nc", 
            "pr_Amon_CMCC-CESM_rcp85_r1i1p1_206601-207512.nc", 
            "pr_Amon_CMCC-CESM_rcp85_r1i1p1_207601-208512.nc", 
            "pr_Amon_CMCC-CESM_rcp85_r1i1p1_208601-209512.nc", 
            "pr_Amon_CMCC-CESM_rcp85_r1i1p1_209601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CESM/historical",
      gridfile.filename = "tas_Amon_CMCC-CESM_historical_r1i1p1_185001-185412.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CMCC-CM-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CMCC-CM",
      gcm.run = 1,
      institute = "CMCC",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CM/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CM/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CMCC-CM_historical_r1i1p1_185001-185912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_186001-186912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_187001-187912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_188001-188912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_189001-189912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_190001-190912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_191001-191912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_192001-192912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_193001-193912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_194001-194912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_195001-195912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_196001-196912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_197001-197912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_198001-198912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_199001-199912.nc", 
            "tas_Amon_CMCC-CM_historical_r1i1p1_200001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CMCC-CM_rcp85_r1i1p1_200601-201012.nc", 
            "tas_Amon_CMCC-CM_rcp85_r1i1p1_201101-202012.nc", 
            "tas_Amon_CMCC-CM_rcp85_r1i1p1_202101-203012.nc", 
            "tas_Amon_CMCC-CM_rcp85_r1i1p1_203101-204012.nc", 
            "tas_Amon_CMCC-CM_rcp85_r1i1p1_204101-205012.nc", 
            "tas_Amon_CMCC-CM_rcp85_r1i1p1_205101-206012.nc", 
            "tas_Amon_CMCC-CM_rcp85_r1i1p1_206101-207012.nc", 
            "tas_Amon_CMCC-CM_rcp85_r1i1p1_207101-208012.nc", 
            "tas_Amon_CMCC-CM_rcp85_r1i1p1_208101-209012.nc", 
            "tas_Amon_CMCC-CM_rcp85_r1i1p1_209101-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CMCC-CM_historical_r1i1p1_185001-185912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_186001-186912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_187001-187912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_188001-188912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_189001-189912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_190001-190912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_191001-191912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_192001-192912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_193001-193912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_194001-194912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_195001-195912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_196001-196912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_197001-197912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_198001-198912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_199001-199912.nc", 
            "pr_Amon_CMCC-CM_historical_r1i1p1_200001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CMCC-CM_rcp85_r1i1p1_200601-201012.nc", 
            "pr_Amon_CMCC-CM_rcp85_r1i1p1_201101-202012.nc", 
            "pr_Amon_CMCC-CM_rcp85_r1i1p1_202101-203012.nc", 
            "pr_Amon_CMCC-CM_rcp85_r1i1p1_203101-204012.nc", 
            "pr_Amon_CMCC-CM_rcp85_r1i1p1_204101-205012.nc", 
            "pr_Amon_CMCC-CM_rcp85_r1i1p1_205101-206012.nc", 
            "pr_Amon_CMCC-CM_rcp85_r1i1p1_206101-207012.nc", 
            "pr_Amon_CMCC-CM_rcp85_r1i1p1_207101-208012.nc", 
            "pr_Amon_CMCC-CM_rcp85_r1i1p1_208101-209012.nc", 
            "pr_Amon_CMCC-CM_rcp85_r1i1p1_209101-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CM/historical",
      gridfile.filename = "tas_Amon_CMCC-CM_historical_r1i1p1_185001-185912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CMCC-CMS-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CMCC-CMS",
      gcm.run = 1,
      institute = "CMCC",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CMS/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CMS/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CMS/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CMS/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CMCC-CMS_historical_r1i1p1_185001-185912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_186001-186912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_187001-187912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_188001-188912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_189001-189912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_190001-190912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_191001-191912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_192001-192912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_193001-193912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_194001-194912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_195001-195912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_196001-196912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_197001-197912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_198001-198912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_199001-199912.nc", 
            "tas_Amon_CMCC-CMS_historical_r1i1p1_200001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CMCC-CMS_rcp85_r1i1p1_200601-200912.nc", 
            "tas_Amon_CMCC-CMS_rcp85_r1i1p1_201001-201912.nc", 
            "tas_Amon_CMCC-CMS_rcp85_r1i1p1_202001-202912.nc", 
            "tas_Amon_CMCC-CMS_rcp85_r1i1p1_203001-203912.nc", 
            "tas_Amon_CMCC-CMS_rcp85_r1i1p1_204001-204912.nc", 
            "tas_Amon_CMCC-CMS_rcp85_r1i1p1_205001-205912.nc", 
            "tas_Amon_CMCC-CMS_rcp85_r1i1p1_206001-206912.nc", 
            "tas_Amon_CMCC-CMS_rcp85_r1i1p1_207001-207912.nc", 
            "tas_Amon_CMCC-CMS_rcp85_r1i1p1_208001-208912.nc", 
            "tas_Amon_CMCC-CMS_rcp85_r1i1p1_209001-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CMCC-CMS_historical_r1i1p1_185001-185912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_186001-186912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_187001-187912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_188001-188912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_189001-189912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_190001-190912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_191001-191912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_192001-192912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_193001-193912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_194001-194912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_195001-195912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_196001-196912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_197001-197912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_198001-198912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_199001-199912.nc", 
            "pr_Amon_CMCC-CMS_historical_r1i1p1_200001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CMCC-CMS_rcp85_r1i1p1_200601-200912.nc", 
            "pr_Amon_CMCC-CMS_rcp85_r1i1p1_201001-201912.nc", 
            "pr_Amon_CMCC-CMS_rcp85_r1i1p1_202001-202912.nc", 
            "pr_Amon_CMCC-CMS_rcp85_r1i1p1_203001-203912.nc", 
            "pr_Amon_CMCC-CMS_rcp85_r1i1p1_204001-204912.nc", 
            "pr_Amon_CMCC-CMS_rcp85_r1i1p1_205001-205912.nc", 
            "pr_Amon_CMCC-CMS_rcp85_r1i1p1_206001-206912.nc", 
            "pr_Amon_CMCC-CMS_rcp85_r1i1p1_207001-207912.nc", 
            "pr_Amon_CMCC-CMS_rcp85_r1i1p1_208001-208912.nc", 
            "pr_Amon_CMCC-CMS_rcp85_r1i1p1_209001-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CMCC-CMS/historical",
      gridfile.filename = "tas_Amon_CMCC-CMS_historical_r1i1p1_185001-185912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CNRM-CM5-r10i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CNRM-CM5",
      gcm.run = 10,
      institute = "CNRM-CERFACS",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CNRM-CM5_historical_r10i1p1_185001-189912.nc", 
            "tas_Amon_CNRM-CM5_historical_r10i1p1_190001-194912.nc", 
            "tas_Amon_CNRM-CM5_historical_r10i1p1_195001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CNRM-CM5_rcp85_r10i1p1_200601-205512.nc", 
            "tas_Amon_CNRM-CM5_rcp85_r10i1p1_205601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CNRM-CM5_historical_r10i1p1_185001-189912.nc", 
            "pr_Amon_CNRM-CM5_historical_r10i1p1_190001-194912.nc", 
            "pr_Amon_CNRM-CM5_historical_r10i1p1_195001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CNRM-CM5_rcp85_r10i1p1_200601-205512.nc", 
            "pr_Amon_CNRM-CM5_rcp85_r10i1p1_205601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/historical",
      gridfile.filename = "tas_Amon_CNRM-CM5_historical_r10i1p1_185001-189912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CNRM-CM5-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CNRM-CM5",
      gcm.run = 1,
      institute = "CNRM-CERFACS",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CNRM-CM5_historical_r1i1p1_185001-189912.nc", 
            "tas_Amon_CNRM-CM5_historical_r1i1p1_190001-194912.nc", 
            "tas_Amon_CNRM-CM5_historical_r1i1p1_195001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CNRM-CM5_rcp85_r1i1p1_200601-205512.nc", 
            "tas_Amon_CNRM-CM5_rcp85_r1i1p1_205601-210012.nc", 
            "tas_Amon_CNRM-CM5_rcp85_r1i1p1_210101-215012.nc", 
            "tas_Amon_CNRM-CM5_rcp85_r1i1p1_215101-220012.nc", 
            "tas_Amon_CNRM-CM5_rcp85_r1i1p1_220101-225012.nc", 
            "tas_Amon_CNRM-CM5_rcp85_r1i1p1_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CNRM-CM5_historical_r1i1p1_185001-189912.nc", 
            "pr_Amon_CNRM-CM5_historical_r1i1p1_190001-194912.nc", 
            "pr_Amon_CNRM-CM5_historical_r1i1p1_195001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CNRM-CM5_rcp85_r1i1p1_200601-205512.nc", 
            "pr_Amon_CNRM-CM5_rcp85_r1i1p1_205601-210012.nc", 
            "pr_Amon_CNRM-CM5_rcp85_r1i1p1_210101-215012.nc", 
            "pr_Amon_CNRM-CM5_rcp85_r1i1p1_215101-220012.nc", 
            "pr_Amon_CNRM-CM5_rcp85_r1i1p1_220101-225012.nc", 
            "pr_Amon_CNRM-CM5_rcp85_r1i1p1_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/historical",
      gridfile.filename = "tas_Amon_CNRM-CM5_historical_r1i1p1_185001-189912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CNRM-CM5-r2i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CNRM-CM5",
      gcm.run = 2,
      institute = "CNRM-CERFACS",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CNRM-CM5_historical_r2i1p1_185001-189912.nc", 
            "tas_Amon_CNRM-CM5_historical_r2i1p1_190001-194912.nc", 
            "tas_Amon_CNRM-CM5_historical_r2i1p1_195001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CNRM-CM5_rcp85_r2i1p1_200601-205512.nc", 
            "tas_Amon_CNRM-CM5_rcp85_r2i1p1_205601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CNRM-CM5_historical_r2i1p1_185001-189912.nc", 
            "pr_Amon_CNRM-CM5_historical_r2i1p1_190001-194912.nc", 
            "pr_Amon_CNRM-CM5_historical_r2i1p1_195001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CNRM-CM5_rcp85_r2i1p1_200601-205512.nc", 
            "pr_Amon_CNRM-CM5_rcp85_r2i1p1_205601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/historical",
      gridfile.filename = "tas_Amon_CNRM-CM5_historical_r2i1p1_185001-189912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CNRM-CM5-r4i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CNRM-CM5",
      gcm.run = 4,
      institute = "CNRM-CERFACS",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CNRM-CM5_historical_r4i1p1_185001-189912.nc", 
            "tas_Amon_CNRM-CM5_historical_r4i1p1_190001-194912.nc", 
            "tas_Amon_CNRM-CM5_historical_r4i1p1_195001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CNRM-CM5_rcp85_r4i1p1_200601-205512.nc", 
            "tas_Amon_CNRM-CM5_rcp85_r4i1p1_205601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CNRM-CM5_historical_r4i1p1_185001-189912.nc", 
            "pr_Amon_CNRM-CM5_historical_r4i1p1_190001-194912.nc", 
            "pr_Amon_CNRM-CM5_historical_r4i1p1_195001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CNRM-CM5_rcp85_r4i1p1_200601-205512.nc", 
            "pr_Amon_CNRM-CM5_rcp85_r4i1p1_205601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/historical",
      gridfile.filename = "tas_Amon_CNRM-CM5_historical_r4i1p1_185001-189912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CNRM-CM5-r6i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CNRM-CM5",
      gcm.run = 6,
      institute = "CNRM-CERFACS",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CNRM-CM5_historical_r6i1p1_185001-189912.nc", 
            "tas_Amon_CNRM-CM5_historical_r6i1p1_190001-194912.nc", 
            "tas_Amon_CNRM-CM5_historical_r6i1p1_195001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CNRM-CM5_rcp85_r6i1p1_200601-205512.nc", 
            "tas_Amon_CNRM-CM5_rcp85_r6i1p1_205601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CNRM-CM5_historical_r6i1p1_185001-189912.nc", 
            "pr_Amon_CNRM-CM5_historical_r6i1p1_190001-194912.nc", 
            "pr_Amon_CNRM-CM5_historical_r6i1p1_195001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CNRM-CM5_rcp85_r6i1p1_200601-205512.nc", 
            "pr_Amon_CNRM-CM5_rcp85_r6i1p1_205601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/historical",
      gridfile.filename = "tas_Amon_CNRM-CM5_historical_r6i1p1_185001-189912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r10i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 10,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r10i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp85_r10i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r10i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp85_r10i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r10i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 1,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp85_r1i1p1_200601-210012.nc", 
            "tas_Amon_CSIRO-Mk3-6-0_rcp85_r1i1p1_210101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp85_r1i1p1_200601-210012.nc", 
            "pr_Amon_CSIRO-Mk3-6-0_rcp85_r1i1p1_210101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r2i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 2,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp85_r2i1p1_200601-210012.nc", 
            "tas_Amon_CSIRO-Mk3-6-0_rcp85_r2i1p1_210101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp85_r2i1p1_200601-210012.nc", 
            "pr_Amon_CSIRO-Mk3-6-0_rcp85_r2i1p1_210101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r3i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 3,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp85_r3i1p1_200601-210012.nc", 
            "tas_Amon_CSIRO-Mk3-6-0_rcp85_r3i1p1_210101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp85_r3i1p1_200601-210012.nc", 
            "pr_Amon_CSIRO-Mk3-6-0_rcp85_r3i1p1_210101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r4i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 4,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp85_r4i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp85_r4i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r4i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r5i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 5,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp85_r5i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp85_r5i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r5i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r6i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 6,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r6i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp85_r6i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r6i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp85_r6i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r6i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r7i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 7,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r7i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp85_r7i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r7i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp85_r7i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r7i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r8i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 8,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r8i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp85_r8i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r8i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp85_r8i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r8i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r9i1p1_rcp85' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 9,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r9i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp85_r9i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r9i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp85_r9i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r9i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'EC-EARTH-r12i1p1_rcp85' = list( 
      rcm = "",
      gcm = "EC-EARTH",
      gcm.run = 12,
      institute = "EC-EARTH",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_EC-EARTH_historical_r12i1p1_185001-189912.nc", 
            "tas_Amon_EC-EARTH_historical_r12i1p1_190001-194912.nc", 
            "tas_Amon_EC-EARTH_historical_r12i1p1_195001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_EC-EARTH_rcp85_r12i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_EC-EARTH_historical_r12i1p1_185001-189912.nc", 
            "pr_Amon_EC-EARTH_historical_r12i1p1_190001-194912.nc", 
            "pr_Amon_EC-EARTH_historical_r12i1p1_195001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_EC-EARTH_rcp85_r12i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
      gridfile.filename = "tas_Amon_EC-EARTH_historical_r12i1p1_185001-189912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'EC-EARTH-r13i1p1_rcp85' = list( 
      rcm = "",
      gcm = "EC-EARTH",
      gcm.run = 13,
      institute = "EC-EARTH",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_EC-EARTH_historical_r13i1p1_195001-195912.nc", 
            "tas_Amon_EC-EARTH_historical_r13i1p1_196001-196912.nc", 
            "tas_Amon_EC-EARTH_historical_r13i1p1_197001-197912.nc", 
            "tas_Amon_EC-EARTH_historical_r13i1p1_198001-198912.nc", 
            "tas_Amon_EC-EARTH_historical_r13i1p1_199001-199912.nc", 
            "tas_Amon_EC-EARTH_historical_r13i1p1_200001-200911.nc"
            ),
          scenario = c(
            "tas_Amon_EC-EARTH_rcp85_r13i1p1_200601-200912.nc", 
            "tas_Amon_EC-EARTH_rcp85_r13i1p1_201001-201912.nc", 
            "tas_Amon_EC-EARTH_rcp85_r13i1p1_202001-202912.nc", 
            "tas_Amon_EC-EARTH_rcp85_r13i1p1_203001-203912.nc", 
            "tas_Amon_EC-EARTH_rcp85_r13i1p1_204001-204912.nc", 
            "tas_Amon_EC-EARTH_rcp85_r13i1p1_205001-205912.nc", 
            "tas_Amon_EC-EARTH_rcp85_r13i1p1_206001-206912.nc", 
            "tas_Amon_EC-EARTH_rcp85_r13i1p1_207001-207912.nc", 
            "tas_Amon_EC-EARTH_rcp85_r13i1p1_208001-208912.nc", 
            "tas_Amon_EC-EARTH_rcp85_r13i1p1_209001-209912.nc", 
            "tas_Amon_EC-EARTH_rcp85_r13i1p1_210001-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_EC-EARTH_historical_r13i1p1_195001-195912.nc", 
            "pr_Amon_EC-EARTH_historical_r13i1p1_196001-196912.nc", 
            "pr_Amon_EC-EARTH_historical_r13i1p1_197001-197912.nc", 
            "pr_Amon_EC-EARTH_historical_r13i1p1_198001-198912.nc", 
            "pr_Amon_EC-EARTH_historical_r13i1p1_199001-199912.nc", 
            "pr_Amon_EC-EARTH_historical_r13i1p1_200001-200911.nc"
            ),
          scenario = c(
            "pr_Amon_EC-EARTH_rcp85_r13i1p1_200601-200912.nc", 
            "pr_Amon_EC-EARTH_rcp85_r13i1p1_201001-201912.nc", 
            "pr_Amon_EC-EARTH_rcp85_r13i1p1_202001-202912.nc", 
            "pr_Amon_EC-EARTH_rcp85_r13i1p1_203001-203912.nc", 
            "pr_Amon_EC-EARTH_rcp85_r13i1p1_204001-204912.nc", 
            "pr_Amon_EC-EARTH_rcp85_r13i1p1_205001-205912.nc", 
            "pr_Amon_EC-EARTH_rcp85_r13i1p1_206001-206912.nc", 
            "pr_Amon_EC-EARTH_rcp85_r13i1p1_207001-207912.nc", 
            "pr_Amon_EC-EARTH_rcp85_r13i1p1_208001-208912.nc", 
            "pr_Amon_EC-EARTH_rcp85_r13i1p1_209001-209912.nc", 
            "pr_Amon_EC-EARTH_rcp85_r13i1p1_210001-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
      gridfile.filename = "tas_Amon_EC-EARTH_historical_r13i1p1_195001-195912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'EC-EARTH-r14i1p1_rcp85' = list( 
      rcm = "",
      gcm = "EC-EARTH",
      gcm.run = 14,
      institute = "EC-EARTH",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_EC-EARTH_historical_r14i1p1_195001-195912.nc", 
            "tas_Amon_EC-EARTH_historical_r14i1p1_196001-196912.nc", 
            "tas_Amon_EC-EARTH_historical_r14i1p1_197001-197912.nc", 
            "tas_Amon_EC-EARTH_historical_r14i1p1_198001-198912.nc", 
            "tas_Amon_EC-EARTH_historical_r14i1p1_199001-199912.nc", 
            "tas_Amon_EC-EARTH_historical_r14i1p1_200001-200911.nc"
            ),
          scenario = c(
            "tas_Amon_EC-EARTH_rcp85_r14i1p1_200601-200912.nc", 
            "tas_Amon_EC-EARTH_rcp85_r14i1p1_201001-201912.nc", 
            "tas_Amon_EC-EARTH_rcp85_r14i1p1_202001-202912.nc", 
            "tas_Amon_EC-EARTH_rcp85_r14i1p1_203001-203912.nc", 
            "tas_Amon_EC-EARTH_rcp85_r14i1p1_204001-204912.nc", 
            "tas_Amon_EC-EARTH_rcp85_r14i1p1_205001-205912.nc", 
            "tas_Amon_EC-EARTH_rcp85_r14i1p1_206001-206912.nc", 
            "tas_Amon_EC-EARTH_rcp85_r14i1p1_207001-207912.nc", 
            "tas_Amon_EC-EARTH_rcp85_r14i1p1_208001-208912.nc", 
            "tas_Amon_EC-EARTH_rcp85_r14i1p1_209001-209912.nc", 
            "tas_Amon_EC-EARTH_rcp85_r14i1p1_210001-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_EC-EARTH_historical_r14i1p1_195001-195912.nc", 
            "pr_Amon_EC-EARTH_historical_r14i1p1_196001-196912.nc", 
            "pr_Amon_EC-EARTH_historical_r14i1p1_197001-197912.nc", 
            "pr_Amon_EC-EARTH_historical_r14i1p1_198001-198912.nc", 
            "pr_Amon_EC-EARTH_historical_r14i1p1_199001-199912.nc", 
            "pr_Amon_EC-EARTH_historical_r14i1p1_200001-200911.nc"
            ),
          scenario = c(
            "pr_Amon_EC-EARTH_rcp85_r14i1p1_200601-200912.nc", 
            "pr_Amon_EC-EARTH_rcp85_r14i1p1_201001-201912.nc", 
            "pr_Amon_EC-EARTH_rcp85_r14i1p1_202001-202912.nc", 
            "pr_Amon_EC-EARTH_rcp85_r14i1p1_203001-203912.nc", 
            "pr_Amon_EC-EARTH_rcp85_r14i1p1_204001-204912.nc", 
            "pr_Amon_EC-EARTH_rcp85_r14i1p1_205001-205912.nc", 
            "pr_Amon_EC-EARTH_rcp85_r14i1p1_206001-206912.nc", 
            "pr_Amon_EC-EARTH_rcp85_r14i1p1_207001-207912.nc", 
            "pr_Amon_EC-EARTH_rcp85_r14i1p1_208001-208912.nc", 
            "pr_Amon_EC-EARTH_rcp85_r14i1p1_209001-209912.nc", 
            "pr_Amon_EC-EARTH_rcp85_r14i1p1_210001-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
      gridfile.filename = "tas_Amon_EC-EARTH_historical_r14i1p1_195001-195912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    ## 'EC-EARTH-r1i1p1_rcp85' = list( 
    ##   rcm = "",
    ##   gcm = "EC-EARTH",
    ##   gcm.run = 1,
    ##   institute = "EC-EARTH",
    ##   emission.scenario = "rcp85",
    ##   file.path.alt = list(
    ##     air_temperature =
    ##     list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
    ##          scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp85"),
    ##     precipitation_amount =
    ##     list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
    ##          scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp85")),
    ##   file.name = list(
    ##     air_temperature = list(
    ##       historical = c(
    ##         "tas_Amon_EC-EARTH_historical_r1i1p1_185001-185912.nc", 
    ##         "tas_Amon_EC-EARTH_historical_r1i1p1_186001-186912.nc", 
    ##         "tas_Amon_EC-EARTH_historical_r1i1p1_187001-187912.nc", 
    ##         "tas_Amon_EC-EARTH_historical_r1i1p1_188001-188912.nc", 
    ##         "tas_Amon_EC-EARTH_historical_r1i1p1_189001-189912.nc", 
    ##         "tas_Amon_EC-EARTH_historical_r1i1p1_190001-190912.nc", 
    ##         "tas_Amon_EC-EARTH_historical_r1i1p1_191001-191912.nc", 
    ##         "tas_Amon_EC-EARTH_historical_r1i1p1_192001-192912.nc", 
    ##         "tas_Amon_EC-EARTH_historical_r1i1p1_193001-193912.nc", 
    ##         "tas_Amon_EC-EARTH_historical_r1i1p1_194001-194912.nc", 
    ##         "tas_Amon_EC-EARTH_historical_r1i1p1_195001-195912.nc", 
    ##         "tas_Amon_EC-EARTH_historical_r1i1p1_196001-196912.nc", 
    ##         "tas_Amon_EC-EARTH_historical_r1i1p1_197001-197912.nc", 
    ##         "tas_Amon_EC-EARTH_historical_r1i1p1_198001-198912.nc", 
    ##         "tas_Amon_EC-EARTH_historical_r1i1p1_199001-199912.nc", 
    ##         "tas_Amon_EC-EARTH_historical_r1i1p1_200001-200911.nc"
    ##         ),
    ##       scenario = c(
    ##         "tas_Amon_EC-EARTH_rcp85_r1i1p1_200601-200912.nc", 
    ##         "tas_Amon_EC-EARTH_rcp85_r1i1p1_201001-201912.nc", 
    ##         "tas_Amon_EC-EARTH_rcp85_r1i1p1_202001-202912.nc", 
    ##         "tas_Amon_EC-EARTH_rcp85_r1i1p1_203001-203912.nc", 
    ##         "tas_Amon_EC-EARTH_rcp85_r1i1p1_204001-204912.nc", 
    ##         "tas_Amon_EC-EARTH_rcp85_r1i1p1_205001-205912.nc", 
    ##         "tas_Amon_EC-EARTH_rcp85_r1i1p1_206001-206912.nc", 
    ##         "tas_Amon_EC-EARTH_rcp85_r1i1p1_207001-207912.nc", 
    ##         "tas_Amon_EC-EARTH_rcp85_r1i1p1_208001-208912.nc", 
    ##         "tas_Amon_EC-EARTH_rcp85_r1i1p1_209001-209912.nc"
    ##         )),
    ##     precipitation_amount = list(
    ##       historical = c(
    ##         "pr_Amon_EC-EARTH_historical_r1i1p1_185001-185912.nc", 
    ##         "pr_Amon_EC-EARTH_historical_r1i1p1_186001-186912.nc", 
    ##         "pr_Amon_EC-EARTH_historical_r1i1p1_187001-187912.nc", 
    ##         "pr_Amon_EC-EARTH_historical_r1i1p1_188001-188912.nc", 
    ##         "pr_Amon_EC-EARTH_historical_r1i1p1_189001-189912.nc", 
    ##         "pr_Amon_EC-EARTH_historical_r1i1p1_190001-190912.nc", 
    ##         "pr_Amon_EC-EARTH_historical_r1i1p1_191001-191912.nc", 
    ##         "pr_Amon_EC-EARTH_historical_r1i1p1_192001-192912.nc", 
    ##         "pr_Amon_EC-EARTH_historical_r1i1p1_193001-193912.nc", 
    ##         "pr_Amon_EC-EARTH_historical_r1i1p1_194001-194912.nc", 
    ##         "pr_Amon_EC-EARTH_historical_r1i1p1_195001-195912.nc", 
    ##         "pr_Amon_EC-EARTH_historical_r1i1p1_196001-196912.nc", 
    ##         "pr_Amon_EC-EARTH_historical_r1i1p1_197001-197912.nc", 
    ##         "pr_Amon_EC-EARTH_historical_r1i1p1_198001-198912.nc", 
    ##         "pr_Amon_EC-EARTH_historical_r1i1p1_199001-199912.nc", 
    ##         "pr_Amon_EC-EARTH_historical_r1i1p1_200001-200912.nc"
    ##         ),
    ##       scenario = c(
    ##         "pr_Amon_EC-EARTH_rcp85_r1i1p1_200601-200912.nc", 
    ##         "pr_Amon_EC-EARTH_rcp85_r1i1p1_201001-201912.nc", 
    ##         "pr_Amon_EC-EARTH_rcp85_r1i1p1_202001-202912.nc", 
    ##         "pr_Amon_EC-EARTH_rcp85_r1i1p1_203001-203912.nc", 
    ##         "pr_Amon_EC-EARTH_rcp85_r1i1p1_204001-204912.nc", 
    ##         "pr_Amon_EC-EARTH_rcp85_r1i1p1_205001-205912.nc", 
    ##         "pr_Amon_EC-EARTH_rcp85_r1i1p1_206001-206912.nc", 
    ##         "pr_Amon_EC-EARTH_rcp85_r1i1p1_207001-207912.nc", 
    ##         "pr_Amon_EC-EARTH_rcp85_r1i1p1_208001-208912.nc", 
    ##         "pr_Amon_EC-EARTH_rcp85_r1i1p1_209001-209912.nc", 
    ##         "pr_Amon_EC-EARTH_rcp85_r1i1p1_210001-210012.nc"
    ##        ))),
    ##   gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
    ##   gridfile.filename = "tas_Amon_EC-EARTH_historical_r1i1p1_185001-185912.nc",
    ##   resolution = "",
    ##   what.timesteps = "monthly"
    ##   ),

################################################################################
    'EC-EARTH-r2i1p1_rcp85' = list( 
      rcm = "",
      gcm = "EC-EARTH",
      gcm.run = 2,
      institute = "EC-EARTH",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_EC-EARTH_historical_r2i1p1_185001-189912.nc", 
            "tas_Amon_EC-EARTH_historical_r2i1p1_190001-194912.nc", 
            "tas_Amon_EC-EARTH_historical_r2i1p1_195001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_EC-EARTH_rcp85_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_EC-EARTH_historical_r2i1p1_185001-189912.nc", 
            "pr_Amon_EC-EARTH_historical_r2i1p1_190001-194912.nc", 
            "pr_Amon_EC-EARTH_historical_r2i1p1_195001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_EC-EARTH_rcp85_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
      gridfile.filename = "tas_Amon_EC-EARTH_historical_r2i1p1_185001-189912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'EC-EARTH-r6i1p1_rcp85' = list( 
      rcm = "",
      gcm = "EC-EARTH",
      gcm.run = 6,
      institute = "EC-EARTH",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_EC-EARTH_historical_r6i1p1_185001-189912.nc", 
            "tas_Amon_EC-EARTH_historical_r6i1p1_190001-194912.nc", 
            "tas_Amon_EC-EARTH_historical_r6i1p1_195001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_EC-EARTH_rcp85_r6i1p1_200601-205012.nc", 
            "tas_Amon_EC-EARTH_rcp85_r6i1p1_205101-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_EC-EARTH_historical_r6i1p1_185001-189912.nc", 
            "pr_Amon_EC-EARTH_historical_r6i1p1_190001-194912.nc", 
            "pr_Amon_EC-EARTH_historical_r6i1p1_195001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_EC-EARTH_rcp85_r6i1p1_200601-205012.nc", 
            "pr_Amon_EC-EARTH_rcp85_r6i1p1_205101-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
      gridfile.filename = "tas_Amon_EC-EARTH_historical_r6i1p1_185001-189912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'EC-EARTH-r8i1p1_rcp85' = list( 
      rcm = "",
      gcm = "EC-EARTH",
      gcm.run = 8,
      institute = "EC-EARTH",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_EC-EARTH_historical_r8i1p1_185001-189912.nc", 
            "tas_Amon_EC-EARTH_historical_r8i1p1_190001-194912.nc", 
            "tas_Amon_EC-EARTH_historical_r8i1p1_195001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_EC-EARTH_rcp85_r8i1p1_200601-205012.nc", 
            "tas_Amon_EC-EARTH_rcp85_r8i1p1_205101-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_EC-EARTH_historical_r8i1p1_185001-189912.nc", 
            "pr_Amon_EC-EARTH_historical_r8i1p1_190001-194912.nc", 
            "pr_Amon_EC-EARTH_historical_r8i1p1_195001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_EC-EARTH_rcp85_r8i1p1_200601-205012.nc", 
            "pr_Amon_EC-EARTH_rcp85_r8i1p1_205101-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
      gridfile.filename = "tas_Amon_EC-EARTH_historical_r8i1p1_185001-189912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'EC-EARTH-r9i1p1_rcp85' = list( 
      rcm = "",
      gcm = "EC-EARTH",
      gcm.run = 9,
      institute = "EC-EARTH",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_EC-EARTH_historical_r9i1p1_185001-189912.nc", 
            "tas_Amon_EC-EARTH_historical_r9i1p1_190001-194912.nc", 
            "tas_Amon_EC-EARTH_historical_r9i1p1_195001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_EC-EARTH_rcp85_r9i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_EC-EARTH_historical_r9i1p1_185001-189912.nc", 
            "pr_Amon_EC-EARTH_historical_r9i1p1_190001-194912.nc", 
            "pr_Amon_EC-EARTH_historical_r9i1p1_195001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_EC-EARTH_rcp85_r9i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
      gridfile.filename = "tas_Amon_EC-EARTH_historical_r9i1p1_185001-189912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'FGOALS-g2-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "FGOALS-g2",
      gcm.run = 1,
      institute = "LASG-CESS",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-g2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-g2/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-g2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-g2/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_FGOALS-g2_historical_r1i1p1_185001-185912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_186001-186912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_187001-187912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_188001-188912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_189001-189912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_190001-190912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_191001-191912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_192001-192912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_193001-193912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_194001-194912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_195001-195912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_196001-196912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_197001-197912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_198001-198912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_199001-199912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_200001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_FGOALS-g2_rcp85_r1i1p1_200601-201512.nc", 
            "tas_Amon_FGOALS-g2_rcp85_r1i1p1_201601-202512.nc", 
            "tas_Amon_FGOALS-g2_rcp85_r1i1p1_202601-203512.nc", 
            "tas_Amon_FGOALS-g2_rcp85_r1i1p1_203601-204512.nc", 
            "tas_Amon_FGOALS-g2_rcp85_r1i1p1_204601-205512.nc", 
            "tas_Amon_FGOALS-g2_rcp85_r1i1p1_205601-206512.nc", 
            "tas_Amon_FGOALS-g2_rcp85_r1i1p1_206601-207512.nc", 
            "tas_Amon_FGOALS-g2_rcp85_r1i1p1_207601-208512.nc", 
            "tas_Amon_FGOALS-g2_rcp85_r1i1p1_208601-209512.nc", 
            "tas_Amon_FGOALS-g2_rcp85_r1i1p1_209601-210112.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_FGOALS-g2_historical_r1i1p1_185001-185912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_186001-186912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_187001-187912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_188001-188912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_189001-189912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_190001-190912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_191001-191912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_192001-192912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_193001-193912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_194001-194912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_195001-195912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_196001-196912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_197001-197912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_198001-198912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_199001-199912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_200001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_FGOALS-g2_rcp85_r1i1p1_200601-201512.nc", 
            "pr_Amon_FGOALS-g2_rcp85_r1i1p1_201601-202512.nc", 
            "pr_Amon_FGOALS-g2_rcp85_r1i1p1_202601-203512.nc", 
            "pr_Amon_FGOALS-g2_rcp85_r1i1p1_203601-204512.nc", 
            "pr_Amon_FGOALS-g2_rcp85_r1i1p1_204601-205512.nc", 
            "pr_Amon_FGOALS-g2_rcp85_r1i1p1_205601-206512.nc", 
            "pr_Amon_FGOALS-g2_rcp85_r1i1p1_206601-207512.nc", 
            "pr_Amon_FGOALS-g2_rcp85_r1i1p1_207601-208512.nc", 
            "pr_Amon_FGOALS-g2_rcp85_r1i1p1_208601-209512.nc", 
            "pr_Amon_FGOALS-g2_rcp85_r1i1p1_209601-210112.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-g2/historical",
      gridfile.filename = "tas_Amon_FGOALS-g2_historical_r1i1p1_185001-185912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'FIO-ESM-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "FIO-ESM",
      gcm.run = 1,
      institute = "FIO",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_FIO-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_FIO-ESM_rcp85_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_FIO-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_FIO-ESM_rcp85_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
      gridfile.filename = "tas_Amon_FIO-ESM_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'FIO-ESM-r2i1p1_rcp85' = list( 
      rcm = "",
      gcm = "FIO-ESM",
      gcm.run = 2,
      institute = "FIO",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_FIO-ESM_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_FIO-ESM_rcp85_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_FIO-ESM_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_FIO-ESM_rcp85_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
      gridfile.filename = "tas_Amon_FIO-ESM_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'FIO-ESM-r3i1p1_rcp85' = list( 
      rcm = "",
      gcm = "FIO-ESM",
      gcm.run = 3,
      institute = "FIO",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_FIO-ESM_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_FIO-ESM_rcp85_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_FIO-ESM_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_FIO-ESM_rcp85_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
      gridfile.filename = "tas_Amon_FIO-ESM_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-CM3-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "GFDL-CM3",
      gcm.run = 1,
      institute = "NOAA GFDL",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM3/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM3/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-CM3_historical_r1i1p1_186001-186412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_186501-186912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_187001-187412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_187501-187912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_188001-188412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_188501-188912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_189001-189412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_189501-189912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_190001-190412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_190501-190912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_191001-191412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_191501-191912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_192001-192412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_192501-192912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_193001-193412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_193501-193912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_194001-194412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_194501-194912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_195001-195412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_195501-195912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_196001-196412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_196501-196912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_197001-197412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_197501-197912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_198001-198412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_198501-198912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_199001-199412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_199501-199912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_200001-200412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_200501-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-CM3_rcp85_r1i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-CM3_rcp85_r1i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-CM3_rcp85_r1i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-CM3_rcp85_r1i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-CM3_rcp85_r1i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-CM3_rcp85_r1i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-CM3_rcp85_r1i1p1_203601-204012.nc", 
            "tas_Amon_GFDL-CM3_rcp85_r1i1p1_204101-204512.nc", 
            "tas_Amon_GFDL-CM3_rcp85_r1i1p1_204601-205012.nc", 
            "tas_Amon_GFDL-CM3_rcp85_r1i1p1_205101-205512.nc", 
            "tas_Amon_GFDL-CM3_rcp85_r1i1p1_205601-206012.nc", 
            "tas_Amon_GFDL-CM3_rcp85_r1i1p1_206101-206512.nc", 
            "tas_Amon_GFDL-CM3_rcp85_r1i1p1_206601-207012.nc", 
            "tas_Amon_GFDL-CM3_rcp85_r1i1p1_207101-207512.nc", 
            "tas_Amon_GFDL-CM3_rcp85_r1i1p1_207601-208012.nc", 
            "tas_Amon_GFDL-CM3_rcp85_r1i1p1_208101-208512.nc", 
            "tas_Amon_GFDL-CM3_rcp85_r1i1p1_208601-209012.nc", 
            "tas_Amon_GFDL-CM3_rcp85_r1i1p1_209101-209512.nc", 
            "tas_Amon_GFDL-CM3_rcp85_r1i1p1_209601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-CM3_historical_r1i1p1_186001-186412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_186501-186912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_187001-187412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_187501-187912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_188001-188412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_188501-188912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_189001-189412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_189501-189912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_190001-190412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_190501-190912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_191001-191412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_191501-191912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_192001-192412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_192501-192912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_193001-193412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_193501-193912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_194001-194412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_194501-194912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_195001-195412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_195501-195912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_196001-196412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_196501-196912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_197001-197412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_197501-197912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_198001-198412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_198501-198912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_199001-199412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_199501-199912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_200001-200412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_200501-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-CM3_rcp85_r1i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-CM3_rcp85_r1i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-CM3_rcp85_r1i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-CM3_rcp85_r1i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-CM3_rcp85_r1i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-CM3_rcp85_r1i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-CM3_rcp85_r1i1p1_203601-204012.nc", 
            "pr_Amon_GFDL-CM3_rcp85_r1i1p1_204101-204512.nc", 
            "pr_Amon_GFDL-CM3_rcp85_r1i1p1_204601-205012.nc", 
            "pr_Amon_GFDL-CM3_rcp85_r1i1p1_205101-205512.nc", 
            "pr_Amon_GFDL-CM3_rcp85_r1i1p1_205601-206012.nc", 
            "pr_Amon_GFDL-CM3_rcp85_r1i1p1_206101-206512.nc", 
            "pr_Amon_GFDL-CM3_rcp85_r1i1p1_206601-207012.nc", 
            "pr_Amon_GFDL-CM3_rcp85_r1i1p1_207101-207512.nc", 
            "pr_Amon_GFDL-CM3_rcp85_r1i1p1_207601-208012.nc", 
            "pr_Amon_GFDL-CM3_rcp85_r1i1p1_208101-208512.nc", 
            "pr_Amon_GFDL-CM3_rcp85_r1i1p1_208601-209012.nc", 
            "pr_Amon_GFDL-CM3_rcp85_r1i1p1_209101-209512.nc", 
            "pr_Amon_GFDL-CM3_rcp85_r1i1p1_209601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM3/historical",
      gridfile.filename = "tas_Amon_GFDL-CM3_historical_r1i1p1_186001-186412.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-ESM2G-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "GFDL-ESM2G",
      gcm.run = 1,
      institute = "NOAA GFDL",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2G/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2G/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2G/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2G/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_186101-186512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_186601-187012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_187101-187512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_187601-188012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_188101-188512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_188601-189012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_189101-189512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_189601-190012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_190101-190512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_190601-191012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_191101-191512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_191601-192012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_192101-192512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_192601-193012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_193101-193512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_193601-194012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_194101-194512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_194601-195012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_195101-195512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_195601-196012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_196101-196512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_196601-197012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_197101-197512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_197601-198012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_198101-198512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_198601-199012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_199101-199512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_199601-200012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-ESM2G_rcp85_r1i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp85_r1i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp85_r1i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp85_r1i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp85_r1i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp85_r1i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp85_r1i1p1_203601-204012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp85_r1i1p1_204101-204512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp85_r1i1p1_204601-205012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp85_r1i1p1_205101-205512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp85_r1i1p1_205601-206012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp85_r1i1p1_206101-206512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp85_r1i1p1_206601-207012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp85_r1i1p1_207101-207512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp85_r1i1p1_207601-208012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp85_r1i1p1_208101-208512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp85_r1i1p1_208601-209012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp85_r1i1p1_209101-209512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp85_r1i1p1_209601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_186101-186512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_186601-187012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_187101-187512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_187601-188012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_188101-188512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_188601-189012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_189101-189512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_189601-190012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_190101-190512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_190601-191012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_191101-191512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_191601-192012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_192101-192512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_192601-193012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_193101-193512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_193601-194012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_194101-194512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_194601-195012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_195101-195512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_195601-196012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_196101-196512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_196601-197012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_197101-197512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_197601-198012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_198101-198512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_198601-199012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_199101-199512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_199601-200012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-ESM2G_rcp85_r1i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp85_r1i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp85_r1i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp85_r1i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp85_r1i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp85_r1i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp85_r1i1p1_203601-204012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp85_r1i1p1_204101-204512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp85_r1i1p1_204601-205012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp85_r1i1p1_205101-205512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp85_r1i1p1_205601-206012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp85_r1i1p1_206101-206512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp85_r1i1p1_206601-207012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp85_r1i1p1_207101-207512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp85_r1i1p1_207601-208012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp85_r1i1p1_208101-208512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp85_r1i1p1_208601-209012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp85_r1i1p1_209101-209512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp85_r1i1p1_209601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2G/historical",
      gridfile.filename = "tas_Amon_GFDL-ESM2G_historical_r1i1p1_186101-186512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-ESM2M-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "GFDL-ESM2M",
      gcm.run = 1,
      institute = "NOAA GFDL",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2M/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2M/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2M/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2M/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_186101-186512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_186601-187012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_187101-187512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_187601-188012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_188101-188512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_188601-189012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_189101-189512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_189601-190012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_190101-190512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_190601-191012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_191101-191512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_191601-192012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_192101-192512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_192601-193012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_193101-193512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_193601-194012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_194101-194512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_194601-195012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_195101-195512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_195601-196012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_196101-196512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_196601-197012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_197101-197512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_197601-198012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_198101-198512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_198601-199012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_199101-199512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_199601-200012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_203601-204012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_204101-204512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_204601-205012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_205101-205512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_205601-206012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_206101-206512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_206601-207012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_207101-207512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_207601-208012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_208101-208512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_208601-209012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_209101-209512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_209601-210012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_210101-210512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_210601-211012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_211101-211512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_211601-212012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_212101-212512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_212601-213012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_213101-213512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_213601-214012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_214101-214512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_214601-215012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_215101-215512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_215601-216012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_216101-216512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_216601-217012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_217101-217512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_217601-218012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_218101-218512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_218601-219012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_219101-219512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp85_r1i1p1_219601-220012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_186101-186512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_186601-187012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_187101-187512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_187601-188012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_188101-188512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_188601-189012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_189101-189512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_189601-190012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_190101-190512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_190601-191012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_191101-191512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_191601-192012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_192101-192512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_192601-193012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_193101-193512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_193601-194012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_194101-194512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_194601-195012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_195101-195512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_195601-196012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_196101-196512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_196601-197012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_197101-197512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_197601-198012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_198101-198512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_198601-199012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_199101-199512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_199601-200012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-ESM2M_rcp85_r1i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp85_r1i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp85_r1i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp85_r1i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp85_r1i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp85_r1i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp85_r1i1p1_203601-204012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp85_r1i1p1_204101-204512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp85_r1i1p1_204601-205012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp85_r1i1p1_205101-205512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp85_r1i1p1_205601-206012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp85_r1i1p1_206101-206512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp85_r1i1p1_206601-207012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp85_r1i1p1_207101-207512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp85_r1i1p1_207601-208012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp85_r1i1p1_208101-208512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp85_r1i1p1_208601-209012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp85_r1i1p1_209101-209512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp85_r1i1p1_209601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2M/historical",
      gridfile.filename = "tas_Amon_GFDL-ESM2M_historical_r1i1p1_186101-186512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r1i1p1_185001-190012.nc", 
            "tas_Amon_GISS-E2-H_historical_r1i1p1_190101-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r1i1p1_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp85_r1i1p1_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp85_r1i1p1_205101-210012.nc", 
            "tas_Amon_GISS-E2-H_rcp85_r1i1p1_210101-215012.nc", 
            "tas_Amon_GISS-E2-H_rcp85_r1i1p1_215101-220012.nc", 
            "tas_Amon_GISS-E2-H_rcp85_r1i1p1_220101-225012.nc", 
            "tas_Amon_GISS-E2-H_rcp85_r1i1p1_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r1i1p1_185001-190012.nc", 
            "pr_Amon_GISS-E2-H_historical_r1i1p1_190101-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r1i1p1_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp85_r1i1p1_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp85_r1i1p1_205101-210012.nc", 
            "pr_Amon_GISS-E2-H_rcp85_r1i1p1_210101-215012.nc", 
            "pr_Amon_GISS-E2-H_rcp85_r1i1p1_215101-220012.nc", 
            "pr_Amon_GISS-E2-H_rcp85_r1i1p1_220101-225012.nc", 
            "pr_Amon_GISS-E2-H_rcp85_r1i1p1_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r1i1p1_185001-190012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r1i1p2_rcp85' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r1i1p2_185001-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r1i1p2_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp85_r1i1p2_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp85_r1i1p2_205101-210012.nc", 
            "tas_Amon_GISS-E2-H_rcp85_r1i1p2_210101-215012.nc", 
            "tas_Amon_GISS-E2-H_rcp85_r1i1p2_215101-220012.nc", 
            "tas_Amon_GISS-E2-H_rcp85_r1i1p2_220101-225012.nc", 
            "tas_Amon_GISS-E2-H_rcp85_r1i1p2_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r1i1p2_185001-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r1i1p2_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp85_r1i1p2_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp85_r1i1p2_205101-210012.nc", 
            "pr_Amon_GISS-E2-H_rcp85_r1i1p2_210101-215012.nc", 
            "pr_Amon_GISS-E2-H_rcp85_r1i1p2_215101-220012.nc", 
            "pr_Amon_GISS-E2-H_rcp85_r1i1p2_220101-225012.nc", 
            "pr_Amon_GISS-E2-H_rcp85_r1i1p2_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r1i1p2_185001-195012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r1i1p3_rcp85' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r1i1p3_185001-190012.nc", 
            "tas_Amon_GISS-E2-H_historical_r1i1p3_190101-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r1i1p3_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp85_r1i1p3_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp85_r1i1p3_205101-210012.nc", 
            "tas_Amon_GISS-E2-H_rcp85_r1i1p3_210101-215012.nc", 
            "tas_Amon_GISS-E2-H_rcp85_r1i1p3_215101-220012.nc", 
            "tas_Amon_GISS-E2-H_rcp85_r1i1p3_220101-225012.nc", 
            "tas_Amon_GISS-E2-H_rcp85_r1i1p3_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r1i1p3_185001-190012.nc", 
            "pr_Amon_GISS-E2-H_historical_r1i1p3_190101-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r1i1p3_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp85_r1i1p3_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp85_r1i1p3_205101-210012.nc", 
            "pr_Amon_GISS-E2-H_rcp85_r1i1p3_210101-215012.nc", 
            "pr_Amon_GISS-E2-H_rcp85_r1i1p3_215101-220012.nc", 
            "pr_Amon_GISS-E2-H_rcp85_r1i1p3_220101-225012.nc", 
            "pr_Amon_GISS-E2-H_rcp85_r1i1p3_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r1i1p3_185001-190012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r2i1p1_rcp85' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 2,
      institute = "NASA GISS",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r2i1p1_185001-190012.nc", 
            "tas_Amon_GISS-E2-H_historical_r2i1p1_190101-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r2i1p1_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp85_r2i1p1_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp85_r2i1p1_205101-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r2i1p1_185001-190012.nc", 
            "pr_Amon_GISS-E2-H_historical_r2i1p1_190101-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r2i1p1_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp85_r2i1p1_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp85_r2i1p1_205101-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r2i1p1_185001-190012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r2i1p3_rcp85' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 2,
      institute = "NASA GISS",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r2i1p3_185001-190012.nc", 
            "tas_Amon_GISS-E2-H_historical_r2i1p3_190101-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r2i1p3_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp85_r2i1p3_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp85_r2i1p3_205101-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r2i1p3_185001-190012.nc", 
            "pr_Amon_GISS-E2-H_historical_r2i1p3_190101-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r2i1p3_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp85_r2i1p3_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp85_r2i1p3_205101-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r2i1p3_185001-190012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-CC-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "GISS-E2-H-CC",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H-CC/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H-CC/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H-CC/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H-CC/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H-CC_historical_r1i1p1_185001-190012.nc", 
            "tas_Amon_GISS-E2-H-CC_historical_r1i1p1_190101-195012.nc", 
            "tas_Amon_GISS-E2-H-CC_historical_r1i1p1_195101-201012.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H-CC_rcp85_r1i1p1_200601-205012.nc", 
            "tas_Amon_GISS-E2-H-CC_rcp85_r1i1p1_205101-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H-CC_historical_r1i1p1_185001-190012.nc", 
            "pr_Amon_GISS-E2-H-CC_historical_r1i1p1_190101-195012.nc", 
            "pr_Amon_GISS-E2-H-CC_historical_r1i1p1_195101-201012.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H-CC_rcp85_r1i1p1_200601-205012.nc", 
            "pr_Amon_GISS-E2-H-CC_rcp85_r1i1p1_205101-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H-CC/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H-CC_historical_r1i1p1_185001-190012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r1i1p1_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp85_r1i1p1_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p1_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p1_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p1_207601-210012.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p1_210101-212512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p1_212601-215012.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p1_215101-217512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p1_217601-220012.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p1_220101-222512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p1_222601-225012.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p1_225101-227512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p1_227601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r1i1p1_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp85_r1i1p1_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p1_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p1_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p1_207601-210012.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p1_210101-212512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p1_212601-215012.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p1_215101-217512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p1_217601-220012.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p1_220101-222512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p1_222601-225012.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p1_225101-227512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p1_227601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r1i1p1_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r1i1p2_rcp85' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r1i1p2_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp85_r1i1p2_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p2_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p2_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p2_207601-210012.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p2_210101-212512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p2_212601-215012.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p2_215101-217512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p2_217601-220012.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p2_220101-222512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p2_222601-225012.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p2_225101-227512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p2_227601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r1i1p2_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp85_r1i1p2_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p2_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p2_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p2_207601-210012.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p2_210101-212512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p2_212601-215012.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p2_215101-217512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p2_217601-220012.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p2_220101-222512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p2_222601-225012.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p2_225101-227512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p2_227601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r1i1p2_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r1i1p3_rcp85' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r1i1p3_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp85_r1i1p3_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p3_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p3_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p3_207601-210012.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p3_210101-212512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p3_212601-215012.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p3_215101-217512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p3_217601-220012.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p3_220101-222512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p3_222601-225012.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p3_225101-227512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r1i1p3_227601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r1i1p3_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp85_r1i1p3_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p3_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p3_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p3_207601-210012.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p3_210101-212512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p3_212601-215012.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p3_215101-217512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p3_217601-220012.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p3_220101-222512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p3_222601-225012.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p3_225101-227512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r1i1p3_227601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r1i1p3_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r2i1p1_rcp85' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 2,
      institute = "NASA GISS",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r2i1p1_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p1_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p1_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p1_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p1_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p1_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p1_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp85_r2i1p1_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r2i1p1_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r2i1p1_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r2i1p1_207601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r2i1p1_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p1_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p1_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p1_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p1_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p1_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p1_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp85_r2i1p1_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r2i1p1_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r2i1p1_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r2i1p1_207601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r2i1p1_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r2i1p3_rcp85' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 2,
      institute = "NASA GISS",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r2i1p3_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p3_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p3_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p3_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p3_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p3_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r2i1p3_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp85_r2i1p3_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r2i1p3_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r2i1p3_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp85_r2i1p3_207601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r2i1p3_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p3_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p3_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p3_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p3_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p3_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r2i1p3_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp85_r2i1p3_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r2i1p3_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r2i1p3_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp85_r2i1p3_207601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r2i1p3_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-CC-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "GISS-E2-R-CC",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R-CC/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R-CC/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R-CC/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R-CC/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R-CC_historical_r1i1p1_185001-187512.nc", 
            "tas_Amon_GISS-E2-R-CC_historical_r1i1p1_187601-190012.nc", 
            "tas_Amon_GISS-E2-R-CC_historical_r1i1p1_190101-192512.nc", 
            "tas_Amon_GISS-E2-R-CC_historical_r1i1p1_192601-195012.nc", 
            "tas_Amon_GISS-E2-R-CC_historical_r1i1p1_195101-197512.nc", 
            "tas_Amon_GISS-E2-R-CC_historical_r1i1p1_197601-200012.nc", 
            "tas_Amon_GISS-E2-R-CC_historical_r1i1p1_200101-201012.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R-CC_rcp85_r1i1p1_200601-202512.nc", 
            "tas_Amon_GISS-E2-R-CC_rcp85_r1i1p1_202601-205012.nc", 
            "tas_Amon_GISS-E2-R-CC_rcp85_r1i1p1_205101-207512.nc", 
            "tas_Amon_GISS-E2-R-CC_rcp85_r1i1p1_207601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R-CC_historical_r1i1p1_185001-187512.nc", 
            "pr_Amon_GISS-E2-R-CC_historical_r1i1p1_187601-190012.nc", 
            "pr_Amon_GISS-E2-R-CC_historical_r1i1p1_190101-192512.nc", 
            "pr_Amon_GISS-E2-R-CC_historical_r1i1p1_192601-195012.nc", 
            "pr_Amon_GISS-E2-R-CC_historical_r1i1p1_195101-197512.nc", 
            "pr_Amon_GISS-E2-R-CC_historical_r1i1p1_197601-200012.nc", 
            "pr_Amon_GISS-E2-R-CC_historical_r1i1p1_200101-201012.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R-CC_rcp85_r1i1p1_200601-202512.nc", 
            "pr_Amon_GISS-E2-R-CC_rcp85_r1i1p1_202601-205012.nc", 
            "pr_Amon_GISS-E2-R-CC_rcp85_r1i1p1_205101-207512.nc", 
            "pr_Amon_GISS-E2-R-CC_rcp85_r1i1p1_207601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R-CC/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R-CC_historical_r1i1p1_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-AO-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "HadGEM2-AO",
      gcm.run = 1,
      institute = "NIMR/KMA",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-AO/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-AO/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-AO/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-AO/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-AO_historical_r1i1p1_186001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_HadGEM2-AO_rcp85_r1i1p1_200601-209912.nc", 
            "tas_Amon_HadGEM2-AO_rcp85_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-AO_historical_r1i1p1_186001-200512.nc"
            ),
          scenario = c(
##            "pr_Amon_HadGEM2-AO_rcp85_r1i1p1_200601-209912.nc", 
            "pr_Amon_HadGEM2-AO_rcp85_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-AO/historical",
      gridfile.filename = "tas_Amon_HadGEM2-AO_historical_r1i1p1_186001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-CC-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "HadGEM2-CC",
      gcm.run = 1,
      institute = "MOHC",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-CC/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-CC/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-CC/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-CC/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-CC_historical_r1i1p1_185912-188411.nc", 
            "tas_Amon_HadGEM2-CC_historical_r1i1p1_188412-190911.nc", 
            "tas_Amon_HadGEM2-CC_historical_r1i1p1_190912-193411.nc", 
            "tas_Amon_HadGEM2-CC_historical_r1i1p1_193412-195911.nc", 
            "tas_Amon_HadGEM2-CC_historical_r1i1p1_195912-198411.nc", 
            "tas_Amon_HadGEM2-CC_historical_r1i1p1_198412-200511.nc"
            ),
          scenario = c(
            "tas_Amon_HadGEM2-CC_rcp85_r1i1p1_200512-203011.nc", 
            "tas_Amon_HadGEM2-CC_rcp85_r1i1p1_203012-205511.nc", 
            "tas_Amon_HadGEM2-CC_rcp85_r1i1p1_205512-208011.nc", 
            "tas_Amon_HadGEM2-CC_rcp85_r1i1p1_208012-209912.nc", 
            "tas_Amon_HadGEM2-CC_rcp85_r1i1p1_210001-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-CC_historical_r1i1p1_185912-188411.nc", 
            "pr_Amon_HadGEM2-CC_historical_r1i1p1_188412-190911.nc", 
            "pr_Amon_HadGEM2-CC_historical_r1i1p1_190912-193411.nc", 
            "pr_Amon_HadGEM2-CC_historical_r1i1p1_193412-195911.nc", 
            "pr_Amon_HadGEM2-CC_historical_r1i1p1_195912-198411.nc", 
            "pr_Amon_HadGEM2-CC_historical_r1i1p1_198412-200511.nc"
            ),
          scenario = c(
            "pr_Amon_HadGEM2-CC_rcp85_r1i1p1_200512-203011.nc", 
            "pr_Amon_HadGEM2-CC_rcp85_r1i1p1_203012-205511.nc", 
            "pr_Amon_HadGEM2-CC_rcp85_r1i1p1_205512-208011.nc", 
            "pr_Amon_HadGEM2-CC_rcp85_r1i1p1_208012-209912.nc", 
            "pr_Amon_HadGEM2-CC_rcp85_r1i1p1_210001-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-CC/historical",
      gridfile.filename = "tas_Amon_HadGEM2-CC_historical_r1i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-CC-r2i1p1_rcp85' = list( 
      rcm = "",
      gcm = "HadGEM2-CC",
      gcm.run = 2,
      institute = "MOHC",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-CC/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-CC/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-CC/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-CC/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-CC_historical_r2i1p1_195912-198411.nc", 
            "tas_Amon_HadGEM2-CC_historical_r2i1p1_198412-200512.nc"
            ),
          scenario = c(
            "tas_Amon_HadGEM2-CC_rcp85_r2i1p1_200512-203011.nc", 
            "tas_Amon_HadGEM2-CC_rcp85_r2i1p1_203012-205511.nc", 
            "tas_Amon_HadGEM2-CC_rcp85_r2i1p1_205512-208011.nc", 
            "tas_Amon_HadGEM2-CC_rcp85_r2i1p1_208012-209912.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-CC_historical_r2i1p1_195912-198411.nc", 
            "pr_Amon_HadGEM2-CC_historical_r2i1p1_198412-200512.nc"
            ),
          scenario = c(
            "pr_Amon_HadGEM2-CC_rcp85_r2i1p1_200512-203011.nc", 
            "pr_Amon_HadGEM2-CC_rcp85_r2i1p1_203012-205511.nc", 
            "pr_Amon_HadGEM2-CC_rcp85_r2i1p1_205512-208011.nc", 
            "pr_Amon_HadGEM2-CC_rcp85_r2i1p1_208012-209912.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-CC/historical",
      gridfile.filename = "tas_Amon_HadGEM2-CC_historical_r2i1p1_195912-198411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-CC-r3i1p1_rcp85' = list( 
      rcm = "",
      gcm = "HadGEM2-CC",
      gcm.run = 3,
      institute = "MOHC",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-CC/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-CC/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-CC/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-CC/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-CC_historical_r3i1p1_195912-198411.nc", 
            "tas_Amon_HadGEM2-CC_historical_r3i1p1_198412-200512.nc"
            ),
          scenario = c(
            "tas_Amon_HadGEM2-CC_rcp85_r3i1p1_200512-203011.nc", 
            "tas_Amon_HadGEM2-CC_rcp85_r3i1p1_203012-205511.nc", 
            "tas_Amon_HadGEM2-CC_rcp85_r3i1p1_205512-208011.nc", 
            "tas_Amon_HadGEM2-CC_rcp85_r3i1p1_208012-209912.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-CC_historical_r3i1p1_195912-198411.nc", 
            "pr_Amon_HadGEM2-CC_historical_r3i1p1_198412-200512.nc"
            ),
          scenario = c(
            "pr_Amon_HadGEM2-CC_rcp85_r3i1p1_200512-203011.nc", 
            "pr_Amon_HadGEM2-CC_rcp85_r3i1p1_203012-205511.nc", 
            "pr_Amon_HadGEM2-CC_rcp85_r3i1p1_205512-208011.nc", 
            "pr_Amon_HadGEM2-CC_rcp85_r3i1p1_208012-209912.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-CC/historical",
      gridfile.filename = "tas_Amon_HadGEM2-CC_historical_r3i1p1_195912-198411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-ES-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "HadGEM2-ES",
      gcm.run = 1,
      institute = "MOHC",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_185912-188411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_188412-190911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_190912-193411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_193412-195911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_195912-198411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_198412-200511.nc"
            ),
          scenario = c(
            "tas_Amon_HadGEM2-ES_rcp85_r1i1p1_200512-203011.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r1i1p1_203012-205511.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r1i1p1_205512-208011.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r1i1p1_208012-209911.nc", 
            ## "tas_Amon_HadGEM2-ES_rcp85_r1i1p1_208012-209912.nc", file too much...
            "tas_Amon_HadGEM2-ES_rcp85_r1i1p1_209912-212411.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r1i1p1_212412-214911.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r1i1p1_214912-217411.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r1i1p1_217412-219911.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r1i1p1_219912-222411.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r1i1p1_222412-224911.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r1i1p1_224912-227411.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r1i1p1_227412-229911.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r1i1p1_229912-229912.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_185912-188411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_188412-190911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_190912-193411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_193412-195911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_195912-198411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_198412-200511.nc"
            ),
          scenario = c(
            "pr_Amon_HadGEM2-ES_rcp85_r1i1p1_200512-203011.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r1i1p1_203012-205511.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r1i1p1_205512-208011.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r1i1p1_208012-209911.nc", 
            ## "pr_Amon_HadGEM2-ES_rcp85_r1i1p1_208012-209912.nc", file too much...
            "pr_Amon_HadGEM2-ES_rcp85_r1i1p1_209912-212411.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r1i1p1_212412-214911.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r1i1p1_214912-217411.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r1i1p1_217412-219911.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r1i1p1_219912-222411.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r1i1p1_222412-224911.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r1i1p1_224912-227411.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r1i1p1_227412-229911.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r1i1p1_229912-229912.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
      gridfile.filename = "tas_Amon_HadGEM2-ES_historical_r1i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-ES-r2i1p1_rcp85' = list( 
      rcm = "",
      gcm = "HadGEM2-ES",
      gcm.run = 2,
      institute = "MOHC",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_185912-188411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_188412-190911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_190912-193411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_193412-195911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_195912-198411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_198412-200512.nc"
            ),
          scenario = c(
            "tas_Amon_HadGEM2-ES_rcp85_r2i1p1_200512-203011.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r2i1p1_203012-205511.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r2i1p1_205512-208011.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r2i1p1_208012-210011.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r2i1p1_210012-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_185912-188411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_188412-190911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_190912-193411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_193412-195911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_195912-198411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_198412-200512.nc"
            ),
          scenario = c(
            "pr_Amon_HadGEM2-ES_rcp85_r2i1p1_200512-203011.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r2i1p1_203012-205511.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r2i1p1_205512-208011.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r2i1p1_208012-210011.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r2i1p1_210012-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
      gridfile.filename = "tas_Amon_HadGEM2-ES_historical_r2i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-ES-r3i1p1_rcp85' = list( 
      rcm = "",
      gcm = "HadGEM2-ES",
      gcm.run = 3,
      institute = "MOHC",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_185912-188411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_188412-190911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_190912-193411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_193412-195911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_195912-198411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_198412-200512.nc"
            ),
          scenario = c(
            "tas_Amon_HadGEM2-ES_rcp85_r3i1p1_200512-203011.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r3i1p1_203012-205511.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r3i1p1_205512-208011.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r3i1p1_208012-210011.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r3i1p1_210012-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_185912-188411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_188412-190911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_190912-193411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_193412-195911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_195912-198411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_198412-200512.nc"
            ),
          scenario = c(
            "pr_Amon_HadGEM2-ES_rcp85_r3i1p1_200512-203011.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r3i1p1_203012-205511.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r3i1p1_205512-208011.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r3i1p1_208012-210011.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r3i1p1_210012-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
      gridfile.filename = "tas_Amon_HadGEM2-ES_historical_r3i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-ES-r4i1p1_rcp85' = list( 
      rcm = "",
      gcm = "HadGEM2-ES",
      gcm.run = 4,
      institute = "MOHC",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_185912-188411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_188412-190911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_190912-193411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_193412-195911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_195912-198411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_198412-200511.nc"
            ),
          scenario = c(
            "tas_Amon_HadGEM2-ES_rcp85_r4i1p1_200512-203011.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r4i1p1_203012-205511.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r4i1p1_205512-208011.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r4i1p1_208012-210011.nc", 
            "tas_Amon_HadGEM2-ES_rcp85_r4i1p1_210012-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_185912-188411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_188412-190911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_190912-193411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_193412-195911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_195912-198411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_198412-200511.nc"
            ),
          scenario = c(
            "pr_Amon_HadGEM2-ES_rcp85_r4i1p1_200512-203011.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r4i1p1_203012-205511.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r4i1p1_205512-208011.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r4i1p1_208012-210011.nc", 
            "pr_Amon_HadGEM2-ES_rcp85_r4i1p1_210012-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
      gridfile.filename = "tas_Amon_HadGEM2-ES_historical_r4i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'INM-CM4-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "INM-CM4",
      gcm.run = 1,
      institute = "INM",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/INM-CM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/INM-CM4/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/INM-CM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/INM-CM4/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_inmcm4_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_inmcm4_rcp85_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_inmcm4_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_inmcm4_rcp85_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/INM-CM4/historical",
      gridfile.filename = "tas_Amon_inmcm4_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'IPSL-CM5A-LR-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "IPSL-CM5A-LR",
      gcm.run = 1,
      institute = "IPSL",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_IPSL-CM5A-LR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_IPSL-CM5A-LR_rcp85_r1i1p1_200601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_IPSL-CM5A-LR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_IPSL-CM5A-LR_rcp85_r1i1p1_200601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
      gridfile.filename = "tas_Amon_IPSL-CM5A-LR_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'IPSL-CM5A-LR-r2i1p1_rcp85' = list( 
      rcm = "",
      gcm = "IPSL-CM5A-LR",
      gcm.run = 2,
      institute = "IPSL",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_IPSL-CM5A-LR_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_IPSL-CM5A-LR_rcp85_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_IPSL-CM5A-LR_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_IPSL-CM5A-LR_rcp85_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
      gridfile.filename = "tas_Amon_IPSL-CM5A-LR_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'IPSL-CM5A-LR-r3i1p1_rcp85' = list( 
      rcm = "",
      gcm = "IPSL-CM5A-LR",
      gcm.run = 3,
      institute = "IPSL",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_IPSL-CM5A-LR_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_IPSL-CM5A-LR_rcp85_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_IPSL-CM5A-LR_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_IPSL-CM5A-LR_rcp85_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
      gridfile.filename = "tas_Amon_IPSL-CM5A-LR_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'IPSL-CM5A-LR-r4i1p1_rcp85' = list( 
      rcm = "",
      gcm = "IPSL-CM5A-LR",
      gcm.run = 4,
      institute = "IPSL",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_IPSL-CM5A-LR_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_IPSL-CM5A-LR_rcp85_r4i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_IPSL-CM5A-LR_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_IPSL-CM5A-LR_rcp85_r4i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
      gridfile.filename = "tas_Amon_IPSL-CM5A-LR_historical_r4i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'IPSL-CM5A-MR-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "IPSL-CM5A-MR",
      gcm.run = 1,
      institute = "IPSL",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-MR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-MR/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-MR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-MR/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_IPSL-CM5A-MR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_IPSL-CM5A-MR_rcp85_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_IPSL-CM5A-MR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_IPSL-CM5A-MR_rcp85_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-MR/historical",
      gridfile.filename = "tas_Amon_IPSL-CM5A-MR_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'IPSL-CM5B-LR-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "IPSL-CM5B-LR",
      gcm.run = 1,
      institute = "IPSL",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5B-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5B-LR/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5B-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5B-LR/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_IPSL-CM5B-LR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_IPSL-CM5B-LR_rcp85_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_IPSL-CM5B-LR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_IPSL-CM5B-LR_rcp85_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5B-LR/historical",
      gridfile.filename = "tas_Amon_IPSL-CM5B-LR_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC5-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "MIROC5",
      gcm.run = 1,
      institute = "MIROC",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC5_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC5_rcp85_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC5_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC5_rcp85_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
      gridfile.filename = "tas_Amon_MIROC5_historical_r1i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC5-r2i1p1_rcp85' = list( 
      rcm = "",
      gcm = "MIROC5",
      gcm.run = 2,
      institute = "MIROC",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC5_historical_r2i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC5_rcp85_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC5_historical_r2i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC5_rcp85_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
      gridfile.filename = "tas_Amon_MIROC5_historical_r2i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC5-r3i1p1_rcp85' = list( 
      rcm = "",
      gcm = "MIROC5",
      gcm.run = 3,
      institute = "MIROC",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC5_historical_r3i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC5_rcp85_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC5_historical_r3i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC5_rcp85_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
      gridfile.filename = "tas_Amon_MIROC5_historical_r3i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC5-r4i1p1_rcp85' = list( 
      rcm = "",
      gcm = "MIROC5",
      gcm.run = 4,
      institute = "MIROC",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC5_historical_r4i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC5_rcp85_r4i1p1_200601-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC5_historical_r4i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC5_rcp85_r4i1p1_200601-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
      gridfile.filename = "tas_Amon_MIROC5_historical_r4i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC5-r5i1p1_rcp85' = list( 
      rcm = "",
      gcm = "MIROC5",
      gcm.run = 5,
      institute = "MIROC",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC5_historical_r5i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC5_rcp85_r5i1p1_200601-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC5_historical_r5i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC5_rcp85_r5i1p1_200601-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
      gridfile.filename = "tas_Amon_MIROC5_historical_r5i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC-ESM-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "MIROC-ESM",
      gcm.run = 1,
      institute = "MIROC",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC-ESM_rcp85_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC-ESM_rcp85_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM/historical",
      gridfile.filename = "tas_Amon_MIROC-ESM_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC-ESM-CHEM-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "MIROC-ESM-CHEM",
      gcm.run = 1,
      institute = "MIROC",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM-CHEM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM-CHEM/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM-CHEM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM-CHEM/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC-ESM-CHEM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC-ESM-CHEM_rcp85_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC-ESM-CHEM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC-ESM-CHEM_rcp85_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM-CHEM/historical",
      gridfile.filename = "tas_Amon_MIROC-ESM-CHEM_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MPI-ESM-LR-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "MPI-ESM-LR",
      gcm.run = 1,
      institute = "MPI-M",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MPI-ESM-LR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MPI-ESM-LR_rcp85_r1i1p1_200601-210012.nc", 
            "tas_Amon_MPI-ESM-LR_rcp85_r1i1p1_210101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MPI-ESM-LR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MPI-ESM-LR_rcp85_r1i1p1_200601-210012.nc", 
            "pr_Amon_MPI-ESM-LR_rcp85_r1i1p1_210101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
      gridfile.filename = "tas_Amon_MPI-ESM-LR_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MPI-ESM-LR-r2i1p1_rcp85' = list( 
      rcm = "",
      gcm = "MPI-ESM-LR",
      gcm.run = 2,
      institute = "MPI-M",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MPI-ESM-LR_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MPI-ESM-LR_rcp85_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MPI-ESM-LR_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MPI-ESM-LR_rcp85_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
      gridfile.filename = "tas_Amon_MPI-ESM-LR_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MPI-ESM-LR-r3i1p1_rcp85' = list( 
      rcm = "",
      gcm = "MPI-ESM-LR",
      gcm.run = 3,
      institute = "MPI-M",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MPI-ESM-LR_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MPI-ESM-LR_rcp85_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MPI-ESM-LR_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MPI-ESM-LR_rcp85_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
      gridfile.filename = "tas_Amon_MPI-ESM-LR_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MPI-ESM-MR-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "MPI-ESM-MR",
      gcm.run = 1,
      institute = "MPI-M",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MPI-ESM-MR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MPI-ESM-MR_rcp85_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MPI-ESM-MR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MPI-ESM-MR_rcp85_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/historical",
      gridfile.filename = "tas_Amon_MPI-ESM-MR_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MRI-CGCM3-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "MRI-CGCM3",
      gcm.run = 1,
      institute = "MRI",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-CGCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-CGCM3/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-CGCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-CGCM3/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MRI-CGCM3_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MRI-CGCM3_rcp85_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MRI-CGCM3_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MRI-CGCM3_rcp85_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-CGCM3/historical",
      gridfile.filename = "tas_Amon_MRI-CGCM3_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'NorESM1-M-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "NorESM1-M",
      gcm.run = 1,
      institute = "NCC",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-M/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-M/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-M/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-M/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_NorESM1-M_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_NorESM1-M_rcp85_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_NorESM1-M_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_NorESM1-M_rcp85_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-M/historical",
      gridfile.filename = "tas_Amon_NorESM1-M_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'NorESM1-ME-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "NorESM1-ME",
      gcm.run = 1,
      institute = "NCC",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-ME/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-ME/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-ME/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-ME/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_NorESM1-ME_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_NorESM1-ME_rcp85_r1i1p1_200601-204412.nc", 
            "tas_Amon_NorESM1-ME_rcp85_r1i1p1_204501-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_NorESM1-ME_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_NorESM1-ME_rcp85_r1i1p1_200601-204412.nc", 
            "pr_Amon_NorESM1-ME_rcp85_r1i1p1_204501-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-ME/historical",
      gridfile.filename = "tas_Amon_NorESM1-ME_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MRI-ESM1-r1i1p1_rcp85' = list( 
      rcm = "",
      gcm = "MRI-ESM1",
      gcm.run = 1,
      institute = "MRI",
      emission.scenario = "rcp85",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-ESM1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-ESM1/rcp85"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-ESM1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-ESM1/rcp85")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MRI-ESM1_historical_r1i1p1_185101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MRI-ESM1_rcp85_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MRI-ESM1_historical_r1i1p1_185101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MRI-ESM1_rcp85_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-ESM1/historical",
      gridfile.filename = "tas_Amon_MRI-ESM1_historical_r1i1p1_185101-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),
## acrnonyms: , 
##  ACCESS1-0-r1i1p1_rcp85, 
##  ACCESS1-3-r1i1p1_rcp85, 
##  BCC-CSM1-1-r1i1p1_rcp85, 
##  BCC-CSM1-1-m-r1i1p1_rcp85, 
##  BNU-ESM-r1i1p1_rcp85, 
##  CanESM2-r1i1p1_rcp85, 
##  CanESM2-r2i1p1_rcp85, 
##  CanESM2-r3i1p1_rcp85, 
##  CanESM2-r4i1p1_rcp85, 
##  CanESM2-r5i1p1_rcp85, 
##  CCSM4-r1i1p1_rcp85, 
##  CCSM4-r2i1p1_rcp85, 
##  CCSM4-r3i1p1_rcp85, 
##  CCSM4-r4i1p1_rcp85, 
##  CCSM4-r5i1p1_rcp85, 
##  CCSM4-r6i1p1_rcp85, 
##  CESM1-BGC-r1i1p1_rcp85, 
##  CESM1-CAM5-r1i1p1_rcp85, 
##  CESM1-CAM5-r2i1p1_rcp85, 
##  CESM1-CAM5-r3i1p1_rcp85, 
##  CESM1-WACCM-r2i1p1_rcp85, 
##  CESM1-WACCM-r3i1p1_rcp85, 
##  CESM1-WACCM-r4i1p1_rcp85, 
##  CMCC-CESM-r1i1p1_rcp85, 
##  CMCC-CM-r1i1p1_rcp85, 
##  CMCC-CMS-r1i1p1_rcp85, 
##  CNRM-CM5-r10i1p1_rcp85, 
##  CNRM-CM5-r1i1p1_rcp85, 
##  CNRM-CM5-r2i1p1_rcp85, 
##  CNRM-CM5-r4i1p1_rcp85, 
##  CNRM-CM5-r6i1p1_rcp85, 
##  CSIRO-Mk3-6-0-r10i1p1_rcp85, 
##  CSIRO-Mk3-6-0-r1i1p1_rcp85, 
##  CSIRO-Mk3-6-0-r2i1p1_rcp85, 
##  CSIRO-Mk3-6-0-r3i1p1_rcp85, 
##  CSIRO-Mk3-6-0-r4i1p1_rcp85, 
##  CSIRO-Mk3-6-0-r5i1p1_rcp85, 
##  CSIRO-Mk3-6-0-r6i1p1_rcp85, 
##  CSIRO-Mk3-6-0-r7i1p1_rcp85, 
##  CSIRO-Mk3-6-0-r8i1p1_rcp85, 
##  CSIRO-Mk3-6-0-r9i1p1_rcp85, 
##  EC-EARTH-r12i1p1_rcp85, 
##  EC-EARTH-r13i1p1_rcp85, 
##  EC-EARTH-r14i1p1_rcp85, 
##  EC-EARTH-r1i1p1_rcp85, 
##  EC-EARTH-r2i1p1_rcp85, 
##  EC-EARTH-r6i1p1_rcp85, 
##  EC-EARTH-r8i1p1_rcp85, 
##  EC-EARTH-r9i1p1_rcp85, 
##  FGOALS-g2-r1i1p1_rcp85, 
##  FIO-ESM-r1i1p1_rcp85, 
##  FIO-ESM-r2i1p1_rcp85, 
##  FIO-ESM-r3i1p1_rcp85, 
##  GFDL-CM3-r1i1p1_rcp85, 
##  GFDL-ESM2G-r1i1p1_rcp85, 
##  GFDL-ESM2M-r1i1p1_rcp85, 
##  GISS-E2-H-r1i1p1_rcp85, 
##  GISS-E2-H-r1i1p2_rcp85, 
##  GISS-E2-H-r1i1p3_rcp85, 
##  GISS-E2-H-r2i1p1_rcp85, 
##  GISS-E2-H-r2i1p3_rcp85, 
##  GISS-E2-H-CC-r1i1p1_rcp85, 
##  GISS-E2-R-r1i1p1_rcp85, 
##  GISS-E2-R-r1i1p2_rcp85, 
##  GISS-E2-R-r1i1p3_rcp85, 
##  GISS-E2-R-r2i1p1_rcp85, 
##  GISS-E2-R-r2i1p3_rcp85, 
##  GISS-E2-R-CC-r1i1p1_rcp85, 
##  HadGEM2-AO-r1i1p1_rcp85, 
##  HadGEM2-CC-r1i1p1_rcp85, 
##  HadGEM2-CC-r2i1p1_rcp85, 
##  HadGEM2-CC-r3i1p1_rcp85, 
##  HadGEM2-ES-r1i1p1_rcp85, 
##  HadGEM2-ES-r2i1p1_rcp85, 
##  HadGEM2-ES-r3i1p1_rcp85, 
##  HadGEM2-ES-r4i1p1_rcp85, 
##  INM-CM4-r1i1p1_rcp85, 
##  IPSL-CM5A-LR-r1i1p1_rcp85, 
##  IPSL-CM5A-LR-r2i1p1_rcp85, 
##  IPSL-CM5A-LR-r3i1p1_rcp85, 
##  IPSL-CM5A-LR-r4i1p1_rcp85, 
##  IPSL-CM5A-MR-r1i1p1_rcp85, 
##  IPSL-CM5B-LR-r1i1p1_rcp85, 
##  MIROC5-r1i1p1_rcp85, 
##  MIROC5-r2i1p1_rcp85, 
##  MIROC5-r3i1p1_rcp85, 
##  MIROC5-r4i1p1_rcp85, 
##  MIROC5-r5i1p1_rcp85, 
##  MIROC-ESM-r1i1p1_rcp85, 
##  MIROC-ESM-CHEM-r1i1p1_rcp85, 
##  MPI-ESM-LR-r1i1p1_rcp85, 
##  MPI-ESM-LR-r2i1p1_rcp85, 
##  MPI-ESM-LR-r3i1p1_rcp85, 
##  MPI-ESM-MR-r1i1p1_rcp85, 
##  MRI-CGCM3-r1i1p1_rcp85, 
##  NorESM1-M-r1i1p1_rcp85, 
##  NorESM1-ME-r1i1p1_rcp85, 
##  MRI-ESM1-r1i1p1_rcp85
### ----------------------------------------------------------------------
### ************************** SCENARIO: RCP26 ***************************
### ----------------------------------------------------------------------

################################################################################
    'BCC-CSM1-1-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "BCC-CSM1-1",
      gcm.run = 1,
      institute = "BCC",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_bcc-csm1-1_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_bcc-csm1-1_rcp26_r1i1p1_200601-209912.nc", 
            "tas_Amon_bcc-csm1-1_rcp26_r1i1p1_210001-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_bcc-csm1-1_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_bcc-csm1-1_rcp26_r1i1p1_200601-209912.nc", 
            "pr_Amon_bcc-csm1-1_rcp26_r1i1p1_210001-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1/historical",
      gridfile.filename = "tas_Amon_bcc-csm1-1_historical_r1i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'BCC-CSM1-1-m-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "BCC-CSM1-1-m",
      gcm.run = 1,
      institute = "BCC",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1(m)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1(m)/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1(m)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1(m)/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_bcc-csm1-1-m_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_bcc-csm1-1-m_rcp26_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_bcc-csm1-1-m_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_bcc-csm1-1-m_rcp26_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1(m)/historical",
      gridfile.filename = "tas_Amon_bcc-csm1-1-m_historical_r1i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'BNU-ESM-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "BNU-ESM",
      gcm.run = 1,
      institute = "GCESS",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BNU-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BNU-ESM/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BNU-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BNU-ESM/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_BNU-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_BNU-ESM_rcp26_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_BNU-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_BNU-ESM_rcp26_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BNU-ESM/historical",
      gridfile.filename = "tas_Amon_BNU-ESM_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanESM2-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CanESM2",
      gcm.run = 1,
      institute = "CCCma",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanESM2_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanESM2_rcp26_r1i1p1_200601-210012.nc", 
            "tas_Amon_CanESM2_rcp26_r1i1p1_210101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanESM2_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanESM2_rcp26_r1i1p1_200601-210012.nc", 
            "pr_Amon_CanESM2_rcp26_r1i1p1_210101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
      gridfile.filename = "tas_Amon_CanESM2_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanESM2-r2i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CanESM2",
      gcm.run = 2,
      institute = "CCCma",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanESM2_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanESM2_rcp26_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanESM2_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanESM2_rcp26_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
      gridfile.filename = "tas_Amon_CanESM2_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanESM2-r3i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CanESM2",
      gcm.run = 3,
      institute = "CCCma",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanESM2_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanESM2_rcp26_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanESM2_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanESM2_rcp26_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
      gridfile.filename = "tas_Amon_CanESM2_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanESM2-r4i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CanESM2",
      gcm.run = 4,
      institute = "CCCma",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanESM2_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanESM2_rcp26_r4i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanESM2_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanESM2_rcp26_r4i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
      gridfile.filename = "tas_Amon_CanESM2_historical_r4i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CanESM2-r5i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CanESM2",
      gcm.run = 5,
      institute = "CCCma",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CanESM2_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CanESM2_rcp26_r5i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CanESM2_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CanESM2_rcp26_r5i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CanESM2/historical",
      gridfile.filename = "tas_Amon_CanESM2_historical_r5i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 1,
      institute = "NCAR",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_CCSM4_rcp26_r1i1p1_200501-210012.nc", 
            "tas_Amon_CCSM4_rcp26_r1i1p1_200601-210012.nc", 
            "tas_Amon_CCSM4_rcp26_r1i1p1_210101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp26_r1i1p1_200601-210012.nc", 
            "pr_Amon_CCSM4_rcp26_r1i1p1_210101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r2i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 2,
      institute = "NCAR",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_CCSM4_rcp26_r2i1p1_200501-210012.nc", 
            "tas_Amon_CCSM4_rcp26_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp26_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r3i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 3,
      institute = "NCAR",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_CCSM4_rcp26_r3i1p1_200501-210012.nc", 
            "tas_Amon_CCSM4_rcp26_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp26_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r4i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 4,
      institute = "NCAR",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_CCSM4_rcp26_r4i1p1_200501-210012.nc", 
            "tas_Amon_CCSM4_rcp26_r4i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp26_r4i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r4i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r5i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 5,
      institute = "NCAR",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_CCSM4_rcp26_r5i1p1_200501-210012.nc", 
            "tas_Amon_CCSM4_rcp26_r5i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp26_r5i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r5i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r6i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 6,
      institute = "NCAR",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r6i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CCSM4_rcp26_r6i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r6i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp26_r6i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r6i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CESM1-CAM5-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CESM1-CAM5",
      gcm.run = 1,
      institute = "NSF-DOE-NCAR",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CESM1-CAM5_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CESM1-CAM5_rcp26_r1i1p1_200601-210012.nc", 
            "tas_Amon_CESM1-CAM5_rcp26_r1i1p1_210101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CESM1-CAM5_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CESM1-CAM5_rcp26_r1i1p1_200601-210012.nc", 
            "pr_Amon_CESM1-CAM5_rcp26_r1i1p1_210101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
      gridfile.filename = "tas_Amon_CESM1-CAM5_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CESM1-CAM5-r2i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CESM1-CAM5",
      gcm.run = 2,
      institute = "NSF-DOE-NCAR",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CESM1-CAM5_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CESM1-CAM5_rcp26_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CESM1-CAM5_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CESM1-CAM5_rcp26_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
      gridfile.filename = "tas_Amon_CESM1-CAM5_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CESM1-CAM5-r3i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CESM1-CAM5",
      gcm.run = 3,
      institute = "NSF-DOE-NCAR",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CESM1-CAM5_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CESM1-CAM5_rcp26_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CESM1-CAM5_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CESM1-CAM5_rcp26_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
      gridfile.filename = "tas_Amon_CESM1-CAM5_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CNRM-CM5-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CNRM-CM5",
      gcm.run = 1,
      institute = "CNRM-CERFACS",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CNRM-CM5_historical_r1i1p1_185001-189912.nc", 
            "tas_Amon_CNRM-CM5_historical_r1i1p1_190001-194912.nc", 
            "tas_Amon_CNRM-CM5_historical_r1i1p1_195001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CNRM-CM5_rcp26_r1i1p1_200601-205512.nc", 
            "tas_Amon_CNRM-CM5_rcp26_r1i1p1_205601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CNRM-CM5_historical_r1i1p1_185001-189912.nc", 
            "pr_Amon_CNRM-CM5_historical_r1i1p1_190001-194912.nc", 
            "pr_Amon_CNRM-CM5_historical_r1i1p1_195001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CNRM-CM5_rcp26_r1i1p1_200601-205512.nc", 
            "pr_Amon_CNRM-CM5_rcp26_r1i1p1_205601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CNRM-CM5/historical",
      gridfile.filename = "tas_Amon_CNRM-CM5_historical_r1i1p1_185001-189912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r10i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 10,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r10i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp26_r10i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r10i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp26_r10i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r10i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 1,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp26_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp26_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r2i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 2,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp26_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp26_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r3i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 3,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp26_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp26_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r4i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 4,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp26_r4i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp26_r4i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r4i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r5i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 5,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp26_r5i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp26_r5i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r5i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r6i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 6,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r6i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp26_r6i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r6i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp26_r6i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r6i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r7i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 7,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r7i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp26_r7i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r7i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp26_r7i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r7i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r8i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 8,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r8i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp26_r8i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r8i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp26_r8i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r8i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r9i1p1_rcp26' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 9,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r9i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp26_r9i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r9i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp26_r9i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r9i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'EC-EARTH-r12i1p1_rcp26' = list( 
      rcm = "",
      gcm = "EC-EARTH",
      gcm.run = 12,
      institute = "EC-EARTH",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_EC-EARTH_historical_r12i1p1_185001-189912.nc", 
            "tas_Amon_EC-EARTH_historical_r12i1p1_190001-194912.nc", 
            "tas_Amon_EC-EARTH_historical_r12i1p1_195001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_EC-EARTH_rcp26_r12i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_EC-EARTH_historical_r12i1p1_185001-189912.nc", 
            "pr_Amon_EC-EARTH_historical_r12i1p1_190001-194912.nc", 
            "pr_Amon_EC-EARTH_historical_r12i1p1_195001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_EC-EARTH_rcp26_r12i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
      gridfile.filename = "tas_Amon_EC-EARTH_historical_r12i1p1_185001-189912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'EC-EARTH-r8i1p1_rcp26' = list( 
      rcm = "",
      gcm = "EC-EARTH",
      gcm.run = 8,
      institute = "EC-EARTH",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_EC-EARTH_historical_r8i1p1_185001-189912.nc", 
            "tas_Amon_EC-EARTH_historical_r8i1p1_190001-194912.nc", 
            "tas_Amon_EC-EARTH_historical_r8i1p1_195001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_EC-EARTH_rcp26_r8i1p1_200601-205012.nc", 
            "tas_Amon_EC-EARTH_rcp26_r8i1p1_205101-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_EC-EARTH_historical_r8i1p1_185001-189912.nc", 
            "pr_Amon_EC-EARTH_historical_r8i1p1_190001-194912.nc", 
            "pr_Amon_EC-EARTH_historical_r8i1p1_195001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_EC-EARTH_rcp26_r8i1p1_200601-205012.nc", 
            "pr_Amon_EC-EARTH_rcp26_r8i1p1_205101-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/EC-EARTH/historical",
      gridfile.filename = "tas_Amon_EC-EARTH_historical_r8i1p1_185001-189912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'FGOALS-g2-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "FGOALS-g2",
      gcm.run = 1,
      institute = "LASG-CESS",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-g2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-g2/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-g2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-g2/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_FGOALS-g2_historical_r1i1p1_185001-185912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_186001-186912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_187001-187912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_188001-188912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_189001-189912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_190001-190912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_191001-191912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_192001-192912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_193001-193912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_194001-194912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_195001-195912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_196001-196912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_197001-197912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_198001-198912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_199001-199912.nc", 
            "tas_Amon_FGOALS-g2_historical_r1i1p1_200001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_FGOALS-g2_rcp26_r1i1p1_200601-201512.nc", 
            "tas_Amon_FGOALS-g2_rcp26_r1i1p1_201601-202512.nc", 
            "tas_Amon_FGOALS-g2_rcp26_r1i1p1_202601-203512.nc", 
            "tas_Amon_FGOALS-g2_rcp26_r1i1p1_203601-204512.nc", 
            "tas_Amon_FGOALS-g2_rcp26_r1i1p1_204601-205512.nc", 
            "tas_Amon_FGOALS-g2_rcp26_r1i1p1_205601-206512.nc", 
            "tas_Amon_FGOALS-g2_rcp26_r1i1p1_206601-207512.nc", 
            "tas_Amon_FGOALS-g2_rcp26_r1i1p1_207601-208512.nc", 
            "tas_Amon_FGOALS-g2_rcp26_r1i1p1_208601-209512.nc", 
            "tas_Amon_FGOALS-g2_rcp26_r1i1p1_209601-210112.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_FGOALS-g2_historical_r1i1p1_185001-185912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_186001-186912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_187001-187912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_188001-188912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_189001-189912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_190001-190912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_191001-191912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_192001-192912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_193001-193912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_194001-194912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_195001-195912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_196001-196912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_197001-197912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_198001-198912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_199001-199912.nc", 
            "pr_Amon_FGOALS-g2_historical_r1i1p1_200001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_FGOALS-g2_rcp26_r1i1p1_200601-201512.nc", 
            "pr_Amon_FGOALS-g2_rcp26_r1i1p1_201601-202512.nc", 
            "pr_Amon_FGOALS-g2_rcp26_r1i1p1_202601-203512.nc", 
            "pr_Amon_FGOALS-g2_rcp26_r1i1p1_203601-204512.nc", 
            "pr_Amon_FGOALS-g2_rcp26_r1i1p1_204601-205512.nc", 
            "pr_Amon_FGOALS-g2_rcp26_r1i1p1_205601-206512.nc", 
            "pr_Amon_FGOALS-g2_rcp26_r1i1p1_206601-207512.nc", 
            "pr_Amon_FGOALS-g2_rcp26_r1i1p1_207601-208512.nc", 
            "pr_Amon_FGOALS-g2_rcp26_r1i1p1_208601-209512.nc", 
            "pr_Amon_FGOALS-g2_rcp26_r1i1p1_209601-210112.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-g2/historical",
      gridfile.filename = "tas_Amon_FGOALS-g2_historical_r1i1p1_185001-185912.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'FGOALS-s2-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "FGOALS-s2",
      gcm.run = 1,
      institute = "LASG-IAP",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-s2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-s2/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-s2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-s2/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_FGOALS-s2_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_FGOALS-s2_rcp26_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_FGOALS-s2_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_FGOALS-s2_rcp26_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-s2/historical",
      gridfile.filename = "tas_Amon_FGOALS-s2_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'FIO-ESM-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "FIO-ESM",
      gcm.run = 1,
      institute = "FIO",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_FIO-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_FIO-ESM_rcp26_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_FIO-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_FIO-ESM_rcp26_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
      gridfile.filename = "tas_Amon_FIO-ESM_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'FIO-ESM-r2i1p1_rcp26' = list( 
      rcm = "",
      gcm = "FIO-ESM",
      gcm.run = 2,
      institute = "FIO",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_FIO-ESM_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_FIO-ESM_rcp26_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_FIO-ESM_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_FIO-ESM_rcp26_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
      gridfile.filename = "tas_Amon_FIO-ESM_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'FIO-ESM-r3i1p1_rcp26' = list( 
      rcm = "",
      gcm = "FIO-ESM",
      gcm.run = 3,
      institute = "FIO",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_FIO-ESM_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_FIO-ESM_rcp26_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_FIO-ESM_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_FIO-ESM_rcp26_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
      gridfile.filename = "tas_Amon_FIO-ESM_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-CM3-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "GFDL-CM3",
      gcm.run = 1,
      institute = "NOAA GFDL",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM3/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM3/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-CM3_historical_r1i1p1_186001-186412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_186501-186912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_187001-187412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_187501-187912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_188001-188412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_188501-188912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_189001-189412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_189501-189912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_190001-190412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_190501-190912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_191001-191412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_191501-191912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_192001-192412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_192501-192912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_193001-193412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_193501-193912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_194001-194412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_194501-194912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_195001-195412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_195501-195912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_196001-196412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_196501-196912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_197001-197412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_197501-197912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_198001-198412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_198501-198912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_199001-199412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_199501-199912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_200001-200412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_200501-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-CM3_rcp26_r1i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-CM3_rcp26_r1i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-CM3_rcp26_r1i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-CM3_rcp26_r1i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-CM3_rcp26_r1i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-CM3_rcp26_r1i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-CM3_rcp26_r1i1p1_203601-204012.nc", 
            "tas_Amon_GFDL-CM3_rcp26_r1i1p1_204101-204512.nc", 
            "tas_Amon_GFDL-CM3_rcp26_r1i1p1_204601-205012.nc", 
            "tas_Amon_GFDL-CM3_rcp26_r1i1p1_205101-205512.nc", 
            "tas_Amon_GFDL-CM3_rcp26_r1i1p1_205601-206012.nc", 
            "tas_Amon_GFDL-CM3_rcp26_r1i1p1_206101-206512.nc", 
            "tas_Amon_GFDL-CM3_rcp26_r1i1p1_206601-207012.nc", 
            "tas_Amon_GFDL-CM3_rcp26_r1i1p1_207101-207512.nc", 
            "tas_Amon_GFDL-CM3_rcp26_r1i1p1_207601-208012.nc", 
            "tas_Amon_GFDL-CM3_rcp26_r1i1p1_208101-208512.nc", 
            "tas_Amon_GFDL-CM3_rcp26_r1i1p1_208601-209012.nc", 
            "tas_Amon_GFDL-CM3_rcp26_r1i1p1_209101-209512.nc", 
            "tas_Amon_GFDL-CM3_rcp26_r1i1p1_209601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-CM3_historical_r1i1p1_186001-186412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_186501-186912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_187001-187412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_187501-187912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_188001-188412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_188501-188912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_189001-189412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_189501-189912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_190001-190412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_190501-190912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_191001-191412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_191501-191912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_192001-192412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_192501-192912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_193001-193412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_193501-193912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_194001-194412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_194501-194912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_195001-195412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_195501-195912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_196001-196412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_196501-196912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_197001-197412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_197501-197912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_198001-198412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_198501-198912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_199001-199412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_199501-199912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_200001-200412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_200501-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-CM3_rcp26_r1i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-CM3_rcp26_r1i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-CM3_rcp26_r1i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-CM3_rcp26_r1i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-CM3_rcp26_r1i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-CM3_rcp26_r1i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-CM3_rcp26_r1i1p1_203601-204012.nc", 
            "pr_Amon_GFDL-CM3_rcp26_r1i1p1_204101-204512.nc", 
            "pr_Amon_GFDL-CM3_rcp26_r1i1p1_204601-205012.nc", 
            "pr_Amon_GFDL-CM3_rcp26_r1i1p1_205101-205512.nc", 
            "pr_Amon_GFDL-CM3_rcp26_r1i1p1_205601-206012.nc", 
            "pr_Amon_GFDL-CM3_rcp26_r1i1p1_206101-206512.nc", 
            "pr_Amon_GFDL-CM3_rcp26_r1i1p1_206601-207012.nc", 
            "pr_Amon_GFDL-CM3_rcp26_r1i1p1_207101-207512.nc", 
            "pr_Amon_GFDL-CM3_rcp26_r1i1p1_207601-208012.nc", 
            "pr_Amon_GFDL-CM3_rcp26_r1i1p1_208101-208512.nc", 
            "pr_Amon_GFDL-CM3_rcp26_r1i1p1_208601-209012.nc", 
            "pr_Amon_GFDL-CM3_rcp26_r1i1p1_209101-209512.nc", 
            "pr_Amon_GFDL-CM3_rcp26_r1i1p1_209601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM3/historical",
      gridfile.filename = "tas_Amon_GFDL-CM3_historical_r1i1p1_186001-186412.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-ESM2G-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "GFDL-ESM2G",
      gcm.run = 1,
      institute = "NOAA GFDL",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2G/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2G/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2G/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2G/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_186101-186512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_186601-187012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_187101-187512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_187601-188012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_188101-188512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_188601-189012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_189101-189512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_189601-190012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_190101-190512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_190601-191012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_191101-191512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_191601-192012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_192101-192512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_192601-193012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_193101-193512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_193601-194012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_194101-194512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_194601-195012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_195101-195512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_195601-196012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_196101-196512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_196601-197012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_197101-197512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_197601-198012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_198101-198512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_198601-199012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_199101-199512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_199601-200012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-ESM2G_rcp26_r1i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp26_r1i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp26_r1i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp26_r1i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp26_r1i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp26_r1i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp26_r1i1p1_203601-204012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp26_r1i1p1_204101-204512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp26_r1i1p1_204601-205012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp26_r1i1p1_205101-205512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp26_r1i1p1_205601-206012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp26_r1i1p1_206101-206512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp26_r1i1p1_206601-207012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp26_r1i1p1_207101-207512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp26_r1i1p1_207601-208012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp26_r1i1p1_208101-208512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp26_r1i1p1_208601-209012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp26_r1i1p1_209101-209512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp26_r1i1p1_209601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_186101-186512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_186601-187012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_187101-187512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_187601-188012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_188101-188512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_188601-189012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_189101-189512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_189601-190012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_190101-190512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_190601-191012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_191101-191512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_191601-192012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_192101-192512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_192601-193012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_193101-193512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_193601-194012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_194101-194512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_194601-195012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_195101-195512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_195601-196012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_196101-196512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_196601-197012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_197101-197512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_197601-198012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_198101-198512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_198601-199012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_199101-199512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_199601-200012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-ESM2G_rcp26_r1i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp26_r1i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp26_r1i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp26_r1i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp26_r1i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp26_r1i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp26_r1i1p1_203601-204012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp26_r1i1p1_204101-204512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp26_r1i1p1_204601-205012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp26_r1i1p1_205101-205512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp26_r1i1p1_205601-206012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp26_r1i1p1_206101-206512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp26_r1i1p1_206601-207012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp26_r1i1p1_207101-207512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp26_r1i1p1_207601-208012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp26_r1i1p1_208101-208512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp26_r1i1p1_208601-209012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp26_r1i1p1_209101-209512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp26_r1i1p1_209601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2G/historical",
      gridfile.filename = "tas_Amon_GFDL-ESM2G_historical_r1i1p1_186101-186512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-ESM2M-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "GFDL-ESM2M",
      gcm.run = 1,
      institute = "NOAA GFDL",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2M/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2M/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2M/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2M/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_186101-186512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_186601-187012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_187101-187512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_187601-188012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_188101-188512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_188601-189012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_189101-189512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_189601-190012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_190101-190512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_190601-191012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_191101-191512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_191601-192012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_192101-192512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_192601-193012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_193101-193512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_193601-194012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_194101-194512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_194601-195012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_195101-195512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_195601-196012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_196101-196512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_196601-197012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_197101-197512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_197601-198012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_198101-198512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_198601-199012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_199101-199512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_199601-200012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-ESM2M_rcp26_r1i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp26_r1i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp26_r1i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp26_r1i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp26_r1i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp26_r1i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp26_r1i1p1_203601-204012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp26_r1i1p1_204101-204512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp26_r1i1p1_204601-205012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp26_r1i1p1_205101-205512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp26_r1i1p1_205601-206012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp26_r1i1p1_206101-206512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp26_r1i1p1_206601-207012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp26_r1i1p1_207101-207512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp26_r1i1p1_207601-208012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp26_r1i1p1_208101-208512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp26_r1i1p1_208601-209012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp26_r1i1p1_209101-209512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp26_r1i1p1_209601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_186101-186512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_186601-187012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_187101-187512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_187601-188012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_188101-188512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_188601-189012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_189101-189512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_189601-190012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_190101-190512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_190601-191012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_191101-191512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_191601-192012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_192101-192512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_192601-193012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_193101-193512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_193601-194012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_194101-194512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_194601-195012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_195101-195512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_195601-196012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_196101-196512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_196601-197012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_197101-197512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_197601-198012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_198101-198512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_198601-199012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_199101-199512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_199601-200012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-ESM2M_rcp26_r1i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp26_r1i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp26_r1i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp26_r1i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp26_r1i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp26_r1i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp26_r1i1p1_203601-204012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp26_r1i1p1_204101-204512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp26_r1i1p1_204601-205012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp26_r1i1p1_205101-205512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp26_r1i1p1_205601-206012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp26_r1i1p1_206101-206512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp26_r1i1p1_206601-207012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp26_r1i1p1_207101-207512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp26_r1i1p1_207601-208012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp26_r1i1p1_208101-208512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp26_r1i1p1_208601-209012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp26_r1i1p1_209101-209512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp26_r1i1p1_209601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2M/historical",
      gridfile.filename = "tas_Amon_GFDL-ESM2M_historical_r1i1p1_186101-186512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r1i1p1_185001-190012.nc", 
            "tas_Amon_GISS-E2-H_historical_r1i1p1_190101-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r1i1p1_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp26_r1i1p1_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp26_r1i1p1_205101-210012.nc", 
            "tas_Amon_GISS-E2-H_rcp26_r1i1p1_210101-215012.nc", 
            "tas_Amon_GISS-E2-H_rcp26_r1i1p1_215101-220012.nc", 
            "tas_Amon_GISS-E2-H_rcp26_r1i1p1_220101-225012.nc", 
            "tas_Amon_GISS-E2-H_rcp26_r1i1p1_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r1i1p1_185001-190012.nc", 
            "pr_Amon_GISS-E2-H_historical_r1i1p1_190101-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r1i1p1_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp26_r1i1p1_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp26_r1i1p1_205101-210012.nc", 
            "pr_Amon_GISS-E2-H_rcp26_r1i1p1_210101-215012.nc", 
            "pr_Amon_GISS-E2-H_rcp26_r1i1p1_215101-220012.nc", 
            "pr_Amon_GISS-E2-H_rcp26_r1i1p1_220101-225012.nc", 
            "pr_Amon_GISS-E2-H_rcp26_r1i1p1_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r1i1p1_185001-190012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r1i1p2_rcp26' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r1i1p2_185001-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r1i1p2_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp26_r1i1p2_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp26_r1i1p2_205101-210012.nc", 
            "tas_Amon_GISS-E2-H_rcp26_r1i1p2_210101-215012.nc", 
            "tas_Amon_GISS-E2-H_rcp26_r1i1p2_215101-220012.nc", 
            "tas_Amon_GISS-E2-H_rcp26_r1i1p2_220101-225012.nc", 
            "tas_Amon_GISS-E2-H_rcp26_r1i1p2_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r1i1p2_185001-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r1i1p2_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp26_r1i1p2_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp26_r1i1p2_205101-210012.nc", 
            "pr_Amon_GISS-E2-H_rcp26_r1i1p2_210101-215012.nc", 
            "pr_Amon_GISS-E2-H_rcp26_r1i1p2_215101-220012.nc", 
            "pr_Amon_GISS-E2-H_rcp26_r1i1p2_220101-225012.nc", 
            "pr_Amon_GISS-E2-H_rcp26_r1i1p2_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r1i1p2_185001-195012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r1i1p3_rcp26' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r1i1p3_185001-190012.nc", 
            "tas_Amon_GISS-E2-H_historical_r1i1p3_190101-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r1i1p3_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp26_r1i1p3_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp26_r1i1p3_205101-210012.nc", 
            "tas_Amon_GISS-E2-H_rcp26_r1i1p3_210101-215012.nc", 
            "tas_Amon_GISS-E2-H_rcp26_r1i1p3_215101-220012.nc", 
            "tas_Amon_GISS-E2-H_rcp26_r1i1p3_220101-225012.nc", 
            "tas_Amon_GISS-E2-H_rcp26_r1i1p3_225101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r1i1p3_185001-190012.nc", 
            "pr_Amon_GISS-E2-H_historical_r1i1p3_190101-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r1i1p3_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp26_r1i1p3_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp26_r1i1p3_205101-210012.nc", 
            "pr_Amon_GISS-E2-H_rcp26_r1i1p3_210101-215012.nc", 
            "pr_Amon_GISS-E2-H_rcp26_r1i1p3_215101-220012.nc", 
            "pr_Amon_GISS-E2-H_rcp26_r1i1p3_220101-225012.nc", 
            "pr_Amon_GISS-E2-H_rcp26_r1i1p3_225101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r1i1p3_185001-190012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r1i1p1_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp26_r1i1p1_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p1_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p1_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p1_207601-210012.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p1_210101-212512.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p1_212601-215012.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p1_215101-217512.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p1_217601-220012.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p1_220101-222512.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p1_222601-225012.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p1_225101-227512.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p1_227601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r1i1p1_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp26_r1i1p1_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p1_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p1_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p1_207601-210012.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p1_210101-212512.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p1_212601-215012.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p1_215101-217512.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p1_217601-220012.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p1_220101-222512.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p1_222601-225012.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p1_225101-227512.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p1_227601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r1i1p1_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r1i1p2_rcp26' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r1i1p2_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp26_r1i1p2_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p2_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p2_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p2_207601-210012.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p2_210101-212512.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p2_212601-215012.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p2_215101-217512.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p2_217601-220012.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p2_220101-222512.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p2_222601-225012.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p2_225101-227512.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p2_227601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r1i1p2_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp26_r1i1p2_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p2_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p2_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p2_207601-210012.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p2_210101-212512.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p2_212601-215012.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p2_215101-217512.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p2_217601-220012.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p2_220101-222512.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p2_222601-225012.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p2_225101-227512.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p2_227601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r1i1p2_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r1i1p3_rcp26' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r1i1p3_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp26_r1i1p3_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p3_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p3_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p3_207601-210012.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p3_210101-212512.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p3_212601-215012.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p3_215101-217512.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p3_217601-220012.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p3_220101-222512.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p3_222601-225012.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p3_225101-227512.nc", 
            "tas_Amon_GISS-E2-R_rcp26_r1i1p3_227601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r1i1p3_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp26_r1i1p3_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p3_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p3_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p3_207601-210012.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p3_210101-212512.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p3_212601-215012.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p3_215101-217512.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p3_217601-220012.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p3_220101-222512.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p3_222601-225012.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p3_225101-227512.nc", 
            "pr_Amon_GISS-E2-R_rcp26_r1i1p3_227601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r1i1p3_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-AO-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "HadGEM2-AO",
      gcm.run = 1,
      institute = "NIMR/KMA",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-AO/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-AO/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-AO/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-AO/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-AO_historical_r1i1p1_186001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_HadGEM2-AO_rcp26_r1i1p1_200601-209912.nc", 
            "tas_Amon_HadGEM2-AO_rcp26_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-AO_historical_r1i1p1_186001-200512.nc"
            ),
          scenario = c(
##            "pr_Amon_HadGEM2-AO_rcp26_r1i1p1_200601-209912.nc", 
            "pr_Amon_HadGEM2-AO_rcp26_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-AO/historical",
      gridfile.filename = "tas_Amon_HadGEM2-AO_historical_r1i1p1_186001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-ES-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "HadGEM2-ES",
      gcm.run = 1,
      institute = "MOHC",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_185912-188411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_188412-190911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_190912-193411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_193412-195911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_195912-198411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_198412-200511.nc"
            ),
          scenario = c(
            "tas_Amon_HadGEM2-ES_rcp26_r1i1p1_200512-203011.nc", 
            "tas_Amon_HadGEM2-ES_rcp26_r1i1p1_203012-205511.nc", 
            "tas_Amon_HadGEM2-ES_rcp26_r1i1p1_205512-208011.nc", 
            "tas_Amon_HadGEM2-ES_rcp26_r1i1p1_208012-209911.nc", 
            "tas_Amon_HadGEM2-ES_rcp26_r1i1p1_209912-212411.nc", 
            "tas_Amon_HadGEM2-ES_rcp26_r1i1p1_212412-214911.nc", 
            "tas_Amon_HadGEM2-ES_rcp26_r1i1p1_214912-217411.nc", 
            "tas_Amon_HadGEM2-ES_rcp26_r1i1p1_217412-219911.nc", 
            "tas_Amon_HadGEM2-ES_rcp26_r1i1p1_219912-222411.nc", 
            "tas_Amon_HadGEM2-ES_rcp26_r1i1p1_222412-224911.nc", 
            "tas_Amon_HadGEM2-ES_rcp26_r1i1p1_224912-227411.nc", 
            "tas_Amon_HadGEM2-ES_rcp26_r1i1p1_227412-229911.nc", 
            "tas_Amon_HadGEM2-ES_rcp26_r1i1p1_229912-229912.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_185912-188411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_188412-190911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_190912-193411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_193412-195911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_195912-198411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_198412-200511.nc"
            ),
          scenario = c(
            "pr_Amon_HadGEM2-ES_rcp26_r1i1p1_200512-203011.nc", 
            "pr_Amon_HadGEM2-ES_rcp26_r1i1p1_203012-205511.nc", 
            "pr_Amon_HadGEM2-ES_rcp26_r1i1p1_205512-208011.nc", 
            "pr_Amon_HadGEM2-ES_rcp26_r1i1p1_208012-209911.nc", 
            "pr_Amon_HadGEM2-ES_rcp26_r1i1p1_209912-212411.nc", 
            "pr_Amon_HadGEM2-ES_rcp26_r1i1p1_212412-214911.nc", 
            "pr_Amon_HadGEM2-ES_rcp26_r1i1p1_214912-217411.nc", 
            "pr_Amon_HadGEM2-ES_rcp26_r1i1p1_217412-219911.nc", 
            "pr_Amon_HadGEM2-ES_rcp26_r1i1p1_219912-222411.nc", 
            "pr_Amon_HadGEM2-ES_rcp26_r1i1p1_222412-224911.nc", 
            "pr_Amon_HadGEM2-ES_rcp26_r1i1p1_224912-227411.nc", 
            "pr_Amon_HadGEM2-ES_rcp26_r1i1p1_227412-229911.nc", 
            "pr_Amon_HadGEM2-ES_rcp26_r1i1p1_229912-229912.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
      gridfile.filename = "tas_Amon_HadGEM2-ES_historical_r1i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-ES-r2i1p1_rcp26' = list( 
      rcm = "",
      gcm = "HadGEM2-ES",
      gcm.run = 2,
      institute = "MOHC",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_185912-188411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_188412-190911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_190912-193411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_193412-195911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_195912-198411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_198412-200512.nc"
            ),
          scenario = c(
            "tas_Amon_HadGEM2-ES_rcp26_r2i1p1_200512-203011.nc", 
            "tas_Amon_HadGEM2-ES_rcp26_r2i1p1_203012-205511.nc", 
            "tas_Amon_HadGEM2-ES_rcp26_r2i1p1_205512-208011.nc", 
            "tas_Amon_HadGEM2-ES_rcp26_r2i1p1_208012-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_185912-188411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_188412-190911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_190912-193411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_193412-195911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_195912-198411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_198412-200512.nc"
            ),
          scenario = c(
            "pr_Amon_HadGEM2-ES_rcp26_r2i1p1_200512-203011.nc", 
            "pr_Amon_HadGEM2-ES_rcp26_r2i1p1_203012-205511.nc", 
            "pr_Amon_HadGEM2-ES_rcp26_r2i1p1_205512-208011.nc", 
            "pr_Amon_HadGEM2-ES_rcp26_r2i1p1_208012-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
      gridfile.filename = "tas_Amon_HadGEM2-ES_historical_r2i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-ES-r3i1p1_rcp26' = list( 
      rcm = "",
      gcm = "HadGEM2-ES",
      gcm.run = 3,
      institute = "MOHC",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_185912-188411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_188412-190911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_190912-193411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_193412-195911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_195912-198411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_198412-200512.nc"
            ),
          scenario = c(
            "tas_Amon_HadGEM2-ES_rcp26_r3i1p1_200512-203011.nc", 
            "tas_Amon_HadGEM2-ES_rcp26_r3i1p1_203012-205511.nc", 
            "tas_Amon_HadGEM2-ES_rcp26_r3i1p1_205512-208011.nc", 
            "tas_Amon_HadGEM2-ES_rcp26_r3i1p1_208012-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_185912-188411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_188412-190911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_190912-193411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_193412-195911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_195912-198411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_198412-200512.nc"
            ),
          scenario = c(
            "pr_Amon_HadGEM2-ES_rcp26_r3i1p1_200512-203011.nc", 
            "pr_Amon_HadGEM2-ES_rcp26_r3i1p1_203012-205511.nc", 
            "pr_Amon_HadGEM2-ES_rcp26_r3i1p1_205512-208011.nc", 
            "pr_Amon_HadGEM2-ES_rcp26_r3i1p1_208012-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
      gridfile.filename = "tas_Amon_HadGEM2-ES_historical_r3i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-ES-r4i1p1_rcp26' = list( 
      rcm = "",
      gcm = "HadGEM2-ES",
      gcm.run = 4,
      institute = "MOHC",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_185912-188411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_188412-190911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_190912-193411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_193412-195911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_195912-198411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_198412-200511.nc"
            ),
          scenario = c(
            "tas_Amon_HadGEM2-ES_rcp26_r4i1p1_200512-203011.nc", 
            "tas_Amon_HadGEM2-ES_rcp26_r4i1p1_203012-205511.nc", 
            "tas_Amon_HadGEM2-ES_rcp26_r4i1p1_205512-208011.nc", 
            "tas_Amon_HadGEM2-ES_rcp26_r4i1p1_208012-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_185912-188411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_188412-190911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_190912-193411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_193412-195911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_195912-198411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_198412-200511.nc"
            ),
          scenario = c(
            "pr_Amon_HadGEM2-ES_rcp26_r4i1p1_200512-203011.nc", 
            "pr_Amon_HadGEM2-ES_rcp26_r4i1p1_203012-205511.nc", 
            "pr_Amon_HadGEM2-ES_rcp26_r4i1p1_205512-208011.nc", 
            "pr_Amon_HadGEM2-ES_rcp26_r4i1p1_208012-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
      gridfile.filename = "tas_Amon_HadGEM2-ES_historical_r4i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'IPSL-CM5A-LR-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "IPSL-CM5A-LR",
      gcm.run = 1,
      institute = "IPSL",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_IPSL-CM5A-LR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_IPSL-CM5A-LR_rcp26_r1i1p1_200601-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_IPSL-CM5A-LR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_IPSL-CM5A-LR_rcp26_r1i1p1_200601-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
      gridfile.filename = "tas_Amon_IPSL-CM5A-LR_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'IPSL-CM5A-LR-r2i1p1_rcp26' = list( 
      rcm = "",
      gcm = "IPSL-CM5A-LR",
      gcm.run = 2,
      institute = "IPSL",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_IPSL-CM5A-LR_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_IPSL-CM5A-LR_rcp26_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_IPSL-CM5A-LR_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_IPSL-CM5A-LR_rcp26_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
      gridfile.filename = "tas_Amon_IPSL-CM5A-LR_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'IPSL-CM5A-LR-r3i1p1_rcp26' = list( 
      rcm = "",
      gcm = "IPSL-CM5A-LR",
      gcm.run = 3,
      institute = "IPSL",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_IPSL-CM5A-LR_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_IPSL-CM5A-LR_rcp26_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_IPSL-CM5A-LR_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_IPSL-CM5A-LR_rcp26_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
      gridfile.filename = "tas_Amon_IPSL-CM5A-LR_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'IPSL-CM5A-LR-r4i1p1_rcp26' = list( 
      rcm = "",
      gcm = "IPSL-CM5A-LR",
      gcm.run = 4,
      institute = "IPSL",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_IPSL-CM5A-LR_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_IPSL-CM5A-LR_rcp26_r4i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_IPSL-CM5A-LR_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_IPSL-CM5A-LR_rcp26_r4i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
      gridfile.filename = "tas_Amon_IPSL-CM5A-LR_historical_r4i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'IPSL-CM5A-MR-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "IPSL-CM5A-MR",
      gcm.run = 1,
      institute = "IPSL",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-MR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-MR/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-MR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-MR/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_IPSL-CM5A-MR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_IPSL-CM5A-MR_rcp26_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_IPSL-CM5A-MR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_IPSL-CM5A-MR_rcp26_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-MR/historical",
      gridfile.filename = "tas_Amon_IPSL-CM5A-MR_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC5-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "MIROC5",
      gcm.run = 1,
      institute = "MIROC",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC5_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC5_rcp26_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC5_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC5_rcp26_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
      gridfile.filename = "tas_Amon_MIROC5_historical_r1i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC5-r2i1p1_rcp26' = list( 
      rcm = "",
      gcm = "MIROC5",
      gcm.run = 2,
      institute = "MIROC",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC5_historical_r2i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC5_rcp26_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC5_historical_r2i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC5_rcp26_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
      gridfile.filename = "tas_Amon_MIROC5_historical_r2i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC5-r3i1p1_rcp26' = list( 
      rcm = "",
      gcm = "MIROC5",
      gcm.run = 3,
      institute = "MIROC",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC5_historical_r3i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC5_rcp26_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC5_historical_r3i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC5_rcp26_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
      gridfile.filename = "tas_Amon_MIROC5_historical_r3i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC5-r4i1p1_rcp26' = list( 
      rcm = "",
      gcm = "MIROC5",
      gcm.run = 4,
      institute = "MIROC",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC5_historical_r4i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC5_rcp26_r4i1p1_200601-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC5_historical_r4i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC5_rcp26_r4i1p1_200601-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
      gridfile.filename = "tas_Amon_MIROC5_historical_r4i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC5-r5i1p1_rcp26' = list( 
      rcm = "",
      gcm = "MIROC5",
      gcm.run = 5,
      institute = "MIROC",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC5_historical_r5i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC5_rcp26_r5i1p1_200601-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC5_historical_r5i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC5_rcp26_r5i1p1_200601-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
      gridfile.filename = "tas_Amon_MIROC5_historical_r5i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC-ESM-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "MIROC-ESM",
      gcm.run = 1,
      institute = "MIROC",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC-ESM_rcp26_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC-ESM_rcp26_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM/historical",
      gridfile.filename = "tas_Amon_MIROC-ESM_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC-ESM-CHEM-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "MIROC-ESM-CHEM",
      gcm.run = 1,
      institute = "MIROC",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM-CHEM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM-CHEM/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM-CHEM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM-CHEM/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC-ESM-CHEM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC-ESM-CHEM_rcp26_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC-ESM-CHEM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC-ESM-CHEM_rcp26_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM-CHEM/historical",
      gridfile.filename = "tas_Amon_MIROC-ESM-CHEM_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MPI-ESM-LR-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "MPI-ESM-LR",
      gcm.run = 1,
      institute = "MPI-M",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MPI-ESM-LR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MPI-ESM-LR_rcp26_r1i1p1_200601-210012.nc", 
            "tas_Amon_MPI-ESM-LR_rcp26_r1i1p1_210101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MPI-ESM-LR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MPI-ESM-LR_rcp26_r1i1p1_200601-210012.nc", 
            "pr_Amon_MPI-ESM-LR_rcp26_r1i1p1_210101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
      gridfile.filename = "tas_Amon_MPI-ESM-LR_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MPI-ESM-LR-r2i1p1_rcp26' = list( 
      rcm = "",
      gcm = "MPI-ESM-LR",
      gcm.run = 2,
      institute = "MPI-M",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MPI-ESM-LR_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MPI-ESM-LR_rcp26_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MPI-ESM-LR_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MPI-ESM-LR_rcp26_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
      gridfile.filename = "tas_Amon_MPI-ESM-LR_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MPI-ESM-LR-r3i1p1_rcp26' = list( 
      rcm = "",
      gcm = "MPI-ESM-LR",
      gcm.run = 3,
      institute = "MPI-M",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MPI-ESM-LR_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MPI-ESM-LR_rcp26_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MPI-ESM-LR_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MPI-ESM-LR_rcp26_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-LR/historical",
      gridfile.filename = "tas_Amon_MPI-ESM-LR_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MPI-ESM-MR-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "MPI-ESM-MR",
      gcm.run = 1,
      institute = "MPI-M",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MPI-ESM-MR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MPI-ESM-MR_rcp26_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MPI-ESM-MR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MPI-ESM-MR_rcp26_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MPI-ESM-MR/historical",
      gridfile.filename = "tas_Amon_MPI-ESM-MR_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MRI-CGCM3-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "MRI-CGCM3",
      gcm.run = 1,
      institute = "MRI",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-CGCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-CGCM3/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-CGCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-CGCM3/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MRI-CGCM3_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MRI-CGCM3_rcp26_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MRI-CGCM3_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MRI-CGCM3_rcp26_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-CGCM3/historical",
      gridfile.filename = "tas_Amon_MRI-CGCM3_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'NorESM1-M-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "NorESM1-M",
      gcm.run = 1,
      institute = "NCC",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-M/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-M/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-M/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-M/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_NorESM1-M_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_NorESM1-M_rcp26_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_NorESM1-M_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_NorESM1-M_rcp26_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-M/historical",
      gridfile.filename = "tas_Amon_NorESM1-M_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'NorESM1-ME-r1i1p1_rcp26' = list( 
      rcm = "",
      gcm = "NorESM1-ME",
      gcm.run = 1,
      institute = "NCC",
      emission.scenario = "rcp26",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-ME/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-ME/rcp26"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-ME/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-ME/rcp26")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_NorESM1-ME_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_NorESM1-ME_rcp26_r1i1p1_200601-206012.nc", 
            "tas_Amon_NorESM1-ME_rcp26_r1i1p1_206101-210112.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_NorESM1-ME_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_NorESM1-ME_rcp26_r1i1p1_200601-206012.nc", 
            "pr_Amon_NorESM1-ME_rcp26_r1i1p1_206101-210112.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-ME/historical",
      gridfile.filename = "tas_Amon_NorESM1-ME_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),
## acrnonyms: , 
##  BCC-CSM1-1-r1i1p1_rcp26, 
##  BCC-CSM1-1-m-r1i1p1_rcp26, 
##  BNU-ESM-r1i1p1_rcp26, 
##  CanESM2-r1i1p1_rcp26, 
##  CanESM2-r2i1p1_rcp26, 
##  CanESM2-r3i1p1_rcp26, 
##  CanESM2-r4i1p1_rcp26, 
##  CanESM2-r5i1p1_rcp26, 
##  CCSM4-r1i1p1_rcp26, 
##  CCSM4-r2i1p1_rcp26, 
##  CCSM4-r3i1p1_rcp26, 
##  CCSM4-r4i1p1_rcp26, 
##  CCSM4-r5i1p1_rcp26, 
##  CCSM4-r6i1p1_rcp26, 
##  CESM1-CAM5-r1i1p1_rcp26, 
##  CESM1-CAM5-r2i1p1_rcp26, 
##  CESM1-CAM5-r3i1p1_rcp26, 
##  CNRM-CM5-r1i1p1_rcp26, 
##  CSIRO-Mk3-6-0-r10i1p1_rcp26, 
##  CSIRO-Mk3-6-0-r1i1p1_rcp26, 
##  CSIRO-Mk3-6-0-r2i1p1_rcp26, 
##  CSIRO-Mk3-6-0-r3i1p1_rcp26, 
##  CSIRO-Mk3-6-0-r4i1p1_rcp26, 
##  CSIRO-Mk3-6-0-r5i1p1_rcp26, 
##  CSIRO-Mk3-6-0-r6i1p1_rcp26, 
##  CSIRO-Mk3-6-0-r7i1p1_rcp26, 
##  CSIRO-Mk3-6-0-r8i1p1_rcp26, 
##  CSIRO-Mk3-6-0-r9i1p1_rcp26, 
##  EC-EARTH-r12i1p1_rcp26, 
##  EC-EARTH-r8i1p1_rcp26, 
##  FGOALS-g2-r1i1p1_rcp26, 
##  FGOALS-s2-r1i1p1_rcp26, 
##  FIO-ESM-r1i1p1_rcp26, 
##  FIO-ESM-r2i1p1_rcp26, 
##  FIO-ESM-r3i1p1_rcp26, 
##  GFDL-CM3-r1i1p1_rcp26, 
##  GFDL-ESM2G-r1i1p1_rcp26, 
##  GFDL-ESM2M-r1i1p1_rcp26, 
##  GISS-E2-H-r1i1p1_rcp26, 
##  GISS-E2-H-r1i1p2_rcp26, 
##  GISS-E2-H-r1i1p3_rcp26, 
##  GISS-E2-R-r1i1p1_rcp26, 
##  GISS-E2-R-r1i1p2_rcp26, 
##  GISS-E2-R-r1i1p3_rcp26, 
##  HadGEM2-AO-r1i1p1_rcp26, 
##  HadGEM2-ES-r1i1p1_rcp26, 
##  HadGEM2-ES-r2i1p1_rcp26, 
##  HadGEM2-ES-r3i1p1_rcp26, 
##  HadGEM2-ES-r4i1p1_rcp26, 
##  IPSL-CM5A-LR-r1i1p1_rcp26, 
##  IPSL-CM5A-LR-r2i1p1_rcp26, 
##  IPSL-CM5A-LR-r3i1p1_rcp26, 
##  IPSL-CM5A-LR-r4i1p1_rcp26, 
##  IPSL-CM5A-MR-r1i1p1_rcp26, 
##  MIROC5-r1i1p1_rcp26, 
##  MIROC5-r2i1p1_rcp26, 
##  MIROC5-r3i1p1_rcp26, 
##  MIROC5-r4i1p1_rcp26, 
##  MIROC5-r5i1p1_rcp26, 
##  MIROC-ESM-r1i1p1_rcp26, 
##  MIROC-ESM-CHEM-r1i1p1_rcp26, 
##  MPI-ESM-LR-r1i1p1_rcp26, 
##  MPI-ESM-LR-r2i1p1_rcp26, 
##  MPI-ESM-LR-r3i1p1_rcp26, 
##  MPI-ESM-MR-r1i1p1_rcp26, 
##  MRI-CGCM3-r1i1p1_rcp26, 
##  NorESM1-M-r1i1p1_rcp26, 
##  NorESM1-ME-r1i1p1_rcp26

##########################################################################

### ----------------------------------------------------------------------
### ************************** SCENARIO: RCP60 ***************************
### ----------------------------------------------------------------------

################################################################################
    'BCC-CSM1-1-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "BCC-CSM1-1",
      gcm.run = 1,
      institute = "BCC",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_bcc-csm1-1_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_bcc-csm1-1_rcp60_r1i1p1_200601-209912.nc", 
            "tas_Amon_bcc-csm1-1_rcp60_r1i1p1_210001-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_bcc-csm1-1_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_bcc-csm1-1_rcp60_r1i1p1_200601-209912.nc", 
            "pr_Amon_bcc-csm1-1_rcp60_r1i1p1_210001-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1/historical",
      gridfile.filename = "tas_Amon_bcc-csm1-1_historical_r1i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'BCC-CSM1-1-m-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "BCC-CSM1-1-m",
      gcm.run = 1,
      institute = "BCC",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1(m)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1(m)/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1(m)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1(m)/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_bcc-csm1-1-m_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_bcc-csm1-1-m_rcp60_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_bcc-csm1-1-m_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_bcc-csm1-1-m_rcp60_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/BCC-CSM1.1(m)/historical",
      gridfile.filename = "tas_Amon_bcc-csm1-1-m_historical_r1i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 1,
      institute = "NCAR",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_CCSM4_rcp60_r1i1p1_200501-210012.nc", 
            "tas_Amon_CCSM4_rcp60_r1i1p1_200601-210012.nc", 
            "tas_Amon_CCSM4_rcp60_r1i1p1_210101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp60_r1i1p1_200601-210012.nc", 
            "pr_Amon_CCSM4_rcp60_r1i1p1_210101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r2i1p1_rcp60' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 2,
      institute = "NCAR",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_CCSM4_rcp60_r2i1p1_200501-210012.nc", 
            "tas_Amon_CCSM4_rcp60_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp60_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r3i1p1_rcp60' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 3,
      institute = "NCAR",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_CCSM4_rcp60_r3i1p1_200501-210012.nc", 
            "tas_Amon_CCSM4_rcp60_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp60_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r4i1p1_rcp60' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 4,
      institute = "NCAR",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_CCSM4_rcp60_r4i1p1_200501-210012.nc", 
            "tas_Amon_CCSM4_rcp60_r4i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp60_r4i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r4i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r5i1p1_rcp60' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 5,
      institute = "NCAR",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
##            "tas_Amon_CCSM4_rcp60_r5i1p1_200501-210012.nc", 
            "tas_Amon_CCSM4_rcp60_r5i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp60_r5i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r5i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CCSM4-r6i1p1_rcp60' = list( 
      rcm = "",
      gcm = "CCSM4",
      gcm.run = 6,
      institute = "NCAR",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CCSM4_historical_r6i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CCSM4_rcp60_r6i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CCSM4_historical_r6i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CCSM4_rcp60_r6i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CCSM4/historical",
      gridfile.filename = "tas_Amon_CCSM4_historical_r6i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CESM1-CAM5-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "CESM1-CAM5",
      gcm.run = 1,
      institute = "NSF-DOE-NCAR",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CESM1-CAM5_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CESM1-CAM5_rcp60_r1i1p1_200601-210012.nc", 
            "tas_Amon_CESM1-CAM5_rcp60_r1i1p1_210101-230012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CESM1-CAM5_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CESM1-CAM5_rcp60_r1i1p1_200601-210012.nc", 
            "pr_Amon_CESM1-CAM5_rcp60_r1i1p1_210101-230012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
      gridfile.filename = "tas_Amon_CESM1-CAM5_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CESM1-CAM5-r2i1p1_rcp60' = list( 
      rcm = "",
      gcm = "CESM1-CAM5",
      gcm.run = 2,
      institute = "NSF-DOE-NCAR",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CESM1-CAM5_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CESM1-CAM5_rcp60_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CESM1-CAM5_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CESM1-CAM5_rcp60_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
      gridfile.filename = "tas_Amon_CESM1-CAM5_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CESM1-CAM5-r3i1p1_rcp60' = list( 
      rcm = "",
      gcm = "CESM1-CAM5",
      gcm.run = 3,
      institute = "NSF-DOE-NCAR",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CESM1-CAM5_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CESM1-CAM5_rcp60_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CESM1-CAM5_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CESM1-CAM5_rcp60_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CESM1(CAM5)/historical",
      gridfile.filename = "tas_Amon_CESM1-CAM5_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r10i1p1_rcp60' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 10,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r10i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp60_r10i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r10i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp60_r10i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r10i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 1,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp60_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp60_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r2i1p1_rcp60' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 2,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp60_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp60_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r3i1p1_rcp60' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 3,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp60_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp60_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r4i1p1_rcp60' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 4,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp60_r4i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r4i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp60_r4i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r4i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r5i1p1_rcp60' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 5,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp60_r5i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r5i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp60_r5i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r5i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r6i1p1_rcp60' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 6,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r6i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp60_r6i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r6i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp60_r6i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r6i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r7i1p1_rcp60' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 7,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r7i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp60_r7i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r7i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp60_r7i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r7i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r8i1p1_rcp60' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 8,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r8i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp60_r8i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r8i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp60_r8i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r8i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'CSIRO-Mk3-6-0-r9i1p1_rcp60' = list( 
      rcm = "",
      gcm = "CSIRO-Mk3-6-0",
      gcm.run = 9,
      institute = "CSIRO-QCCCE",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_CSIRO-Mk3-6-0_historical_r9i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_CSIRO-Mk3-6-0_rcp60_r9i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_CSIRO-Mk3-6-0_historical_r9i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_CSIRO-Mk3-6-0_rcp60_r9i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/CSIRO-Mk3.6.0/historical",
      gridfile.filename = "tas_Amon_CSIRO-Mk3-6-0_historical_r9i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'FGOALS-s2-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "FGOALS-s2",
      gcm.run = 1,
      institute = "LASG-IAP",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-s2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-s2/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-s2/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-s2/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_FGOALS-s2_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_FGOALS-s2_rcp60_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_FGOALS-s2_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_FGOALS-s2_rcp60_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FGOALS-s2/historical",
      gridfile.filename = "tas_Amon_FGOALS-s2_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'FIO-ESM-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "FIO-ESM",
      gcm.run = 1,
      institute = "FIO",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_FIO-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_FIO-ESM_rcp60_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_FIO-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_FIO-ESM_rcp60_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
      gridfile.filename = "tas_Amon_FIO-ESM_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'FIO-ESM-r2i1p1_rcp60' = list( 
      rcm = "",
      gcm = "FIO-ESM",
      gcm.run = 2,
      institute = "FIO",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_FIO-ESM_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_FIO-ESM_rcp60_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_FIO-ESM_historical_r2i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_FIO-ESM_rcp60_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
      gridfile.filename = "tas_Amon_FIO-ESM_historical_r2i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'FIO-ESM-r3i1p1_rcp60' = list( 
      rcm = "",
      gcm = "FIO-ESM",
      gcm.run = 3,
      institute = "FIO",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_FIO-ESM_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_FIO-ESM_rcp60_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_FIO-ESM_historical_r3i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_FIO-ESM_rcp60_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/FIO-ESM/historical",
      gridfile.filename = "tas_Amon_FIO-ESM_historical_r3i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-CM3-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "GFDL-CM3",
      gcm.run = 1,
      institute = "NOAA GFDL",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM3/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM3/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-CM3_historical_r1i1p1_186001-186412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_186501-186912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_187001-187412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_187501-187912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_188001-188412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_188501-188912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_189001-189412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_189501-189912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_190001-190412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_190501-190912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_191001-191412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_191501-191912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_192001-192412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_192501-192912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_193001-193412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_193501-193912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_194001-194412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_194501-194912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_195001-195412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_195501-195912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_196001-196412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_196501-196912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_197001-197412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_197501-197912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_198001-198412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_198501-198912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_199001-199412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_199501-199912.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_200001-200412.nc", 
            "tas_Amon_GFDL-CM3_historical_r1i1p1_200501-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-CM3_rcp60_r1i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-CM3_rcp60_r1i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-CM3_rcp60_r1i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-CM3_rcp60_r1i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-CM3_rcp60_r1i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-CM3_rcp60_r1i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-CM3_rcp60_r1i1p1_203601-204012.nc", 
            "tas_Amon_GFDL-CM3_rcp60_r1i1p1_204101-204512.nc", 
            "tas_Amon_GFDL-CM3_rcp60_r1i1p1_204601-205012.nc", 
            "tas_Amon_GFDL-CM3_rcp60_r1i1p1_205101-205512.nc", 
            "tas_Amon_GFDL-CM3_rcp60_r1i1p1_205601-206012.nc", 
            "tas_Amon_GFDL-CM3_rcp60_r1i1p1_206101-206512.nc", 
            "tas_Amon_GFDL-CM3_rcp60_r1i1p1_206601-207012.nc", 
            "tas_Amon_GFDL-CM3_rcp60_r1i1p1_207101-207512.nc", 
            "tas_Amon_GFDL-CM3_rcp60_r1i1p1_207601-208012.nc", 
            "tas_Amon_GFDL-CM3_rcp60_r1i1p1_208101-208512.nc", 
            "tas_Amon_GFDL-CM3_rcp60_r1i1p1_208601-209012.nc", 
            "tas_Amon_GFDL-CM3_rcp60_r1i1p1_209101-209512.nc", 
            "tas_Amon_GFDL-CM3_rcp60_r1i1p1_209601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-CM3_historical_r1i1p1_186001-186412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_186501-186912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_187001-187412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_187501-187912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_188001-188412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_188501-188912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_189001-189412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_189501-189912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_190001-190412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_190501-190912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_191001-191412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_191501-191912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_192001-192412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_192501-192912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_193001-193412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_193501-193912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_194001-194412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_194501-194912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_195001-195412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_195501-195912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_196001-196412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_196501-196912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_197001-197412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_197501-197912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_198001-198412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_198501-198912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_199001-199412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_199501-199912.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_200001-200412.nc", 
            "pr_Amon_GFDL-CM3_historical_r1i1p1_200501-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-CM3_rcp60_r1i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-CM3_rcp60_r1i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-CM3_rcp60_r1i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-CM3_rcp60_r1i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-CM3_rcp60_r1i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-CM3_rcp60_r1i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-CM3_rcp60_r1i1p1_203601-204012.nc", 
            "pr_Amon_GFDL-CM3_rcp60_r1i1p1_204101-204512.nc", 
            "pr_Amon_GFDL-CM3_rcp60_r1i1p1_204601-205012.nc", 
            "pr_Amon_GFDL-CM3_rcp60_r1i1p1_205101-205512.nc", 
            "pr_Amon_GFDL-CM3_rcp60_r1i1p1_205601-206012.nc", 
            "pr_Amon_GFDL-CM3_rcp60_r1i1p1_206101-206512.nc", 
            "pr_Amon_GFDL-CM3_rcp60_r1i1p1_206601-207012.nc", 
            "pr_Amon_GFDL-CM3_rcp60_r1i1p1_207101-207512.nc", 
            "pr_Amon_GFDL-CM3_rcp60_r1i1p1_207601-208012.nc", 
            "pr_Amon_GFDL-CM3_rcp60_r1i1p1_208101-208512.nc", 
            "pr_Amon_GFDL-CM3_rcp60_r1i1p1_208601-209012.nc", 
            "pr_Amon_GFDL-CM3_rcp60_r1i1p1_209101-209512.nc", 
            "pr_Amon_GFDL-CM3_rcp60_r1i1p1_209601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-CM3/historical",
      gridfile.filename = "tas_Amon_GFDL-CM3_historical_r1i1p1_186001-186412.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-ESM2G-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "GFDL-ESM2G",
      gcm.run = 1,
      institute = "NOAA GFDL",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2G/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2G/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2G/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2G/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_186101-186512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_186601-187012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_187101-187512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_187601-188012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_188101-188512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_188601-189012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_189101-189512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_189601-190012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_190101-190512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_190601-191012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_191101-191512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_191601-192012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_192101-192512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_192601-193012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_193101-193512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_193601-194012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_194101-194512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_194601-195012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_195101-195512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_195601-196012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_196101-196512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_196601-197012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_197101-197512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_197601-198012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_198101-198512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_198601-199012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_199101-199512.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_199601-200012.nc", 
            "tas_Amon_GFDL-ESM2G_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-ESM2G_rcp60_r1i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp60_r1i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp60_r1i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp60_r1i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp60_r1i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp60_r1i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp60_r1i1p1_203601-204012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp60_r1i1p1_204101-204512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp60_r1i1p1_204601-205012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp60_r1i1p1_205101-205512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp60_r1i1p1_205601-206012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp60_r1i1p1_206101-206512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp60_r1i1p1_206601-207012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp60_r1i1p1_207101-207512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp60_r1i1p1_207601-208012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp60_r1i1p1_208101-208512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp60_r1i1p1_208601-209012.nc", 
            "tas_Amon_GFDL-ESM2G_rcp60_r1i1p1_209101-209512.nc", 
            "tas_Amon_GFDL-ESM2G_rcp60_r1i1p1_209601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_186101-186512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_186601-187012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_187101-187512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_187601-188012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_188101-188512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_188601-189012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_189101-189512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_189601-190012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_190101-190512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_190601-191012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_191101-191512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_191601-192012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_192101-192512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_192601-193012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_193101-193512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_193601-194012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_194101-194512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_194601-195012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_195101-195512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_195601-196012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_196101-196512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_196601-197012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_197101-197512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_197601-198012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_198101-198512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_198601-199012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_199101-199512.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_199601-200012.nc", 
            "pr_Amon_GFDL-ESM2G_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-ESM2G_rcp60_r1i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp60_r1i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp60_r1i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp60_r1i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp60_r1i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp60_r1i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp60_r1i1p1_203601-204012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp60_r1i1p1_204101-204512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp60_r1i1p1_204601-205012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp60_r1i1p1_205101-205512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp60_r1i1p1_205601-206012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp60_r1i1p1_206101-206512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp60_r1i1p1_206601-207012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp60_r1i1p1_207101-207512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp60_r1i1p1_207601-208012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp60_r1i1p1_208101-208512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp60_r1i1p1_208601-209012.nc", 
            "pr_Amon_GFDL-ESM2G_rcp60_r1i1p1_209101-209512.nc", 
            "pr_Amon_GFDL-ESM2G_rcp60_r1i1p1_209601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2G/historical",
      gridfile.filename = "tas_Amon_GFDL-ESM2G_historical_r1i1p1_186101-186512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GFDL-ESM2M-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "GFDL-ESM2M",
      gcm.run = 1,
      institute = "NOAA GFDL",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2M/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2M/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2M/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2M/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_186101-186512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_186601-187012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_187101-187512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_187601-188012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_188101-188512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_188601-189012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_189101-189512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_189601-190012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_190101-190512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_190601-191012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_191101-191512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_191601-192012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_192101-192512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_192601-193012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_193101-193512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_193601-194012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_194101-194512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_194601-195012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_195101-195512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_195601-196012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_196101-196512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_196601-197012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_197101-197512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_197601-198012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_198101-198512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_198601-199012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_199101-199512.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_199601-200012.nc", 
            "tas_Amon_GFDL-ESM2M_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GFDL-ESM2M_rcp60_r1i1p1_200601-201012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp60_r1i1p1_201101-201512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp60_r1i1p1_201601-202012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp60_r1i1p1_202101-202512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp60_r1i1p1_202601-203012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp60_r1i1p1_203101-203512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp60_r1i1p1_203601-204012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp60_r1i1p1_204101-204512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp60_r1i1p1_204601-205012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp60_r1i1p1_205101-205512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp60_r1i1p1_205601-206012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp60_r1i1p1_206101-206512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp60_r1i1p1_206601-207012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp60_r1i1p1_207101-207512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp60_r1i1p1_207601-208012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp60_r1i1p1_208101-208512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp60_r1i1p1_208601-209012.nc", 
            "tas_Amon_GFDL-ESM2M_rcp60_r1i1p1_209101-209512.nc", 
            "tas_Amon_GFDL-ESM2M_rcp60_r1i1p1_209601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_186101-186512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_186601-187012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_187101-187512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_187601-188012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_188101-188512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_188601-189012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_189101-189512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_189601-190012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_190101-190512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_190601-191012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_191101-191512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_191601-192012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_192101-192512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_192601-193012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_193101-193512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_193601-194012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_194101-194512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_194601-195012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_195101-195512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_195601-196012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_196101-196512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_196601-197012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_197101-197512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_197601-198012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_198101-198512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_198601-199012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_199101-199512.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_199601-200012.nc", 
            "pr_Amon_GFDL-ESM2M_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GFDL-ESM2M_rcp60_r1i1p1_200601-201012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp60_r1i1p1_201101-201512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp60_r1i1p1_201601-202012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp60_r1i1p1_202101-202512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp60_r1i1p1_202601-203012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp60_r1i1p1_203101-203512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp60_r1i1p1_203601-204012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp60_r1i1p1_204101-204512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp60_r1i1p1_204601-205012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp60_r1i1p1_205101-205512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp60_r1i1p1_205601-206012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp60_r1i1p1_206101-206512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp60_r1i1p1_206601-207012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp60_r1i1p1_207101-207512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp60_r1i1p1_207601-208012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp60_r1i1p1_208101-208512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp60_r1i1p1_208601-209012.nc", 
            "pr_Amon_GFDL-ESM2M_rcp60_r1i1p1_209101-209512.nc", 
            "pr_Amon_GFDL-ESM2M_rcp60_r1i1p1_209601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GFDL-ESM2M/historical",
      gridfile.filename = "tas_Amon_GFDL-ESM2M_historical_r1i1p1_186101-186512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r1i1p1_185001-190012.nc", 
            "tas_Amon_GISS-E2-H_historical_r1i1p1_190101-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r1i1p1_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp60_r1i1p1_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp60_r1i1p1_205101-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r1i1p1_185001-190012.nc", 
            "pr_Amon_GISS-E2-H_historical_r1i1p1_190101-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r1i1p1_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp60_r1i1p1_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp60_r1i1p1_205101-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r1i1p1_185001-190012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r1i1p2_rcp60' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r1i1p2_185001-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r1i1p2_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp60_r1i1p2_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp60_r1i1p2_205101-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r1i1p2_185001-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r1i1p2_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp60_r1i1p2_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp60_r1i1p2_205101-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r1i1p2_185001-195012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-H-r1i1p3_rcp60' = list( 
      rcm = "",
      gcm = "GISS-E2-H",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-H_historical_r1i1p3_185001-190012.nc", 
            "tas_Amon_GISS-E2-H_historical_r1i1p3_190101-195012.nc", 
            "tas_Amon_GISS-E2-H_historical_r1i1p3_195101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-H_rcp60_r1i1p3_200601-205012.nc", 
            "tas_Amon_GISS-E2-H_rcp60_r1i1p3_205101-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-H_historical_r1i1p3_185001-190012.nc", 
            "pr_Amon_GISS-E2-H_historical_r1i1p3_190101-195012.nc", 
            "pr_Amon_GISS-E2-H_historical_r1i1p3_195101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-H_rcp60_r1i1p3_200601-205012.nc", 
            "pr_Amon_GISS-E2-H_rcp60_r1i1p3_205101-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-H/historical",
      gridfile.filename = "tas_Amon_GISS-E2-H_historical_r1i1p3_185001-190012.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r1i1p1_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp60_r1i1p1_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp60_r1i1p1_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp60_r1i1p1_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp60_r1i1p1_207601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r1i1p1_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p1_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp60_r1i1p1_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp60_r1i1p1_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp60_r1i1p1_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp60_r1i1p1_207601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r1i1p1_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r1i1p2_rcp60' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r1i1p2_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p2_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp60_r1i1p2_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp60_r1i1p2_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp60_r1i1p2_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp60_r1i1p2_207601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r1i1p2_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p2_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp60_r1i1p2_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp60_r1i1p2_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp60_r1i1p2_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp60_r1i1p2_207601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r1i1p2_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'GISS-E2-R-r1i1p3_rcp60' = list( 
      rcm = "",
      gcm = "GISS-E2-R",
      gcm.run = 1,
      institute = "NASA GISS",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_GISS-E2-R_historical_r1i1p3_185001-187512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_187601-190012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_190101-192512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_192601-195012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_195101-197512.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_197601-200012.nc", 
            "tas_Amon_GISS-E2-R_historical_r1i1p3_200101-200512.nc"
            ),
          scenario = c(
            "tas_Amon_GISS-E2-R_rcp60_r1i1p3_200601-202512.nc", 
            "tas_Amon_GISS-E2-R_rcp60_r1i1p3_202601-205012.nc", 
            "tas_Amon_GISS-E2-R_rcp60_r1i1p3_205101-207512.nc", 
            "tas_Amon_GISS-E2-R_rcp60_r1i1p3_207601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_GISS-E2-R_historical_r1i1p3_185001-187512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_187601-190012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_190101-192512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_192601-195012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_195101-197512.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_197601-200012.nc", 
            "pr_Amon_GISS-E2-R_historical_r1i1p3_200101-200512.nc"
            ),
          scenario = c(
            "pr_Amon_GISS-E2-R_rcp60_r1i1p3_200601-202512.nc", 
            "pr_Amon_GISS-E2-R_rcp60_r1i1p3_202601-205012.nc", 
            "pr_Amon_GISS-E2-R_rcp60_r1i1p3_205101-207512.nc", 
            "pr_Amon_GISS-E2-R_rcp60_r1i1p3_207601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/GISS-E2-R/historical",
      gridfile.filename = "tas_Amon_GISS-E2-R_historical_r1i1p3_185001-187512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-AO-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "HadGEM2-AO",
      gcm.run = 1,
      institute = "NIMR/KMA",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-AO/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-AO/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-AO/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-AO/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-AO_historical_r1i1p1_186001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_HadGEM2-AO_rcp60_r1i1p1_200601-209912.nc" 
##            "tas_Amon_HadGEM2-AO_rcp60_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-AO_historical_r1i1p1_186001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_HadGEM2-AO_rcp60_r1i1p1_200601-209912.nc" 
##            "pr_Amon_HadGEM2-AO_rcp60_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-AO/historical",
      gridfile.filename = "tas_Amon_HadGEM2-AO_historical_r1i1p1_186001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-ES-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "HadGEM2-ES",
      gcm.run = 1,
      institute = "MOHC",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_185912-188411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_188412-190911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_190912-193411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_193412-195911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_195912-198411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r1i1p1_198412-200511.nc"
            ),
          scenario = c(
            "tas_Amon_HadGEM2-ES_rcp60_r1i1p1_200512-201111.nc", 
            "tas_Amon_HadGEM2-ES_rcp60_r1i1p1_201112-203611.nc", 
            "tas_Amon_HadGEM2-ES_rcp60_r1i1p1_203612-206111.nc", 
            "tas_Amon_HadGEM2-ES_rcp60_r1i1p1_206112-208611.nc", 
            "tas_Amon_HadGEM2-ES_rcp60_r1i1p1_208612-209911.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_185912-188411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_188412-190911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_190912-193411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_193412-195911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_195912-198411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r1i1p1_198412-200511.nc"
            ),
          scenario = c(
            "pr_Amon_HadGEM2-ES_rcp60_r1i1p1_200512-201111.nc", 
            "pr_Amon_HadGEM2-ES_rcp60_r1i1p1_201112-203611.nc", 
            "pr_Amon_HadGEM2-ES_rcp60_r1i1p1_203612-206111.nc", 
            "pr_Amon_HadGEM2-ES_rcp60_r1i1p1_206112-208611.nc", 
            "pr_Amon_HadGEM2-ES_rcp60_r1i1p1_208612-209911.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
      gridfile.filename = "tas_Amon_HadGEM2-ES_historical_r1i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-ES-r2i1p1_rcp60' = list( 
      rcm = "",
      gcm = "HadGEM2-ES",
      gcm.run = 2,
      institute = "MOHC",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_185912-188411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_188412-190911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_190912-193411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_193412-195911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_195912-198411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r2i1p1_198412-200512.nc"
            ),
          scenario = c(
            "tas_Amon_HadGEM2-ES_rcp60_r2i1p1_200512-203011.nc", 
            "tas_Amon_HadGEM2-ES_rcp60_r2i1p1_203012-205511.nc", 
            "tas_Amon_HadGEM2-ES_rcp60_r2i1p1_205512-208011.nc", 
            "tas_Amon_HadGEM2-ES_rcp60_r2i1p1_208012-210011.nc", 
            "tas_Amon_HadGEM2-ES_rcp60_r2i1p1_210012-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_185912-188411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_188412-190911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_190912-193411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_193412-195911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_195912-198411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r2i1p1_198412-200512.nc"
            ),
          scenario = c(
            "pr_Amon_HadGEM2-ES_rcp60_r2i1p1_200512-203011.nc", 
            "pr_Amon_HadGEM2-ES_rcp60_r2i1p1_203012-205511.nc", 
            "pr_Amon_HadGEM2-ES_rcp60_r2i1p1_205512-208011.nc", 
            "pr_Amon_HadGEM2-ES_rcp60_r2i1p1_208012-210011.nc", 
            "pr_Amon_HadGEM2-ES_rcp60_r2i1p1_210012-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
      gridfile.filename = "tas_Amon_HadGEM2-ES_historical_r2i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-ES-r3i1p1_rcp60' = list( 
      rcm = "",
      gcm = "HadGEM2-ES",
      gcm.run = 3,
      institute = "MOHC",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_185912-188411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_188412-190911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_190912-193411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_193412-195911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_195912-198411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r3i1p1_198412-200512.nc"
            ),
          scenario = c(
            "tas_Amon_HadGEM2-ES_rcp60_r3i1p1_200512-203011.nc", 
            "tas_Amon_HadGEM2-ES_rcp60_r3i1p1_203012-205511.nc", 
            "tas_Amon_HadGEM2-ES_rcp60_r3i1p1_205512-208011.nc", 
            "tas_Amon_HadGEM2-ES_rcp60_r3i1p1_208012-210011.nc", 
            "tas_Amon_HadGEM2-ES_rcp60_r3i1p1_210012-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_185912-188411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_188412-190911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_190912-193411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_193412-195911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_195912-198411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r3i1p1_198412-200512.nc"
            ),
          scenario = c(
            "pr_Amon_HadGEM2-ES_rcp60_r3i1p1_200512-203011.nc", 
            "pr_Amon_HadGEM2-ES_rcp60_r3i1p1_203012-205511.nc", 
            "pr_Amon_HadGEM2-ES_rcp60_r3i1p1_205512-208011.nc", 
            "pr_Amon_HadGEM2-ES_rcp60_r3i1p1_208012-210011.nc", 
            "pr_Amon_HadGEM2-ES_rcp60_r3i1p1_210012-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
      gridfile.filename = "tas_Amon_HadGEM2-ES_historical_r3i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'HadGEM2-ES-r4i1p1_rcp60' = list( 
      rcm = "",
      gcm = "HadGEM2-ES",
      gcm.run = 4,
      institute = "MOHC",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_185912-188411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_188412-190911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_190912-193411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_193412-195911.nc", 
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_195912-198411.nc", 
            "tas_Amon_HadGEM2-ES_historical_r4i1p1_198412-200511.nc"
            ),
          scenario = c(
            "tas_Amon_HadGEM2-ES_rcp60_r4i1p1_200512-203011.nc", 
            "tas_Amon_HadGEM2-ES_rcp60_r4i1p1_203012-205511.nc", 
            "tas_Amon_HadGEM2-ES_rcp60_r4i1p1_205512-208011.nc", 
            "tas_Amon_HadGEM2-ES_rcp60_r4i1p1_208012-210011.nc", 
            "tas_Amon_HadGEM2-ES_rcp60_r4i1p1_210012-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_185912-188411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_188412-190911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_190912-193411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_193412-195911.nc", 
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_195912-198411.nc", 
            "pr_Amon_HadGEM2-ES_historical_r4i1p1_198412-200511.nc"
            ),
          scenario = c(
            "pr_Amon_HadGEM2-ES_rcp60_r4i1p1_200512-203011.nc", 
            "pr_Amon_HadGEM2-ES_rcp60_r4i1p1_203012-205511.nc", 
            "pr_Amon_HadGEM2-ES_rcp60_r4i1p1_205512-208011.nc", 
            "pr_Amon_HadGEM2-ES_rcp60_r4i1p1_208012-210011.nc", 
            "pr_Amon_HadGEM2-ES_rcp60_r4i1p1_210012-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/HadGEM2-ES/historical",
      gridfile.filename = "tas_Amon_HadGEM2-ES_historical_r4i1p1_185912-188411.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'IPSL-CM5A-LR-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "IPSL-CM5A-LR",
      gcm.run = 1,
      institute = "IPSL",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_IPSL-CM5A-LR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_IPSL-CM5A-LR_rcp60_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_IPSL-CM5A-LR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_IPSL-CM5A-LR_rcp60_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-LR/historical",
      gridfile.filename = "tas_Amon_IPSL-CM5A-LR_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'IPSL-CM5A-MR-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "IPSL-CM5A-MR",
      gcm.run = 1,
      institute = "IPSL",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-MR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-MR/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-MR/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-MR/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_IPSL-CM5A-MR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_IPSL-CM5A-MR_rcp60_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_IPSL-CM5A-MR_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_IPSL-CM5A-MR_rcp60_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/IPSL-CM5A-MR/historical",
      gridfile.filename = "tas_Amon_IPSL-CM5A-MR_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC5-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "MIROC5",
      gcm.run = 1,
      institute = "MIROC",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC5_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC5_rcp60_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC5_historical_r1i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC5_rcp60_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
      gridfile.filename = "tas_Amon_MIROC5_historical_r1i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC5-r2i1p1_rcp60' = list( 
      rcm = "",
      gcm = "MIROC5",
      gcm.run = 2,
      institute = "MIROC",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC5_historical_r2i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC5_rcp60_r2i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC5_historical_r2i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC5_rcp60_r2i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
      gridfile.filename = "tas_Amon_MIROC5_historical_r2i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC5-r3i1p1_rcp60' = list( 
      rcm = "",
      gcm = "MIROC5",
      gcm.run = 3,
      institute = "MIROC",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC5_historical_r3i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC5_rcp60_r3i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC5_historical_r3i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC5_rcp60_r3i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
      gridfile.filename = "tas_Amon_MIROC5_historical_r3i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC5-r4i1p1_rcp60' = list( 
      rcm = "",
      gcm = "MIROC5",
      gcm.run = 4,
      institute = "MIROC",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC5_historical_r4i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC5_rcp60_r4i1p1_200601-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC5_historical_r4i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC5_rcp60_r4i1p1_200601-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
      gridfile.filename = "tas_Amon_MIROC5_historical_r4i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC5-r5i1p1_rcp60' = list( 
      rcm = "",
      gcm = "MIROC5",
      gcm.run = 5,
      institute = "MIROC",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC5_historical_r5i1p1_185001-201212.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC5_rcp60_r5i1p1_200601-203512.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC5_historical_r5i1p1_185001-201212.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC5_rcp60_r5i1p1_200601-203512.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC5/historical",
      gridfile.filename = "tas_Amon_MIROC5_historical_r5i1p1_185001-201212.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC-ESM-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "MIROC-ESM",
      gcm.run = 1,
      institute = "MIROC",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC-ESM_rcp60_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC-ESM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC-ESM_rcp60_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM/historical",
      gridfile.filename = "tas_Amon_MIROC-ESM_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MIROC-ESM-CHEM-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "MIROC-ESM-CHEM",
      gcm.run = 1,
      institute = "MIROC",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM-CHEM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM-CHEM/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM-CHEM/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM-CHEM/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MIROC-ESM-CHEM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MIROC-ESM-CHEM_rcp60_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MIROC-ESM-CHEM_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MIROC-ESM-CHEM_rcp60_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MIROC-ESM-CHEM/historical",
      gridfile.filename = "tas_Amon_MIROC-ESM-CHEM_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'MRI-CGCM3-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "MRI-CGCM3",
      gcm.run = 1,
      institute = "MRI",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-CGCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-CGCM3/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-CGCM3/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-CGCM3/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_MRI-CGCM3_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_MRI-CGCM3_rcp60_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_MRI-CGCM3_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_MRI-CGCM3_rcp60_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/MRI-CGCM3/historical",
      gridfile.filename = "tas_Amon_MRI-CGCM3_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'NorESM1-M-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "NorESM1-M",
      gcm.run = 1,
      institute = "NCC",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-M/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-M/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-M/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-M/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_NorESM1-M_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_NorESM1-M_rcp60_r1i1p1_200601-210012.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_NorESM1-M_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_NorESM1-M_rcp60_r1i1p1_200601-210012.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-M/historical",
      gridfile.filename = "tas_Amon_NorESM1-M_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),

################################################################################
    'NorESM1-ME-r1i1p1_rcp60' = list( 
      rcm = "",
      gcm = "NorESM1-ME",
      gcm.run = 1,
      institute = "NCC",
      emission.scenario = "rcp60",
      file.path.alt = list(
        air_temperature =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-ME/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-ME/rcp60"),
        precipitation_amount =
        list(historical = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-ME/historical",
             scenario =  "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-ME/rcp60")),
      file.name = list(
        air_temperature = list(
          historical = c(
            "tas_Amon_NorESM1-ME_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "tas_Amon_NorESM1-ME_rcp60_r1i1p1_200601-205012.nc", 
            "tas_Amon_NorESM1-ME_rcp60_r1i1p1_205101-210112.nc"
            )),
        precipitation_amount = list(
          historical = c(
            "pr_Amon_NorESM1-ME_historical_r1i1p1_185001-200512.nc"
            ),
          scenario = c(
            "pr_Amon_NorESM1-ME_rcp60_r1i1p1_200601-205012.nc", 
            "pr_Amon_NorESM1-ME_rcp60_r1i1p1_205101-210112.nc"
           ))),
      gridfile.path = "/data/reloclim/rcm/CMIP5_update_2013_02_07/NorESM1-ME/historical",
      gridfile.filename = "tas_Amon_NorESM1-ME_historical_r1i1p1_185001-200512.nc",
      resolution = "",
      what.timesteps = "monthly"
      ),
## acrnonyms: , 
##  BCC-CSM1-1-r1i1p1_rcp60, 
##  BCC-CSM1-1-m-r1i1p1_rcp60, 
##  CCSM4-r1i1p1_rcp60, 
##  CCSM4-r2i1p1_rcp60, 
##  CCSM4-r3i1p1_rcp60, 
##  CCSM4-r4i1p1_rcp60, 
##  CCSM4-r5i1p1_rcp60, 
##  CCSM4-r6i1p1_rcp60, 
##  CESM1-CAM5-r1i1p1_rcp60, 
##  CESM1-CAM5-r2i1p1_rcp60, 
##  CESM1-CAM5-r3i1p1_rcp60, 
##  CSIRO-Mk3-6-0-r10i1p1_rcp60, 
##  CSIRO-Mk3-6-0-r1i1p1_rcp60, 
##  CSIRO-Mk3-6-0-r2i1p1_rcp60, 
##  CSIRO-Mk3-6-0-r3i1p1_rcp60, 
##  CSIRO-Mk3-6-0-r4i1p1_rcp60, 
##  CSIRO-Mk3-6-0-r5i1p1_rcp60, 
##  CSIRO-Mk3-6-0-r6i1p1_rcp60, 
##  CSIRO-Mk3-6-0-r7i1p1_rcp60, 
##  CSIRO-Mk3-6-0-r8i1p1_rcp60, 
##  CSIRO-Mk3-6-0-r9i1p1_rcp60, 
##  FGOALS-s2-r1i1p1_rcp60, 
##  FIO-ESM-r1i1p1_rcp60, 
##  FIO-ESM-r2i1p1_rcp60, 
##  FIO-ESM-r3i1p1_rcp60, 
##  GFDL-CM3-r1i1p1_rcp60, 
##  GFDL-ESM2G-r1i1p1_rcp60, 
##  GFDL-ESM2M-r1i1p1_rcp60, 
##  GISS-E2-H-r1i1p1_rcp60, 
##  GISS-E2-H-r1i1p2_rcp60, 
##  GISS-E2-H-r1i1p3_rcp60, 
##  GISS-E2-R-r1i1p1_rcp60, 
##  GISS-E2-R-r1i1p2_rcp60, 
##  GISS-E2-R-r1i1p3_rcp60, 
##  HadGEM2-AO-r1i1p1_rcp60, 
##  HadGEM2-ES-r1i1p1_rcp60, 
##  HadGEM2-ES-r2i1p1_rcp60, 
##  HadGEM2-ES-r3i1p1_rcp60, 
##  HadGEM2-ES-r4i1p1_rcp60, 
##  IPSL-CM5A-LR-r1i1p1_rcp60, 
##  IPSL-CM5A-MR-r1i1p1_rcp60, 
##  MIROC5-r1i1p1_rcp60, 
##  MIROC5-r2i1p1_rcp60, 
##  MIROC5-r3i1p1_rcp60, 
##  MIROC5-r4i1p1_rcp60, 
##  MIROC5-r5i1p1_rcp60, 
##  MIROC-ESM-r1i1p1_rcp60, 
##  MIROC-ESM-CHEM-r1i1p1_rcp60, 
##  MRI-CGCM3-r1i1p1_rcp60, 
##  NorESM1-M-r1i1p1_rcp60, 
##  NorESM1-ME-r1i1p1_rcp60

################################################################################



###++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
###+++++++++++++++++++++++++++++DATASET: SCHOENER ENSEMBLES QM+++++++++++++++
###++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

###########################################################################
    'METO-HC_HadRM3Q0_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "HadRM3",
      gcm = "HadCM3Q0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/HC/HadRM3Q0/HadCM3Q0_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/HC/HadRM3Q0/HadCM3Q0_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'METO-HC_HadRM3Q16_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "HadRM3",
      gcm = "HadCM3Q16",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/HC/HadRM3Q16/HadCM3Q16_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/HC/HadRM3Q16/HadCM3Q16_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'METO-HC_HadRM3Q3_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "HadRM3",
      gcm = "HadCM3Q3",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/HC/HadRM3Q3/HadCM3Q3_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/HC/HadRM3Q3/HadCM3Q3_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'ETHZ-CLM_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "CLM",
      gcm = "HadCM3Q0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/ETHZ/CLM/HadCM3Q0_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/ETHZ/CLM/HadCM3Q0_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'METNOHIRHAM_HadCM3Q0_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "HIRHAM",
      gcm = "HadCM3Q0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/METNO/HIRHAM/HadCM3Q0_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/METNO/HIRHAM/HadCM3Q0_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'METNOHIRHAM_BCM_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "HIRHAM",
      gcm = "BCCR-BCM2.0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/METNO/HIRHAM/BCM_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/METNO/HIRHAM/BCM_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'ICTP-REGCM3_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "RegCM",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/ICTP/RegCM/ECHAM5-r3_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/ICTP/RegCM/ECHAM5-r3_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'MPI-M-REMO_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "REMO",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/MPI/REMO/ECHAM5-r3_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/MPI/REMO/ECHAM5-r3_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'C4IRCA3_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "RCA3",
      gcm = "HadCM3Q16",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/C4I/RCA/HadCM3Q16_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/C4I/RCA/HadCM3Q16_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'CNRM-RM5.1_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "RM5.1",
      gcm = "ARPEGE",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/CNRM/ALADIN/ARPEGE5.1_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/CNRM/ALADIN/ARPEGE5.1_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'CNRM-RM4.5_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "RM4.5",
      gcm = "ARPEGE",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/CNRM/ALADIN/ARPEGE4.5_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/CNRM/ALADIN/ARPEGE4.5_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'DMI-HIRHAM5_ARPEGE_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "HIRHAM",
      gcm = "ARPEGE",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/DMI/HIRHAM/ARPEGE_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/DMI/HIRHAM/ARPEGE_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'DMI-HIRHAM5_ECHAM5_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "HIRHAM",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/DMI/HIRHAM/ECHAM5-r3_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/DMI/HIRHAM/ECHAM5-r3_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'DMI-HIRHAM5_BCM_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "HIRHAM",
      gcm = "BCCR-BCM2.0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/DMI/HIRHAM/BCM_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/DMI/HIRHAM/BCM_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'GKSS-CCLM4.8_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "CLM",
      gcm = "IPSL-CM4",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/GKSS/CLM/IPSL_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/GKSS/CLM/IPSL_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'KNMI-RACMO2_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "RACMO",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/KNMI/RACMO/ECHAM5-r3_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/KNMI/RACMO/ECHAM5-r3_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'OURANOSMRCC4.2.1_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "CRCM",
      gcm = "CGCM3",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/OURANOS/CRCM/CGCM3_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/OURANOS/CRCM/CGCM3_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'SMHIRCA_BCM_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "RCA",
      gcm = "BCCR-BCM2.0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/SMHI/RCA/BCM_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/SMHI/RCA/BCM_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'SMHIRCA_ECHAM5-r3_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "RCA",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/SMHI/RCA/ECHAM5-r3_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/SMHI/RCA/ECHAM5-r3_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'SMHIRCA_HadCM3Q3_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "RCA",
      gcm = "HadCM3Q3",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/SMHI/RCA/HadCM3Q3_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/SMHI/RCA/HadCM3Q3_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'UCLM-PROMES_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "PROMES",
      gcm = "HadCM3Q0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/UCLM/PROMES/HadCM3Q0_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/UCLM/PROMES/HadCM3Q0_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'VMGO-RRCM_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "RRCM",
      gcm = "HadCM3Q0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/VMGO/RRCM/HadCM3Q0_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/VMGO/RRCM/HadCM3Q0_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
################################################################################
    'AIT-CCLM_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "CCLM",
      gcm = "HadCM3",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/AIT/CCLM/HadCM3_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/AIT/CCLM/HadCM3_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),
#################################################################################
    'WEGC-CCLM_QM_SCHOENER' = list(
      institute = "WEGC",
      rcm = "CCLM",
      gcm = "ECHAM5",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/KWF/WEGC/CCLM/ECHAM5-r2_A1B/postproc/QM_SCHOENER",
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc',
        surface_snow_height  = 'WICE_SnowModel_sst_24hc_[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/KWF/WEGC/CCLM/ECHAM5-r2_A1B/postproc/QM_SCHOENER",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1984.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc",
        surface_snow_height = "sst_24hc"),
      resolution = "1km"
      ),

###++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
###+++++++++++++++++++++ DATASET: ENSEMBLES QM ECAv2.0 ++++++++++++++++++++++
###++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

################################################################################
    'METO-HC_HadRM3Q0_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "HadRM3",
      gcm = "HadCM3Q0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q0/HadCM3Q0_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q0/HadCM3Q0_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q0/HadCM3Q0_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'METO-HC_HadRM3Q16_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "HadRM3",
      gcm = "HadCM3Q16",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q16/HadCM3Q16_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q16/HadCM3Q16_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q16/HadCM3Q16_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'METO-HC_HadRM3Q3_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "HadRM3",
      gcm = "HadCM3Q3",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q3/HadCM3Q3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q3/HadCM3Q3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q3/HadCM3Q3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'ETHZ-CLM_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "CLM",
      gcm = "HadCM3Q0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/ETHZ/CLM/HadCM3Q0_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/ETHZ/CLM/HadCM3Q0_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/ETHZ/CLM/HadCM3Q0_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'METNOHIRHAM_HadCM3Q0_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "HIRHAM",
      gcm = "HadCM3Q0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/METNO/HIRHAM/HadCM3Q0_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/METNO/HIRHAM/HadCM3Q0_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/METNO/HIRHAM/HadCM3Q0_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'METNOHIRHAM_BCM_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "HIRHAM",
      gcm = "BCCR-BCM2.0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/METNO/HIRHAM/BCM_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/METNO/HIRHAM/BCM_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/METNO/HIRHAM/BCM_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'ICTP-REGCM3_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "RegCM",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/ICTP/RegCM/ECHAM5-r3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/ICTP/RegCM/ECHAM5-r3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/ICTP/RegCM/ECHAM5-r3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'MPI-M-REMO_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "REMO",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/MPI/REMO/ECHAM5-r3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/MPI/REMO/ECHAM5-r3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/MPI/REMO/ECHAM5-r3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'C4IRCA3_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "RCA3",
      gcm = "HadCM3Q16",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/C4I/RCA/HadCM3Q16_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/C4I/RCA/HadCM3Q16_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/C4I/RCA/HadCM3Q16_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'CNRM-RM5.1_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "RM5.1",
      gcm = "ARPEGE",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/CNRM/ALADIN/ARPEGE5.1_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/CNRM/ALADIN/ARPEGE5.1_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/CNRM/ALADIN/ARPEGE5.1_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'CNRM-RM4.5_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "RM4.5",
      gcm = "ARPEGE",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/CNRM/ALADIN/ARPEGE4.5_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/CNRM/ALADIN/ARPEGE4.5_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/CNRM/ALADIN/ARPEGE4.5_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'DMI-HIRHAM5_ARPEGE_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "HIRHAM",
      gcm = "ARPEGE",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/ARPEGE_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/ARPEGE_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/ARPEGE_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'DMI-HIRHAM5_ECHAM5_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "HIRHAM",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/ECHAM5-r3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/ECHAM5-r3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/ECHAM5-r3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'DMI-HIRHAM5_BCM_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "HIRHAM",
      gcm = "BCCR-BCM2.0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/BCM_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/BCM_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/BCM_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'GKSS-CCLM4.8_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "CLM",
      gcm = "IPSL-CM4",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/GKSS/CLM/IPSL_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/GKSS/CLM/IPSL_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/GKSS/CLM/IPSL_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'KNMI-RACMO2_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "RACMO",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/KNMI/RACMO/ECHAM5-r3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/KNMI/RACMO/ECHAM5-r3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/KNMI/RACMO/ECHAM5-r3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'OURANOSMRCC4.2.1_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "CRCM",
      gcm = "CGCM3",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/OURANOS/CRCM/CGCM3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/OURANOS/CRCM/CGCM3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/OURANOS/CRCM/CGCM3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'SMHIRCA_BCM_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "RCA",
      gcm = "BCCR-BCM2.0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/BCM_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/BCM_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/BCM_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'SMHIRCA_ECHAM5-r3_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "RCA",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/ECHAM5-r3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/ECHAM5-r3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/ECHAM5-r3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'SMHIRCA_HadCM3Q3_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "RCA",
      gcm = "HadCM3Q3",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/HadCM3Q3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/HadCM3Q3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/HadCM3Q3_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'UCLM-PROMES_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "PROMES",
      gcm = "HadCM3Q0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/UCLM/PROMES/HadCM3Q0_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/UCLM/PROMES/HadCM3Q0_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/UCLM/PROMES/HadCM3Q0_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'VMGO-RRCM_QM_ECAv2.0' = list(
      institute = "WEGC",
      rcm = "RRCM",
      gcm = "HadCM3Q0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/VMGO/RRCM/HadCM3Q0_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/VMGO/RRCM/HadCM3Q0_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}-[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}-[0-9]{4}.nc'
        ),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/VMGO/RRCM/HadCM3Q0_A1B/postproc/QM_EOBSv2.0_A1Bcalib6190",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971-1980.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################



###++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
###+++++++++++++++++++++ DATASET: ENSEMBLES QM ECAv5.0 ++++++++++++++++++++++
###++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    ## land sea-mask is actually unnecessary here, as quantile-mapped
    ## data are on E-OBS grid anyway, having missing values above
    ## water...

################################################################################
    'METO-HC_HadRM3Q0_QM_ECAv5.0' = list(
      institute = "WEGC",
      rcm = "HadRM3",
      gcm = "HadCM3Q0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q0/HadCM3Q0_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510",
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q0/HadCM3Q0_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc'
        ),
      land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q0/HadCM3Q0_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'METO-HC_HadRM3Q16_QM_ECAv5.0' = list(
      institute = "WEGC",
      rcm = "HadRM3",
      gcm = "HadCM3Q16",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q16/HadCM3Q16_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510",
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q16/HadCM3Q16_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc'
        ),
      land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q16/HadCM3Q16_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'METO-HC_HadRM3Q3_QM_ECAv5.0' = list(
      institute = "WEGC",
      rcm = "HadRM3",
      gcm = "HadCM3Q3",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q3/HadCM3Q3_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510",
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q3/HadCM3Q3_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc'
        ),
      land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q3/HadCM3Q3_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'ETHZ-CLM_QM_ECAv5.0' = list(
      institute = "WEGC",
      rcm = "CLM",
      gcm = "HadCM3Q0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/ETHZ/CLM/HadCM3Q0_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510",
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/ETHZ/CLM/HadCM3Q0_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc'
        ),
      land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/ETHZ/CLM/HadCM3Q0_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'ICTP-REGCM3_QM_ECAv5.0' = list(
      institute = "WEGC",
      rcm = "RegCM",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/ICTP/RegCM/ECHAM5-r3_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510",
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/ICTP/RegCM/ECHAM5-r3_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc'
        ),
            land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
gridfile.path = "/data/reloclim/rcm/ENSEMBLES/ICTP/RegCM/ECHAM5-r3_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'MPI-M-REMO_QM_ECAv5.0' = list(
      institute = "WEGC",
      rcm = "REMO",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/MPI/REMO/ECHAM5-r3_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/MPI/REMO/ECHAM5-r3_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc'
        ),
            land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
gridfile.path = "/data/reloclim/rcm/ENSEMBLES/MPI/REMO/ECHAM5-r3_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'C4IRCA3_QM_ECAv5.0' = list(
      institute = "WEGC",
      rcm = "RCA3",
      gcm = "HadCM3Q16",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/C4I/RCA/HadCM3Q16_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/C4I/RCA/HadCM3Q16_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc'
        ),
            land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
gridfile.path = "/data/reloclim/rcm/ENSEMBLES/C4I/RCA/HadCM3Q16_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'CNRM-RM5.1_QM_ECAv5.0' = list(
      institute = "WEGC",
      rcm = "RM5.1",
      gcm = "ARPEGE",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/CNRM/ALADIN/ARPEGE5.1_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/CNRM/ALADIN/ARPEGE5.1_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc'
        ),
            land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
gridfile.path = "/data/reloclim/rcm/ENSEMBLES/CNRM/ALADIN/ARPEGE5.1_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'DMI-HIRHAM5_ARPEGE_QM_ECAv5.0' = list(
      institute = "WEGC",
      rcm = "HIRHAM",
      gcm = "ARPEGE",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/ARPEGE_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/ARPEGE_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc'
        ),
            land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
gridfile.path = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/ARPEGE_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'DMI-HIRHAM5_ECHAM5_QM_ECAv5.0' = list(
      institute = "WEGC",
      rcm = "HIRHAM",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/ECHAM5-r3_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/ECHAM5-r3_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc'
        ),
            land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
gridfile.path = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/ECHAM5-r3_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'DMI-HIRHAM5_BCM_QM_ECAv5.0' = list(
      institute = "WEGC",
      rcm = "HIRHAM",
      gcm = "BCCR-BCM2.0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/BCM_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/BCM_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc'
        ),
            land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
gridfile.path = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/BCM_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'KNMI-RACMO2_QM_ECAv5.0' = list(
      institute = "WEGC",
      rcm = "RACMO",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/KNMI/RACMO/ECHAM5-r3_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/KNMI/RACMO/ECHAM5-r3_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc'
        ),
            land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
gridfile.path = "/data/reloclim/rcm/ENSEMBLES/KNMI/RACMO/ECHAM5-r3_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'SMHIRCA_BCM_QM_ECAv5.0' = list(
      institute = "WEGC",
      rcm = "RCA",
      gcm = "BCCR-BCM2.0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/BCM_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/BCM_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc'
        ),
            land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
gridfile.path = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/BCM_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'SMHIRCA_ECHAM5-r3_QM_ECAv5.0' = list(
      institute = "WEGC",
      rcm = "RCA",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/ECHAM5-r3_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/ECHAM5-r3_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc'
        ),
            land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
gridfile.path = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/ECHAM5-r3_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'SMHIRCA_HadCM3Q3_QM_ECAv5.0' = list(
      institute = "WEGC",
      rcm = "RCA",
      gcm = "HadCM3Q3",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/HadCM3Q3_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/HadCM3Q3_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510"),
      file.name = list(
        air_temperature      = 'WICE_QuantileMapping_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_QuantileMapping_pr_24hc_[0-9]{4}.nc'
        ),
            land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
gridfile.path = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/HadCM3Q3_A1B/postproc/QM_EOBSv5.0_A1Bcalib6510",
      gridfile.filename = "WICE_QuantileMapping_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################



###++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
###+++++++++++++++++++++ DATASET: ENSEMBLES RM ECAv5.0 ++++++++++++++++++++++
###++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


################################################################################
    'METO-HC_HadRM3Q0_RM_ECAv5.0' = list(
      institute = "METO-HC",
      rcm = "HadRM3",
      gcm = "HadCM3Q0",
      corrected.data = "FALSE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q0/HadCM3Q0_A1B/postproc/regridded_to_EOBSv5.0",
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q0/HadCM3Q0_A1B/postproc/regridded_to_EOBSv5.0"),
      file.name = list(
        air_temperature      = 'WICE_regridded_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_regridded_pr_24hc_[0-9]{4}.nc'
        ),
      land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q0/HadCM3Q0_A1B/postproc/regridded_to_EOBSv5.0",
      gridfile.filename = "WICE_regridded_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'METO-HC_HadRM3Q16_RM_ECAv5.0' = list(
      institute = "METO-HC",
      rcm = "HadRM3",
      gcm = "HadCM3Q16",
      corrected.data = "FALSE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q16/HadCM3Q16_A1B/postproc/regridded_to_EOBSv5.0",
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q16/HadCM3Q16_A1B/postproc/regridded_to_EOBSv5.0"),
      file.name = list(
        air_temperature      = 'WICE_regridded_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_regridded_pr_24hc_[0-9]{4}.nc'
        ),
      land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q16/HadCM3Q16_A1B/postproc/regridded_to_EOBSv5.0",
      gridfile.filename = "WICE_regridded_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'METO-HC_HadRM3Q3_RM_ECAv5.0' = list(
      institute = "METO-HC",
      rcm = "HadRM3",
      gcm = "HadCM3Q3",
      corrected.data = "FALSE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q3/HadCM3Q3_A1B/postproc/regridded_to_EOBSv5.0",
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q3/HadCM3Q3_A1B/postproc/regridded_to_EOBSv5.0"),
      file.name = list(
        air_temperature      = 'WICE_regridded_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_regridded_pr_24hc_[0-9]{4}.nc'
        ),
      land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q3/HadCM3Q3_A1B/postproc/regridded_to_EOBSv5.0",
      gridfile.filename = "WICE_regridded_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'ETHZ-CLM_RM_ECAv5.0' = list(
      institute = "ETHZ",
      rcm = "CLM",
      gcm = "HadCM3Q0",
      corrected.data = "FALSE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/ETHZ/CLM/HadCM3Q0_A1B/postproc/regridded_to_EOBSv5.0",
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/ETHZ/CLM/HadCM3Q0_A1B/postproc/regridded_to_EOBSv5.0"),
      file.name = list(
        air_temperature      = 'WICE_regridded_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_regridded_pr_24hc_[0-9]{4}.nc'
        ),
      land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/ETHZ/CLM/HadCM3Q0_A1B/postproc/regridded_to_EOBSv5.0",
      gridfile.filename = "WICE_regridded_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'ICTP-REGCM3_RM_ECAv5.0' = list(
      institute = "ICTP",
      rcm = "RegCM",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      corrected.data = "FALSE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/ICTP/RegCM/ECHAM5-r3_A1B/postproc/regridded_to_EOBSv5.0",
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/ICTP/RegCM/ECHAM5-r3_A1B/postproc/regridded_to_EOBSv5.0"),
      file.name = list(
        air_temperature      = 'WICE_regridded_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_regridded_pr_24hc_[0-9]{4}.nc'
        ),
      land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/ICTP/RegCM/ECHAM5-r3_A1B/postproc/regridded_to_EOBSv5.0",
      gridfile.filename = "WICE_regridded_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'MPI-M-REMO_RM_ECAv5.0' = list(
      institute = "MPI",
      rcm = "REMO",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      corrected.data = "FALSE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/MPI/REMO/ECHAM5-r3_A1B/postproc/regridded_to_EOBSv5.0", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/MPI/REMO/ECHAM5-r3_A1B/postproc/regridded_to_EOBSv5.0"),
      file.name = list(
        air_temperature      = 'WICE_regridded_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_regridded_pr_24hc_[0-9]{4}.nc'
        ),
       land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
     gridfile.path = "/data/reloclim/rcm/ENSEMBLES/MPI/REMO/ECHAM5-r3_A1B/postproc/regridded_to_EOBSv5.0",
      gridfile.filename = "WICE_regridded_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'C4IRCA3_RM_ECAv5.0' = list(
      institute = "C4I",
      rcm = "RCA3",
      gcm = "HadCM3Q16",
      corrected.data = "FALSE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/C4I/RCA/HadCM3Q16_A1B/postproc/regridded_to_EOBSv5.0", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/C4I/RCA/HadCM3Q16_A1B/postproc/regridded_to_EOBSv5.0"),
      file.name = list(
        air_temperature      = 'WICE_regridded_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_regridded_pr_24hc_[0-9]{4}.nc'
        ),
       land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
     gridfile.path = "/data/reloclim/rcm/ENSEMBLES/C4I/RCA/HadCM3Q16_A1B/postproc/regridded_to_EOBSv5.0",
      gridfile.filename = "WICE_regridded_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'CNRM-RM5.1_RM_ECAv5.0' = list(
      institute = "CNRM",
      rcm = "RM5.1",
      gcm = "ARPEGE",
      corrected.data = "FALSE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/CNRM/ALADIN/ARPEGE5.1_A1B/postproc/regridded_to_EOBSv5.0", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/CNRM/ALADIN/ARPEGE5.1_A1B/postproc/regridded_to_EOBSv5.0"),
      file.name = list(
        air_temperature      = 'WICE_regridded_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_regridded_pr_24hc_[0-9]{4}.nc'
        ),
      land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/CNRM/ALADIN/ARPEGE5.1_A1B/postproc/regridded_to_EOBSv5.0",
      gridfile.filename = "WICE_regridded_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'DMI-HIRHAM5_ARPEGE_RM_ECAv5.0' = list(
      institute = "DMI",
      rcm = "HIRHAM",
      gcm = "ARPEGE",
      corrected.data = "FALSE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/ARPEGE_A1B/postproc/regridded_to_EOBSv5.0", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/ARPEGE_A1B/postproc/regridded_to_EOBSv5.0"),
      file.name = list(
        air_temperature      = 'WICE_regridded_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_regridded_pr_24hc_[0-9]{4}.nc'
        ),
       land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
     gridfile.path = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/ARPEGE_A1B/postproc/regridded_to_EOBSv5.0",
      gridfile.filename = "WICE_regridded_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'DMI-HIRHAM5_ECHAM5_RM_ECAv5.0' = list(
      institute = "DMI",
      rcm = "HIRHAM",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      corrected.data = "FALSE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/ECHAM5-r3_A1B/postproc/regridded_to_EOBSv5.0", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/ECHAM5-r3_A1B/postproc/regridded_to_EOBSv5.0"),
      file.name = list(
        air_temperature      = 'WICE_regridded_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_regridded_pr_24hc_[0-9]{4}.nc'
        ),
      land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/ECHAM5-r3_A1B/postproc/regridded_to_EOBSv5.0",
      gridfile.filename = "WICE_regridded_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'DMI-HIRHAM5_BCM_RM_ECAv5.0' = list(
      institute = "DMI",
      rcm = "HIRHAM",
      gcm = "BCCR-BCM2.0",
      corrected.data = "FALSE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/BCM_A1B/postproc/regridded_to_EOBSv5.0", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/BCM_A1B/postproc/regridded_to_EOBSv5.0"),
      file.name = list(
        air_temperature      = 'WICE_regridded_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_regridded_pr_24hc_[0-9]{4}.nc'
        ),
       land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
     gridfile.path = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/BCM_A1B/postproc/regridded_to_EOBSv5.0",
      gridfile.filename = "WICE_regridded_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'KNMI-RACMO2_RM_ECAv5.0' = list(
      institute = "KNMI",
      rcm = "RACMO",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      corrected.data = "FALSE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/KNMI/RACMO/ECHAM5-r3_A1B/postproc/regridded_to_EOBSv5.0", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/KNMI/RACMO/ECHAM5-r3_A1B/postproc/regridded_to_EOBSv5.0"),
      file.name = list(
        air_temperature      = 'WICE_regridded_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_regridded_pr_24hc_[0-9]{4}.nc'
        ),
      land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/KNMI/RACMO/ECHAM5-r3_A1B/postproc/regridded_to_EOBSv5.0",
      gridfile.filename = "WICE_regridded_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'SMHIRCA_BCM_RM_ECAv5.0' = list(
      institute = "SMHI",
      rcm = "RCA",
      gcm = "BCCR-BCM2.0",
      corrected.data = "FALSE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/BCM_A1B/postproc/regridded_to_EOBSv5.0", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/BCM_A1B/postproc/regridded_to_EOBSv5.0"),
      file.name = list(
        air_temperature      = 'WICE_regridded_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_regridded_pr_24hc_[0-9]{4}.nc'
        ),
       land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
     gridfile.path = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/BCM_A1B/postproc/regridded_to_EOBSv5.0",
      gridfile.filename = "WICE_regridded_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'SMHIRCA_ECHAM5-r3_RM_ECAv5.0' = list(
      institute = "SMHI",
      rcm = "RCA",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      corrected.data = "FALSE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/ECHAM5-r3_A1B/postproc/regridded_to_EOBSv5.0", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/ECHAM5-r3_A1B/postproc/regridded_to_EOBSv5.0"),
      file.name = list(
        air_temperature      = 'WICE_regridded_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_regridded_pr_24hc_[0-9]{4}.nc'
        ),
       land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
     gridfile.path = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/ECHAM5-r3_A1B/postproc/regridded_to_EOBSv5.0",
      gridfile.filename = "WICE_regridded_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################
    'SMHIRCA_HadCM3Q3_RM_ECAv5.0' = list(
      institute = "SMHI",
      rcm = "RCA",
      gcm = "HadCM3Q3",
      corrected.data = "FALSE",
      emission.scenario = "A1B",
      file.path.alt = c(
        air_temperature = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/HadCM3Q3_A1B/postproc/regridded_to_EOBSv5.0", 
        precipitation_amount = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/HadCM3Q3_A1B/postproc/regridded_to_EOBSv5.0"),
      file.name = list(
        air_temperature      = 'WICE_regridded_tas_dm_[0-9]{4}.nc',
        precipitation_amount = 'WICE_regridded_pr_24hc_[0-9]{4}.nc'
        ),
       land.mask.name = "sftlf",
      land.mask = "/data/reloclim/rcd/e-obs/data/eobs_0.25deg_reg_v5.0_landseamask.nc",
     gridfile.path = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/HadCM3Q3_A1B/postproc/regridded_to_EOBSv5.0",
      gridfile.filename = "WICE_regridded_tas_dm_1971.nc",
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      resolution = "25km"
      ),
################################################################################



#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+++++++++++++++++++++++++++++DATASET: ADAPT.AT++++++++++++++++++++++++++++
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    'SMHIRCA_BCM_ADAPT.AT_QM' = list(
      institute = "WEGC",
      rcm = "RCA",
      gcm = "BCCR-BCM2.0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/koeppen/rcm/adapt.at/SMHI/RCA/BCM_A1B/postproc/QM",
      file.name = list(
        air_temperature = c(
          'tas_dm_QM_SMHIRCA_A1B_BCM_1961-2050.nc'
          ),
        precipitation_amount = c(
          'pr_24hc_QM_SMHIRCA_A1B_BCM_1961-2050.nc'
          )),
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      gridfile.path = "/data/koeppen/rcm/adapt.at/SMHI/RCA/BCM_A1B/postproc/QM",
      gridfile.filename = "tas_dm_QM_SMHIRCA_A1B_BCM_1961-2050.nc",
      resolution = "1km"
      ),
###########################################################################
    'ICTP-REGCM3_ADAPT.AT_QM' = list(
      institute = "WEGC",
      rcm = "RegCM",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/koeppen/rcm/adapt.at/ICTP/RegCM/ECHAM5-r3_A1B/postproc/QM",
      file.name = list(
        air_temperature = c(
          'tas_dm_QM_ICTP-REGCM3_A1B_ECHAM5_r3_1951-2050.nc'
          ),
        precipitation_amount = c(
          'pr_24hc_QM_ICTP-REGCM3_A1B_ECHAM5_r3_1951-2050.nc'
          )),
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      gridfile.path = "/data/koeppen/rcm/adapt.at/ICTP/RegCM/ECHAM5-r3_A1B/postproc/QM",
      gridfile.filename = "tas_dm_QM_ICTP-REGCM3_A1B_ECHAM5_r3_1951-2050.nc",
      resolution = "1km"
      ),
###########################################################################
    'CNRM-RM4.5_ADAPT.AT_QM' = list(
      institute = "WEGC",
      rcm = "Aladin4.5",
      gcm = "ARPEGE",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/koeppen/rcm/adapt.at/CNRM/ALADIN/ARPEGE4.5_A1B/postproc/QM",
      file.name = list(
        air_temperature = c(
          'tas_dm_QM_CNRM-RM4.5_A1B_1951-2050.nc'
          ),
        precipitation_amount = c(
          'pr_24hc_QM_CNRM-RM4.5_A1B_1951-2050.nc'
          )),
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      gridfile.path = "/data/koeppen/rcm/adapt.at/CNRM/ALADIN/ARPEGE4.5_A1B/postproc/QM",
      gridfile.filename = "tas_dm_QM_CNRM-RM4.5_A1B_1951-2050.nc",
      resolution = "1km"
      ),
###########################################################################
    'ETHZ-CLM_ADAPT.AT_QM' = list(
      institute = "WEGC",
      rcm = "CCLM",
      gcm = "HadCM3Q0",
      corrected.data = "TRUE",
      emission.scenario = "A1B",
      file.path.default = "/data/koeppen/rcm/EnergClim/ETHZ/CLM/A1B/postproc/QM",
      file.name = list(
        air_temperature = c(
          'tas_dm_QM_ETHZ-CLM_A1B_1951-2050.nc'
          ),
        precipitation_amount = c(
          'pr_24hc_QM_ETHZ-CLM_A1B_1951-2050.nc'
          )),
      parameters = c(air_temperature = "tas_dm", precipitation_amount = "pr_24hc"),
      gridfile.path = "/data/koeppen/rcm/EnergClim/ETHZ/CLM/A1B/postproc/QM",
      gridfile.filename = "tas_dm_QM_ETHZ-CLM_A1B_1951-2050.nc",
      resolution = "1km"
      ),
###########################################################################


###++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
###++++++++++++++++++++++++++DATASET: reclip:century+++++++++++++++++++++++++
###++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
###########################################################################
    'WEGC-CCLM_reclipcentury' = list(
      institute = "WEGC",
      rcm = "CCLM",
      gcm = "ECHAM5",
      emission.scenario = "A1B",
      file.path.default = list(
        historical = '/data/reloclim-tmp/rcm/RECLIP-CENTURY/WEGC/CCLM/ECHAM5/data/daily',
        scenario = '/data/reloclim-tmp/rcm/RECLIP-CENTURY/WEGC/CCLM/ECHAM5/data/daily'),
      file.name = list(
        air_temperature = c(
           historical = list(
          'tas_reclip:century_ECHAM5_historical_2_CCLM4_COSMO4.8_CLM17_day_(19550101-19551231|19[5-9]60101-19[6-9]01231|19[6-9]10101-19[6-9]51231|19960101-19991231).nc'
             ),
          scenario = c('tas_reclip:century_ECHAM5_A1B_2_CCLM4_COSMO4.8_CLM17_day_(20000101-20001231|20[0-9]10101-20[0-9]51231|20[0-9]60101-20[0-9]01231|20960101-21001231).nc'
            )
            ),
         
        precipitation_amount = list(
          historical = c(
            'pr_reclip:century_ECHAM5_historical_2_CCLM4_COSMO4.8_CLM17_day_(19550101-19551231|19[5-9]60101-19[6-9]01231|19[6-9]10101-19[6-9]51231|19960101-19991231).nc'
          ),
          scenario = c(
            'pr_reclip:century_ECHAM5_A1B_2_CCLM4_COSMO4.8_CLM17_day_(20000101-20001231|20[0-9]10101-20[0-9]51231|20[0-9]60101-20[0-9]01231|20960101-21001231).nc' 
            )
          ),
        global_radiation = list(
          historical = c(
            'rsds_reclip:century_ECHAM5_historical_2_CCLM4_COSMO4.8_CLM17_day_(19550101-19551231|19[5-9]60101-19[6-9]01231|19[6-9]10101-19[6-9]51231|19960101-19991231).nc'
          ),
          scenario = c(
            'rsds_reclip:century_ECHAM5_A1B_2_CCLM4_COSMO4.8_CLM17_day_(20000101-20001231|20[0-9]10101-20[0-9]51231|20[0-9]60101-20[0-9]01231|20960101-21001231).nc'
            )
          ),
        wind_speed = list(
          historical = c(
            'sfcWind_reclip:century_ECHAM5_historical_2_CCLM4_COSMO4.8_CLM17_day_(19550101-19551231|19[5-9]60101-19[6-9]01231|19[6-9]10101-19[6-9]51231|19960101-19991231).nc'
          ),
          scenario = c(
            'sfcWind_reclip:century_ECHAM5_A1B_2_CCLM4_COSMO4.8_CLM17_day_(20000101-20001231|20[0-9]10101-20[0-9]51231|20[0-9]60101-20[0-9]01231|20960101-21001231).nc'
            )
          ),
        relative_humidity = list(
          historical = c(
            'hurs_reclip:century_ECHAM5_historical_2_CCLM4_COSMO4.8_CLM17_day_(19550101-19551231|19[5-9]60101-19[6-9]01231|19[6-9]10101-19[6-9]51231|19960101-19991231).nc'
          ),
          scenario = c(
            'hurs_reclip:century_ECHAM5_A1B_2_CCLM4_COSMO4.8_CLM17_day_(20000101-20001231|20[0-9]10101-20[0-9]51231|20[0-9]60101-20[0-9]01231|20960101-21001231).nc'
            )
          )
        ),
     
     
      parameters = c(
        air_temperature = "tas",
        precipitation_amount = "pr",
        global_radiation = 'rsds',
        wind_speed = "sfcWind",
        relative_humidity = "hurs"),
      gridfile.path = "/data/reloclim/rcm/reclip.century/WEGC/CCLM/ECHAM5_A1B/direct",
      gridfile.filename = "WEGC-CCLM_ECHAM5-A1Br2_FIX_10km_orog.nc",
      resolution = "10km"
      ),
###########################################################################
    'AIT-CCLM_reclipcentury' = list(
      institute = "AIT",
      rcm = "CCLM",
      gcm = "HADCM3",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/reclip.century/AIT/CCLM/HadCM3_A1B/direct",
      file.name = list(
        air_temperature = c(
          'AIT-CCLM_HADCM3-A1B_DM_10km_(19[5-8]1-19[6-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2099)_tas.nc'
          ),
        precipitation_amount = c(
          'AIT-CCLM_HADCM3-A1B_DS_10km_(19[5-8]1-19[6-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2099)_prt.nc'
          ),
        global_radiation = c(
          'AIT-CCLM_HADCM3-A1B_DM_10km_(19[5-8]1-19[6-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2099)_rsds.nc'
          ),
        wind_speed = c(
          'AIT-CCLM_HADCM3-A1B_DM_10km_(19[5-8]1_19[6-9]0|1991_2000|20[0-9]1_20[0-9]0|2091_2099)_wss.nc'
          ),
        relative_humidity = c(
          'AIT-CCLM_HADCM3-A1B_DM_10km_(19[5-8]1_19[6-9]0|1991_2000|20[0-9]1_20[0-9]0|2091_2099)_hurs.nc'
          )),
      parameters = c(
        air_temperature = "tas",
        precipitation_amount = "prt",
        global_radiation = 'rsds',
        wind_speed = "wss",
        relative_humidity = "hurs"),
      gridfile.path = "/data/reloclim/rcm/reclip.century/AIT/CCLM/HadCM3_A1B/direct",
      gridfile.filename = "AIT-CCLM_HadCM3-A1B_FIX_10km_orog.nc",
      resolution = "10km"
      ),
###########################################################################
    'ZAMG-CCLM-B1_reclipcentury' = list(
      institute = "ZAMG",
      rcm = "CCLM",
      gcm = "ECHAM5",
      emission.scenario = "B1",
      file.path.alt = list(
        air_temperature = list(
          historical = "/data/reloclim/rcm/reclip.century/WEGC/CCLM/ECHAM5_A1B/direct",
          scenario = "/data/reloclim/rcm/reclip.century/ZAMG/CCLM/ECHAM5_B1/direct"),
        precipitation_amount = list(
          historical = "/data/reloclim/rcm/reclip.century/WEGC/CCLM/ECHAM5_A1B/direct",
          scenario = "/data/reloclim/rcm/reclip.century/ZAMG/CCLM/ECHAM5_B1/direct"),
        global_radiation = list(
          historical = "/data/reloclim/rcm/reclip.century/WEGC/CCLM/ECHAM5_A1B/direct",
          scenario = "/data/reloclim/rcm/reclip.century/ZAMG/CCLM/ECHAM5_B1/direct"),
        relative_humidity = list(
          historical = "/data/reloclim/rcm/reclip.century/WEGC/CCLM/ECHAM5_A1B/direct",
          scenario = "/data/reloclim/rcm/reclip.century/ZAMG/CCLM/ECHAM5_B1/direct"),
        wind_speed = list(
          historical = "/data/reloclim/rcm/reclip.century/WEGC/CCLM/ECHAM5_A1B/direct",
          scenario = "/data/reloclim/rcm/reclip.century/ZAMG/CCLM/ECHAM5_B1/direct")
        ),
      file.name = list(
        air_temperature = list(
          historical = c(
            'WEGC-CCLM_ECHAM5-A1Br2_DD_10km_(19[6-8]1-19[7-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2100)_tas.nc'
            ),
          scenario = c(
            'ZAMG-CCLM_B1_DM_10km_(19[6-8]1-19[7-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2099)_tas.nc'
            )),
        precipitation_amount = list(
          historical = c(
            'WEGC-CCLM_ECHAM5-A1Br2_DS_10km_(19[6-8]1-19[7-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2100)_prt.nc'
            ),
          scenario = c(
            'ZAMG-CCLM_B1_DS_10km_(19[6-8]1-19[7-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2099)_prt.nc'
            )),
        global_radiation = list(
          historical = c(
            'WEGC-CCLM_ECHAM5-A1Br2_DD_10km_(19[6-8]1-19[7-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2100)_rsds.nc'
            ),
          scenario = c(
            'ZAMG-CCLM_B1_DM_10km_(19[6-8]1-19[7-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2099)_rsds.nc'
            )),
        relative_humidity = list(
          historical = c(
            'WEGC-CCLM_ECHAM5-A1Br2_DD_10km_(19[6-8]1-19[7-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2100)_hur.nc'
            ),
          scenario = c(
            'ZAMG-CCLM_B1_DM_10km_(19[6-8]1-19[7-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2099)_hurs.nc'
            )),
        wind_speed = list(
          historical = c(
            'WEGC-CCLM_ECHAM5-A1Br2_DD_10km_(19[6-8]1-19[7-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2100)_wss.nc'
            ),
          scenario = c(
            'ZAMG-CCLM_B1_DM_10km_(19[6-8]1-19[7-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2099)_wss.nc'
            ))
          ),
      parameters = c(
        air_temperature = "tas",
        precipitation_amount = "prt",
        global_radiation = "rsds",
        wind_speed = "wss",
        relative_humidity = "hurs"),
      gridfile.path = "/data/reloclim/rcm/reclip.century/WEGC/CCLM/ECHAM5_A1B/direct",
      gridfile.filename = "WEGC-CCLM_ECHAM5-A1Br2_FIX_10km_orog.nc",
      resolution = "10km"
      ),
###########################################################################
    'ZAMG-CCLM-A2_reclipcentury' = list(
      institute = "ZAMG",
      rcm = "CCLM",
      gcm = "ECHAM5",
      emission.scenario = "A2",
      file.path.alt = list(
        air_temperature = list(
          historical = "/data/reloclim/rcm/reclip.century/WEGC/CCLM/ECHAM5_A1B/direct",
          scenario = "/data/reloclim/rcm/reclip.century/ZAMG/CCLM/ECHAM5_A2/direct"),
        precipitation_amount = list(
          historical = "/data/reloclim/rcm/reclip.century/WEGC/CCLM/ECHAM5_A1B/direct",
          scenario = "/data/reloclim/rcm/reclip.century/ZAMG/CCLM/ECHAM5_A2/direct"),
        global_radiation = list(
          historical = "/data/reloclim/rcm/reclip.century/WEGC/CCLM/ECHAM5_A1B/direct",
          scenario = "/data/reloclim/rcm/reclip.century/ZAMG/CCLM/ECHAM5_A2/direct"),
        relative_humidity = list(
          historical = "/data/reloclim/rcm/reclip.century/WEGC/CCLM/ECHAM5_A1B/direct",
          scenario = "/data/reloclim/rcm/reclip.century/ZAMG/CCLM/ECHAM5_A2/direct"),
        wind_speed = list(
          historical = "/data/reloclim/rcm/reclip.century/WEGC/CCLM/ECHAM5_A1B/direct",
          scenario = "/data/reloclim/rcm/reclip.century/ZAMG/CCLM/ECHAM5_A2/direct")
        ),
      file.name = list(
        air_temperature = list(
          historical = c(
            'WEGC-CCLM_ECHAM5-A1Br2_DD_10km_(19[6-8]1-19[7-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2100)_tas.nc'
            ),
          scenario = c(
            'ZAMG-CCLM_A2_DM_10km_(19[6-8]1-19[7-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2099)_tas.nc'
            )),
        precipitation_amount = list(
          historical = c(
            'WEGC-CCLM_ECHAM5-A1Br2_DS_10km_(19[6-8]1-19[7-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2100)_prt.nc'
            ),
          scenario = c(
            'ZAMG-CCLM_A2_DS_10km_(19[6-8]1-19[7-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2099)_prt.nc'
            )),
        global_radiation = list(
          historical = c(
            'WEGC-CCLM_ECHAM5-A1Br2_DD_10km_(19[6-8]1-19[7-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2100)_rsds.nc'
            ),
          scenario = c(
            'ZAMG-CCLM_A2_DM_10km_(19[6-8]1-19[7-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2099)_rsds.nc'
            )),
        relative_humidity = list(
          historical = c(
            'WEGC-CCLM_ECHAM5-A1Br2_DD_10km_(19[6-8]1-19[7-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2100)_hur.nc'
            ),
          scenario = c(
            'ZAMG-CCLM_A2_DM_10km_(19[6-8]1-19[7-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2099)_hurs.nc'
            )),
        wind_speed = list(
          historical = c(
            'WEGC-CCLM_ECHAM5-A1Br2_DD_10km_(19[6-8]1-19[7-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2100)_wss.nc'
            ),
          scenario = c(
            'ZAMG-CCLM_A2_DM_10km_(19[6-8]1-19[7-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2099)_wss.nc'
            ))
        ),
      parameters = c(
        air_temperature = "tas",
        precipitation_amount = "prt",
        global_radiation = "rsds",
        wind_speed = "wss",
        relative_humidity = "hurs"),
      gridfile.path = "/data/reloclim/rcm/reclip.century/WEGC/CCLM/ECHAM5_A1B/direct",
      gridfile.filename = "WEGC-CCLM_ECHAM5-A1Br2_FIX_10km_orog.nc",
      resolution = "10km"
      ),
###########################################################################
    ## 'BOKU-MM5_reclipcentury' = list(
    ##   institute = "BOKU",
    ##   rcm = "MM5",
    ##   gcm = "ECHAM5",
    ##   emission.scenario = "A1B",
    ##   file.path.default = "/data/reloclim/rcm/reclip.century/BOKU/MM5/ECHAM5_A1B/direct",
    ##   file.name = list(
    ##     air_temperature = c(
    ##       'BOKU-MM5_ECHAM5-A1Br2_DD_10km_(19[5-8]1-19[6-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2100)_tas.nc'
    ##       ),
    ##     precipitation_amount = c(
    ##       'BOKU-MM5_ECHAM5-A1Br2_DD_10km_(19[5-8]1-19[6-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2100)_prt.nc'
    ##       ),
    ##     global_radiation = c(
    ##       'BOKU-MM5_ECHAM5-A1Br2_DD_10km_(19[5-8]1-19[6-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2100)_rsds.nc'
    ##       ),
    ##     wind_speed = c(
    ##       'BOKU-MM5_ECHAM5-A1Br2_DD_10km_(19[5-8]1-19[6-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2100)_wss.nc'
    ##       ),
    ##     relative_humidity = c(
    ##       'BOKU-MM5_ECHAM5-A1Br2_DD_10km_(19[5-8]1-19[6-9]0|1991-2000|20[0-9]1-20[0-9]0|2091-2100)_hurs.nc'
    ##       )),
    ##   parameters = c(air_temperature = "tas", precipitation_amount = "prt", global_radiation = 'rsds',
    ##     wind_speed = "wss", relative_humidity = "hurs"),
    ##   gridfile.path = "/data/reloclim/rcm/reclip.century/BOKU/MM5/ECHAM5_A1B/direct",
    ##   gridfile.filename = "BOKU-MM5_ECHAM5-A1Br2_DD_10km_1961-1970_tas.nc",
    ##   resolution = "10km"
    ##   ),
###########################################################################



###++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
###+++++++++++++++++++++++++++DATASET: ENSEMBLES+++++++++++++++++++++++++++++
###++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

### ----------------------------------------------------------------------
### ************************** SCENARIO: ERA40 ***************************
### ----------------------------------------------------------------------

###########################################################################
    'METO-HC_HadRM3Q0_ERA40' = list(
      institute = "METO-HC",
      rcm = "HadRM3",
      gcm = "ERA40",
      emission.scenario = "",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q0/ERA40",
      file.name = list(
        air_temperature = c(
          'METO-HC_HadRM3Q0_CTL_ERA40_DM_25km_1959-1960_tas.nc',
          'METO-HC_HadRM3Q0_CTL_ERA40_DM_25km_1961-1970_tas.nc',
          'METO-HC_HadRM3Q0_CTL_ERA40_DM_25km_1971-1980_tas.nc',
          'METO-HC_HadRM3Q0_CTL_ERA40_DM_25km_1981-1990_tas.nc',
          'METO-HC_HadRM3Q0_CTL_ERA40_DM_25km_1991-2000_tas.nc',
          'METO-HC_HadRM3Q0_CTL_ERA40_DM_25km_2001-2002_tas.nc'
          ),
        precipitation_amount = c(
          'METO-HC_HadRM3Q0_CTL_ERA40_DM_25km_1959-1960_pr.nc',
          'METO-HC_HadRM3Q0_CTL_ERA40_DM_25km_1961-1970_pr.nc',
          'METO-HC_HadRM3Q0_CTL_ERA40_DM_25km_1971-1980_pr.nc',
          'METO-HC_HadRM3Q0_CTL_ERA40_DM_25km_1981-1990_pr.nc',
          'METO-HC_HadRM3Q0_CTL_ERA40_DM_25km_1991-2000_pr.nc',
          'METO-HC_HadRM3Q0_CTL_ERA40_DM_25km_2001-2002_pr.nc'
          )),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q0/ERA40",
      gridfile.filename = "METO-HC_HadRM3Q0_CTL_ERA40_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'METO-HC_HadRM3Q16_ERA40' = list(
      institute = "METO-HC",
      rcm = "HadRM3",
      gcm = "ERA40",
      emission.scenario = "",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q16/ERA40",
      file.name = list(
        air_temperature = c(
          'METO-HadRM3Q16_CTL_ERA40_DM_25km_1959-1960_tas.nc',
          'METO-HadRM3Q16_CTL_ERA40_DM_25km_1961-1970_tas.nc',
          'METO-HadRM3Q16_CTL_ERA40_DM_25km_1971-1980_tas.nc',
          'METO-HadRM3Q16_CTL_ERA40_DM_25km_1981-1990_tas.nc',
          'METO-HadRM3Q16_CTL_ERA40_DM_25km_1991-2000_tas.nc',
          'METO-HadRM3Q16_CTL_ERA40_DM_25km_2001-2002_tas.nc'
          ),
        precipitation_amount = c(
          'METO-HadRM3Q16_CTL_ERA40_DM_25km_1959-1960_pr.nc',
          'METO-HadRM3Q16_CTL_ERA40_DM_25km_1961-1970_pr.nc',
          'METO-HadRM3Q16_CTL_ERA40_DM_25km_1971-1980_pr.nc',
          'METO-HadRM3Q16_CTL_ERA40_DM_25km_1981-1990_pr.nc',
          'METO-HadRM3Q16_CTL_ERA40_DM_25km_1991-2000_pr.nc',
          'METO-HadRM3Q16_CTL_ERA40_DM_25km_2001-2002_pr.nc'
          )),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q16/ERA40",
      gridfile.filename = "METO-HC_HadRM3Q0_CTL_ERA40_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'METO-HC_HadRM3Q3_ERA40' = list(
      institute = "METO-HC",
      rcm = "HadRM3",
      gcm = "ERA40",
      emission.scenario = "",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q3/ERA40",
      file.name = list(
        air_temperature = c(
          'METO-HadRM3Q3_CTL_ERA40_DM_25km_1959-1960_tas.nc',
          'METO-HadRM3Q3_CTL_ERA40_DM_25km_1961-1970_tas.nc',
          'METO-HadRM3Q3_CTL_ERA40_DM_25km_1971-1980_tas.nc',
          'METO-HadRM3Q3_CTL_ERA40_DM_25km_1981-1990_tas.nc',
          'METO-HadRM3Q3_CTL_ERA40_DM_25km_1991-2000_tas.nc',
          'METO-HadRM3Q3_CTL_ERA40_DM_25km_2001-2002_tas.nc'
          ),
        precipitation_amount = c(
          'METO-HadRM3Q3_CTL_ERA40_DM_25km_1959-1960_pr.nc',
          'METO-HadRM3Q3_CTL_ERA40_DM_25km_1961-1970_pr.nc',
          'METO-HadRM3Q3_CTL_ERA40_DM_25km_1971-1980_pr.nc',
          'METO-HadRM3Q3_CTL_ERA40_DM_25km_1981-1990_pr.nc',
          'METO-HadRM3Q3_CTL_ERA40_DM_25km_1991-2000_pr.nc',
          'METO-HadRM3Q3_CTL_ERA40_DM_25km_2001-2002_pr.nc'
          )),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q3/ERA40",
      gridfile.filename = "METO-HC_HadRM3Q0_CTL_ERA40_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'ETHZ-CLM_ERA40' = list(
      institute = "ETHZ",
      rcm = "CLM",
      gcm = "ERA40",
      emission.scenario = "",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/ETHZ/CLM/ERA40",
      file.name = list(
        air_temperature = c(
          'ETHZ-CLM_CTL_ERA40_DM_25km_1961-1970_tas.nc',
          'ETHZ-CLM_CTL_ERA40_DM_25km_1971-1980_tas.nc',
          'ETHZ-CLM_CTL_ERA40_DM_25km_1981-1990_tas.nc',
          'ETHZ-CLM_CTL_ERA40_DM_25km_1991-2000_tas.nc'
          ),
        precipitation_amount = c(
          'ETHZ-CLM_CTL_ERA40_DM_25km_1961-1970_pr.nc',
          'ETHZ-CLM_CTL_ERA40_DM_25km_1971-1980_pr.nc',
          'ETHZ-CLM_CTL_ERA40_DM_25km_1981-1990_pr.nc',
          'ETHZ-CLM_CTL_ERA40_DM_25km_1991-2000_pr.nc'
          )),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/ETHZ/CLM/ERA40",
      gridfile.filename = "ETHZ-CLM_CTL_ERA40_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'METNOHIRHAM_ERA40' = list(
      institute = "METNO",
      rcm = "HIRHAM",
      gcm = "ERA40",
      emission.scenario = "",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/METNO/HIRHAM/ERA40",
      file.name = list(
        air_temperature = c(
          'METNOHIRHAM_CTR_ERA40_DM_25km_1961-1970_tas.nc',
          'METNOHIRHAM_CTR_ERA40_DM_25km_1971-1980_tas.nc',
          'METNOHIRHAM_CTR_ERA40_DM_25km_1981-1990_tas.nc',
          'METNOHIRHAM_CTR_ERA40_DM_25km_1991-2000_tas.nc'
          ),
        precipitation_amount = c(
          'METNOHIRHAM_CTR_ERA40_DM_25km_1961-1970_pr.nc',
          'METNOHIRHAM_CTR_ERA40_DM_25km_1971-1980_pr.nc',
          'METNOHIRHAM_CTR_ERA40_DM_25km_1981-1990_pr.nc',
          'METNOHIRHAM_CTR_ERA40_DM_25km_1991-2000_pr.nc'
          )),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/METNO/HIRHAM/ERA40",
      gridfile.filename = "METNOHIRHAM_CTR_ERA40_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'ICTP-REGCM3_ERA40' = list(
      institute = "ICTP",
      rcm = "RegCM",
      gcm = "ERA40",
      emission.scenario = "",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/ICTP/RegCM/ERA40/direct",
      file.name = list(
        air_temperature = c(
          'ICTP-REGCM3_CTL_ERA40_DM_25km_1961-1970_tas.nc',
          'ICTP-REGCM3_CTL_ERA40_DM_25km_1971-1980_tas.nc',
          'ICTP-REGCM3_CTL_ERA40_DM_25km_1981-1990_tas.nc',
          'ICTP-REGCM3_CTL_ERA40_DM_25km_1991-2000_tas.nc'
          ),
        precipitation_amount = c(
          'ICTP-REGCM3_CTL_ERA40_DM_25km_1961-1970_pr.nc',
          'ICTP-REGCM3_CTL_ERA40_DM_25km_1971-1980_pr.nc',
          'ICTP-REGCM3_CTL_ERA40_DM_25km_1981-1990_pr.nc',
          'ICTP-REGCM3_CTL_ERA40_DM_25km_1991-2000_pr.nc'
          )),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/ICTP/RegCM/ERA40/direct",
      gridfile.filename = "ICTP-REGCM3_CTL_ERA40_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'MPI-M-REMO_ERA40' = list(
      institute = "MPI",
      rcm = "REMO",
      emission.scenario = "",
      gcm = "ERA40",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/MPI/REMO/ERA40",
      file.name = list(
        air_temperature = c(
          'MPI-M-REMO_CTL_ERA40_DM_25km_1961-1970_tas.nc',
          'MPI-M-REMO_CTL_ERA40_DM_25km_1971-1980_tas.nc',
          'MPI-M-REMO_CTL_ERA40_DM_25km_1981-1990_tas.nc',
          'MPI-M-REMO_CTL_ERA40_DM_25km_1991-2000_tas.nc'
          ),
        precipitation_amount = c(
          'MPI-M-REMO_CTL_ERA40_DM_25km_1961-1970_pr.nc',
          'MPI-M-REMO_CTL_ERA40_DM_25km_1971-1980_pr.nc',
          'MPI-M-REMO_CTL_ERA40_DM_25km_1981-1990_pr.nc',
          'MPI-M-REMO_CTL_ERA40_DM_25km_1991-2000_pr.nc'
          )),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/MPI/REMO/ERA40",
      gridfile.filename = "MPI-M-REMO_CTL_ERA40_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'C4IRCA3_ERA40' = list(
      institute = "C4I",
      rcm = "RCA3",
      gcm = "ERA40",
      emission.scenario = "",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/C4I/RCA/ERA40",
      file.name = list(
        air_temperature = c(
          'C4IRCA3_CTL_ERA40_DM_25km_1961-1970_tas.nc',
          'C4IRCA3_CTL_ERA40_DM_25km_1971-1980_tas.nc',
          'C4IRCA3_CTL_ERA40_DM_25km_1981-1990_tas.nc',
          'C4IRCA3_CTL_ERA40_DM_25km_1991-2000_tas.nc'
          ),
        precipitation_amount = c(
          'C4IRCA3_CTL_ERA40_DM_25km_1961-1970_pr.nc',
          'C4IRCA3_CTL_ERA40_DM_25km_1971-1980_pr.nc',
          'C4IRCA3_CTL_ERA40_DM_25km_1981-1990_pr.nc',
          'C4IRCA3_CTL_ERA40_DM_25km_1991-2000_pr.nc'
          )),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/C4I/RCA/ERA40",
      gridfile.filename = "C4IRCA3_CTL_ERA40_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'CNRM-RM4.5_ERA40' = list(
      institute = "CNRM",
      rcm = "RM4.5",
      gcm = "ERA40",
      emission.scenario = "",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/CNRM/ALADIN/ERA40",
      file.name = list(
        air_temperature = c(
          'CNRM-RM4.5_SCN_ARPEGE_DM_25km_1961-1970_tas.nc',
          'CNRM-RM4.5_SCN_ARPEGE_DM_25km_1971-1980_tas.nc',
          'CNRM-RM4.5_SCN_ARPEGE_DM_25km_1981-1990_tas.nc',
          'CNRM-RM4.5_SCN_ARPEGE_DM_25km_1991-2000_tas.nc'
          ),
        precipitation_amount = c(
          'CNRM-RM4.5_SCN_ARPEGE_DM_25km_1961-1970_pr.nc',
          'CNRM-RM4.5_SCN_ARPEGE_DM_25km_1971-1980_pr.nc',
          'CNRM-RM4.5_SCN_ARPEGE_DM_25km_1981-1990_pr.nc',
          'CNRM-RM4.5_SCN_ARPEGE_DM_25km_1991-2000_pr.nc'
          )),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/CNRM/ALADIN/ERA40",
      gridfile.filename = "CNRM-RM4.5_CTL_ERA40_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'DMI-HIRHAM5_ERA40' = list(
      institute = "DMI",
      rcm = "HIRHAM",
      gcm = "ERA40",
      emission.scenario = "",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/ERA40",
      file.name = list(
        air_temperature = c(
          'DMI-HIRHAM5_CTL_ERA40_DM_25km_1958-1960_tas.nc',
          'DMI-HIRHAM5_CTL_ERA40_DM_25km_1961-1970_tas.nc',
          'DMI-HIRHAM5_CTL_ERA40_DM_25km_1971-1980_tas.nc',
          'DMI-HIRHAM5_CTL_ERA40_DM_25km_1981-1990_tas.nc',
          'DMI-HIRHAM5_CTL_ERA40_DM_25km_1991-2000_tas.nc'
          ),
        precipitation_amount = c(
          'DMI-HIRHAM5_CTL_ERA40_DM_25km_1958-1960_pr.nc',
          'DMI-HIRHAM5_CTL_ERA40_DM_25km_1961-1970_pr.nc',
          'DMI-HIRHAM5_CTL_ERA40_DM_25km_1971-1980_pr.nc',
          'DMI-HIRHAM5_CTL_ERA40_DM_25km_1981-1990_pr.nc',
          'DMI-HIRHAM5_CTL_ERA40_DM_25km_1991-2000_pr.nc'
          )),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/ERA40",
      gridfile.filename = "DMI-HIRHAM5_CTL_ERA40_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'GKSS-CCLM4.8_ERA40' = list(
      institute = "GKSS",
      rcm = "CLM",
      gcm = "ERA40",
      emission.scenario = "",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/GKSS/CLM/ERA40",
      file.name = list(
        air_temperature = c(
          'GKSS-CLM_CTL_ERA40_50km_1961-1970_DM_tas.nc',
          'GKSS-CLM_CTL_ERA40_50km_1971-1980_DM_tas.nc',
          'GKSS-CLM_CTL_ERA40_50km_1981-1990_DM_tas.nc',
          'GKSS-CLM_CTL_ERA40_50km_1991-2000_DM_tas.nc'
          ),
        precipitation_amount = c(
          'GKSS-CLM_CTL_ERA40_50km_1961-1970_DM_pr.nc',
          'GKSS-CLM_CTL_ERA40_50km_1971-1980_DM_pr.nc',
          'GKSS-CLM_CTL_ERA40_50km_1981-1990_DM_pr.nc',
          'GKSS-CLM_CTL_ERA40_50km_1991-2000_DM_pr.nc'
          )),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/GKSS/CLM/ERA40",
      gridfile.filename = "GKSSCLM_ERA40_50km_FIX_orog.nc",
      resolution = "50km"
      ),
###########################################################################
    'KNMI-RACMO2_ERA40' = list(
      institute = "KNMI",
      rcm = "RACMO",
      gcm = "ERA40",
      emission.scenario = "",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/KNMI/RACMO/ERA40",
      file.name = list(
        air_temperature = c(
          'KNMI-RACMO2_CTL_ERA40_DM_25km_1958-1960_tas.nc',
          'KNMI-RACMO2_CTL_ERA40_DM_25km_1961-1970_tas.nc',
          'KNMI-RACMO2_CTL_ERA40_DM_25km_1971-1980_tas.nc',
          'KNMI-RACMO2_CTL_ERA40_DM_25km_1981-1990_tas.nc',
          'KNMI-RACMO2_CTL_ERA40_DM_25km_1991-2000_tas.nc',
          'KNMI-RACMO2_CTL_ERA40_DM_25km_2001-2002_tas.nc'
          ),
        precipitation_amount = c(
          'KNMI-RACMO2_CTL_ERA40_DM_25km_1958-1960_pr.nc',
          'KNMI-RACMO2_CTL_ERA40_DM_25km_1961-1970_pr.nc',
          'KNMI-RACMO2_CTL_ERA40_DM_25km_1971-1980_pr.nc',
          'KNMI-RACMO2_CTL_ERA40_DM_25km_1981-1990_pr.nc',
          'KNMI-RACMO2_CTL_ERA40_DM_25km_1991-2000_pr.nc',
          'KNMI-RACMO2_CTL_ERA40_DM_25km_2001-2002_pr.nc'
          )),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/KNMI/RACMO/ERA40",
      gridfile.filename = "KNMI-RACMO2_CTL_ERA40_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'OURANOSMRCC4.2.1_ERA40' = list(
      institute = "OURANOS",
      rcm = "CRCM",
      gcm = "ERA40",
      emission.scenario = "",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/OURANOS/CRCM/ERA40",
      file.name = list(
        air_temperature = c(
          'OURANOSMRCC4.2.3_CTL_ERA40_DM_25km_CRU_1961-1970_tas.nc',
          'OURANOSMRCC4.2.3_CTL_ERA40_DM_25km_CRU_1971-1980_tas.nc',
          'OURANOSMRCC4.2.3_CTL_ERA40_DM_25km_CRU_1981-1990_tas.nc',
          'OURANOSMRCC4.2.3_CTL_ERA40_DM_25km_CRU_1991-2000_tas.nc'
          ),
        precipitation_amount = c(
          'OURANOSMRCC4.2.3_CTL_ERA40_DM_25km_CRU_1961-1970_pr.nc',
          'OURANOSMRCC4.2.3_CTL_ERA40_DM_25km_CRU_1971-1980_pr.nc',
          'OURANOSMRCC4.2.3_CTL_ERA40_DM_25km_CRU_1981-1990_pr.nc',
          'OURANOSMRCC4.2.3_CTL_ERA40_DM_25km_CRU_1991-2000_pr.nc'
          )),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/OURANOS/CRCM/ERA40",
      gridfile.filename = "OURANOSMRCC4.2.1_CTL_ERA40_FIX_25km_CRU_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'SMHIRCA_ERA40' = list(
      institute = "SMHI",
      rcm = "RCA",
      gcm = "ERA40",
      emission.scenario = "",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/ERA40",
      file.name = list(
        air_temperature = c(
          'SMHIRCA_CTL_ERA40_DM_25km_1961-1970_tas.nc',
          'SMHIRCA_CTL_ERA40_DM_25km_1971-1980_tas.nc',
          'SMHIRCA_CTL_ERA40_DM_25km_1981-1990_tas.nc',
          'SMHIRCA_CTL_ERA40_DM_25km_1991-2000_tas.nc'
          ),
        precipitation_amount = c(
          'SMHIRCA_CTL_ERA40_DM_25km_1961-1970_pr.nc',
          'SMHIRCA_CTL_ERA40_DM_25km_1971-1980_pr.nc',
          'SMHIRCA_CTL_ERA40_DM_25km_1981-1990_pr.nc',
          'SMHIRCA_CTL_ERA40_DM_25km_1991-2000_pr.nc'
          )),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/SMHI/RCA/ERA40",
      gridfile.filename = "SMHIRCA_A1B_ERA40_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'UCLM-PROMES_ERA40' = list(
      institute = "UCLM",
      rcm = "PROMES",
      gcm = "ERA40",
      emission.scenario = "",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/UCLM/PROMES/ERA40",
      file.name = list(
        air_temperature = c(
          'UCLM-PROMES_CTL_ERA40_DM_25km_1961-1970_tas.nc',
          'UCLM-PROMES_CTL_ERA40_DM_25km_1971-1980_tas.nc',
          'UCLM-PROMES_CTL_ERA40_DM_25km_1981-1990_tas.nc',
          'UCLM-PROMES_CTL_ERA40_DM_25km_1991-2000_tas.nc'
          ),
        precipitation_amount = c(
          'UCLM-PROMES_CTL_ERA40_DM_25km_1961-1970_pr.nc',
          'UCLM-PROMES_CTL_ERA40_DM_25km_1971-1980_pr.nc',
          'UCLM-PROMES_CTL_ERA40_DM_25km_1981-1990_pr.nc',
          'UCLM-PROMES_CTL_ERA40_DM_25km_1991-2000_pr.nc'
          )),
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/UCLM/PROMES/ERA40",
      gridfile.filename = "UCLM-PROMES_CTL_ERA40_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################

### ----------------------------------------------------------------------
### *************************** SCENARIO: A1B ****************************
### ----------------------------------------------------------------------

    'METO-HC_HadRM3Q0' = list(
      institute = "METO-HC",
      rcm = "HadRM3",
      gcm = "HadCM3Q0",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q0/HadCM3Q0_A1B/direct",
      file.name = list(
        air_temperature = c(
          'METO-HC_HadRM3Q0_A1B_HadCM3Q0_DM_25km_(19[5-8]1-19[6-9]0|1991-2000|20[0-9]1-2[01][0-9]0)_tas.nc'
          ),
        precipitation_amount = c(
          'METO-HC_HadRM3Q0_A1B_HadCM3Q0_DM_25km_(19[5-8]1-19[6-9]0|1991-2000|20[0-9]1-2[01][0-9]0)_pr.nc'
          ),
        global_radiation = c(
          'METO-HC_HadRM3Q0_A1B_HadCM3Q0_DM_25km_(19[5-8]1-19[6-9]0|1991-2000|20[0-9]1-2[01][0-9]0)_rsds.nc'
          ),
        wind_speed = c(
          'METO-HC_HadRM3Q0_A1B_HadCM3Q0_DM_25km_(19[5-8]1-19[6-9]0|1991-2000|20[0-9]1-2[01][0-9]0)_wss.nc'
          ),
        relative_humidity= c(
          'METO-HC_HadRM3Q0_A1B_HadCM3Q0_DM_25km_(19[5-8]1-19[6-9]0|1991-2000|20[0-9]1-2[01][0-9]0)_hurs.nc'
          ),
        surface_upward_sensible_heat_flux= c(
          'METO-HC_HadRM3Q0_A1B_HadCM3Q0_DM_25km_[0-9]{4}-[0-9]{4}_hfss.nc'
          ),
        air_temperature_minimum= c(
          'METO-HC_HadRM3Q0_A1B_HadCM3Q0_DM_25km_[0-9]{4}-[0-9]{4}_tasmin.nc'
          ),
        air_temperature_maximum= c(
          'METO-HC_HadRM3Q0_A1B_HadCM3Q0_DM_25km_[0-9]{4}-[0-9]{4}_tasmax.nc'
          ),
        surface_temperature= c(
          NA
          )
        ),
      land.mask.name = "sftls",
      land.mask = "/data/reloclim/rcu/geh/data/ensembles/landmask/METO-HC_HadRM3Q0_ERA40_FIX_25km_sftls.ens_min-new.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q0/HadCM3Q0_A1B/direct",
      gridfile.filename = "METO-HC_HadRM3Q0_CTL_ERA40_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'METO-HC_HadRM3Q16' = list(
      institute = "METO-HC",
      rcm = "HadRM3",
      gcm = "HadCM3Q16",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q16/HadCM3Q16_A1B/direct",
      file.name =  list(
        air_temperature = c(
          'METO-HC_HadRM3Q16_A1B_HadCM3Q16_DM_25km_[0-9]{4}-[0-9]{4}_tas.nc'
          ),
        precipitation_amount = c(
          'METO-HC_HadRM3Q16_A1B_HadCM3Q16_DM_25km_[0-9]{4}-[0-9]{4}_pr.nc'
          ),
        global_radiation = c(
          'METO-HC_HadRM3Q16_A1B_HadCM3Q16_DM_25km_[0-9]{4}-[0-9]{4}_rsds.nc'
          ),
        wind_speed = c(
          'METO-HC_HadRM3Q16_A1B_HadCM3Q16_DM_25km_[0-9]{4}-[0-9]{4}_wss.nc'
          ),
        relative_humidity= c(
          'METO-HC_HadRM3Q16_A1B_HadCM3Q16_DM_25km_[0-9]{4}-[0-9]{4}_hurs.nc'
          ),
        surface_upward_sensible_heat_flux= c(
          'METO-HC_HadRM3Q16_A1B_HadCM3Q16_DM_25km_[0-9]{4}-[0-9]{4}_hfss.nc'
          ),
        air_temperature_minimum= c(
          'METO-HC_HadRM3Q16_A1B_HadCM3Q16_DM_25km_[0-9]{4}-[0-9]{4}_tasmin.nc'
          ),
        air_temperature_maximum= c(
          'METO-HC_HadRM3Q16_A1B_HadCM3Q16_DM_25km_[0-9]{4}-[0-9]{4}_tasmax.nc'
          ),
        surface_temperature= c(
          NA
          )
        ),
      land.mask.name = "sftls",
      land.mask = "/data/reloclim/rcu/geh/data/ensembles/landmask/METO-HC_HadRM3Q0_ERA40_FIX_25km_sftls.ens_min-new.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q16/HadCM3Q16_A1B/direct",
      gridfile.filename = "METO-HC_HadRM3Q0_CTL_ERA40_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'METO-HC_HadRM3Q3' = list(
      institute = "METO-HC",
      rcm = "HadRM3",
      gcm = "HadCM3Q3",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q3/HadCM3Q3_A1B/direct",
      file.name = list(
        air_temperature = c(
          'METO-HC_HadRM3Q3_A1B_HadCM3Q3_DM_25km_[0-9]{4}-[0-9]{4}_tas.nc'
          ),
        precipitation_amount = c(
          'METO-HC_HadRM3Q3_A1B_HadCM3Q3_DM_25km_[0-9]{4}-[0-9]{4}_pr.nc'
          ),
        global_radiation = c(
          'METO-HC_HadRM3Q3_A1B_HadCM3Q3_DM_25km_[0-9]{4}-[0-9]{4}_rsds.nc'
          ),
        wind_speed = c(
          'METO-HC_HadRM3Q3_A1B_HadCM3Q3_DM_25km_[0-9]{4}-[0-9]{4}_wss.nc'
          ),
        relative_humidity= c(
          'METO-HC_HadRM3Q3_A1B_HadCM3Q3_DM_25km_[0-9]{4}-[0-9]{4}_hurs.nc'
          ),
        surface_upward_sensible_heat_flux= c(
          'METO-HC_HadRM3Q3_A1B_HadCM3Q3_DM_25km_[0-9]{4}-[0-9]{4}_hfss.nc'
          ),
        air_temperature_minimum= c(
          'METO-HC_HadRM3Q3_A1B_HadCM3Q3_DM_25km_[0-9]{4}-[0-9]{4}_tasmin.nc'
          ),
        air_temperature_maximum= c(
          'METO-HC_HadRM3Q3_A1B_HadCM3Q3_DM_25km_[0-9]{4}-[0-9]{4}_tasmax.nc'
          ),
        surface_temperature= c(
          NA
          )
        ),
      land.mask.name = "sftls",
      land.mask = "/data/reloclim/rcu/geh/data/ensembles/landmask/METO-HC_HadRM3Q0_ERA40_FIX_25km_sftls.ens_min-new.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/HC/HadRM3Q3/HadCM3Q3_A1B/direct",
      gridfile.filename = "METO-HC_HadRM3Q0_CTL_ERA40_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'ETHZ-CLM' = list(
      institute = "ETHZ",
      rcm = "CLM",
      gcm = "HadCM3Q0",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/ETHZ/CLM/HadCM3Q0_A1B/direct",
      file.name = list(
        air_temperature = c(
          'ETHZ-CLM_SCN_HadCM3Q0_DM_25km_[0-9]{4}-[0-9]{4}_tas.nc'
          ),
        precipitation_amount = c(
          'ETHZ-CLM_SCN_HadCM3Q0_DM_25km_[0-9]{4}-[0-9]{4}_pr.nc'
          ),
        global_radiation = c(
          'ETHZ-CLM_SCN_HadCM3Q0_DM_25km_[0-9]{4}-[0-9]{4}_rsds.nc'
          ),
        wind_speed = c(
          'ETHZ-CLM_SCN_HadCM3Q0_DM_25km_[0-9]{4}-[0-9]{4}_wss.nc'
          ),
        relative_humidity= c(
          'ETHZ-CLM_SCN_HadCM3Q0_DM_25km_[0-9]{4}-[0-9]{4}_hurs.nc'
          ),
        surface_upward_sensible_heat_flux= c(
          'ETHZ-CLM_SCN_HadCM3Q0_DM_25km_[0-9]{4}-[0-9]{4}_hfss.nc'
          ),
        air_temperature_minimum= c(
          'ETHZ-CLM_SCN_HadCM3Q0_DM_25km_[0-9]{4}-[0-9]{4}_tasmin.nc'
          ),
        air_temperature_maximum= c(
          'ETHZ-CLM_SCN_HadCM3Q0_DM_25km_[0-9]{4}-[0-9]{4}_tasmax.nc'
          ),
        surface_temperature= c(
          'ETHZ-CLM_SCN_HadCM3Q0_DM_25km_[0-9]{4}-[0-9]{4}_ts.nc'
          )
        ),
      land.mask.name = "sftls",
      land.mask = "/data/reloclim/rcu/geh/data/ensembles/landmask/ETHZ-CLM_SCN_HadCM3Q0_FIX_25km_sftls.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/ETHZ/CLM/HadCM3Q0_A1B/direct",
      gridfile.filename = "ETHZ-CLM_SCN_HadCM3Q0_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'METNOHIRHAM_HadCM3Q0' = list(
      institute = "METNO",
      rcm = "HIRHAM",
      gcm = "HadCM3Q0",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/METNO/HIRHAM/HadCM3Q0_A1B/direct",
      file.name = list(
        air_temperature = c(
          'METNOHIRHAM_SRESA1B_HadCM3Q0_DM_25km_[0-9]{4}-[0-9]{4}_tas.nc'
          ),
        precipitation_amount = c(
          'METNOHIRHAM_SRESA1B_HadCM3Q0_DM_25km_[0-9]{4}-[0-9]{4}_pr.nc'
          ),
        global_radiation = c(
          'METNOHIRHAM_SRESA1B_HadCM3Q0_DM_25km_[0-9]{4}-[0-9]{4}_rsds.nc'
          ),
        wind_speed = c(
          'METNOHIRHAM_SRESA1B_HadCM3Q0_DM_25km_[0-9]{4}-[0-9]{4}_wss.nc'
          ),
        relative_humidity= c(
          'METNOHIRHAM_SRESA1B_HadCM3Q0_DM_25km_[0-9]{4}-[0-9]{4}_hurs.nc'
          ),
        surface_upward_sensible_heat_flux= c(
          'METNOHIRHAM_SRESA1B_HadCM3Q0_DM_25km_[0-9]{4}-[0-9]{4}_hfss.nc'
          ),
        air_temperature_minimum= c(
          'METNOHIRHAM_SRESA1B_HadCM3Q0_DM_25km_[0-9]{4}-[0-9]{4}_tasmin.nc'
          ),
        air_temperature_maximum= c(
          'METNOHIRHAM_SRESA1B_HadCM3Q0_DM_25km_[0-9]{4}-[0-9]{4}_tasmax.nc'
          ),
        surface_temperature= c(
          'METNOHIRHAM_SRESA1B_HadCM3Q0_DM_25km_[0-9]{4}-[0-9]{4}_ts.nc'
          )
        ),
      land.mask.name = "sftls",
      land.mask = "/data/reloclim/rcu/geh/data/ensembles/landmask/METNOHIRHAM_CTR_ERA40_FIX_25km_sftls.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/METNO/HIRHAM/HadCM3Q0_A1B/direct",
      gridfile.filename = "METNOHIRHAM_CTR_ERA40_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'METNOHIRHAM_BCM' = list(
      institute = "METNO",
      rcm = "HIRHAM",
      gcm = "BCM",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/METNO/HIRHAM/BCM_A1B/direct",
      file.name = list(
        air_temperature = c(
          'METNOHIRHAM_SRESA1B_BCM_DM_25km_[0-9]{4}-[0-9]{4}_tas.nc'
          ),
        precipitation_amount = c(
          'METNOHIRHAM_SRESA1B_BCM_DM_25km_[0-9]{4}-[0-9]{4}_pr.nc'
          ),
        global_radiation = c(
          'METNOHIRHAM_SRESA1B_BCM_DM_25km_[0-9]{4}-[0-9]{4}_rsds.nc'
          ),
        wind_speed = c(
          'METNOHIRHAM_SRESA1B_BCM_DM_25km_[0-9]{4}-[0-9]{4}_wss.nc'
          ),
        relative_humidity = c(
          'METNOHIRHAM_SRESA1B_BCM_DM_25km_[0-9]{4}-[0-9]{4}_hurs.nc'
          ),
        surface_upward_sensible_heat_flux = c(
          'METNOHIRHAM_SRESA1B_BCM_DM_25km_[0-9]{4}-[0-9]{4}_hfss.nc'
          ),
        air_temperature_minimum= c(
          'METNOHIRHAM_SRESA1B_BCM_DM_25km_[0-9]{4}-[0-9]{4}_tasmin.nc'
          ),
        air_temperature_maximum= c(
          'METNOHIRHAM_SRESA1B_BCM_DM_25km_[0-9]{4}-[0-9]{4}_tasmax.nc'
          ),
        surface_temperature= c(
          'METNOHIRHAM_SRESA1B_BCM_DM_25km_[0-9]{4}-[0-9]{4}_ts.nc'
          )
        ),
      land.mask.name = "sftls",
      land.mask = "/data/reloclim/rcu/geh/data/ensembles/landmask/METNOHIRHAM_CTR_ERA40_FIX_25km_sftls.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/METNO/HIRHAM/BCM_A1B/direct",
      gridfile.filename = "METNOHIRHAM_CTR_ERA40_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'ICTP-REGCM3' = list(
      institute = "ICTP",
      rcm = "RegCM",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/ICTP/RegCM/ECHAM5-r3_A1B/direct",
      file.name = list(
        air_temperature = c(
          'ICTP-REGCM3_A1B_ECHAM5_r3_DM_25km_[0-9]{4}-[0-9]{4}_tas.nc'
          ),
        precipitation_amount = c(
          'ICTP-REGCM3_A1B_ECHAM5_r3_DM_25km_[0-9]{4}-[0-9]{4}_pr.nc'
          ),
        global_radiation = c(
          'ICTP-REGCM3_A1B_ECHAM5_r3_DM_25km_[0-9]{4}-[0-9]{4}_rsds.nc'
          ),
        wind_speed = c(
          'ICTP-REGCM3_A1B_ECHAM5_r3_DM_25km_[0-9]{4}-[0-9]{4}_wss.nc'
          ),
        relative_humidity= c(
          'ICTP-REGCM3_A1B_ECHAM5_r3_DM_25km_[0-9]{4}-[0-9]{4}_hurs.nc'
          ),
        surface_upward_sensible_heat_flux= c(
          'ICTP-REGCM3_A1B_ECHAM5_r3_DM_25km_[0-9]{4}-[0-9]{4}_hfss.nc'
          ),
        air_temperature_minimum= c(
          'ICTP-REGCM3_A1B_ECHAM5_r3_DM_25km_[0-9]{4}-[0-9]{4}_tasmin.nc'
          ),
        air_temperature_maximum= c(
          'ICTP-REGCM3_A1B_ECHAM5_r3_DM_25km_[0-9]{4}-[0-9]{4}_tasmax.nc'
          ),
        surface_temperature= c(
          'ICTP-REGCM3_A1B_ECHAM5_r3_DM_25km_[0-9]{4}-[0-9]{4}_ts.nc'
          )
        ),
      land.mask.name = "sftls",
      land.mask = "/data/reloclim/rcu/geh/data/ensembles/landmask/ICTP-REGCM3_A1B_ECHAM5_r3_FIX_25km_sftls.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/ICTP/RegCM/ECHAM5-r3_A1B/direct",
      gridfile.filename = "ICTP-REGCM3_A1B_ECHAM5_r3_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'MPI-M-REMO' = list(
      institute = "MPI",
      rcm = "REMO",
      gcm = "ECHAM5/MPI-OM",
      gcm.run = 3,
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/MPI/REMO/ECHAM5-r3_A1B/direct",
      file.name = list(
        air_temperature = c(
          'MPI-M-REMO_SCN_ECHAM5_DM_25km_[0-9]{4}-[0-9]{4}_tas.nc'
          ),
        precipitation_amount = c(
          'MPI-M-REMO_SCN_ECHAM5_DM_25km_[0-9]{4}-[0-9]{4}_pr.nc'
          ),
        global_radiation = c(
          'MPI-M-REMO_SCN_ECHAM5_DM_25km_[0-9]{4}-[0-9]{4}_rsds.nc'
          ),
        wind_speed = c(
          'MPI-M-REMO_SCN_ECHAM5_DM_25km_[0-9]{4}-[0-9]{4}_wss.nc'
          ),
        relative_humidity= c(
          'MPI-M-REMO_SCN_ECHAM5_DM_25km_[0-9]{4}-[0-9]{4}_hurs.nc'
          ),
        surface_upward_sensible_heat_flux= c(
          'MPI-M-REMO_SCN_ECHAM5_DM_25km_[0-9]{4}-[0-9]{4}_hfss.nc'
          ),
        air_temperature_minimum= c(
          'MPI-M-REMO_SCN_ECHAM5_DM_25km_[0-9]{4}-[0-9]{4}_tasmin.nc'
          ),
        air_temperature_maximum= c(
          'MPI-M-REMO_SCN_ECHAM5_DM_25km_[0-9]{4}-[0-9]{4}_tasmax.nc'
          ),
        surface_temperature= c(
          'MPI-M-REMO_SCN_ECHAM5_DM_25km_[0-9]{4}-[0-9]{4}_ts.nc'
          )
        ),
      land.mask.name = "sftls",
      land.mask = "/data/reloclim/rcu/geh/data/ensembles/landmask/MPI-M-REMO_CTL_ERA40_FIX_25km_sftls.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/MPI/REMO/ECHAM5-r3_A1B/direct",
      gridfile.filename = "MPI-M-REMO_CTL_ERA40_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'C4IRCA3' = list(
      institute = "C4I",
      rcm = "RCA3",
      gcm = "HadCM3Q16",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/C4I/RCA/HadCM3Q16_A1B/direct",
      file.name = list(
        air_temperature = c(
          'C4IRCA3_A1B_HadCM3Q16_DM_25km_[0-9]{4}-[0-9]{4}_tas.nc'
          ),
        precipitation_amount = c(
          'C4IRCA3_A1B_HadCM3Q16_DM_25km_[0-9]{4}-[0-9]{4}_pr.nc'
          ),
        global_radiation = c(
          'C4IRCA3_A1B_HadCM3Q16_DM_25km_[0-9]{4}-[0-9]{4}_rsds.nc'
          ),
        wind_speed = c(
          'C4IRCA3_A1B_HadCM3Q16_DM_25km_[0-9]{4}-[0-9]{4}_wss.nc'
          ),
        relative_humidity= c(
          'C4IRCA3_A1B_HadCM3Q16_DM_25km_[0-9]{4}-[0-9]{4}_hurs.nc'
          ),
        surface_upward_sensible_heat_flux= c(
          'C4IRCA3_A1B_HadCM3Q16_DM_25km_[0-9]{4}-[0-9]{4}_hfss.nc'
          ),
        air_temperature_minimum= c(
          'C4IRCA3_A1B_HadCM3Q16_DM_25km_[0-9]{4}-[0-9]{4}_tasmin.nc'
          ),
        air_temperature_maximum= c(
          'C4IRCA3_A1B_HadCM3Q16_DM_25km_[0-9]{4}-[0-9]{4}_tasmax.nc'
          ),
        surface_temperature= c(
          'C4IRCA3_A1B_HadCM3Q16_DM_25km_[0-9]{4}-[0-9]{4}_ts.nc'
          )
        ),
      land.mask.name = "sftls",
      land.mask = "/data/reloclim/rcu/geh/data/ensembles/landmask/C4IRCA3_CTL_ERA40_FIX_25km_sftls.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/C4I/RCA/HadCM3Q16_A1B/direct",
      gridfile.filename = "C4IRCA3_CTL_ERA40_FIX_25km_orog.nc",
      resolution = "25km",
      calendar = "360_days",
      count.first.time.value = "julian"
      ),
###########################################################################
    'CNRM-RM5.1' = list(
      institute = "CNRM",
      rcm = "RM5.1",
      gcm = "ARPEGE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/CNRM/ALADIN/ARPEGE5.1_A1B/direct",
      file.name = list(
        air_temperature = c(
          'CNRM-RM5.1_SCN_ARPEGE_DM_25km_[0-9]{4}-[0-9]{4}_tas.nc'
          ),
        precipitation_amount = c(
          'CNRM-RM5.1_SCN_ARPEGE_DM_25km_[0-9]{4}-[0-9]{4}_pr.nc'
          ),
        global_radiation = c(
          'CNRM-RM5.1_SCN_ARPEGE_DM_25km_[0-9]{4}-[0-9]{4}_rsds.nc'
          ),
        wind_speed = c(
          'CNRM-RM5.1_SCN_ARPEGE_DM_25km_[0-9]{4}-[0-9]{4}_wss.nc'
          ),
        relative_humidity= c(
          'CNRM-RM5.1_SCN_ARPEGE_DM_25km_[0-9]{4}-[0-9]{4}_hurs.nc'
          ),
        surface_upward_sensible_heat_flux= c(
          'CNRM-RM5.1_SCN_ARPEGE_DM_25km_[0-9]{4}-[0-9]{4}_hfss.nc'
          ),
        air_temperature_minimum= c(
          'CNRM-RM5.1_SCN_ARPEGE_DM_25km_[0-9]{4}-[0-9]{4}_tasmin.nc'
          ),
        air_temperature_maximum= c(
          'CNRM-RM5.1_SCN_ARPEGE_DM_25km_[0-9]{4}-[0-9]{4}_tasmax.nc'
          ),
        surface_temperature= c(
          'CNRM-RM5.1_SCN_ARPEGE_DM_25km_[0-9]{4}-[0-9]{4}_ts.nc'
          )
        ),
      land.mask.name = "sftls",
      land.mask = "/data/reloclim/rcu/geh/data/ensembles/landmask/CNRM-RM4.5_SCN_ARPEGE_FIX_25km_sftls.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/CNRM/ALADIN/ARPEGE5.1_A1B/direct",
      gridfile.filename = "CNRM-RM4.5_SCN_ARPEGE_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'CNRM-RM4.5' = list(
      institute = "CNRM",
      rcm = "RM4.5",
      gcm = "ARPEGE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/CNRM/ALADIN/ARPEGE4.5_A1B/direct",
      file.name = list(
        air_temperature = c(
          'CNRM-RM4.5_SCN_ARPEGE_DM_25km_[0-9]{4}-[0-9]{4}_tas.nc'
          ),
        precipitation_amount = c(
          'CNRM-RM4.5_SCN_ARPEGE_DM_25km_[0-9]{4}-[0-9]{4}_pr.nc'
          ),
        global_radiation = c(
          'CNRM-RM4.5_SCN_ARPEGE_DM_25km_[0-9]{4}-[0-9]{4}_rsds.nc'
          ),
        wind_speed = c(
          'CNRM-RM4.5_SCN_ARPEGE_DM_25km_[0-9]{4}-[0-9]{4}_wss.nc'
          ),
        relative_humidity= c(
          'CNRM-RM4.5_SCN_ARPEGE_DM_25km_[0-9]{4}-[0-9]{4}_hurs.nc'
          ),
        surface_upward_sensible_heat_flux= c(
          NA
          ),
        air_temperature_minimum= c(
          'CNRM-RM4.5_SCN_ARPEGE_DM_25km_[0-9]{4}-[0-9]{4}_tasmin.nc'
          ),
        air_temperature_maximum= c(
          'CNRM-RM4.5_SCN_ARPEGE_DM_25km_[0-9]{4}-[0-9]{4}_tasmax.nc'
          ),
        surface_temperature= c(
          NA
          )
        ),
      land.mask.name = "sftls",
      land.mask = "/data/reloclim/rcu/geh/data/ensembles/landmask/CNRM-RM4.5_SCN_ARPEGE_FIX_25km_sftls.nc",
      gridfile.path = "/data/reloclim/rcm/ENSEMBLES/CNRM/ALADIN/ARPEGE4.5_A1B/direct",
      gridfile.filename = "CNRM-RM4.5_SCN_ARPEGE_FIX_25km_orog.nc",
      resolution = "25km"
      ),
###########################################################################
    'DMI-HIRHAM5_ARPEGE' = list(
      institute = "DMI",
      rcm = "HIRHAM",
      gcm = "ARPEGE",
      emission.scenario = "A1B",
      file.path.default = "/data/reloclim/rcm/ENSEMBLES/DMI/HIRHAM/ARPEGE_A1B/direct",
      file.name = list(
        air_temperature = c(
          'DMI-HIRHAM5_A1B_ARPEGE_DM_25km_[0-9]{4}-[0-9]{4}_tas.nc'
          ),
        precipitation_amount = c(
