% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tts_methods.R
\name{tts_methods}
\alias{tts_methods}
\alias{summary.tts}
\alias{print.tts}
\alias{set_times.tts}
\alias{set_timescales.tts}
\alias{set_values.tts}
\alias{get_times.tts}
\alias{get_timescales.tts}
\alias{get_values.tts}
\title{Basic methods for the \code{tts} class}
\usage{
\method{summary}{tts}(object, ...)

\method{print}{tts}(x, ...)

\method{set_times}{tts}(obj, newval)

\method{set_timescales}{tts}(obj, newval)

\method{set_values}{tts}(obj, newval)

\method{get_times}{tts}(obj)

\method{get_timescales}{tts}(obj)

\method{get_values}{tts}(obj)
}
\arguments{
\item{object, x, obj}{An object of class \code{tts}}

\item{...}{Not currently used. Included for argument consistency
with existing generics.}

\item{newval}{A new value, for the \code{set_*} methods}
}
\value{
\code{summary.tts} produces a summary of a \code{tts} object.
A \code{print.tts} method is also available. For \code{tts} objects, 
\code{set_*} and \code{get_*} methods are available for all slots,
i.e., \code{*} equal to \code{times}, \code{timescales}, and 
\code{values}. The \code{set_*} methods just throw an error. Although
class \code{tts} is flexible enough that setting of individual slots
could have been allowed, because \code{wt} and other classes are 
based on it and because individual slots of those classes should not 
be changed, for consistency the same is forced for the \code{tts} 
class.
}
\description{
Set, get, summary, and print methods for the \code{tts} class.
}
\examples{
times<-1:10
timescales<-1/c(1:10)
values<-matrix(1,length(times),length(timescales))
h<-tts(times,timescales,values)
get_times(h)
summary(h)
print(h)

}
\seealso{
\code{\link{tts}}
}
\author{
Daniel Reuman, \email{reuman@ku.edu}
}
