% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fftsurrog.R
\name{fftsurrog}
\alias{fftsurrog}
\title{Surrogate time series using Fourier surrogates}
\usage{
fftsurrog(dat, nsurrogs, syncpres)
}
\arguments{
\item{dat}{A locations x time matrix of observations}

\item{nsurrogs}{The number of surrogates to produce}

\item{syncpres}{Logical. TRUE for "synchrony preserving" surrogates (same phase randomizations used for all 
time series). FALSE leads to independent phase randomizations for all time series.}
}
\value{
\code{fftsurrog} returns a list of nsurrogs surrogate datasets
}
\description{
Creates surrogate time series using Fourier surrogates
}
\note{
For internal use, no error checking
}
\references{
Sheppard, LW, et al. (2016) Changes in large-scale climate alter spatial synchrony of aphid pests. Nature Climate Change. DOI: 10.1038/nclimate2881

Schreiber, T and Schmitz, A (2000) Surrogate time series. Physica D 142, 346-382.

Prichard, D and Theiler, J (1994) Generating surrogate data for time series with several simultaneously measured variables. Physical Review Letters 73, 951-954.
}
\author{
Jonathan Walter, \email{jaw3es@virginia.edu}; Lawrence Sheppard, \email{lwsheppard@ku.edu}; 
Daniel Reuman, \email{reuman@ku.edu}
}
