% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/census_geo_api.R
\name{census_geo_api}
\alias{census_geo_api}
\title{Census Data download function.}
\usage{
census_geo_api(key, state, geo = "tract", age = FALSE, sex = FALSE,
  retry = 0)
}
\arguments{
\item{key}{A required character object. Must contain user's Census API
key, which can be requested \href{https://api.census.gov/data/key_signup.html}{here}.}

\item{state}{A required character object specifying which state to extract Census data for, 
e.g., \code{"NJ"}.}

\item{geo}{A character object specifying what aggregation level to use. 
Use \code{"county"}, \code{"tract"}, or \code{"block"}. Default is \code{"tract"}. 
Warning: extracting block-level data takes very long.}

\item{age}{A \code{TRUE}/\code{FALSE} object indicating whether to condition on 
age or not. If \code{FALSE} (default), function will return Pr(Geolocation | Race).
If \code{TRUE}, function will return Pr(Geolocation, Age | Race). 
If \code{\var{sex}} is also \code{TRUE}, function will return Pr(Geolocation, Age, Sex | Race).}

\item{sex}{A \code{TRUE}/\code{FALSE} object indicating whether to condition on 
sex or not. If \code{FALSE} (default), function will return Pr(Geolocation | Race). 
If \code{TRUE}, function will return Pr(Geolocation, Sex | Race). 
If \code{\var{age}} is also \code{TRUE}, function will return Pr(Geolocation, Age, Sex | Race).}

\item{retry}{The number of retries at the census website if network interruption occurs.}
}
\value{
Output will be an object of class \code{list}, indexed by state names. It will 
 consist of the original user-input data with additional columns of Census geographic data.
}
\description{
\code{census_geo_api} retrieves U.S. Census geographic data for a given state.
}
\details{
This function allows users to download U.S. Census 2010 geographic data, 
at either the county, tract, or block level, for a particular state.
}
\examples{
\dontshow{data(voters)}
\dontrun{census_geo_api(key = "...", states = c("NJ", "DE"), geo = "block")}
\dontrun{census_geo_api(key = "...", states = "FL", geo = "tract", age = TRUE, sex = TRUE)}

}
\references{
Relies on get_census_api, get_census_api_2, and vec_to_chunk functions authored by Nicholas Nagle, 
available \href{https://rstudio-pubs-static.s3.amazonaws.com/19337_2e7f827190514c569ea136db788ce850.html}{here}.
}
