% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc.R
\name{sx}
\alias{sx}
\title{String eXplode. Parse argument as a vector of string allowing "blank separators".}
\usage{
sx(s, ..., sep_symbols = ",|", strict = TRUE)
}
\arguments{
\item{s}{string to parse}

\item{...}{force later arguments to be set by name}

\item{sep_symbols}{characters to consider separators}

\item{strict}{logical, if TRUE throw exception on confusing input}
}
\value{
vector of values
}
\description{
Separates string data on whitespace and separating symbols into an array.
}
\details{
Can throw exception on lack of explicit value separators, example: \code{bc('"a""b"')} and  non-matching portions.
Whitespace is normalized to spaces.
Suggested by Emil Erik Pula Bellamy Begtrup-Bright \url{https://github.com/WinVector/wrapr/issues/15}.
}
\examples{

sx('1 2 "c", d') # returns c("1", "2", "c", "d")
sx('1 2 3') # returns c("1", "2", "3")
sx('1 2 "3"') # returns c("1", "2", "3")
sx('1,2|3.4') # returns c("1", "2", "3.4")
sx('01 02') # returns c("01", "02")

}
\seealso{
\code{\link{qc}}, \code{\link{qe}}, \code{\link{qae}}, \code{\link[base]{bquote}}, \code{\link{bc}}
}
