% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tempNameGenerator.R
\name{mk_tmp_name_source}
\alias{mk_tmp_name_source}
\title{Produce a temp name generator with a given prefix.}
\usage{
mk_tmp_name_source(prefix = "tmpnam", ...,
  alphabet = as.character(0:9), size = 20, sep = "_")
}
\arguments{
\item{prefix}{character, string to prefix temp names with.}

\item{...}{force later argument to be bound by name.}

\item{alphabet}{character, characters to choose from in building ids.}

\item{size}{character, number of characters to build id portion of names from.}

\item{sep}{character, separator between temp name fields.}
}
\value{
name generator function.
}
\description{
Returns a function f where: f() returns a new temporary name,
f(remove=vector) removes names in vector and returns what was removed,
f(dumpList=TRUE) returns the list of names generated and clears the list,
f(peek=TRUE) returns the list without altering anything.
}
\examples{

f <- mk_tmp_name_source('ex')
print(f())
nm2 <- f()
print(nm2)
f(remove=nm2)
print(f(dumpList=TRUE))

}
