% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addMassModif.R
\name{addMassModif}
\alias{addMassModif}
\title{Add modifications to peptide mass}
\usage{
addMassModif(
  cou,
  pepTab,
  combTerm,
  modTy,
  lastIndex = NULL,
  modChem = NULL,
  basVarMod = "basMod",
  massTy = "mono",
  knownMods = NULL,
  nProc = 1,
  parallDefault = TRUE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{cou}{(list) list of matrixes with counts for number of modifications per peptide}

\item{pepTab}{(matrix) table with peptide properties}

\item{combTerm}{(matrix) table with separate rows for $basMod that are exclusive (ie can't be accumulated, eg x & y ions)}

\item{modTy}{(character) list of modification types to be considered}

\item{lastIndex}{(integer) index-1 (ie last index from prev matrix) from which new peptide-variants should start from}

\item{modChem}{(character) optional modifications}

\item{basVarMod}{(character) toggle if fixed ('basMod') or variable ('varMod') modificatons should be calculated}

\item{massTy}{(character) default 'mono'}

\item{knownMods}{(list) optional custom definition whoch modification is N-term, etc (see \code{\link{AAfragSettings}}}

\item{nProc}{(integer) number of processors in case of multi-processor use (requires Bioconductor package \code{BiocParallel})}

\item{parallDefault}{(logical) for use of other/previously set \code{register(bpstart())} in case \code{.parCombinateAllAndSum} is called}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) for bug-tracking: more/enhanced messages and intermediate objects written in global name-space}

\item{callFrom}{(character) allows easier tracking of message(s) produced}
}
\value{
list of $pepTab (table of peptide as single charge positive ions), $abc ('representative' list of all combinations to add). Main result in $pepTab
}
\description{
Adjust/add mass for modifications from 'modTy' to all peptides in 'pepTab' based on count 'cou' of occurances of modifications :
Either fixed or variable modifications will be added to the mass of initial peptides from argument \code{papTab}.
Terminal ionization (like 'b' or 'y' -fragments) is treated as fixed modification and the resulting masses will correspond to standard mono-protonated ions.
Since variable and fixed modification types can't be run in a single instance, the function has to get calles twice, it is recommended to always start with the fixed modfications,
In the case of fixed modifications (like defining 'b' or 'y' fragments) neutral peptide masses should be given to add the corresponding mass-shift (and to obtain mono-protonated ions).
In case of variable modifications (like 'd' or 'p'), the corresponding ions from the fixed modifications should get furnished to add the corresponding mass-shift,
the masses resulting from the initial fixed modifications run can be used.  
Note, that transforming a neutral precursor M into MH+ is also considered a modification. 
The results are also correct with obligatory fragments that can't occur the same time (eg x & y ions can't be same time, need to make add'l lines...).
This function has a multiprocessor mode, with small data-sets (like the toy example below) there is typcally no gain in performance.
}
\examples{
pep1 <- c(pe1="KPEPTI")
# The table of possible terminal fragments (for simplicity terminal only)
pepTab1 <- makeFragments(pep1, min=3, max=7, internFra=FALSE)
# Which fragment may be subject to how many modification (including ionization by H+)
cou1 <- countPotModifAAs(pepTab=pepTab1, modTy=list(basMod=c("b","y")))
# Add modifications (here: ionize all pepptides by H+)
preMa1 <- addMassModif(cou=cou1$cou, pepTab=pepTab1, combTerm=cou1$combTerm, 
  modTy=list(basMod=c("b","y")), basVarMod="basMod")
preMa1

## Example including variable modifications
modT3 <- list(basMod=c("b","y"),varMod=c("p","h","d"))
cou3 <- countPotModifAAs(pepTab=pepTab1, modTy=modT3)
## Now we re-use/inject the results for the fixed modificatons
preMa3 <- addMassModif(cou=cou3$cou, pepTab=preMa1$pepTab, combTerm=cou1$combTerm, 
  modTy=modT3, basVarMod="varMod")
head(preMa3$pepTab,12)
}
\seealso{
\code{\link[wrMisc]{convToNum}}
}
