% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractTestingResults.R
\name{extractTestingResults}
\alias{extractTestingResults}
\title{Extract results from moderated t-tests}
\usage{
extractTestingResults(
  stat,
  compNo = 1,
  statTy = "BH",
  thrsh = 0.05,
  FCthrs = 1.5,
  annotCol = c("Accession", "EntryName", "GeneName"),
  nSign = 6,
  add = "allMeans",
  filename = NULL,
  fileTy = "csvUS",
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{stat}{('MArrayLM'-object or list) Designed for the output from \code{moderTest2grp} or \code{moderTestXgrp}}

\item{compNo}{(integer) the comparison number/index to be used}

\item{statTy}{(character) the multiple-testing correction type to be considered when looking for significant changes  with threshold \code{thrsh} (depends on which have been run initially with \code{moderTest2grp} or \code{moderTestXgrp})}

\item{thrsh}{(numeric) the threshold to be applied on \code{statTy} for the result of the statistcal testing (after multiple testing correction)}

\item{FCthrs}{(numeric) Fold-Change threshold given as Fold-change and NOT log2(FC), default at 1.5 (for filtering at M-value =0.585)}

\item{annotCol}{(character) column-names from the annotation to be included}

\item{nSign}{(integer) number of significant digits whe returning results}

\item{add}{(character) additional groups to add (so far only "allMeans" available) in addition to the means used in the pairwise comparison}

\item{filename}{(character) optional (path and) file-name for exporting results to csv-file}

\item{fileTy}{(character) file-type to be used with argument \code{filename}, may be 'csvEur' or 'csvUS'}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
limma-type MA-object (list)
}
\description{
This function allows convenient access to results produced using the functions \code{\link{moderTest2grp}} or \code{moderTestXgrp}.
The user can define the threshold which type of multiple testing correction should be used
 (as long as the  multiple testing correction method was actually performed as part of testing).
}
\examples{
grp <- factor(rep(LETTERS[c(3,1,4)],c(2,3,3)))
set.seed(2017); t8 <- matrix(round(rnorm(208*8,10,0.4),2), ncol=8,
  dimnames=list(paste(letters[],rep(1:8,each=26),sep=""), paste(grp,c(1:2,1:3,1:3),sep="")))
t8[3:6,1:2] <- t8[3:6,1:2] +3                    # augment lines 3:6 (c-f) 
t8[5:8,c(1:2,6:8)] <- t8[5:8,c(1:2,6:8)] -1.5    # lower lines 
t8[6:7,3:5] <- t8[6:7,3:5] +2.2                  # augment lines 
## expect to find C/A in c,d,g, (h)
## expect to find C/D in c,d,e,f
## expect to find A/D in f,g,(h) 
library(wrMisc)     # for testing we'll use this package
test8 <- moderTestXgrp(t8, grp) 
extractTestingResults(test8)
}
\seealso{
\code{\link{moderTest2grp}} for single comparisons, \code{\link{moderTestXgrp}} for multiple comparisons, \code{\link[limma]{lmFit}} and the \code{eBayes}-family of functions in package \href{https://bioconductor.org/packages/release/bioc/html/limma.html}{limma}
}
