% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowMedSds.R
\name{rowMedSds}
\alias{rowMedSds}
\title{sd of median for each row by bootstrap}
\usage{
rowMedSds(dat, nBoot = 99)
}
\arguments{
\item{dat}{(numeric) matix, main input}

\item{nBoot}{(integer) number if iterations for bootstrap}
}
\value{
(numeric) vector with estimated standard errors
}
\description{
\code{rowMedSds} determines the stand error (sd) of the median for each row by bootstraping each row of 'dat'.
Note: requires package \href{https://CRAN.R-project.org/package=boot}{boot}
}
\examples{
set.seed(2016); dat1 <- matrix(c(runif(200)+rep(1:10,20)), ncol=10)
rowMedSds(dat1) ; plot(rowSds(dat1), rowMedSds(dat1))
}
\seealso{
\code{\link[boot]{boot}}
}
