% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiMatch.R
\name{multiMatch}
\alias{multiMatch}
\title{Simple Multi-to-Multi Matching of (Concatenated) Terms}
\usage{
multiMatch(
  x,
  y,
  sep = "; ",
  sep2 = NULL,
  method = "byX",
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x}{(vector or list) first object to compare; if vector, the (partially) concatenated identifyers (will be split using separator \code{sep}), or list of items to be matched (ie already split)}

\item{y}{(vector or list) second object to compare; if vector, the (partially) concatenated identifyers (will be split using separator \code{sep}), or list of items to be matched (ie already split)}

\item{sep}{(character, length=1) separator used to split concatenated identifyers (if \code{x} or  \code{y} is vector)}

\item{sep2}{(character, length=1) optional separator used when \code{method="matched"} to concatenate all indexes of \code{y} for column \code{y.allInd}}

\item{method}{(character) mode of operation: 'asIndex' to return index of y (those hwo have matches) with names of x (which x are the correpsonding match)}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
matrix, data.frame or list with matching results depending on \code{method} chosen
}
\description{
This function allows convenient matching of multi-to-multi relationships between two objects/vectors. 
It was designed for finding common elements in multiple to multiple matching situations (eg when comparing \code{c("aa; bb", "cc")}  to \code{c("bb; ab","dd")}, 
ie to find 'bb' as matching between both objects).
}
\details{
\code{method='byX'} .. returns data.frame with view oriented towards entries of \code{x}: character column \code{x} for entire content of \code{x}; integer column \code{x.Ind} for index of \code{x}; 
 character column \code{TagBest} for most frequent matching isolated tag/ID; integer column \code{y.IndBest} index of most frequent matching \code{y};
 character column \code{y.IndAll} index for all \code{y} matching any of the tags;
 character column \code{y.Match} for entire content of best matching \code{y}; 
 character column \code{y.Adj} for \code{y} adjusted to best matching \code{y} for easier subsequent perfect matching.
                                                                                                                                                      
\code{method=c("byX","filter")} .. combinded argument to keep only lines with any matches 
                                                                                                                                                      
\code{method='byTag'} .. returns matrix (of integers) from view of isolated tags from \code{x} (a separate line for each tag from  \code{x} matching to \code{y});

\code{method=c("byTag","filter")} ..if combined as arguments, this will return a data.frame for all unique tags with any matches between \code{x} and \code{y}, with 
  additional colunms \code{x.AllInd} for all matching \code{x}-indexes,  \code{y.IndBest} best matching \code{y} index; \code{x.n} for number of different \code{x} conatining this tag;
\code{y.AllInd} for all matching \code{y}-indexes 

\code{method='adjustXtoY'} .. returns vector with \code{x} adjusted to \code{y}, ie those elements of \code{x} matching are replace by the exact corresponding term of \code{y}.
                                                                                                                                                      
\code{method=NULL} .. If no term matching the options shown above is given, another version of 'asIndex' is returned, but indexes to \code{y} _after_ spliting by \code{sep}. 
Again, this method can be filtered by using \code{method="filter"} to focus on the best matches to \code{x}.
}
\examples{
aa <- c("m","k", "j; aa", "m; aa; bb; o; ee", "n; dd; cc", "aa", "cc")
bb <- c("dd; r", "aa", "ee; bb; q; cc", "p; cc")
(match1 <- multiMatch(aa, bb, method=NULL))      # match bb to aa
(match2 <- multiMatch(aa, bb, method="byX"))     # match bb to aa
(match3 <- multiMatch(aa, bb, method="byTag"))   # match bb to aa
(match4 <- multiMatch(aa, bb, method=c("byTag","filter")))   # match bb to aa

}
\seealso{
\code{\link[base]{match}}; \code{\link[base]{strsplit}}
}
