% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuseCommonListElem.R
\name{fuseCommonListElem}
\alias{fuseCommonListElem}
\title{Fuse content of list-elements with redundant (duplicated) names}
\usage{
fuseCommonListElem(
  lst,
  initOrd = TRUE,
  removeDuplicates = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{lst}{(list) main input, list of numeric vectors}

\item{initOrd}{(logical) preserve initial order in output (if TRUE) or otherwise sort alphabetically}

\item{removeDuplicates}{(logical) allow to remove duplicate entries (if vector contains names, both the name and the value need to be identical to be removed; note: all names must have names with more than 0 characters to be considered as names)}

\item{callFrom}{(character) allows easier tracking of message(s) produced}
}
\value{
fused list (same names as elements of input)
}
\description{
\code{fuseCommonListElem} fuses (character or numeric) elements of list re-occuring under same name, so that resultant list has unique names.
Note : will not work with list of matrixes
}
\examples{
val1 <- 10 +1:26
names(val1) <- letters
lst1 <- list(c=val1[3:6],a=val1[1:3],b=val1[2:3],a=val1[12],c=val1[13])
fuseCommonListElem(lst1)
}
\seealso{
\code{\link[base]{unlist}}
}
