% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cutArrayInCluLike.R
\name{cutArrayInCluLike}
\alias{cutArrayInCluLike}
\title{Cut 3-dim array in list of matrixes (or arrays) similar to organizing into clusters}
\usage{
cutArrayInCluLike(dat, cluOrg, silent = FALSE, debug = FALSE, callFrom = NULL)
}
\arguments{
\item{dat}{array (3 dim)}

\item{cluOrg}{(factor) organization of lines to clusters}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) display additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
This function retruns a list of matrixes (or arrays)
}
\description{
\code{cutArrayInCluLike} cuts 'dat' (matrix,data.frame or 3-dim array) in list (of appended lines) according to 'cluOrg', 
 which serves as instruction which line of 'dat' should be placed in which list-element (like sorting according to cluster-numbers).
}
\examples{
mat1 <- matrix(1:30,nc=3,dimnames=list(letters[1:10],1:3))
cutArrayInCluLike(mat1,cluOrg=factor(c(2,rep(1:4,2),5)))
}
