% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeSelCol.R
\name{mergeSelCol3}
\alias{mergeSelCol3}
\title{mergeSelCol3}
\usage{
mergeSelCol3(dat1, dat2, dat3, selCols, supCols2 = NULL,
  supCols3 = NULL, byC = NULL, useAll = FALSE, setRownames = TRUE,
  newSuff = c(".x", ".y", ".z"), callFrom = NULL)
}
\arguments{
\item{dat1}{matrix or data.frame for fusing}

\item{dat2}{matrix or data.frame for fusing}

\item{dat3}{matrix or data.frame for fusing}

\item{selCols}{will be used to define columns to be used; optionally may be different for 'dat2' : define in 'supCols2'}

\item{supCols2}{if additional column-names should be extracted form dat2}

\item{supCols3}{if additional column-names should be extracted form dat3}

\item{byC}{(character) 'by' value used in \code{\link[base]{merge}}}

\item{useAll}{(logical) use all lines (will produce NAs when given identifyer not found un 2nd group of data)}

\item{setRownames}{if TRUE, will use values of col used as 'by' as rownames instead of showing as add'l col in output}

\item{newSuff}{(character) prefix (argument 'suffixes' in \code{merge})}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
data.frame
}
\description{
successive merge of selected columns out of 3 matrix or data.frames.
'selCols' will be used to define columns to be used; optionally may be different for 'dat2' : define in 'supCols2'. 
Output-cols will get additions specified in newSuff (default '.x' and '.y')
}
\examples{
mat1 <- matrix(c(1:7,letters[1:7],11:17),ncol=3,dimnames=list(LETTERS[1:7],c("x1","x2","x3")))
mat2 <- matrix(c(1:6,c("b","a","e","f","g","k"),31:36),ncol=3,
  dimnames=list(LETTERS[11:16],c("y1","x2","x3")))
mat3 <- matrix(c(1:6,c("c","a","e","b","g","k"),51:56),ncol=3,
  dimnames=list(LETTERS[11:16],c("z1","x2","x3")))
mergeSelCol3(mat1,mat2,mat3,selC=c("x2","x3"))
}
\seealso{
\code{\link[base]{merge}}, \code{\link{mergeSelCol}}
}
