% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_trndseason.R
\name{show_trndseason}
\alias{show_trndseason}
\title{Plot rates of change based on seasonal metrics}
\usage{
show_trndseason(
  mod,
  metfun = mean,
  doystr = 1,
  doyend = 364,
  type = c("log10", "approx"),
  justify = c("left", "right", "center"),
  win = 5,
  ylab,
  nsim = 10000,
  useave = FALSE,
  usearrow = FALSE,
  base_size = 11,
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{mod}{input model object as returned by \code{\link{anlz_gam}}}

\item{metfun}{function input for metric to calculate, e.g., \code{mean}, \code{var}, \code{max}, etc}

\item{doystr}{numeric indicating start Julian day for extracting averages}

\item{doyend}{numeric indicating ending Julian day for extracting averages}

\item{type}{chr string indicating if log slopes are shown (if applicable)}

\item{justify}{chr string indicating the justification for the trend window}

\item{win}{numeric indicating number of years to use for the trend window, see details}

\item{ylab}{chr string for y-axis label}

\item{nsim}{numeric indicating number of random draws for simulating uncertainty}

\item{useave}{logical indicating if \code{anlz_avgseason} is used for the seasonal metric calculation}

\item{usearrow}{logical indicating if arrows should be used to indicate significant trend direction}

\item{base_size}{numeric indicating base font size, passed to \code{\link[ggplot2]{theme_bw}}}

\item{xlim}{optional numeric vector of length two for x-axis limits}

\item{ylim}{optional numeric vector of length two for y-axis limits}

\item{...}{additional arguments passed to \code{metfun}, e.g., \code{na.rm = TRUE)}}
}
\value{
A \code{\link[ggplot2]{ggplot}} object
}
\description{
Plot rates of change based on seasonal metrics
}
\examples{
library(dplyr)

# data to model
tomod <- rawdat \%>\%
  filter(station \%in\% 34) \%>\%
  filter(param \%in\% 'chl') \%>\% 
  filter(yr > 2015)

mod <- anlz_gam(tomod, trans = 'log10')
show_trndseason(mod, doystr = 90, doyend = 180, justify = 'left', win = 4,
     ylab = 'Slope Chlorophyll-a (ug/L/yr)')
}
\concept{show}
