% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_perchg.R
\name{show_perchg}
\alias{show_perchg}
\title{Plot percent change trends from GAM results for selected time periods}
\usage{
show_perchg(
  mod,
  baseyr,
  testyr,
  ylab,
  base_size = 11,
  xlim = NULL,
  ylim = NULL
)
}
\arguments{
\item{mod}{input model object as returned by \code{\link{anlz_gam}}}

\item{baseyr}{numeric vector of starting years}

\item{testyr}{numeric vector of ending years}

\item{ylab}{chr string for y-axis label}

\item{base_size}{numeric indicating base font size, passed to \code{\link[ggplot2]{theme_bw}}}

\item{xlim}{optional numeric vector of length two for x-axis limits}

\item{ylim}{optional numeric vector of length two for y-axis limits}
}
\value{
A \code{\link[ggplot2]{ggplot}} object
}
\description{
Plot percent change trends from GAM results for selected time periods
}
\examples{
library(dplyr)

# data to model
tomod <- rawdat \%>\%
  filter(station \%in\% 34) \%>\%
  filter(param \%in\% 'chl')
  
mod <- anlz_gam(tomod, trans = 'log10')

show_perchg(mod, baseyr = 1990, testyr = 2016, ylab = 'Chlorophyll-a (ug/L)')
}
\concept{show}
