\name{utilities}
\Rdversion{1.1}
\alias{date2decyear}
\alias{decyear2date}
\alias{layerMean}
\alias{leapYear}
\alias{meanSub}
\alias{monthNum}
\alias{tsSub}
\alias{years}

\title{
  Miscellaneous utility functions
}

\description{
  A variety of small utilities used in other functions.
  
  \code{date2decyear}: Converts object of class \code{"Date"} to decimal year assuming time of day is noon.
  
  \code{decyear2date}: Converts decimal year to object of class \code{"Date"}.

  \code{layerMean}: Acts on a matrix or data frame with depth in the first column and observations for different variables (or different sites, or different times) in each of the remaining columns. The trapezoidal mean over the given depths is calculated for each of the variables. Replicate depths are averaged, and missing values or data with only one unique depth are handled. Data are not extrapolated to cover missing values at the top or bottom of the layer. The result can differ markedly from the simple mean even for equal spacing of depths, because the top and bottom values are weighted by 0.5 in a trapezoidal mean.
  
  \code{leapYear}: \code{TRUE} if \code{x} is a leap year, \code{FALSE} otherwise.
  
  \code{meanSub}: Mean of a subset of a vector.
  
  \code{monthNum}: Converts dates to the corresponding numeric month.
  
  \code{tsSub}: Drops seasons from a matrix or vector time series.

  \code{years}: Converts dates to the corresponding numeric years.
}

\usage{
date2decyear(w)

decyear2date(x)

layerMean(d)

leapYear(x)

meanSub(x, sub, na.rm = FALSE)

monthNum(y)

tsSub(x1, seas = 1:frequency(x1))

years(y)
}

\arguments{
   \item{d}{
    A numeric matrix or data frame with depth in the first column and observations for some variable in each of the remaining columns.
  }
  \item{na.rm}{
    Should missing data be removed?
  }
  \item{seas}{
    An integer vector of seasons to be retained.
  }
  \item{sub}{
    An integer vector.
  }
  \item{w}{
    A vector of class \code{"Date"}.
  }
  \item{x}{
    A numeric vector.
  }
  \item{x1}{
    A matrix or vector time series.
  }
  \item{y}{
    A vector of class \code{"Date"} or \code{"POSIX"} date-time.
  }
}

\examples{
dates <- as.Date(c("1996-01-01", "1999-12-31", "2004-02-29", "2005-03-01"))
date2decyear(dates)

decyear2date(c(1996.0014, 1999.9986, 2004.1626, 2005.1630))

z = c(1,2,3,5,10)  # 5 depths
x = matrix(rnorm(30), nrow = 5)  # 6 variables at 5 depths
layerMean(cbind(z, x))

leapYear(seq(1500, 2000, 100))
leapYear(c(1996.9, 1997))

## Aggregate monthly time series over Feb-Apr only.
aggregate(sfbayChla, 1, meanSub, sub=2:4)

monthNum(as.Date(c('2007-03-17', '2003-06-01')))

## Ignore certain seasons in a Seasonal Kendall test.
c27 <- sfbayChla[, 's27']
seaKen(tsSub(c27))  # Aug and Dec missing the most key data
seaKen(tsSub(c27, seas = c(1:7, 9:11)))

y = Sys.time()
years(y)
}

\keyword{manip}
