% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worms_func.R
\name{wormsbynames}
\alias{wormsbynames}
\title{GET AphiaRecordsByNames}
\usage{
wormsbynames(taxon_names, ids = FALSE, match = FALSE, verbose = TRUE,
  chunksize = 50, like = "false", marine_only = "true",
  sleep_btw_chunks_in_sec = 0.1)
}
\arguments{
\item{taxon_names}{character vector with names of taxa to look up.}

\item{ids}{add column "id" and "name" with running id and search names}

\item{match}{taxon_names that could not retrieved will be retried with \code{\link{wormsbymatchnames}}. Implies "id=TRUE"}

\item{verbose}{be verbose}

\item{chunksize}{there is a limit to the number of taxa that can be looked up at once, so request are split up into chunks. This limit seems to be variable. 50 is very safe.}

\item{like}{Add a "\%"-sign after the ScientificName (SQL LIKE function). Default=true}

\item{marine_only}{Limit to marine taxa. Default=true}

\item{sleep_btw_chunks_in_sec}{pause between requests}
}
\value{
a data frame.
}
\description{
takes character vector with taxon names and retrives AphiaRecords from WoRMS
}
\details{
This function will take a character vector with taxon names, 
retrive AphiaRecords (CC-BY) from www.marinespecies.org using the 
GET /AphiaRecordsByName/{ScientificName} Method described at
http://www.marinespecies.org/rest/.
Results will be output to a data.frame with each row being a record.
For each name given, only the one AphiaRecord will be retrived. AphiaRecord with "accepted" status are preferred.
If  not present last entry will be taken which seems to result in best results.
}
\examples{
taxon_names <- c( "Westwodilla caecula" ,  "Abra alba", "Chaetozone cf. setosa",  "Algae" )
w <- wormsbynames(taxon_names)
## print unrecognized returns
failed_species <- rownames(w[is.na(w[,1]),])

## try again with fuzzy matching turned on
\donttest{w <- wormsbynames(taxon_names, match=TRUE)}

## this is how to load taxon_names from file
write.csv(taxon_names , file = "tax.csv", 
        row.names = FALSE,
        na = "")
## check it out, then load it
read.csv(file = "tax.csv",
        na = "", 
        stringsAsFactors = FALSE,
        col.names = FALSE)
## save results to file to inspect with, e.g. spreadsheet software
write.csv(w,file = "aphiainfo.csv", 
        na = "", 
        col.names = TRUE,
        row.names = TRUE)

        
}
