% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_matchday_table.R
\name{tm_matchday_table}
\alias{tm_matchday_table}
\title{Get weekly league table}
\usage{
tm_matchday_table(country_name, start_year, matchday, league_url = NA)
}
\arguments{
\item{country_name}{the country of the league's players}

\item{start_year}{the start year of the season (2020 for the 20/21 season)}

\item{matchday}{the matchweek number. Can be a vector of matchdays}

\item{league_url}{league url from transfermarkt.com. To be used when country_name not available in main function}
}
\value{
returns a dataframe of the table for a selected league and matchday
}
\description{
Returns the league table for each chosen matchday from transfermarkt
}
\examples{
\dontrun{
try({
tm_matchday_table(country_name="England", start_year="2020", matchday=1)
tm_matchday_table(country_name="England", start_year="2020", matchday=c(1:5))
})
}
}
