% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fotmob_stats.R
\name{fotmob_get_season_stats}
\alias{fotmob_get_season_stats}
\title{Get season statistics from fotmob}
\usage{
fotmob_get_season_stats(
  country,
  league_name,
  league_id,
  season_name,
  team_or_player,
  stat_type
)
}
\arguments{
\item{country}{Three character country code. Can be one or multiple. If provided, `league_name` must also be provided (of the same length)}

\item{league_name}{League names. If provided, `country` must also be provided (of the same length)}

\item{league_id}{Fotmob ID for the league. Only used if `country` and `league_name` are not specified.}

\item{season_name}{Season names in the format `"2021/2022"`. Multiple allowed. If multiple leagues are specified, season stats are retrieved for each league.

Note that not Fotmob currently only goes back as far as `"2016/2017"`. Some leagues may not have data for that far back.}

\item{team_or_player}{return statistics for either \code{"team"} or \code{"player"}. Can only be one or the other.}

\item{stat_type}{the type of statistic. Can only be one.
For \code{entity = "player"}, must be one of the following:
\itemize{
\item{"accurate_pass"}
\item{"big_chance_created"}
\item{"big_chance_missed"}
\item{"clean_sheet"}
\item{"effective_clearance"}
\item{"xg"}
\item{"xg_conceded"}
\item{"assist"}
\item{"goals"}
\item{"mins_played_goal"}
\item{"ontarget_scoring_att"}
\item{"penalty_won"}
\item{"poss_won_att_3rd"}
\item{"rating"}
\item{"red_card"}
\item{"saves"}
\item{"total_att_assist"}
\item{"won_contest"}
\item{"won_tackle"}
\item{"yellow_card"}
}
For `entity = "team"` all of the same stats are available, with the exception of:
\itemize{
\item{"goals"}
\item{"assist"}
\item{"won_contest"}
}
Additional stats available for \code{"team"} are:
\itemize{
\item{"goals_conceded_per_match"}
\item{"goals_per_match"}
\item{"possession_percentage"}
}}
}
\value{
returns a dataframe of league standings
}
\description{
Returns team or player season-long statistics standings from fotmob.com.
}
\examples{
\dontrun{
library(dplyr)
library(tidyr)
}
}
