% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fb_big5_advanced_season.R
\name{fb_big5_advanced_season_stats}
\alias{fb_big5_advanced_season_stats}
\title{Big 5 Euro League Season Stats}
\usage{
fb_big5_advanced_season_stats(season_end_year, stat_type, team_or_player)
}
\arguments{
\item{season_end_year}{the year(s) the season concludes}

\item{stat_type}{the type of team statistics the user requires}

\item{team_or_player}{result either summarised for each team, or individual players

The statistic type options (stat_type) include:

\emph{"standard"}, \emph{"shooting"}, \emph{"passing"}, \emph{"passing"_types},
\emph{"gca"}, \emph{"defense"}, \emph{"possession"}, \emph{"playing_time"},
\emph{"misc"}, \emph{"keepers"}, \emph{"keepers_adv"}}
}
\value{
returns a dataframe of a selected team or player statistic type for a selected season(s)
}
\description{
Returns data frame of selected statistics for seasons of the big 5 Euro leagues, for either
whole team or individual players.
Multiple seasons can be passed to the function, but only one `stat_type` can be selected
}
\examples{
\dontrun{

fb_big5_advanced_season_stats(season_end_year=2021,stat_type="possession",team_or_player="player")
}
}
