% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pip.R
\name{pip_valid_params}
\alias{pip_valid_params}
\title{Return valid query parameters}
\source{
\url{https://pip.worldbank.org/api}
}
\usage{
pip_valid_params(
  endpoint = c("all", "aux", "pip", "pip-grp", "pip-info", "valid-params"),
  release_version = NULL,
  ppp_version = NULL,
  version = NULL
)
}
\arguments{
\item{endpoint}{(\code{character(1)}) endpoint for which valid parameters are to be
returned. Default \code{"all"}.}

\item{release_version}{(\code{character(1)}) version of the data release in YYYYMMDD
format. Default \code{NULL}.}

\item{ppp_version}{(\code{character(1)} | \code{numeric(1)}) version of the data.
Default \code{NULL}.}

\item{version}{(\code{character(1)}) version of the data. Default \code{NULL}.}
}
\value{
A \code{data.frame()} with the valid parameters.
}
\description{
Return valid query parameters
}
\examples{
\donttest{
pip_valid_params()
}
}
\seealso{
Other poverty and inequality statistics: 
\code{\link{pip_aux}()},
\code{\link{pip_citation}()},
\code{\link{pip_data}()},
\code{\link{pip_group}()},
\code{\link{pip_health_check}()},
\code{\link{pip_info}()},
\code{\link{pip_versions}()}
}
\concept{poverty and inequality statistics}
