% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{workflows-internals}
\alias{workflows-internals}
\alias{.fit_pre}
\alias{.fit_model}
\title{Internal workflow functions}
\usage{
.fit_pre(workflow, data)

.fit_model(workflow, control)
}
\arguments{
\item{workflow}{A workflow

For \code{.fit_pre()}, this should be a fresh workflow.

For \code{.fit_model()}, this should be a workflow that has already been trained
through \code{.fit_pre()}.}

\item{data}{A data frame of predictors and outcomes to use when fitting the
workflow}

\item{control}{A \code{\link[=control_workflow]{control_workflow()}} object}
}
\description{
\code{.fit_pre()} and \code{.fit_model()} are internal workflow functions for
\emph{partially} fitting a workflow object. They are only exported for usage by
the tuning package, \href{https://github.com/tidymodels/tune}{tune}, and the
general user should never need to worry about them.
}
\examples{
library(parsnip)
library(recipes)

model <- linear_reg()
model <- set_engine(model, "lm")

base_workflow <- workflow()
base_workflow <- add_model(base_workflow, model)

formula_workflow <- add_formula(base_workflow, mpg ~ cyl + log(disp))

partially_fit_workflow <- .fit_pre(formula_workflow, mtcars)
fit_workflow <- .fit_model(partially_fit_workflow, control_workflow())
}
\keyword{internal}
