% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_boots.R
\name{summarise_predictions}
\alias{summarise_predictions}
\alias{`summarize_predictions()`}
\alias{summarize_predictions}
\title{Append a tibble of predictions returned by \code{predict_boots()} with a prediction
interval.}
\usage{
summarise_predictions(.data, conf = 0.95)

summarize_predictions(.data, conf = 0.95)
}
\arguments{
\item{.data}{a tibble of predictions returned by \code{predict_boots()}.}

\item{conf}{a value between (0, 1) specifying the interval range.}
}
\value{
Appends the tibble of predictions returned by \code{predict_boots()} with
three new columns: \code{.pred_lower}, \code{.pred}, and \code{.pred_upper}.
}
\description{
Append a tibble of predictions returned by \code{predict_boots()} with a prediction
interval.
}
\details{
Generates a summary of predictions with a upper and lower interval
range. Presently, the \code{quantile()} function from the \code{{stats}} package is
used to determine the lower, 50th percentile, and upper interval ranges.
}
\examples{
\dontrun{
library(tidymodels)

# setup a workflow without fitting
wf <-
  workflow() \%>\%
  add_recipe(recipe(qsec ~ wt, data = mtcars)) \%>\%
  add_model(linear_reg())

# fit and predict 125 bootstrap resampled models to mtcars
set.seed(123)
preds <-
  wf \%>\%
  predict_boots(n = 125, training_data = mtcars, new_data = mtcars)

# append with prediction interval summary columns
preds \%>\%
  summarise_predictions(conf = 0.95)
}
}
