% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getQualtrics.R
\name{qualtrics}
\alias{qualtrics}
\title{Retrieve Survey Data from Qualtrics}
\usage{
qualtrics(
  qualtrics_alias,
  institution = NULL,
  label = FALSE,
  interview_date = NULL
)
}
\arguments{
\item{qualtrics_alias}{The alias for the Qualtrics survey to be retrieved.}

\item{institution}{Optional. The institution name (e.g., "temple" or "nu"). If NULL, all institutions will be searched.}

\item{label}{Logical indicating whether to return coded values or their associated labels (default is FALSE).}

\item{interview_date}{Optional; can be either:
- A date string in various formats (ISO, US, etc.) to filter data up to that date
- A boolean TRUE to return only rows with non-NA interview_date values}
}
\value{
A cleaned and harmonized data frame containing the survey data with superkeys first.
}
\description{
Retrieve Survey Data from Qualtrics
}
\examples{
\dontrun{
# Get survey by alias (will search all institutions)
survey_data <- qualtrics("rgpts")
}
}
